/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescUtilMap;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.commini.xmlbind.PARAS;
import com.swimap.iview.commstyle.commini.xmlimpl.read.Attribute;
import com.swimap.iview.commstyle.commini.xmlimpl.read.XmlObject;
import com.swimap.iview.commstyle.commini.xmlimpl.write.Element;
import com.swimap.iview.commstyle.commini.xmlimpl.write.ElementError;
import com.swimap.iview.commstyle.commini.xmlimpl.write.ErrorList;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.IViewStringBuffer;
import com.swimap.iview.util.log.IviewLogger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class DescContainer
extends XmlObject {
    private static IviewLogger logger = IviewLogger.getLogger(DescContainer.class, "IVIEW");
    private HashMap parasHashMap = new HashMap(1);
    private ConcurrentHashMap<String, DescContainer> subDescsHashMap = new ConcurrentHashMap(4);
    public static final String _tagName = "DESC";
    public Attribute descname = new Attribute("descname", "CDATA", "IMPLIED", "");
    protected PARAS _objPARAS = null;
    protected ArrayList _objDescContainer = new ArrayList();

    private void updateParasHashMap() {
        this.parasHashMap.clear();
        PARAS pARAS = this.getPARAS();
        if (pARAS != null) {
            int n = pARAS.getPARACount();
            PARA pARA = null;
            for (int i = 0; i < n; ++i) {
                pARA = pARAS.getPARA(i);
                this.parasHashMap.put(pARA.getName(), pARA);
            }
        }
    }

    public void updateSubDescsHashMap() {
        this.subDescsHashMap.clear();
        String string = null;
        DescContainer descContainer = null;
        int n = this.getDescContainerCount();
        for (int i = 0; i < n; ++i) {
            descContainer = this.getDescContainer(i);
            if (null != descContainer) {
                string = descContainer.getDescname();
                if (null != string) {
                    this.subDescsHashMap.put(string, descContainer);
                    continue;
                }
                logger.trace("Desc Name is null");
                continue;
            }
            logger.trace("DescContainer is null");
        }
    }

    public int getParasItemCount() {
        this.checkIfExistPARAS();
        return this.getPARAS().getPARACount();
    }

    public int getSubDescCount() {
        return this.getDescContainerCount();
    }

    public String getDescName() {
        return this.getDescname();
    }

    public void setDescName(String string) {
        this.setDescname(string);
    }

    public PARA getParasItem(int n) {
        return this.getPARAS().getPARA(n);
    }

    public PARA getParasItem(String string) {
        return (PARA)this.parasHashMap.get(string);
    }

    public String getParasItemValue(int n) {
        return this.getPARAS().getPARA(n).getValue();
    }

    public String getParasItemValue(String string) {
        PARA pARA = (PARA)this.parasHashMap.get(string);
        if (pARA != null) {
            return pARA.getValue();
        }
        return null;
    }

    public boolean setParasItem(String string, String string2) {
        return this.setParasItem(string, string2, false);
    }

    public boolean setParasItem(String string, String string2, boolean bl) {
        PARA pARA = new PARA();
        pARA.setName(string);
        pARA.setValue(string2);
        return this.setParasItem(pARA, bl);
    }

    public boolean setParasItem(PARA pARA, boolean bl) {
        PARA pARA2 = (PARA)this.parasHashMap.get(pARA.getName());
        if (pARA2 != null) {
            this.removeParasItem(pARA2);
            return this.addParasItem(pARA);
        }
        if (bl) {
            return this.addParasItem(pARA);
        }
        return false;
    }

    public boolean addParasItem(PARA pARA) {
        if (this.getParasItem(pARA.getName()) == null) {
            this.checkIfExistPARAS();
            boolean bl = this.getPARAS().addPARA(pARA);
            if (bl) {
                this.parasHashMap.put(pARA.getName(), pARA);
            }
            return bl;
        }
        return false;
    }

    public boolean removeParasItem(PARA pARA) {
        this.checkIfExistPARAS();
        boolean bl = this.getPARAS().removePARA(pARA);
        if (bl) {
            this.parasHashMap.remove(pARA.getName());
        }
        return bl;
    }

    public DescContainer getDescContainer(String string) {
        if (null == string) {
            logger.trace("DescContainerName is null:");
            return null;
        }
        return this.subDescsHashMap.get(string);
    }

    public DescContainer getDescContainer(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        DescContainer descContainer = this;
        for (int i = 0; i < stringArray.length; ++i) {
            DescContainer descContainer2 = descContainer.getDescContainer(stringArray[i]);
            if (descContainer2 == null) {
                return null;
            }
            descContainer = descContainer2;
        }
        return descContainer;
    }

    public boolean setDescContainer(DescContainer descContainer, boolean bl) {
        String string = descContainer.getDescName();
        DescContainer descContainer2 = null;
        if (null != string) {
            descContainer2 = this.subDescsHashMap.get(string);
        } else {
            logger.trace("Desc Name is null");
        }
        if (descContainer2 != null) {
            this.removeDescContainer(descContainer2);
            boolean bl2 = this.addDescContainer(descContainer);
            return bl2;
        }
        if (bl) {
            return this.addDescContainer(descContainer);
        }
        return false;
    }

    public void addDescContainer(String string) {
        DescContainer descContainer = new DescContainer(string);
        this.addDescContainer(descContainer);
    }

    public void joinDescContainer(DescContainer descContainer) {
        try {
            int n = descContainer.getSubDescCount();
            for (int i = 0; i < n; ++i) {
                this.addDescContainer(descContainer.getDescContainer(i));
            }
        }
        catch (Exception exception) {
            logger.debug(exception.getMessage());
        }
    }

    public void rejoinDescContainer(DescContainer descContainer) {
        try {
            int n = descContainer.getSubDescCount();
            for (int i = 0; i < n; ++i) {
                this.setDescContainer(descContainer.getDescContainer(i), true);
            }
        }
        catch (Exception exception) {
            logger.debug(exception.getMessage());
        }
    }

    public DescContainer(String string) {
        this.setDescname(string);
        PARAS pARAS = new PARAS();
        this.setPARAS(pARAS);
    }

    public void clear() {
        this.clearDescContainerList();
        this.setPARAS(null);
        this.setPARAS(new PARAS());
    }

    private void checkIfExistPARAS() {
        if (this.getPARAS() == null) {
            this.setPARAS(new PARAS());
        }
    }

    public DescContainer() {
    }

    private String getDescname() {
        return this.descname.getValue();
    }

    private void setDescname(String string) {
        this.descname.setValue(string);
    }

    public PARAS getPARAS() {
        return this._objPARAS;
    }

    public void setPARAS(PARAS pARAS) {
        this._objPARAS = pARAS;
        if (pARAS == null) {
            this.parasHashMap.clear();
            return;
        }
        pARAS._setParent(this);
        this.updateParasHashMap();
    }

    public DescContainer[] getDescContainer() {
        return this._objDescContainer.toArray(new DescContainer[this._objDescContainer.size()]);
    }

    public void setDescContainer(DescContainer[] descContainerArray) {
        if (descContainerArray == null || descContainerArray.length == 0) {
            this._objDescContainer.clear();
            this.subDescsHashMap.clear();
        } else {
            this._objDescContainer = new ArrayList<DescContainer>(Arrays.asList(descContainerArray));
            for (int i = 0; i < descContainerArray.length; ++i) {
                if (descContainerArray[i] == null) continue;
                descContainerArray[i]._setParent(this);
            }
            this.updateSubDescsHashMap();
        }
    }

    public DescContainer getDescContainer(int n) {
        return (DescContainer)this._objDescContainer.get(n);
    }

    public void setDescContainer(int n, DescContainer descContainer) {
        if (descContainer == null) {
            this.removeDescContainer(n);
        } else {
            this._objDescContainer.set(n, descContainer);
            descContainer._setParent(this);
            String string = descContainer.getDescName();
            if (null != string) {
                this.subDescsHashMap.put(string, descContainer);
            } else {
                logger.trace("Desc name is null");
            }
        }
    }

    public int getDescContainerCount() {
        return this._objDescContainer.size();
    }

    public boolean isNoDescContainer() {
        return this._objDescContainer.size() == 0;
    }

    public List getDescContainerList() {
        return Collections.unmodifiableList(this._objDescContainer);
    }

    public boolean addDescContainer(DescContainer descContainer) {
        if (descContainer == null) {
            return false;
        }
        descContainer._setParent(this);
        boolean bl = this._objDescContainer.add(descContainer);
        if (bl) {
            String string = descContainer.getDescName();
            if (null != string) {
                this.subDescsHashMap.put(string, descContainer);
            } else {
                logger.trace("Desc Name is null");
            }
        }
        return bl;
    }

    public DescContainer removeDescContainer(int n) {
        String string = this.getDescContainer(n).getDescName();
        if (null != string) {
            this.subDescsHashMap.remove(string);
        } else {
            logger.trace("Desc Name is null");
        }
        return (DescContainer)this._objDescContainer.remove(n);
    }

    public boolean removeDescContainer(DescContainer descContainer) {
        if (null == descContainer) {
            return false;
        }
        String string = descContainer.getDescName();
        if (null != string) {
            this.subDescsHashMap.remove(string);
        } else {
            logger.trace("Desc Name is null");
        }
        return this._objDescContainer.remove(descContainer);
    }

    public void removeDescContainer(String string) {
        this.removeDescContainer(this.getDescContainer(string));
    }

    public void clearDescContainerList() {
        this._objDescContainer.clear();
        this.subDescsHashMap.clear();
    }

    public Element marshal() {
        Element element = new Element(this.get_TagName());
        element.addAttribute(this.descname.marshal());
        if (this._objPARAS != null) {
            element.addContent(this._objPARAS.marshal());
        }
        for (DescContainer descContainer : this._objDescContainer) {
            if (descContainer == null) continue;
            element.addContent(descContainer.marshal());
        }
        return element;
    }

    public static DescContainer unmarshal(Element element) {
        Object object;
        if (element == null) {
            return null;
        }
        DescContainer descContainer = new DescContainer();
        if (descContainer != null) {
            object = element.getAttributeValue("descname");
            if (null == object) {
                object = "";
            }
            descContainer.descname.setValue((String)object);
        }
        descContainer.setPARAS(PARAS.unmarshal(element.getChild(PARAS._tagName)));
        object = element.getChildren(_tagName).iterator();
        while (object.hasNext()) {
            descContainer.addDescContainer(DescContainer.unmarshal((Element)((Object)object.next())));
        }
        return descContainer;
    }

    @Override
    public ErrorList validate(boolean bl) {
        ErrorList errorList = new ErrorList();
        if (this._objPARAS != null) {
            errorList.add(this._objPARAS.validate(bl));
        } else {
            errorList.add(new ElementError(this, PARAS.class));
        }
        if (bl && errorList.size() > 0) {
            return errorList;
        }
        for (DescContainer descContainer : this._objDescContainer) {
            if (descContainer == null) continue;
            errorList.add(descContainer.validate(bl));
            if (!bl || errorList.size() <= 0) continue;
            return errorList;
        }
        return errorList.size() == 0 ? null : errorList;
    }

    public List _getChildren() {
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        if (this._objPARAS != null) {
            arrayList.add(this._objPARAS);
        }
        if (this._objDescContainer != null && this._objDescContainer.size() > 0) {
            arrayList.add(this._objDescContainer);
        }
        return arrayList;
    }

    @Override
    public String get_TagName() {
        return _tagName;
    }

    public String toString() {
        IViewStringBuffer iViewStringBuffer = new IViewStringBuffer();
        this.toString(iViewStringBuffer, 2);
        return iViewStringBuffer.toString();
    }

    final void toString(IViewStringBuffer iViewStringBuffer, int n) {
        CommStyleInfo.appSPACE(iViewStringBuffer, n);
        iViewStringBuffer.append("<");
        iViewStringBuffer.append(this.get_TagName());
        iViewStringBuffer.append(" ");
        this.appendAttrString(iViewStringBuffer, this.descname);
        iViewStringBuffer.append(">");
        iViewStringBuffer.append(CommStyleInfo.lineSeparator);
        if (this._objPARAS != null) {
            this._objPARAS.toString(iViewStringBuffer, n + 1);
        }
        iViewStringBuffer.append(CommStyleInfo.lineSeparator);
        for (DescContainer descContainer : this._objDescContainer) {
            if (descContainer == null) continue;
            descContainer.toString(iViewStringBuffer, n + 1);
            iViewStringBuffer.append(CommStyleInfo.lineSeparator);
        }
        CommStyleInfo.appSPACE(iViewStringBuffer, n);
        iViewStringBuffer.append("</");
        iViewStringBuffer.append(this.get_TagName());
        iViewStringBuffer.append(">");
    }

    private void appendAttrString(IViewStringBuffer iViewStringBuffer, Attribute attribute) {
        String string = attribute.getValue();
        if (string == null || "".equals(string)) {
            iViewStringBuffer.append("");
            return;
        }
        iViewStringBuffer.append(attribute.getName());
        iViewStringBuffer.append("=");
        iViewStringBuffer.append("\"");
        CommStyleInfo.normalizeToStrBuffer(iViewStringBuffer, string);
        iViewStringBuffer.append("\" ");
    }

    public void mergeDescContainer(DescContainer descContainer) {
        PARA pARA = null;
        PARA pARA2 = null;
        for (int i = 0; i < descContainer.getParasItemCount(); ++i) {
            pARA = descContainer.getParasItem(i);
            pARA2 = this.getParasItem(pARA.getName());
            if (pARA2 != null) {
                this.setParasItem(pARA, false);
                continue;
            }
            this.addParasItem(pARA);
        }
        DescContainer descContainer2 = null;
        DescContainer descContainer3 = null;
        for (int i = 0; i < descContainer.getSubDescCount(); ++i) {
            Object object;
            descContainer2 = descContainer.getDescContainer(i);
            descContainer3 = this.getDescContainer(descContainer2.getDescName());
            if (descContainer3 != null) {
                object = descContainer2.getParasItemValue("operation");
                if ("delete".equals(object)) {
                    this.removeDescContainer(descContainer3);
                    continue;
                }
                if ("add".equals(object)) {
                    this.addDescContainer(descContainer2);
                    continue;
                }
                DescContainer descContainer4 = null;
                if (CommonUtil.IS_MENUTOOL) {
                    descContainer4 = DescUtilMap.getParentDesc(descContainer2);
                    DescUtilMap.getInstance().putParas(descContainer3, descContainer3.getPARAS());
                }
                descContainer3.mergeDescContainer(descContainer2);
                if (!CommonUtil.IS_MENUTOOL) continue;
                DescUtilMap.getInstance().put(descContainer3, descContainer4, true);
                continue;
            }
            object = null;
            if (CommonUtil.IS_MENUTOOL) {
                object = DescUtilMap.getParentDesc(descContainer2);
                DescUtilMap.getInstance().putParas(descContainer2, descContainer2.getPARAS());
            }
            this.addDescContainer(descContainer2);
            if (!CommonUtil.IS_MENUTOOL) continue;
            DescUtilMap.getInstance().put(descContainer2, (DescContainer)object, false);
        }
    }
}

