/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.IProfileParser;
import com.swimap.iview.commstyle.commini.LocalProfileParser;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.log.IviewLogger;

public class CommStyleParserFactory {
    private static IviewLogger logger = IviewLogger.getLogger(CommStyleParserFactory.class, "IVIEW");
    private IProfileParser profileParser = null;
    private IProfileParser cacheProfileParser = null;
    private static CommStyleParserFactory parserFactory = null;
    private static final String DEFAULT_CLIENT_CONF_FILE = "style/defaultstyle/conf/mainfrm/userprofile.xml";
    private static final String PRODUCT_CLIENT_CONF_FILE = "style/productstyle/conf/mainfrm/userprofile.xml";

    private CommStyleParserFactory() {
    }

    public static CommStyleParserFactory getInstance() {
        if (parserFactory == null) {
            parserFactory = new CommStyleParserFactory();
        }
        return parserFactory;
    }

    public IProfileParser createCacheProfileParser() {
        if (null == this.cacheProfileParser) {
            this.createParser(true);
        }
        return this.cacheProfileParser;
    }

    public IProfileParser createProfileParser() {
        if (null == this.profileParser) {
            this.createParser(false);
        }
        return this.profileParser;
    }

    private void createParser(boolean bl) {
        boolean bl2;
        CommStyleInfo commStyleInfo = null;
        String string = null;
        String string2 = null;
        string2 = bl ? "cacheconfigurelocation" : "clientconfigurelocation";
        commStyleInfo = CommStyleManager.getInstance().getCommonStyleFileByPath(PRODUCT_CLIENT_CONF_FILE, false);
        if (null != commStyleInfo) {
            string = commStyleInfo.getAreaDescContainer(0).getDescContainer("userprofile").getParasItemValue(string2);
            bl2 = this.checkParserClassName(string, bl);
            if (!bl2) {
                commStyleInfo = null;
            }
        } else {
            logger.trace("style/productstyle/conf/mainfrm/userprofile.xmlFile not Found");
        }
        if (null == commStyleInfo) {
            commStyleInfo = CommStyleManager.getInstance().getCommonStyleFileByPath(DEFAULT_CLIENT_CONF_FILE, false);
            if (null != commStyleInfo) {
                string = commStyleInfo.getAreaDescContainer(0).getDescContainer("userprofile").getParasItemValue(string2);
                bl2 = this.checkParserClassName(string, bl);
                if (bl && !bl2) {
                    this.cacheProfileParser = this.createProfileParser();
                } else if (!bl2) {
                    this.profileParser = new LocalProfileParser();
                }
            } else {
                logger.trace("style/defaultstyle/conf/mainfrm/userprofile.xmlFile not found");
            }
        }
        if (commStyleInfo == null) {
            logger.trace("Initializing the local profileparser");
            this.profileParser = new LocalProfileParser();
            this.cacheProfileParser = new LocalProfileParser();
        }
    }

    private boolean checkParserClassName(String string, boolean bl) {
        if (string != null) {
            try {
                if (bl) {
                    this.cacheProfileParser = (IProfileParser)ReflectionUtilities.instantiateTheClass(string);
                } else {
                    this.profileParser = (IProfileParser)ReflectionUtilities.instantiateTheClass(string);
                }
                return true;
            }
            catch (Exception exception) {
                logger.trace(string + "class not found");
                return false;
            }
        }
        logger.trace(string + "class not found");
        return false;
    }
}

