/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.PathManager;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.FileFilter;

public class CommStyleMergeTool {
    private static IviewLogger logger = IviewLogger.getLogger(CommStyleMergeTool.class, "IVIEW");
    private static final String PARAM_OPERATION = "operation";
    private static final String DELETE_OPERATION = "delete";
    private static final String DELETE_PATH = "style/updatedelete/";
    private static FileFilter pathFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private static FileFilter xmlFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".xml");
        }
    };
    private static boolean isSaveUserNewConfig = true;
    private static boolean isUpdateSuccess = true;
    private static String currentPath = null;
    public static final String ARG_SAVEUSERCFG = "-reserved";
    public static final String ARG_USERINFO_CFG = "-mergeuserpath=";
    private static final PathManager PATH_MANAGER = PathManager.getInstance();
    private static final String USER_SETTING_PATH = "style/usersettings/";

    public static void merge(boolean bl) {
        File file = CommonUtil.getAbsoluteFile("style/users/");
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles(pathFilter);
        if (fileArray != null && fileArray.length > 0) {
            String string = "style/defaultstyle/conf/";
            File file2 = null;
            for (int i = 0; i < fileArray.length; ++i) {
                File[] fileArray2;
                String string2 = "style/users/" + fileArray[i].getName() + "/conf/";
                file2 = CommonUtil.getAbsoluteFile(string2);
                if (!file2.exists() || (fileArray2 = file2.listFiles(pathFilter)) == null || fileArray2.length <= 0) continue;
                for (int j = 0; j < fileArray2.length; ++j) {
                    File[] fileArray3 = fileArray2[j].listFiles(xmlFilter);
                    if (fileArray3 == null || fileArray3.length == 0) continue;
                    for (int k = 0; k < fileArray3.length; ++k) {
                        String string3 = fileArray2[j].getName() + '/' + fileArray3[k].getName();
                        String string4 = string2 + string3;
                        String string5 = string + string3;
                        CommStyleMergeTool.merge(string4, string5, bl);
                    }
                }
            }
        }
    }

    public static void merge(String[] stringArray, boolean bl) {
        File[] fileArray;
        File file = CommonUtil.getAbsoluteFile("style/users/");
        if (file.exists() && (fileArray = file.listFiles(pathFilter)) != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                CommStyleManager.getInstance().setUserName(fileArray[i].getName());
                for (int j = 0; j < stringArray.length; ++j) {
                    CommStyleMergeTool.merge(stringArray[j], bl);
                }
            }
        }
    }

    public static void merge(String string, boolean bl) {
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getAbsCommStyleFile("style/defaultstyle/" + string);
        CommStyleInfo commStyleInfo2 = CommStyleManager.getInstance().getUserCommonStyleFile(string);
        if (commStyleInfo == null || commStyleInfo2 == null) {
            return;
        }
        CommStyleMergeTool.merge(commStyleInfo2, commStyleInfo, bl);
        commStyleInfo.writeStyle(commStyleInfo2.getFileName(), false);
    }

    public static void merge(String string, String string2, boolean bl) {
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getAbsCommStyleFile(string);
        if (commStyleInfo == null || commStyleInfo.getAreaDescCount() <= 0) {
            return;
        }
        CommStyleInfo commStyleInfo2 = CommStyleManager.getInstance().getAbsCommStyleFile(string2);
        if (commStyleInfo2 == null || commStyleInfo.getAreaDescCount() <= 0) {
            return;
        }
        CommStyleMergeTool.merge(commStyleInfo, commStyleInfo2, bl);
        commStyleInfo2.writeStyle(commStyleInfo.getFileName(), false);
    }

    private static void merge(CommStyleInfo commStyleInfo, CommStyleInfo commStyleInfo2, boolean bl) {
        int n = commStyleInfo2.getAreaDescContainerCount();
        AreaDescContainer areaDescContainer = null;
        AreaDescContainer areaDescContainer2 = null;
        String string = null;
        for (int i = 0; i < n; ++i) {
            areaDescContainer2 = commStyleInfo2.getAreaDescContainer(i);
            string = areaDescContainer2.getAreaName();
            areaDescContainer = string != null && !"".equals(string) ? commStyleInfo.getAreaDescContainer(string) : commStyleInfo.getAreaDescContainer(i);
            if (areaDescContainer == null) continue;
            CommStyleMergeTool.merge(areaDescContainer, areaDescContainer2, bl);
        }
    }

    private static void merge(AreaDescContainer areaDescContainer, AreaDescContainer areaDescContainer2, boolean bl) {
        DescContainer descContainer = null;
        String string = null;
        DescContainer descContainer2 = null;
        int n = areaDescContainer2.getDescContainerCount();
        for (int i = 0; i < n; ++i) {
            descContainer = areaDescContainer2.getDescContainer(i);
            string = descContainer.getDescName();
            descContainer2 = areaDescContainer.getDescContainer(string);
            if (descContainer2 == null) continue;
            CommStyleMergeTool.merge(descContainer2, descContainer, bl);
        }
    }

    private static void merge(DescContainer descContainer, DescContainer descContainer2, boolean bl) {
        Object object;
        Object object2;
        int n;
        int n2 = descContainer2.getDescContainerCount();
        for (n = 0; n < n2; ++n) {
            DescContainer descContainer3 = descContainer2.getDescContainer(n);
            object2 = descContainer3.getDescName();
            object = descContainer.getDescContainer((String)object2);
            if (object == null) continue;
            CommStyleMergeTool.merge((DescContainer)object, descContainer3, bl);
        }
        n = descContainer2.getParasItemCount();
        for (int i = 0; i < n; ++i) {
            object2 = descContainer2.getParasItem(i);
            object = ((PARA)object2).getName();
            PARA pARA = descContainer.getParasItem((String)object);
            if (pARA != null) {
                if (bl && !"reserved".equalsIgnoreCase(((PARA)object2).getType())) {
                    ((PARA)object2).setValue(pARA.getValue());
                    continue;
                }
                if (bl || !"replaced".equalsIgnoreCase(((PARA)object2).getType())) continue;
                ((PARA)object2).setValue(pARA.getValue());
                continue;
            }
            descContainer2.addParasItem((PARA)object2);
        }
    }

    public static boolean isSpecifyUserInfo() {
        File file = CommonUtil.getAbsoluteFile(CommStyleMergeTool.getSpecifiedUserStylePath());
        return file.isDirectory() && file.exists();
    }

    private static String getSpecifiedUserStylePath() {
        if (currentPath == null || currentPath.length() == 0) {
            return USER_SETTING_PATH;
        }
        currentPath = PathManager.getInstance().filterPath(currentPath);
        return currentPath + USER_SETTING_PATH;
    }

    private static final String getDefaultStylePath() {
        if (currentPath == null || currentPath.length() == 0) {
            return "style/defaultstyle/conf/";
        }
        return currentPath + "style/defaultstyle/" + "conf/";
    }

    public static void updateSpecified(boolean bl) {
        String string = CommStyleMergeTool.getSpecifiedUserStylePath();
        File file = CommonUtil.getAbsoluteFile(string);
        File[] fileArray = file.listFiles(pathFilter);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        CommStyleMergeTool.updateSpecified(string, fileArray, bl);
    }

    private static void update(File file, boolean bl) {
        File[] fileArray = file.listFiles(pathFilter);
        String string = PATH_MANAGER.filterPath(file.getAbsolutePath());
        if (fileArray == null) {
            return;
        }
        String string2 = "style/updatedelete/conf/";
        if (currentPath != null) {
            string2 = currentPath + DELETE_PATH + "conf/";
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File[] fileArray2 = fileArray[i].listFiles(xmlFilter);
            if (fileArray2 == null) continue;
            for (int j = 0; j < fileArray2.length; ++j) {
                String string3 = fileArray[i].getName() + '/' + fileArray2[j].getName();
                String string4 = string + string3;
                String string5 = CommStyleMergeTool.getDefaultStylePath() + string3;
                String string6 = string2 + string3;
                logger.error("Start to merge:" + string4 + " and " + string5);
                CommStyleMergeTool.update(string4, string5, string6, bl);
            }
        }
    }

    private static void updateSpecified(String string, File[] fileArray, boolean bl) {
        if (fileArray == null) {
            return;
        }
        File file = null;
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = PATH_MANAGER.filterPath(fileArray[i].getAbsolutePath());
            file = CommonUtil.getAbsoluteFile(string2 + "conf/");
            if (file.exists()) {
                CommStyleMergeTool.update(file, bl);
                continue;
            }
            CommStyleMergeTool.updateSpecified(string, CommonUtil.getAbsoluteFile(string2).listFiles(), bl);
        }
    }

    public static void setSaveUserCfg(boolean bl) {
        isSaveUserNewConfig = bl;
    }

    public static void update(String[] stringArray, boolean bl) {
        File[] fileArray;
        File file = CommonUtil.getAbsoluteFile("style/users/");
        if (file.exists() && (fileArray = file.listFiles(pathFilter)) != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                CommStyleManager.getInstance().setUserName(fileArray[i].getName());
                for (int j = 0; j < stringArray.length; ++j) {
                    CommStyleMergeTool.update(stringArray[j], bl);
                }
            }
        }
    }

    public static void update(String string, boolean bl) {
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getAbsCommStyleFile("style/defaultstyle/" + string);
        CommStyleInfo commStyleInfo2 = CommStyleManager.getInstance().getUserCommonStyleFile(string);
        if (commStyleInfo == null || commStyleInfo2 == null) {
            return;
        }
        CommStyleMergeTool.update(commStyleInfo2, commStyleInfo, bl);
        commStyleInfo.writeStyle(commStyleInfo2.getFileName(), false);
    }

    public static void update(boolean bl) {
        if (CommStyleMergeTool.isSpecifyUserInfo()) {
            CommStyleMergeTool.updateSpecified(bl);
        }
        File file = null;
        if (currentPath != null) {
            file = CommonUtil.getAbsoluteFile(currentPath + "style/users/");
            logger.error(" current user style path of GUI = " + currentPath + "style/users/");
        } else {
            file = CommonUtil.getAbsoluteFile("style/users/");
        }
        if (!file.exists()) {
            logger.error("The style/users/ File not exists");
            isUpdateSuccess = false;
            return;
        }
        File[] fileArray = file.listFiles(pathFilter);
        if (fileArray != null && fileArray.length > 0) {
            File file2 = null;
            for (int i = 0; i < fileArray.length; ++i) {
                String string = "style/users/" + fileArray[i].getName() + "/conf/";
                if (currentPath != null) {
                    string = currentPath + "style/users/" + fileArray[i].getName() + "/conf/";
                }
                if (!(file2 = CommonUtil.getAbsoluteFile(string)).exists()) continue;
                CommStyleMergeTool.update(file2, bl);
            }
        }
    }

    public static boolean updateStyle(boolean bl, String string) {
        if (string != null) {
            currentPath = string;
            logger.error(" path args = " + currentPath);
        }
        CommStyleMergeTool.update(bl);
        logger.error("merge result = " + isUpdateSuccess);
        DebugTracer.cleanup();
        currentPath = null;
        return isUpdateSuccess;
    }

    public static void update(String string, String string2, boolean bl) {
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getAbsCommStyleFile(string);
        if (commStyleInfo == null || commStyleInfo.getAreaDescCount() <= 0) {
            logger.error("Can't get file from " + string);
            return;
        }
        CommStyleInfo commStyleInfo2 = CommStyleManager.getInstance().getAbsCommStyleFile(string2);
        if (commStyleInfo2 == null || commStyleInfo.getAreaDescCount() <= 0) {
            logger.error("Can't get file from " + string2);
            return;
        }
        CommStyleMergeTool.update(commStyleInfo, commStyleInfo2, bl);
        commStyleInfo2.writeStyle(commStyleInfo.getFileName(), false);
    }

    public static void update(String string, String string2, String string3, boolean bl) {
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getAbsCommStyleFile(string);
        if (commStyleInfo == null || commStyleInfo.getAreaDescCount() <= 0) {
            logger.error("Can't get file from " + string);
            return;
        }
        CommStyleInfo commStyleInfo2 = CommStyleManager.getInstance().getAbsCommStyleFile(string2);
        if (commStyleInfo2 == null || commStyleInfo.getAreaDescCount() <= 0) {
            logger.error("Can't get file from " + string2);
            return;
        }
        CommStyleMergeTool.update(commStyleInfo, commStyleInfo2, bl);
        commStyleInfo2.writeStyle(commStyleInfo.getFileName(), false);
        CommStyleInfo commStyleInfo3 = CommStyleManager.getInstance().getAbsCommStyleFile(string3);
        if (commStyleInfo3 != null && commStyleInfo3.getAreaDescCount() > 0) {
            commStyleInfo = CommStyleManager.getInstance().getAbsCommStyleFile(string);
            CommStyleMergeTool.deleteDescWithFlag(commStyleInfo, commStyleInfo3);
            commStyleInfo.writeStyle(commStyleInfo.getFileName(), false);
        }
    }

    private static void update(CommStyleInfo commStyleInfo, CommStyleInfo commStyleInfo2, boolean bl) {
        Object object;
        Object object2;
        int n;
        int n2 = commStyleInfo2.getAreaDescContainerCount();
        for (n = 0; n < n2; ++n) {
            AreaDescContainer areaDescContainer = commStyleInfo2.getAreaDescContainer(n);
            object2 = areaDescContainer.getAreaName();
            object = null;
            object = object2 != null && !"".equals(object2) ? commStyleInfo.getAreaDescContainer((String)object2) : commStyleInfo.getAreaDescContainer(n);
            if (object == null) continue;
            CommStyleMergeTool.update((AreaDescContainer)object, areaDescContainer, bl);
        }
        if (isSaveUserNewConfig) {
            n = commStyleInfo.getAreaDescContainerCount();
            for (int i = 0; i < n; ++i) {
                object2 = commStyleInfo.getAreaDescContainer(i);
                object = ((AreaDescContainer)object2).getAreaName();
                AreaDescContainer areaDescContainer = null;
                areaDescContainer = object != null && !"".equals(object) ? commStyleInfo2.getAreaDescContainer((String)object) : commStyleInfo2.getAreaDescContainer(i);
                if (areaDescContainer != null) continue;
                commStyleInfo2.addAreaDescContainer((AreaDescContainer)object2);
            }
        }
    }

    private static void update(AreaDescContainer areaDescContainer, AreaDescContainer areaDescContainer2, boolean bl) {
        DescContainer descContainer;
        String string;
        DescContainer descContainer2;
        int n;
        int n2;
        if (isSaveUserNewConfig && areaDescContainer.getDescContainerCount() > areaDescContainer2.getDescContainerCount()) {
            n2 = areaDescContainer.getDescContainerCount();
            for (n = 0; n < n2; ++n) {
                descContainer2 = areaDescContainer.getDescContainer(n);
                string = descContainer2.getDescName();
                descContainer = areaDescContainer2.getDescContainer(string);
                if (descContainer != null) continue;
                areaDescContainer2.addDescContainer(descContainer2);
            }
        }
        n2 = areaDescContainer2.getDescContainerCount();
        for (n = 0; n < n2; ++n) {
            descContainer2 = areaDescContainer2.getDescContainer(n);
            string = descContainer2.getDescName();
            descContainer = areaDescContainer.getDescContainer(string);
            if (descContainer == null) continue;
            CommStyleMergeTool.update(descContainer, descContainer2, bl);
        }
    }

    private static void deleteDescWithFlag(CommStyleInfo commStyleInfo, CommStyleInfo commStyleInfo2) {
        int n = commStyleInfo2.getAreaDescContainerCount();
        for (int i = 0; i < n; ++i) {
            AreaDescContainer areaDescContainer = commStyleInfo2.getAreaDescContainer(i);
            String string = areaDescContainer.getAreaName();
            AreaDescContainer areaDescContainer2 = commStyleInfo.getAreaDescContainer(string);
            if (areaDescContainer2 == null) continue;
            CommStyleMergeTool.deleteDescWithFlag(areaDescContainer2, areaDescContainer);
        }
    }

    private static void deleteDescWithFlag(AreaDescContainer areaDescContainer, AreaDescContainer areaDescContainer2) {
        int n = areaDescContainer2.getDescContainerCount();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2;
            DescContainer descContainer;
            DescContainer descContainer2 = areaDescContainer2.getDescContainer(i);
            if (null == descContainer2 || (descContainer = areaDescContainer.getDescContainer(string2 = descContainer2.getDescName())) == null || !DELETE_OPERATION.equals(string = descContainer2.getParasItemValue(PARAM_OPERATION))) continue;
            boolean bl = areaDescContainer.removeDescContainer(descContainer);
            String string3 = new StringBuffer("Delete ").append(descContainer2.getDescName()).append(". Result is ").append(bl).toString();
            logger.trace(string3);
        }
    }

    private static void update(DescContainer descContainer, DescContainer descContainer2, boolean bl) {
        int n;
        Object object;
        Object object2;
        DescContainer descContainer3;
        int n2;
        int n3;
        if (isSaveUserNewConfig && descContainer.getDescContainerCount() > descContainer2.getDescContainerCount()) {
            n3 = descContainer.getDescContainerCount();
            for (n2 = 0; n2 < n3; ++n2) {
                descContainer3 = descContainer.getDescContainer(n2);
                object2 = descContainer3.getDescName();
                object = descContainer2.getDescContainer((String)object2);
                if (object != null) continue;
                descContainer2.addDescContainer(descContainer3);
            }
        }
        n3 = descContainer2.getDescContainerCount();
        for (n2 = 0; n2 < n3; ++n2) {
            descContainer3 = descContainer2.getDescContainer(n2);
            object2 = descContainer3.getDescName();
            object = descContainer.getDescContainer((String)object2);
            if (object == null) continue;
            CommStyleMergeTool.update((DescContainer)object, descContainer3, bl);
        }
        n2 = descContainer2.getParasItemCount();
        for (n = 0; n < n2; ++n) {
            object2 = descContainer2.getParasItem(n);
            object = ((PARA)object2).getName();
            PARA pARA = descContainer.getParasItem((String)object);
            if (pARA != null) {
                if (bl && !"reserved".equalsIgnoreCase(((PARA)object2).getType())) {
                    ((PARA)object2).setValue(pARA.getValue());
                    continue;
                }
                if (bl || !"replaced".equalsIgnoreCase(((PARA)object2).getType())) continue;
                ((PARA)object2).setValue(pARA.getValue());
                continue;
            }
            descContainer2.addParasItem((PARA)object2);
        }
        if (isSaveUserNewConfig) {
            n = descContainer.getParasItemCount();
            for (int i = 0; i < n; ++i) {
                object = descContainer.getParasItem(i);
                descContainer2.addParasItem((PARA)object);
            }
        }
    }
}

