/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.CommStyleParserFactory;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IProfileParser;
import com.swimap.iview.commstyle.commini.parsers.IParser;
import com.swimap.iview.commstyle.commini.parsers.ParserFactory;
import com.swimap.iview.commstyle.commini.xmlimpl.read.XmlObject;
import com.swimap.iview.commstyle.commini.xmlimpl.write.Element;
import com.swimap.iview.commstyle.commini.xmlimpl.write.ElementError;
import com.swimap.iview.commstyle.commini.xmlimpl.write.ErrorList;
import com.swimap.iview.commstyle.commini.xmlimpl.write.XmlUtil;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.pluginmanagement.Resource;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.IViewStringBuffer;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.adapter.FrameworkHelper;
import com.swimap.iview.util.adapter.ResourceMngHelper;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JFrame;

public class CommStyleInfo
extends XmlObject
implements Printable {
    private static IviewLogger logger = IviewLogger.getLogger(CommStyleInfo.class, "IVIEW");
    private static IParser parser = ParserFactory.getParser();
    static final String RES_BUNDLE_PATH = "mainfrm/iview/commstyle/commini/Res";
    static ResourceBundle thisRes = ResourceMngHelper.getResourceBundleFromPropertyFile("mainfrm/iview/commstyle/commini/Res");
    private Vector styleRes = new Vector();
    private String fileName = null;
    private String appID = "";
    private String objFileName = null;
    private String encoding = null;
    private int integrateKey = 0;
    private boolean hasDtdHeader = true;
    public static final String SPACESTR = "    ";
    public static final String lineSeparator = System.getProperty("line.separator");
    public static final String leftXMLBracket = "<";
    public static final String rightXMLBracket = ">";
    public static final String endXMLBracket = "/>";
    public static final String endLeftXMLBracket = "</";
    public static final String equal = "=";
    public static final String leftQuota = "\"";
    public static final String rightQuota = "\" ";
    public static final String rightQuotaAndSpace = "\" ";
    public static final String oneSpace = " ";
    private static final String BACKUP_FILE_EXT = ".iviewbak";
    private volatile boolean writeStyleInfoSuccess = false;
    private String pluginName = null;
    private String relatFileName = null;
    private Resource pluginRes = null;
    private String urlExternalForm = null;
    public static final String _tagName = "COMMINIDATA";
    protected ArrayList _objAreaDescContainer = new ArrayList();
    protected String publicId = "";
    protected String systemId = "commini.dtd";

    public void setHasDtdHeader(boolean bl) {
        this.hasDtdHeader = bl;
    }

    public boolean hasDtdHeader() {
        return this.hasDtdHeader;
    }

    public void setFileName(String string) {
        if (null != string) {
            this.fileName = CommStyleManager.getRelativeFileNameFromURL(string);
        }
    }

    public void setAppID(String string) {
        this.appID = string;
    }

    public String getAppID() {
        return this.appID;
    }

    void setObjFileName(String string) {
        this.objFileName = string;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.styleRes.addElement(resourceBundle);
    }

    ResourceBundle getResourceBundle() {
        if (this.styleRes.size() > 0) {
            return (ResourceBundle)this.styleRes.elementAt(0);
        }
        return null;
    }

    Vector getResourceBundleVector() {
        return this.styleRes;
    }

    public String getResString(String string) {
        ResourceBundle resourceBundle = null;
        String string2 = null;
        for (int i = 0; i < this.styleRes.size(); ++i) {
            resourceBundle = (ResourceBundle)this.styleRes.elementAt(i);
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (Exception exception) {
                logger.trace(string + " String is not found in properties file");
            }
            if (string2 == null) continue;
            return string2;
        }
        return string2;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public int getAreaDescCount() {
        return this.getAreaDescContainerCount();
    }

    public boolean setAreaDescContainer(AreaDescContainer areaDescContainer, boolean bl) {
        int n = this.getIndexFromName(areaDescContainer.getAreaName());
        if (n != -1) {
            this.setAreaDescContainer(n, areaDescContainer);
            return true;
        }
        if (bl) {
            return this.addAreaDescContainer(areaDescContainer);
        }
        return false;
    }

    public void removeAreaDescContainer(String string) {
        int n = this.getAreaDescContainerCount();
        for (int i = 0; i < n; ++i) {
            if (!ResourceUtil.areEquals(this.getAreaDescContainer(i).getAreaName(), string)) continue;
            this.removeAreaDescContainer(i);
            break;
        }
    }

    public void removeAreaDescContainer() {
        this.clearAreaDescContainerList();
    }

    public AreaDescContainer getAreaDescContainer(String string) {
        int n = this.getAreaDescContainerCount();
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            string2 = this.getAreaDescContainer(i).getAreaName();
            if (string2 == null || !ResourceUtil.areEquals(string2, string)) continue;
            return this.getAreaDescContainer(i);
        }
        return null;
    }

    private int getIndexFromName(String string) {
        int n = this.getAreaDescContainerCount();
        for (int i = 0; i < n; ++i) {
            if (!ResourceUtil.areEquals(this.getAreaDescContainer(i).getAreaName(), string)) continue;
            return i;
        }
        return -1;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getObjFileName() {
        return this.objFileName;
    }

    public void removeDesc(String string) {
        AreaDescContainer areaDescContainer = this.getAreaDescContainer(string);
        areaDescContainer.clear();
    }

    public void removeDesc(String string, String string2) {
        this.getAreaDescContainer(string).removeDescContainer(string2);
    }

    public void removeDesc(String string, int n) {
        this.getAreaDescContainer(string).removeDescContainer(n);
    }

    public void writeBack() {
        if (this.fileName != null) {
            this.writeBackToFile(false);
        }
        if (this.objFileName != null) {
            this.writeBackToFile(true);
        }
    }

    public void writeBackPersonal() {
        if (this.fileName != null) {
            this.writeStyle(CommStyleManager.getInstance().checkPersonalStyleFile(this.fileName));
        }
        if (this.objFileName != null) {
            this.writeStyle(CommStyleManager.getInstance().checkPersonalStyleFile(this.objFileName));
        }
    }

    public synchronized void writeStyle(String string) {
        this.writeStyleInfoSuccess = false;
        string = CommonUtil.getAbsolutePath(string);
        CommonUtil.checkDirectory(string);
        File file = new File(string);
        if (file.exists()) {
            if (!file.canWrite()) {
                JFrame jFrame = FrameworkHelper.getMainFrame();
                StringBuffer stringBuffer = new StringBuffer(55);
                stringBuffer.append(thisRes.getString("The_File_"));
                stringBuffer.append(string);
                stringBuffer.append(thisRes.getString("_Is_ReadOnly_And_Can"));
                OptionPane.showMessageDialog(jFrame, stringBuffer.toString());
                return;
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                logger.debug("Error : Can not create File " + this.fileName);
                logger.trace(iOException.getMessage(), iOException);
                return;
            }
        }
        if (CommStyleManager.STYLE_TYPE_SWITCH == 0) {
            try {
                parser.marshal(this, string);
            }
            catch (Exception exception) {
                logger.debug("can not write xml style");
                logger.trace(exception.getMessage(), exception);
            }
        } else if (CommStyleManager.STYLE_TYPE_SWITCH == 1) {
            this.writeObjetToFile(this.objFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeStyle(String string, boolean bl) {
        this.writeStyleInfoSuccess = false;
        string = CommonUtil.getAbsolutePath(string);
        CommonUtil.checkDirectory(string);
        String string2 = bl ? this.objFileName : string;
        File file = new File(string2);
        if (file.exists()) {
            if (!file.canWrite()) {
                JFrame jFrame = FrameworkHelper.getMainFrame();
                StringBuffer stringBuffer = new StringBuffer(55);
                stringBuffer.append(thisRes.getString("The_File_"));
                stringBuffer.append(string);
                stringBuffer.append(thisRes.getString("_Is_ReadOnly_And_Can"));
                OptionPane.showMessageDialog(jFrame, stringBuffer.toString());
                return;
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                logger.debug("Error : Can not create File " + this.fileName);
                return;
            }
        }
        if (!bl) {
            try {
                parser.marshal(this, string);
            }
            catch (Exception exception) {
                logger.debug("can not write xml style");
                logger.trace(exception.getMessage(), exception);
            }
        } else {
            FileOutputStream fileOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(CommonUtil.getAbsolutePath(this.objFileName));
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this);
                objectOutputStream.flush();
                objectOutputStream.reset();
            }
            catch (Exception exception) {
                logger.debug("can not write obj style");
                logger.trace(exception.getMessage(), exception);
            }
            finally {
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException) {
                        logger.trace(iOException.getMessage(), iOException);
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        logger.trace(iOException.getMessage(), iOException);
                    }
                }
            }
        }
    }

    public void writeDefaultStyle(String string) {
        if (null == string) {
            logger.error("file name is null for CommstyleInfo");
            throw new IllegalArgumentException();
        }
        String string2 = CommStyleManager.getFullFileName(string);
        this.writeStyle(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePersonlStyle(String string) {
        if (null == string) {
            logger.error("file name is null for CommstyleInfo");
            throw new IllegalArgumentException();
        }
        CommStyleParserFactory commStyleParserFactory = CommStyleParserFactory.getInstance();
        IProfileParser iProfileParser = commStyleParserFactory.createProfileParser();
        if (null == iProfileParser) {
            logger.trace("CommStyleInfo is : " + this + " Profileparser is : null");
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string2 = CommStyleManager.getInstance().getPersonalFullFileName(string);
        try {
            this.marshal(byteArrayOutputStream);
            iProfileParser.write(((Object)byteArrayOutputStream).toString(), string2);
        }
        catch (IOException iOException) {
            logger.debug("Error : Can not create File " + string2);
            logger.trace(iOException.getMessage(), iOException);
        }
        finally {
            if (null != byteArrayOutputStream) {
                try {
                    ((OutputStream)byteArrayOutputStream).close();
                }
                catch (IOException iOException) {
                    logger.trace(iOException.getMessage(), iOException);
                }
            }
        }
    }

    public void writeToAllUsers() {
        if (this.fileName != null) {
            this.writeStyle(CommStyleManager.getInstance().checkAllUsersStyleFile(this.fileName));
        }
        if (this.objFileName != null) {
            this.writeStyle(CommStyleManager.getInstance().checkAllUsersStyleFile(this.objFileName));
        }
    }

    synchronized void writeBackToFile(boolean bl) {
        this.writeStyleInfoSuccess = false;
        if (!bl) {
            if (this.fileName != null) {
                this.fileName = this.fileName.replaceAll("%20", oneSpace);
                File file = new File(CommonUtil.getAbsolutePath(this.fileName));
                if (!file.exists()) {
                    try {
                        file.createNewFile();
                    }
                    catch (IOException iOException) {
                        logger.debug("Error : Can not create File " + this.fileName);
                        return;
                    }
                }
                if (!file.canWrite()) {
                    JFrame jFrame = FrameworkHelper.getMainFrame();
                    StringBuffer stringBuffer = new StringBuffer(55);
                    stringBuffer.append(thisRes.getString("The_File_"));
                    stringBuffer.append(this.fileName);
                    stringBuffer.append(thisRes.getString("_Is_ReadOnly_And_Can"));
                    OptionPane.showMessageDialog(jFrame, stringBuffer.toString());
                    return;
                }
                try {
                    this.marshal(file);
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                }
            }
        } else if (this.objFileName != null) {
            File file = new File(CommonUtil.getAbsolutePath(this.objFileName));
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    logger.debug("Error : Can not create File " + this.objFileName);
                    return;
                }
            }
            if (!file.canWrite()) {
                JFrame jFrame = FrameworkHelper.getMainFrame();
                StringBuffer stringBuffer = new StringBuffer(55);
                stringBuffer.append(thisRes.getString("The_File_"));
                stringBuffer.append(this.objFileName);
                stringBuffer.append(thisRes.getString("_Is_ReadOnly_And_Can"));
                OptionPane.showMessageDialog(jFrame, stringBuffer.toString());
                return;
            }
            this.writeObjetToFile(this.objFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFileLocked(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        if (file.exists()) {
            FileOutputStream fileOutputStream = null;
            FileChannel fileChannel = null;
            FileLock fileLock = null;
            try {
                fileOutputStream = new FileOutputStream(file, true);
                fileChannel = fileOutputStream.getChannel();
                fileLock = fileChannel.tryLock();
                if (null == fileLock) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
            finally {
                if (fileLock != null) {
                    try {
                        fileLock.release();
                        fileLock = null;
                    }
                    catch (IOException iOException) {
                        logger.trace(iOException.getMessage(), iOException);
                    }
                }
                if (fileChannel != null) {
                    try {
                        fileChannel.close();
                        fileChannel = null;
                    }
                    catch (IOException iOException) {
                        logger.trace(iOException.getMessage(), iOException);
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                    catch (IOException iOException) {
                        logger.trace(iOException.getMessage(), iOException);
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObjetToFile(String string) {
        this.writeStyleInfoSuccess = false;
        boolean bl = false;
        File file = CommonUtil.getAbsoluteFile(string);
        File file2 = new File(file.getAbsolutePath() + BACKUP_FILE_EXT);
        if (file2.exists()) {
            file2.delete();
            logger.trace(file2.getPath() + " is exist, and delete it to backup the latest one.");
        }
        if (this.isFileLocked(file)) {
            logger.trace("File is locked, cannot be renamed.");
            return;
        }
        if (file.length() > 0L && (file2 = this.backupFile(file)) == null) {
            logger.trace(file.getPath() + " backup failed.");
            return;
        }
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        FileChannel fileChannel = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileChannel = fileOutputStream.getChannel();
            FileLock fileLock = fileChannel.tryLock();
            if (fileLock != null && fileLock.isValid()) {
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this);
                objectOutputStream.flush();
                objectOutputStream.reset();
                bl = true;
            } else {
                logger.warn("Because failed to get file lock, failed to write back file:" + string);
            }
        }
        catch (Exception exception) {
            logger.debug("can not write obj style");
            logger.trace(exception.getMessage(), exception);
        }
        finally {
            try {
                if (null != fileChannel) {
                    fileChannel.close();
                    fileChannel = null;
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            try {
                if (null != fileOutputStream) {
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            try {
                if (null != objectOutputStream) {
                    objectOutputStream.close();
                    objectOutputStream = null;
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            if (bl) {
                if (file.exists()) {
                    file2.delete();
                }
            } else {
                file.delete();
                if (file2.renameTo(file)) {
                    file2.delete();
                }
            }
            this.writeStyleInfoSuccess = bl;
        }
    }

    public boolean isWriteStyleInfoSuccess() {
        return this.writeStyleInfoSuccess;
    }

    public HashMap getParasItemHash(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            DescContainer descContainer = this.getAreaDescContainer(string).getDescContainer(string2);
            for (int i = 0; i < descContainer.getParasItemCount(); ++i) {
                hashMap.put(descContainer.getParasItem(i).getName(), descContainer.getParasItem(i).getValue());
            }
        }
        catch (Exception exception) {
            hashMap = null;
        }
        return hashMap;
    }

    public String getParasItemValue(String string, String string2, String string3) {
        String string4 = null;
        try {
            string4 = this.getAreaDescContainer(string).getDescContainer(string2).getParasItemValue(string3);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(" can not get [areaName:");
            stringBuffer.append(string);
            stringBuffer.append(" descName:");
            stringBuffer.append(string2);
            stringBuffer.append(" parasItemName:");
            stringBuffer.append(string3);
            stringBuffer.append("], null will be return.");
            logger.debug(stringBuffer.toString());
        }
        return string4;
    }

    public String getParasItemValue(String string, String string2) {
        String string3 = null;
        try {
            string3 = this.getAreaDescContainer(0).getDescContainer(string).getParasItemValue(string2);
        }
        catch (Exception exception) {
            logger.debug(" can not get [areaName :index 0, descName:" + string + " parasItemName:" + string2 + "], null will be return.");
        }
        return string3;
    }

    public void setParasItemHash(String string, String string2, Hashtable hashtable) {
        try {
            DescContainer descContainer = this.getAreaDescContainer(string).getDescContainer(string2);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                descContainer.setParasItem(string3, descContainer.getParasItem(string3).getValue(), true);
            }
        }
        catch (Exception exception) {
            logger.debug("set the value failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveInObjFormat() {
        if (this.fileName != null) {
            FileOutputStream fileOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                String string = this.fileName.substring(0, this.fileName.length() - 4);
                fileOutputStream = new FileOutputStream(CommonUtil.getAbsolutePath(string + ".obj"));
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this);
                objectOutputStream.flush();
                objectOutputStream.reset();
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            finally {
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException) {
                        logger.trace(iOException.getMessage(), iOException);
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        logger.trace(iOException.getMessage(), iOException);
                    }
                }
            }
        }
    }

    public void setParasItemValue(String string, String string2, String string3, String string4) {
        try {
            this.getAreaDescContainer(string).getDescContainer(string2).setParasItem(string3, string4, true);
        }
        catch (Exception exception) {
            logger.debug("set the value failed");
        }
    }

    public void setParasItemValue(String string, String string2, String string3) {
        try {
            this.getAreaDescContainer(0).getDescContainer(string).setParasItem(string2, string3, true);
        }
        catch (Exception exception) {
            logger.debug("set the value failed");
        }
    }

    public CommStyleInfo() {
        XmlUtil.setEncoding(CommStyleManager.ENCODING_SWITCH);
    }

    public AreaDescContainer[] getAreaDescContainer() {
        return this._objAreaDescContainer.toArray(new AreaDescContainer[0]);
    }

    public void setAreaDescContainer(AreaDescContainer[] areaDescContainerArray) {
        if (areaDescContainerArray == null || areaDescContainerArray.length == 0) {
            this._objAreaDescContainer.clear();
        } else {
            this._objAreaDescContainer = new ArrayList<AreaDescContainer>(Arrays.asList(areaDescContainerArray));
            for (int i = 0; i < areaDescContainerArray.length; ++i) {
                if (areaDescContainerArray[i] == null) continue;
                areaDescContainerArray[i]._setParent(this);
            }
        }
    }

    public AreaDescContainer getAreaDescContainer(int n) {
        return (AreaDescContainer)this._objAreaDescContainer.get(n);
    }

    public void setAreaDescContainer(int n, AreaDescContainer areaDescContainer) {
        if (areaDescContainer == null) {
            this.removeAreaDescContainer(n);
        } else {
            this._objAreaDescContainer.set(n, areaDescContainer);
            areaDescContainer._setParent(this);
        }
    }

    public int getAreaDescContainerCount() {
        return this._objAreaDescContainer.size();
    }

    public boolean isNoAreaDescContainer() {
        return this._objAreaDescContainer.size() == 0;
    }

    public List getAreaDescContainerList() {
        return Collections.unmodifiableList(this._objAreaDescContainer);
    }

    public boolean addAreaDescContainer(AreaDescContainer areaDescContainer) {
        if (areaDescContainer == null) {
            return false;
        }
        areaDescContainer._setParent(this);
        return this._objAreaDescContainer.add(areaDescContainer);
    }

    public AreaDescContainer removeAreaDescContainer(int n) {
        return (AreaDescContainer)this._objAreaDescContainer.remove(n);
    }

    public boolean removeAreaDescContainer(AreaDescContainer areaDescContainer) {
        return this._objAreaDescContainer.remove(areaDescContainer);
    }

    public void clearAreaDescContainerList() {
        this._objAreaDescContainer.clear();
    }

    public void marshal(OutputStream outputStream) throws IOException {
        parser.marshal(this, outputStream);
    }

    public void marshal(String string) throws IOException {
        parser.marshal(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(File file) throws IOException {
        this.writeStyleInfoSuccess = false;
        boolean bl = false;
        File file2 = new File(file.getAbsolutePath() + BACKUP_FILE_EXT);
        if (file2.exists()) {
            file2.delete();
            logger.trace(file2.getPath() + " is exist, and delete it to backup the latest one.");
        }
        if (this.isFileLocked(file)) {
            logger.trace("File is locked, cannot be renamed.");
            return;
        }
        if (file.length() > 0L && (file2 = this.backupFile(file)) == null) {
            logger.trace(file.getPath() + " backup failed.");
            return;
        }
        BufferedWriter bufferedWriter = null;
        FileOutputStream fileOutputStream = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            abstractInterruptibleChannel = fileOutputStream.getChannel();
            FileLock fileLock = ((FileChannel)abstractInterruptibleChannel).tryLock();
            if (fileLock != null && fileLock.isValid()) {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
                this.marshal(bufferedWriter);
                bl = true;
            } else {
                logger.warn("Because failed to get file lock, failed to write back file:" + file.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            logger.trace(file.getPath() + " write failed.");
            logger.trace(iOException.getMessage(), iOException);
        }
        finally {
            try {
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                    abstractInterruptibleChannel = null;
                }
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                    bufferedWriter = null;
                }
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
            if (bl) {
                if (file.exists()) {
                    file2.delete();
                }
            } else {
                file.delete();
                if (file2.renameTo(file)) {
                    file2.delete();
                }
            }
            this.writeStyleInfoSuccess = bl;
        }
    }

    static void writeDocument(Writer writer, char[] cArray, int n, int n2) throws IOException {
        writer.write(cArray, n, n2);
        writer.flush();
    }

    public void marshal(Writer writer) throws IOException {
        parser.marshal(this, writer);
        this.writeStyleInfoSuccess = parser.isWriteInfoSuccess();
    }

    public static CommStyleInfo unmarshal(InputStream inputStream) {
        return parser.unmarshal(inputStream);
    }

    public static CommStyleInfo unmarshal(File file) {
        return parser.unmarshal(file);
    }

    public static CommStyleInfo unmarshal(String string) {
        if ("true".equals(System.getProperty("iview.osgi"))) {
            FileInputStream fileInputStream = null;
            CommStyleInfo commStyleInfo = null;
            String string2 = CommonUtil.getAbsolutePath(string);
            try {
                fileInputStream = new FileInputStream(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.trace("File may not exist :" + string + fileNotFoundException.getMessage());
                return null;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            commStyleInfo = parser.unmarshal(inputStreamReader);
            if (null != fileInputStream) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    logger.trace("fail to close stream " + iOException);
                }
            }
            return commStyleInfo;
        }
        return parser.unmarshal(string);
    }

    public static CommStyleInfo unmarshal(Reader reader) {
        return parser.unmarshal(reader);
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String string) {
        this.publicId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public Element marshal() {
        return parser.marshal(this);
    }

    public static CommStyleInfo unmarshal(Element element) {
        return parser.unmarshal(element);
    }

    @Override
    public ErrorList validate(boolean bl) {
        ErrorList errorList = new ErrorList();
        if (this._objAreaDescContainer.size() == 0) {
            errorList.add(new ElementError(this, AreaDescContainer.class));
            if (bl) {
                return errorList;
            }
        } else {
            for (AreaDescContainer areaDescContainer : this._objAreaDescContainer) {
                if (areaDescContainer == null) continue;
                errorList.add(areaDescContainer.validate(bl));
                if (!bl || errorList.size() <= 0) continue;
                return errorList;
            }
        }
        return errorList.size() == 0 ? null : errorList;
    }

    public List _getChildren() {
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        if (this._objAreaDescContainer != null && this._objAreaDescContainer.size() > 0) {
            arrayList.add(this._objAreaDescContainer);
        }
        return arrayList;
    }

    @Override
    public String get_TagName() {
        return _tagName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        StringWriter stringWriter = new StringWriter();
        StringReader stringReader = null;
        BufferedReader bufferedReader = null;
        try {
            this.marshal(stringWriter);
            stringReader = new StringReader(stringWriter.toString());
            bufferedReader = new BufferedReader(stringReader);
            int n2 = 10;
            String string = bufferedReader.readLine();
            while (string != null) {
                graphics2D.drawString(string, 10, n2);
                n2 += 10;
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.trace(iOException.getMessage(), iOException);
                }
            }
            if (stringReader != null) {
                try {
                    stringReader.close();
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                }
            }
        }
        return 0;
    }

    public void toPrinter() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        printerJob.setPrintable(this, pageFormat);
        try {
            printerJob.print();
        }
        catch (PrinterException printerException) {
            logger.trace(printerException.getMessage(), printerException);
        }
    }

    public void toString(Writer writer, IViewStringBuffer iViewStringBuffer) throws IOException {
        iViewStringBuffer.append(this.headString());
        iViewStringBuffer.append(lineSeparator);
        iViewStringBuffer.append(leftXMLBracket);
        iViewStringBuffer.append(this.get_TagName());
        iViewStringBuffer.append(rightXMLBracket);
        iViewStringBuffer.append(lineSeparator);
        Iterator iterator = this._objAreaDescContainer.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            AreaDescContainer areaDescContainer = (AreaDescContainer)iterator.next();
            if (areaDescContainer != null) {
                areaDescContainer.toString(writer, iViewStringBuffer, n);
                iViewStringBuffer.append(lineSeparator);
            }
            CommStyleInfo.writeDocument(writer, iViewStringBuffer.getValue(), 0, iViewStringBuffer.length());
            iViewStringBuffer.setLength(0);
        }
        iViewStringBuffer.append(endLeftXMLBracket);
        iViewStringBuffer.append(this.get_TagName());
        iViewStringBuffer.append(rightXMLBracket);
    }

    private String headString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"");
        stringBuffer.append(this.getEncoding());
        stringBuffer.append("\"?>");
        stringBuffer.append(lineSeparator);
        stringBuffer.append(this.getDTDHeader());
        return stringBuffer.toString();
    }

    public String getEncoding() {
        if (null == this.encoding) {
            return CommStyleInfo.getResourceEncoding();
        }
        return this.encoding;
    }

    public static String getResourceEncoding() {
        return ResourceUtil.CLIENT_ENCODING;
    }

    public String getDTDHeader() {
        StringBuffer stringBuffer = new StringBuffer(50);
        if (this.hasDtdHeader) {
            stringBuffer.append("<!DOCTYPE COMMINIDATA SYSTEM \"");
            stringBuffer.append(this.systemId);
            stringBuffer.append("\">");
        }
        return stringBuffer.toString();
    }

    public static String normalize(String string) {
        IViewStringBuffer iViewStringBuffer = new IViewStringBuffer();
        CommStyleInfo.normalizeToStrBuffer(iViewStringBuffer, string);
        return iViewStringBuffer.toString();
    }

    public static void normalizeToStrBuffer(IViewStringBuffer iViewStringBuffer, String string) {
        int n = string != null ? string.length() : 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    iViewStringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    iViewStringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    iViewStringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    iViewStringBuffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    iViewStringBuffer.append("&apos;");
                    continue block7;
                }
                default: {
                    iViewStringBuffer.append(c);
                }
            }
        }
    }

    public static void appSPACE(IViewStringBuffer iViewStringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            iViewStringBuffer.append(SPACESTR);
        }
    }

    public void mergeCommStyleInfo(CommStyleInfo commStyleInfo) {
        if (commStyleInfo == null) {
            return;
        }
        AreaDescContainer areaDescContainer = null;
        AreaDescContainer areaDescContainer2 = null;
        for (int i = 0; i < commStyleInfo.getAreaDescContainerCount(); ++i) {
            areaDescContainer = commStyleInfo.getAreaDescContainer(i);
            areaDescContainer2 = areaDescContainer.getAreaName() == null || areaDescContainer.getAreaName().length() < 1 ? this.getAreaDescContainer(i) : this.getAreaDescContainer(areaDescContainer.getAreaName());
            if (areaDescContainer2 != null) {
                areaDescContainer2.mergeAreaDesc(areaDescContainer);
                continue;
            }
            this.addAreaDescContainer(areaDescContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private File backupFile(File file) {
        FileLock fileLock;
        FileLock fileLock2;
        File file2;
        FileChannel fileChannel;
        FileChannel fileChannel2;
        FileOutputStream fileOutputStream;
        RandomAccessFile randomAccessFile;
        block10: {
            block9: {
                randomAccessFile = null;
                fileOutputStream = null;
                fileChannel2 = null;
                fileChannel = null;
                file2 = new File(file.getAbsolutePath() + BACKUP_FILE_EXT);
                fileLock2 = null;
                fileLock = null;
                randomAccessFile = new RandomAccessFile(file, "rw");
                fileChannel2 = randomAccessFile.getChannel();
                fileLock = fileChannel2.tryLock(0L, fileChannel2.size(), false);
                if (fileLock == null || !fileLock.isValid()) break block9;
                fileOutputStream = new FileOutputStream(file2);
                fileChannel = fileOutputStream.getChannel();
                fileLock2 = fileChannel.tryLock();
                if (fileLock2 != null && fileLock2.isValid()) {
                    fileChannel.transferFrom(fileChannel2, 0L, fileChannel2.size());
                    break block10;
                }
                logger.trace(" backupFile return null ");
                File file3 = null;
                this.releaseLock(fileLock);
                this.releaseLock(fileLock2);
                this.closeChannel(fileChannel2);
                this.closeChannel(fileChannel);
                this.closeStream(randomAccessFile);
                this.closeStream(fileOutputStream);
                return file3;
            }
            try {
                logger.trace(" read file ######### return null ");
                File file4 = null;
                this.releaseLock(fileLock);
                this.releaseLock(fileLock2);
                this.closeChannel(fileChannel2);
                this.closeChannel(fileChannel);
                this.closeStream(randomAccessFile);
                this.closeStream(fileOutputStream);
                return file4;
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.trace(file.getPath() + " read failed.");
                logger.trace(fileNotFoundException.getMessage(), fileNotFoundException);
                this.releaseLock(fileLock);
                this.releaseLock(fileLock2);
                this.closeChannel(fileChannel2);
                this.closeChannel(fileChannel);
                this.closeStream(randomAccessFile);
                this.closeStream(fileOutputStream);
            }
            catch (IOException iOException) {
                logger.trace(file2.getPath() + " write failed.");
                logger.trace(iOException.getMessage(), iOException);
                this.releaseLock(fileLock);
                this.releaseLock(fileLock2);
                this.closeChannel(fileChannel2);
                this.closeChannel(fileChannel);
                this.closeStream(randomAccessFile);
                this.closeStream(fileOutputStream);
                {
                    catch (Throwable throwable) {
                        this.releaseLock(fileLock);
                        this.releaseLock(fileLock2);
                        this.closeChannel(fileChannel2);
                        this.closeChannel(fileChannel);
                        this.closeStream(randomAccessFile);
                        this.closeStream(fileOutputStream);
                        throw throwable;
                    }
                }
            }
        }
        this.releaseLock(fileLock);
        this.releaseLock(fileLock2);
        this.closeChannel(fileChannel2);
        this.closeChannel(fileChannel);
        this.closeStream(randomAccessFile);
        this.closeStream(fileOutputStream);
        if (file2.length() != file.length()) {
            file2 = null;
        }
        return file2;
    }

    private void releaseLock(FileLock fileLock) {
        if (null != fileLock) {
            try {
                fileLock.release();
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
    }

    private void closeChannel(FileChannel fileChannel) {
        if (null != fileChannel) {
            try {
                fileChannel.close();
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
    }

    private void closeStream(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
                closeable = null;
            }
        }
        catch (IOException iOException) {
            logger.trace(iOException);
        }
    }

    public Resource getResource() {
        String string = this.getPluginName();
        if (null != string) {
            return this.pluginRes;
        }
        return null;
    }

    public void setPluginResource(Resource resource) {
        this.pluginRes = resource;
    }

    public void setPluginName(String string) {
        this.pluginName = string;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getRelatFileName() {
        return this.relatFileName;
    }

    public void setRelatFileName(String string) {
        this.relatFileName = string;
    }

    public void setUrlExternalForm(String string) {
        this.urlExternalForm = string;
    }

    public String getUrlExternalForm() {
        return this.urlExternalForm;
    }
}

