/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.ClassNotAllowedException;
import com.swimap.iview.util.log.IviewLogger;
import java.lang.reflect.Method;

public class ClassUtils {
    private static IviewLogger logger = IviewLogger.getLogger(ClassUtils.class, "IVIEW");

    public static Object createObject(Class clazz, Class clazz2) throws ClassNotAllowedException {
        try {
            if (!clazz2.isAssignableFrom(clazz)) {
                throw new ClassNotAllowedException("Illegal class " + clazz);
            }
            return clazz.newInstance();
        }
        catch (ClassNotAllowedException classNotAllowedException) {
            throw classNotAllowedException;
        }
        catch (Exception exception) {
            throw new ClassNotAllowedException("Could not create " + clazz);
        }
    }

    public static Class findClass(String string) throws ClassNotAllowedException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassNotAllowedException("Can not find class " + string);
        }
    }

    public static Object callTheMethod(Object object, String string) {
        Method method = null;
        Object[] objectArray = new Object[]{};
        Class[] classArray = new Class[]{};
        try {
            method = object.getClass().getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        if (method != null) {
            try {
                return method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
        return null;
    }
}

