/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.authority.ActionManager;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityView;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IComminiProperties;
import com.swimap.iview.commstyle.commini.IUIObjState;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.commstyle.commini.foldingmenus.FoldingCBMenuItem;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationmanagement.AppCheckboxMenuItem;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.util.log.IviewLogger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class CheckBoxMenuItem
extends FoldingCBMenuItem
implements IUIObjState,
IComminiProperties {
    private static IviewLogger logger = IviewLogger.getLogger(CheckBoxMenuItem.class, "IVIEW");
    private DescContainer m_desc;
    private AuthorityAction menuItemAction = null;
    private AuthorityView authorityViewAction = null;
    private boolean commandDefined = false;
    private String secondaryID = null;
    private int serialNumber = Integer.MIN_VALUE;
    private String command = null;

    public CheckBoxMenuItem() {
        this.m_desc = new DescContainer();
    }

    @Override
    public String getID() {
        return this.m_desc.getDescName();
    }

    public CheckBoxMenuItem(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        try {
            if (!"JMenuItem".equals(descContainer.getParasItem("type").getValue())) {
                logger.trace("descContainer is not JMenuItem type");
            }
            this.m_desc = descContainer;
            CommStyleInfo commStyleInfo = (CommStyleInfo)descContainer._getRootParent();
            String string = descContainer.getParasItemValue("name");
            String string2 = commStyleInfo.getResString(string);
            this.setName(string);
            if (string2 != null) {
                this.setText(string2);
            } else {
                this.setText(string);
            }
            this.command = descContainer.getParasItemValue("command");
            this.setActionCommand(this.command);
            if (this.command != null) {
                this.commandDefined = true;
            }
            this.secondaryID = descContainer.getParasItemValue("secondaryid");
            this.initAction();
            String string3 = descContainer.getParasItemValue("mnemonic");
            if (string3 != null && string3.trim().length() > 0) {
                this.setMnemonic(string3.charAt(0));
            }
            String string4 = null;
            string4 = descContainer.getParasItemValue("description");
            if (string4 != null) {
                string2 = commStyleInfo.getResString(string4);
                if (string2 != null) {
                    this.setToolTipText(string2);
                } else {
                    this.setToolTipText(string4);
                }
            }
            String string5 = null;
            try {
                string5 = descContainer.getParasItem("icon").getValue();
            }
            catch (Exception exception) {
                string5 = null;
            }
            if (string5 != null) {
                this.setIcon(ResourceMng.getInstance().getIconDirect(string5));
            }
            String string6 = null;
            try {
                string6 = descContainer.getParasItem("accelerator").getValue();
            }
            catch (Exception exception) {
                string6 = null;
            }
            if (string6 != null) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(string6);
                this.setAccelerator(keyStroke);
            }
            try {
                this.setSelected("true".equals(descContainer.getParasItem("checked").getValue()));
            }
            catch (Exception exception) {
                logger.trace("CheckBoxMenuItem-CheckBoxMenuItem\uff0cchecked is not configured.");
            }
        }
        catch (Exception exception) {
            throw new UIObjectDescriptionNotCorrectException("CheckBoxMenuItem:UI Object can not be create from the Description, check your Style file ");
        }
    }

    protected void initAction() {
        String string = null;
        if (this.m_desc.getParasItem("action") != null) {
            string = this.m_desc.getParasItem("action").getValue();
        }
        if (string != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
                this.menuItemAction = (AuthorityAction)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.trace(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                logger.trace(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.trace(illegalAccessException);
            }
            if (null != this.menuItemAction) {
                this.menuItemAction.setSource(this);
            }
            if (!this.commandDefined) {
                this.setAction(this.menuItemAction);
            }
        }
    }

    @Override
    public void setMnemonic(char c) {
        String string = this.getText();
        super.setMnemonic(c);
        String string2 = ".*\\(" + c + "\\)";
        if (string != null && (string.toLowerCase().matches(string2) || string.toUpperCase().matches(string2))) {
            this.setDisplayedMnemonicIndex(string.length() - 2);
        }
    }

    public static Object getUIObject(DescContainer descContainer) {
        CheckBoxMenuItem checkBoxMenuItem = null;
        try {
            checkBoxMenuItem = FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.traditional ? new CheckBoxMenuItem(descContainer) : new AppCheckboxMenuItem(descContainer);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return checkBoxMenuItem;
    }

    public static Object getPortalPopupUIObject(DescContainer descContainer) {
        AppCheckboxMenuItem appCheckboxMenuItem = null;
        try {
            String string;
            if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application && "true".equalsIgnoreCase(string = descContainer.getParasItemValue("showInPortalPanel"))) {
                appCheckboxMenuItem = new AppCheckboxMenuItem(descContainer);
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return appCheckboxMenuItem;
    }

    @Override
    public String getState(String string) {
        return this.m_desc.getParasItemValue(string);
    }

    @Override
    public boolean setState(String string, String string2) {
        this.m_desc.setParasItem(string, string2, true);
        return true;
    }

    public String getParaValue(String string) {
        return this.m_desc.getParasItemValue(string);
    }

    @Override
    public int getSerialNumber() {
        if (this.serialNumber != Integer.MIN_VALUE) {
            return this.serialNumber;
        }
        this.serialNumber = -1;
        String string = this.m_desc.getParasItemValue("serialnumber");
        if (string == null || string.trim().length() == 0) {
            return this.serialNumber;
        }
        int n = string.lastIndexOf("-");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        try {
            this.serialNumber = Integer.parseInt(string);
        }
        catch (Exception exception) {
            logger.error("sSerialNumber=" + string);
            logger.trace(exception.getMessage(), exception);
        }
        return this.serialNumber;
    }

    @Override
    public void setAction(Action action) {
        if (null == action) {
            return;
        }
        super.setAction(action);
        if (this.commandDefined && this.menuItemAction == null) {
            ActionManager.configActionToButton(this, (AuthorityAction)action);
        }
        Icon icon = this.getIcon();
        String string = this.getText();
        String string2 = this.getToolTipText();
        int n = this.getMnemonic();
        KeyStroke keyStroke = this.getAccelerator();
        this.setText(string);
        this.setMnemonic(n);
        if (null != keyStroke) {
            this.setAccelerator(keyStroke);
        }
        if (null != string2) {
            this.setToolTipText(string2);
        }
        if (null != icon) {
            this.setIcon(icon);
        }
    }

    public AbstractAction getMenuItemAction() {
        return this.menuItemAction;
    }

    public AuthorityView getMenuItemView() {
        return this.authorityViewAction;
    }

    public void updateMenuItem() {
        try {
            if (this.menuItemAction != null) {
                this.setEnabled(this.menuItemAction.isActionEnabled());
                this.setVisible(this.menuItemAction.isActionVisible());
            } else if (this.commandDefined) {
                CommandManager commandManager = CommandManager.getInstance();
                this.authorityViewAction = commandManager.getAuthorityViewAction(this.command);
                if (null != this.authorityViewAction) {
                    boolean bl = commandManager.securityInfoCheck(this.command);
                    this.setEnabled(this.authorityViewAction.isEnabled(this.command) && bl);
                    this.setVisible(this.authorityViewAction.isVisible(this.command));
                }
            } else {
                logger.trace("no authority action or command  is defined for menu itme");
            }
        }
        catch (Throwable throwable) {
            logger.trace("Iview Handled Error while updating Checkbox menuitem" + this.getName(), throwable);
        }
    }

    public boolean isCommandDefined() {
        return this.commandDefined;
    }

    public String getSecondaryId() {
        return this.secondaryID;
    }

    public char getMnemonicCheckBox() {
        String string = "";
        string = this.m_desc.getParasItemValue("mnemonic");
        if (string != null && string.trim().length() > 0) {
            return string.charAt(0);
        }
        return '\u0000';
    }
}

