/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.framework.lookandfeel.button.SwimapButtonListener;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import javax.swing.text.View;

public class BorderlessToggleButton
extends JToggleButton
implements MouseListener {
    public BorderlessToggleButton() {
        this.setName("BorderlessToggleButton");
        this.setBorderPainted(false);
        this.addMouseListener(this);
        super.setUI(new ToggleButtonUI());
    }

    public BorderlessToggleButton(Icon icon) {
        super(icon);
        this.setName("BorderlessToggleButton");
        this.setBorderPainted(false);
        this.addMouseListener(this);
        super.setUI(new ToggleButtonUI());
    }

    public BorderlessToggleButton(String string) {
        super(string);
        this.setName("BorderlessToggleButton");
        this.setBorderPainted(false);
        this.addMouseListener(this);
        super.setUI(new ToggleButtonUI());
    }

    public BorderlessToggleButton(String string, Icon icon) {
        super(string, icon);
        this.setName("BorderlessToggleButton");
        this.setBorderPainted(false);
        this.addMouseListener(this);
        super.setUI(new ToggleButtonUI());
    }

    @Override
    public void updateUI() {
        this.setUI(new ToggleButtonUI());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl && this.isBorderPainted()) {
            this.setBorderPainted(false);
            this.repaint();
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public boolean hasFocus() {
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.isBorderPainted() && this.isEnabled()) {
            this.setBorderPainted(true);
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.isBorderPainted()) {
            this.setBorderPainted(false);
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            if (this.getModel().isArmed() && this.getModel().isPressed() || this.getModel().isSelected()) {
                graphics.setColor(UIManager.getColor("ToolbarButton.borderColor"));
                graphics.drawRect(0, 0, this.getBounds().width - 1, this.getBounds().height - 1);
            } else {
                graphics.setColor(UIManager.getColor("ToolbarButton.borderColor"));
                graphics.drawRect(0, 0, this.getBounds().width - 1, this.getBounds().height - 1);
            }
        } else if (this.getModel().isSelected()) {
            graphics.setColor(UIManager.getColor("ToolbarButton.borderColor"));
            graphics.drawRect(0, 0, this.getBounds().width - 1, this.getBounds().height - 1);
        } else {
            super.paintBorder(graphics);
        }
    }

    protected class ToggleButtonUI
    extends MetalToggleButtonUI {
        protected ToggleButtonUI() {
        }

        @Override
        protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
            graphics.setColor(UIManager.getColor("ToolbarButton.pressedBackground"));
            graphics.fillRect(1, 1, abstractButton.getBounds().width - 2, abstractButton.getBounds().height - 2);
        }

        @Override
        protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
            return new SwimapButtonListener(abstractButton);
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            Object object;
            AbstractButton abstractButton = (AbstractButton)jComponent;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle rectangle = new Rectangle(abstractButton.getSize());
            Insets insets = jComponent.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.right + rectangle.x;
            rectangle.height -= insets.bottom + rectangle.y;
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            graphics.setFont(jComponent.getFont());
            String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
            graphics.setColor(abstractButton.getBackground());
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                this.paintButtonPressed(graphics, abstractButton);
            } else if (abstractButton.isOpaque()) {
                object = (Boolean)abstractButton.getClientProperty("background");
                if (BorderlessToggleButton.this.isBorderPainted() && (object == null || !((Boolean)object).booleanValue() || abstractButton.getBackground() == UIManager.getColor("Button.background") && ((Boolean)object).booleanValue())) {
                    graphics.setColor(UIManager.getColor("ToolbarButton.reoverBackground"));
                    graphics.fillRect(1, 1, abstractButton.getBounds().width - 2, abstractButton.getBounds().height - 2);
                }
            }
            if (abstractButton.getIcon() != null) {
                this.paintIcon(graphics, abstractButton, rectangle2);
            }
            if (string != null && string.length() > 0) {
                object = (View)jComponent.getClientProperty("html");
                if (object != null) {
                    ((View)object).paint(graphics, rectangle3);
                } else {
                    this.paintText(graphics, (JComponent)abstractButton, rectangle3, string);
                }
            }
            if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
                this.paintFocus(graphics, abstractButton, rectangle, rectangle3, rectangle2);
            }
        }
    }
}

