/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.framework.lookandfeel.button.SwimapButtonListener;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalButtonUI;

public class BorderlessButton
extends JButton
implements MouseListener,
AncestorListener {
    public BorderlessButton() {
        this.buttonInit();
    }

    public BorderlessButton(Icon icon) {
        super(icon);
        this.buttonInit();
    }

    public BorderlessButton(String string) {
        super(string);
        this.buttonInit();
    }

    public BorderlessButton(String string, Icon icon) {
        super(string, icon);
        this.buttonInit();
    }

    private void buttonInit() {
        super.putClientProperty("BorderlessButton", Boolean.TRUE);
        this.setName("BorderlessButton");
        this.setBorderPainted(false);
        this.addMouseListener(this);
        this.addAncestorListener(this);
        super.setUI(new ToolBarButtonUI());
    }

    @Override
    public void updateUI() {
        this.setUI(new ToolBarButtonUI());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl && this.isBorderPainted()) {
            this.setBorderPainted(false);
            this.repaint();
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public boolean hasFocus() {
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.isBorderPainted() && this.isEnabled()) {
            this.setBorderPainted(true);
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.isBorderPainted()) {
            this.setBorderPainted(false);
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            if (this.getModel().isArmed() && this.getModel().isPressed()) {
                graphics.setColor(UIManager.getColor("ToolbarButton.borderColor"));
                graphics.drawRect(0, 0, this.getBounds().width - 1, this.getBounds().height - 1);
            } else {
                graphics.setColor(UIManager.getColor("ToolbarButton.borderColor"));
                graphics.drawRect(0, 0, this.getBounds().width - 1, this.getBounds().height - 1);
            }
        } else {
            super.paintBorder(graphics);
        }
    }

    protected class ToolBarButtonUI
    extends MetalButtonUI {
        protected ToolBarButtonUI() {
        }

        @Override
        protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
            graphics.setColor(UIManager.getColor("ToolbarButton.pressedBackground"));
            graphics.fillRect(1, 1, abstractButton.getBounds().width - 2, abstractButton.getBounds().height - 2);
        }

        @Override
        protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
            return new SwimapButtonListener(abstractButton);
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            Boolean bl = (Boolean)abstractButton.getClientProperty("background");
            if (BorderlessButton.this.isBorderPainted() && (bl == null || !bl.booleanValue() || abstractButton.getBackground() == UIManager.getColor("Button.background") && bl.booleanValue())) {
                if (abstractButton.getModel().isArmed() && abstractButton.getModel().isPressed()) {
                    this.paintButtonPressed(graphics, abstractButton);
                } else {
                    graphics.setColor(UIManager.getColor("ToolbarButton.reoverBackground"));
                    graphics.fillRect(0, 0, abstractButton.getBounds().width - 1, abstractButton.getBounds().height - 1);
                }
            }
            super.paint(graphics, jComponent);
        }
    }
}

