/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commandmng.authority;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;

public final class ActionManager {
    private static ActionManager instance = new ActionManager();
    private Map actionMap = Collections.synchronizedMap(new HashMap());
    private Map actionView = Collections.synchronizedMap(new HashMap());

    private ActionManager() {
    }

    public static ActionManager getInstance() {
        return instance;
    }

    public void putAction(String string, AuthorityAction authorityAction) {
        if (string == null) {
            throw new IllegalArgumentException("commandID cannot be null.");
        }
        if (authorityAction == null) {
            throw new IllegalArgumentException("action cannot be null.");
        }
        this.actionMap.put(string, authorityAction);
    }

    public void putAuthorityView(String string, AuthorityView authorityView) {
        if (string == null) {
            throw new IllegalArgumentException("commandID cannot be null.");
        }
        if (authorityView == null) {
            throw new IllegalArgumentException("AuthorityView cannot be null.");
        }
        this.actionView.put(string, authorityView);
    }

    public void putAction(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("map cannot be null.");
        }
        this.actionMap.putAll(map);
    }

    public AuthorityAction getAction(String string) {
        return (AuthorityAction)this.actionMap.get(string);
    }

    public AuthorityView getAuthorityView(String string) {
        return (AuthorityView)this.actionView.get(string);
    }

    public Map getActionMap() {
        return Collections.unmodifiableMap(this.actionMap);
    }

    public void removeAction(String string) {
        this.actionMap.remove(string);
    }

    public void update() {
        Collection collection = this.actionMap.values();
        AuthorityAction authorityAction = null;
        for (Object v : collection) {
            authorityAction = (AuthorityAction)v;
            authorityAction.update();
        }
    }

    public void clear() {
        Set set = this.actionMap.keySet();
        Iterator iterator = set.iterator();
        String string = null;
        ArrayList arrayList = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            arrayList = CommandManager.getInstance().getAbstractButton(string);
            if (arrayList == null) continue;
            int n = arrayList.size();
            AbstractButton abstractButton = null;
            for (int i = 0; i < n; ++i) {
                abstractButton = (AbstractButton)arrayList.get(i);
                abstractButton.setAction(null);
                abstractButton.setIcon(abstractButton.getIcon());
                abstractButton.setText(abstractButton.getText());
                abstractButton.setMnemonic(abstractButton.getMnemonic());
                abstractButton.setActionCommand(abstractButton.getActionCommand());
                abstractButton.setToolTipText(abstractButton.getToolTipText());
            }
        }
        this.actionMap.clear();
        this.actionView.clear();
    }

    public static final void configActionToButton(final AbstractButton abstractButton, AuthorityAction authorityAction) {
        if (abstractButton == null) {
            throw new IllegalArgumentException("button is null.");
        }
        if (authorityAction == null) {
            return;
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("visibled".equals(propertyChangeEvent.getPropertyName())) {
                    Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    abstractButton.setVisible(bl);
                } else if ("selected".equals(propertyChangeEvent.getPropertyName())) {
                    Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    abstractButton.setSelected(bl);
                }
            }
        };
        abstractButton.setVisible(authorityAction.isVisible());
        abstractButton.setSelected(authorityAction.isSelected());
        authorityAction.addPropertyChangeListener(propertyChangeListener);
    }
}

