/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commandmng;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.ICommandProcessor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.AbstractButton;

public class CommandSource
implements ActionListener {
    private ICommandProcessor m_commandProcessor = null;
    protected AbstractButton m_button;

    public AbstractButton getButton() {
        return this.m_button;
    }

    public CommandSource(AbstractButton abstractButton) {
        this.m_button = abstractButton;
        if (this.m_button != null) {
            if (this.m_button.getAction() != null) {
                return;
            }
            EventListener[] eventListenerArray = this.m_button.getListeners(ActionListener.class);
            for (int i = 0; i < eventListenerArray.length; ++i) {
                if (!(eventListenerArray[i] instanceof CommandSource)) continue;
                this.m_button.removeActionListener((ActionListener)eventListenerArray[i]);
            }
            this.m_button.addActionListener(this);
            this.setEnable();
        }
    }

    protected void setEnable() {
        if (!CommandManager.getInstance().checkAuthorityAction(this.m_button)) {
            this.m_button.setEnabled(false);
        }
    }

    public String getCommand() {
        return this.m_button.getActionCommand();
    }

    public void setEnabled(boolean bl) {
        if (!CommandManager.getInstance().checkAuthorityAction(this.m_button)) {
            this.m_button.setEnabled(bl);
        }
    }

    public boolean setCommandProcessor(ICommandProcessor iCommandProcessor) {
        this.m_commandProcessor = iCommandProcessor;
        return true;
    }

    public ICommandProcessor getCommandProcessor() {
        return this.m_commandProcessor;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        CommandManager.getInstance().invoke(this, actionEvent);
    }
}

