/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap12.util.pagedTable;

import com.swimap.imap12.util.pagedTable.InmPagedTable;
import com.swimap.imap12.util.pagedTable.InmPagedTableModel;
import com.swimap.imap12.util.pagedTable.InmToolTipPanel;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class InmTableScrollPane
extends JScrollPane
implements TableModelListener,
MouseWheelListener {
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/imap12/util/pagedTable/Res");
    private InmPagedTable pagedTable = null;
    private VerticalScollBar verticalTableScrollBar = null;
    private InmToolTipPanel tooltipPanel = null;
    private int tipXPos = 0;
    private int tipYPos = 0;
    private int scrollIncrement = 6;
    public static int prevousRow = 0;

    public InmTableScrollPane(InmPagedTable inmPagedTable) {
        this.pagedTable = inmPagedTable;
        this.pagedTable.setName("InmTableScrollPane_pagedTable");
        this.initialize();
    }

    public InmTableScrollPane(InmPagedTableModel inmPagedTableModel) {
        this.pagedTable = new InmPagedTable(inmPagedTableModel);
        this.pagedTable.setName("InmTableScrollPane_pagedTable");
        this.initialize();
    }

    private void initialize() {
        this.pagedTable.getModel().addTableModelListener(this);
        this.pagedTable.addMouseWheelListener(this);
        this.pagedTable.setTableScrollPane(this);
        this.setVerticalScrollBarPolicy(21);
        this.setHorizontalScrollBarPolicy(30);
        this.setDoubleBuffered(true);
        this.getViewport().add(this.pagedTable);
        this.verticalTableScrollBar = new VerticalScollBar();
        this.verticalTableScrollBar.setName("InmTableScrollPane_verticalTableScrollBar");
        this.tooltipPanel = new InmToolTipPanel(this.verticalTableScrollBar);
        this.tooltipPanel.setName("InmTableScrollPane_tooltipPanel");
        this.tooltipPanel.setVisible(false);
        this.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                InmTableScrollPane.this.originalScrollPaneAdjustmentValueChanged(adjustmentEvent);
            }
        });
        this.verticalTableScrollBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                InmTableScrollPane.this.showTip();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                InmTableScrollPane.this.hideTip();
            }
        });
        this.verticalTableScrollBar.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                InmTableScrollPane.this.showTip();
            }
        });
        this.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JScrollBar jScrollBar = InmTableScrollPane.this.getVerticalScrollBar();
                AdjustmentEvent adjustmentEvent = new AdjustmentEvent(jScrollBar, 601, 1, jScrollBar.getValue());
                InmTableScrollPane.this.originalScrollPaneAdjustmentValueChanged(adjustmentEvent);
            }
        });
    }

    private void showTip() {
        if (!this.verticalTableScrollBar.isEnabled() || 0 == this.pagedTable.getRowCount() || this.getVerticalScrollBar().getMaximum() == this.getVerticalScrollBar().getVisibleAmount()) {
            return;
        }
        this.refreshTipText(this.verticalTableScrollBar.getValue());
        this.tooltipPanel.show(this.tipXPos, this.tipYPos);
    }

    private void hideTip() {
        if (this.tooltipPanel.isVisible()) {
            this.tooltipPanel.setVisible(false);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = this.verticalTableScrollBar.getValue();
        n = mouseWheelEvent.getWheelRotation() > 0 ? (n += this.scrollIncrement) : (n -= this.scrollIncrement);
        this.srollToPosition(n);
    }

    public void setScrollIncrement(int n) {
        this.scrollIncrement = n;
    }

    public int getscrollIncrement() {
        return this.scrollIncrement;
    }

    public void originalScrollPaneAdjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        this.verticalTableScrollBar.refreshProperties();
        this.verticalTableScrollBar.setValue(n);
        int n2 = this.pagedTable.rowAtPoint(new Point(1, n));
        if (Math.abs(prevousRow - n2) > ((InmPagedTableModel)this.pagedTable.getModel()).getPageSize() - 2) {
            this.pagedTable.updateData(adjustmentEvent.getValue());
            this.pagedTable.revalidate();
            this.pagedTable.repaint();
            prevousRow = n2;
        }
    }

    private void refreshTipText(int n) {
        if (this.verticalTableScrollBar.isEnabled() && this.getVerticalScrollBar().getMaximum() > this.getVerticalScrollBar().getVisibleAmount()) {
            float f = (float)n / (float)(this.getVerticalScrollBar().getMaximum() - this.getVerticalScrollBar().getVisibleAmount());
            int n2 = (int)((float)this.pagedTable.getRowCount() * f) + 1;
            if (this.pagedTable.getRowCount() < n2) {
                n2 = this.pagedTable.getRowCount();
            }
            JToolTip jToolTip = new JToolTip();
            String string = MessageFormat.format(res.getString("NO_TOTAL_KEY"), String.valueOf(n2), String.valueOf(this.pagedTable.getRowCount()));
            jToolTip.setTipText(string);
            this.tooltipPanel.addTip(jToolTip);
            this.tooltipPanel.setVisible(this.tooltipPanel.isVisible());
        }
    }

    public int getCurrentRow() {
        float f = (float)this.getVerticalScrollBar().getValue() / (float)(this.getVerticalScrollBar().getMaximum() - this.getVerticalScrollBar().getVisibleAmount());
        int n = (int)((float)this.pagedTable.getRowCount() * f);
        return n;
    }

    public int getCurrentColumn() {
        float f = (float)this.getHorizontalScrollBar().getValue() / (float)(this.getHorizontalScrollBar().getMaximum() - this.getHorizontalScrollBar().getVisibleAmount());
        int n = (int)((float)this.pagedTable.getColumnCount() * f);
        return n;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.pagedTable.revalidate();
        this.pagedTable.repaint();
    }

    public VerticalScollBar getInmVerticalScrollBar() {
        return this.verticalTableScrollBar;
    }

    public void scrollPaneAdjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        JScrollBar jScrollBar = (JScrollBar)adjustmentEvent.getSource();
        if (!jScrollBar.getValueIsAdjusting()) {
            this.pagedTable.updateData(n);
            this.getVerticalScrollBar().setValue(n);
        }
    }

    public void srollToPosition(int n) {
        this.getVerticalScrollBar().setValue(n);
        this.verticalTableScrollBar.setValue(n);
    }

    public void scrollToRow(int n) {
        float f = (float)n / (float)this.pagedTable.getRowCount();
        int n2 = (int)((float)(this.getVerticalScrollBar().getMaximum() - this.getVerticalScrollBar().getVisibleAmount()) * f);
        this.getVerticalScrollBar().setValue(n2);
        this.verticalTableScrollBar.setValue(n2);
    }

    public class VerticalScollBar
    extends JScrollBar {
        public VerticalScollBar() {
            this.initialize();
        }

        public void initialize() {
            this.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    InmTableScrollPane.this.scrollPaneAdjustmentValueChanged(adjustmentEvent);
                }
            });
        }

        public void refreshProperties() {
            if ((int)InmTableScrollPane.this.getViewport().getViewRect().getHeight() > InmTableScrollPane.this.getVerticalScrollBar().getMaximum()) {
                this.setMaximum(0);
            } else {
                this.setMaximum(InmTableScrollPane.this.getVerticalScrollBar().getMaximum());
            }
            this.setMinimum(InmTableScrollPane.this.getVerticalScrollBar().getMinimum());
            this.setUnitIncrement(InmTableScrollPane.this.pagedTable.getRowHeight());
            this.setBlockIncrement((int)InmTableScrollPane.this.getViewport().getViewRect().getHeight());
            this.setVisibleAmount(InmTableScrollPane.this.getVerticalScrollBar().getVisibleAmount());
        }
    }
}

