/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap12.util.dateChooser;

import com.swimap.imap12.util.dateChooser.InmDateDocument;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Font;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class InmFormatDocument
extends PlainDocument {
    private static IviewLogger logger = IviewLogger.getLogger(InmFormatDocument.class, "IVIEW");
    private int newOffset = -1;
    protected String initString = null;
    protected byte type = 0;
    protected int[] separator = null;
    protected JTextComponent textComponent = null;
    private boolean isAM_PMenable = false;
    private static final int FONT_SIZE = 12;
    private static final int DEFAULT_VALUE = 255;
    private static final int MIN_YEAR = 1;
    private static final int MAX_YEAR = 9999;
    private static final int YEAR_LEN = 4;
    private boolean isRemove = false;
    private boolean fireEvent = true;
    public static boolean zFlag = false;
    private String formatString = "";

    public InmFormatDocument() {
    }

    public InmFormatDocument(JTextComponent jTextComponent, String string, int[] nArray) {
        if (string != null) {
            this.initString = string;
            this.separator = nArray;
            this.textComponent = jTextComponent;
            this.textComponent.setFont(new Font("Dialog", 0, 12));
            try {
                this.insertString(0, this.initString, null);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    public InmFormatDocument(JTextComponent jTextComponent, String string, int[] nArray, byte by) {
        this(jTextComponent, string, nArray);
        this.type = by;
        if (this.type == 7 || this.type == 9 || this.type == 11 || this.type == 12 || this.type == 13 || this.type == 18 || this.type == 20 || this.type == 14) {
            this.isAM_PMenable = true;
        }
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        boolean bl = true;
        if (!this.fireEvent) {
            bl = false;
        }
        this.fireEvent = false;
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n, string.length(), DocumentEvent.EventType.INSERT);
        this.textComponent.select(n, n);
        if (ResourceUtil.areEquals(string, this.initString)) {
            super.remove(0, super.getLength());
            super.insertString(n, string, attributeSet);
        } else {
            int n2 = string.length();
            if (n == 0 && this.initString != null && n2 == this.initString.length() && this.isValidated(n, string, attributeSet, this.isAM_PMenable)) {
                super.remove(0, this.textComponent.getText().length());
                super.insertString(n, string, attributeSet);
                if (bl) {
                    this.fireEvent = true;
                    this.fireInsertUpdate(defaultDocumentEvent);
                }
                return;
            }
            if (n2 > 1) {
                for (int i = 0; i < n2; ++i) {
                    this.insertString(n + i, string.substring(i, i + 1), null);
                }
                if (bl) {
                    this.fireEvent = true;
                    this.fireInsertUpdate(defaultDocumentEvent);
                }
                return;
            }
            this.newOffset = n;
            if (this.atSeparator(n)) {
                ++this.newOffset;
                if (this.newOffset >= this.initString.length()) {
                    if (bl) {
                        this.fireEvent = true;
                        this.fireInsertUpdate(defaultDocumentEvent);
                    }
                    return;
                }
                this.textComponent.setCaretPosition(this.newOffset);
            }
            if (" ".equals(string)) {
                if (bl) {
                    this.fireEvent = true;
                    this.fireInsertUpdate(defaultDocumentEvent);
                }
                return;
            }
            if (!this.isRemove && !this.isValidated(this.newOffset, string, attributeSet, this.isAM_PMenable)) {
                if (this.atSeparator(this.newOffset - 1) || this.newOffset == 0) {
                    int n3 = -1;
                    try {
                        n3 = Integer.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (bl) {
                            this.fireEvent = true;
                        }
                        return;
                    }
                    int n4 = this.getCalendarValueWithOffset(this.newOffset);
                    if (n4 != 255) {
                        if (n4 == 2 && n3 == 1 || n4 == 5 && n3 == 3) {
                            this.autoCorrectInput(this.newOffset, string, attributeSet);
                        }
                        if (n4 == 10) {
                            if (this.isAM_PMenable) {
                                if (n3 == 1) {
                                    this.autoCorrectInput(this.newOffset, string, attributeSet);
                                }
                            } else if (n3 == 2) {
                                this.autoCorrectInput(this.newOffset, string, attributeSet);
                            }
                        }
                        if (n4 == 1) {
                            this.autoYearCorrectInput(n3, this.newOffset);
                        }
                        if (n4 == 2 && n3 == 0 || n4 == 5 && n3 == 0) {
                            int n5 = -1;
                            try {
                                n5 = Integer.valueOf(this.textComponent.getText().substring(this.newOffset + 1, this.newOffset + 2));
                            }
                            catch (Exception exception) {
                                if (bl) {
                                    this.fireEvent = true;
                                }
                                return;
                            }
                            if (n5 == 0) {
                                super.remove(this.newOffset, 2);
                                super.insertString(this.newOffset, "0", attributeSet);
                                super.insertString(this.newOffset + 1, "1", attributeSet);
                                this.textComponent.setCaretPosition(this.newOffset + 1);
                            }
                        }
                    }
                }
                if (bl) {
                    this.fireEvent = true;
                    this.fireInsertUpdate(defaultDocumentEvent);
                }
                return;
            }
            if ((this.type == 7 || this.type == 9 || this.type == 11) && n >= InmDateDocument.YMDTSEPT[5]) {
                if (bl) {
                    this.fireEvent = true;
                    this.fireInsertUpdate(defaultDocumentEvent);
                }
                return;
            }
            if (this.type == 12 && n >= InmDateDocument.TIMESEPT[2]) {
                if (bl) {
                    this.fireEvent = true;
                    this.fireInsertUpdate(defaultDocumentEvent);
                }
                return;
            }
            if ((this.type == 13 || this.type == 18 || this.type == 20) && n >= InmDateDocument.YMDHMSEPT[4]) {
                if (bl) {
                    this.fireEvent = true;
                    this.fireInsertUpdate(defaultDocumentEvent);
                }
                return;
            }
            if (this.type == 14 && n >= InmDateDocument.HMSEPT[1]) {
                if (bl) {
                    this.fireEvent = true;
                    this.fireInsertUpdate(defaultDocumentEvent);
                }
                return;
            }
            if (this.atSeparator(this.newOffset)) {
                this.insertString(this.newOffset, string, attributeSet);
            } else {
                super.remove(this.newOffset, string.length());
                super.insertString(this.newOffset, string, attributeSet);
            }
            while (++this.newOffset < this.initString.length() && this.atSeparator(this.newOffset)) {
                if (this.newOffset >= this.initString.length()) continue;
                this.textComponent.setCaretPosition(this.newOffset);
            }
        }
        if (bl) {
            this.fireEvent = true;
            this.fireInsertUpdate(defaultDocumentEvent);
        }
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        Object object;
        this.isRemove = true;
        boolean bl = true;
        if (!this.fireEvent) {
            bl = false;
        }
        this.fireEvent = false;
        int n3 = this.textComponent.getCaretPosition();
        String string = this.textComponent.getSelectedText();
        String string2 = this.textComponent.getText();
        if (string != null) {
            int n4 = this.textComponent.getSelectionStart();
            object = string.toCharArray();
            for (int i = 0; i < ((char[])object).length; ++i) {
                if (!Character.isDigit(object[i])) continue;
                try {
                    this.insertString(n4 + i, "0", null);
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    logger.trace(badLocationException.getMessage(), badLocationException);
                }
            }
            this.textComponent.setCaretPosition(n3);
        } else if (n3 > n && n2 == 1) {
            if (n3 < 2) {
                this.insertString(0, "0", null);
                this.textComponent.setCaretPosition(0);
            } else if (this.atSeparator(n3 - 1)) {
                this.textComponent.setCaretPosition(n3 - 1);
            } else {
                this.insertString(n3 - 1, "0", null);
                this.textComponent.setCaretPosition(n3 - 1);
            }
        } else if (n3 == n && n2 == 1) {
            if (this.atSeparator(n3)) {
                this.textComponent.setCaretPosition(n3 + 1);
            } else {
                if (n3 == 12) {
                    zFlag = true;
                }
                this.insertString(n3, "0", null);
                this.textComponent.setCaretPosition(n3 + 1);
            }
        }
        this.validateNotNull(n, n2);
        this.validateNotZero(n);
        String string3 = this.textComponent.getText(n, n2);
        if (!this.isValidated(n, string3, null, this.isAM_PMenable)) {
            this.insertString(0, string2, null);
            if (string != null) {
                this.textComponent.setCaretPosition(n3);
            } else if (n3 == n && n2 == 1) {
                this.textComponent.setCaretPosition(n3 + 1);
            } else {
                this.textComponent.setCaretPosition(n);
            }
        }
        this.isRemove = false;
        if (bl) {
            object = new AbstractDocument.DefaultDocumentEvent(this, n, n2, DocumentEvent.EventType.REMOVE);
            this.fireEvent = true;
            this.fireRemoveUpdate((DocumentEvent)object);
        }
    }

    public void validateNotZero(int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.separator.length + 1; ++i) {
            String string;
            n3 = i < this.separator.length ? this.separator[i] : this.getLength();
            boolean bl = false;
            int n4 = n3 - n2;
            try {
                int n5;
                string = this.getText(n2, n4);
                if (string.trim().length() > 0 && Character.isDigit(string.charAt(0)) && (n5 = Integer.parseInt(string)) == 0) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.trace(numberFormatException.getMessage(), numberFormatException);
            }
            catch (BadLocationException badLocationException) {
                logger.trace(badLocationException.getMessage(), badLocationException);
            }
            try {
                string = this.getText(n2 - 1, 1);
                if (string != null && ":".equals(string)) {
                    bl = false;
                }
            }
            catch (BadLocationException badLocationException) {
                logger.trace(badLocationException.getMessage());
            }
            try {
                string = this.getText(n3, 1);
                if (string != null && ":".equals(string)) {
                    bl = false;
                }
            }
            catch (BadLocationException badLocationException) {
                logger.trace(badLocationException.getMessage());
            }
            try {
                if (bl) {
                    int n6 = this.textComponent.getCaretPosition();
                    this.insertString(n3 - 1, "1", null);
                    this.textComponent.setCaretPosition(n6);
                }
            }
            catch (BadLocationException badLocationException) {
                logger.trace(badLocationException.getMessage(), badLocationException);
            }
            n2 = n3 + 1;
        }
    }

    public void validateNotNull(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        try {
            for (int i = 0; i < this.separator.length + 1; ++i) {
                int n5;
                n4 = i < this.separator.length ? this.separator[i] : this.getLength();
                boolean bl = true;
                for (n5 = n3; n5 < n4; ++n5) {
                    if (" ".equals(this.getText(n5, 1))) continue;
                    bl = false;
                }
                if (bl) {
                    for (n5 = n3; n5 < n4; ++n5) {
                        this.insertString(n5, "0", null);
                    }
                    this.textComponent.setCaretPosition(n);
                }
                n3 = n4 + 1;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private boolean atSeparator(int n) {
        if (this.separator == null) {
            return false;
        }
        for (int i = 0; i < this.separator.length; ++i) {
            if (n != this.separator[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidated(int n, String string, AttributeSet attributeSet, boolean bl) {
        return true;
    }

    protected int getCalendarValueWithOffset(int n) {
        return -255;
    }

    private void autoCorrectInput(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        String string2 = this.getText(n + 1, 1);
        super.remove(n + 1, 1);
        super.insertString(n + 1, "0", attributeSet);
        if (this.isValidated(n, string, attributeSet, this.isAM_PMenable)) {
            super.remove(n, 1);
            super.insertString(n, string, attributeSet);
            this.textComponent.setCaretPosition(n);
        } else {
            super.remove(n + 1, 1);
            super.insertString(n + 1, string2, attributeSet);
        }
    }

    public void insertStringInDocument(int n, int n2, String string, AttributeSet attributeSet) {
        try {
            super.remove(n, n2);
            super.insertString(n, string, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            logger.trace(badLocationException.getMessage(), badLocationException);
        }
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        if (this.fireEvent) {
            super.fireInsertUpdate(documentEvent);
        }
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        if (this.fireEvent) {
            super.fireRemoveUpdate(documentEvent);
        }
    }

    @Override
    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        if (this.fireEvent) {
            super.fireChangedUpdate(documentEvent);
        }
    }

    protected String getFormatString() {
        return this.formatString;
    }

    protected void setFormatString(String string) {
        this.formatString = string;
    }

    protected String getYear(String string, int n) {
        return null;
    }

    protected int getMinYearValue() {
        return 1;
    }

    protected int getMaxYearValue() {
        return 9999;
    }

    private void autoYearCorrectInput(int n, int n2) {
        String string = this.getYear(Integer.toString(n), n2);
        if (null == string) {
            return;
        }
        if ((string = string.trim()).length() == 0) {
            return;
        }
        int n3 = Integer.parseInt(string);
        try {
            if (n3 > this.getMaxYearValue()) {
                super.remove(n2, 4);
                super.insertString(n2, Integer.toString(this.getMaxYearValue()), null);
            } else if (n3 < this.getMinYearValue()) {
                super.remove(n2, 4);
                super.insertString(n2, Integer.toString(this.getMinYearValue()), null);
            }
        }
        catch (BadLocationException badLocationException) {
            logger.trace(badLocationException);
        }
    }

    protected void fireChageEvent() {
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, this.textComponent.getCaretPosition(), this.textComponent.getText().length(), DocumentEvent.EventType.CHANGE);
        this.fireChangedUpdate(defaultDocumentEvent);
    }
}

