/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap12.util.dateChooser;

import com.swimap.imap12.util.dateChooser.CalendarToolkit;
import com.swimap.imap12.util.dateChooser.InmCommonUtil;
import com.swimap.imap12.util.dateChooser.InmDateChooserDlg;
import com.swimap.imap12.util.dateChooser.InmDateDocument;
import com.swimap.imap12.util.dateChooser.InmFormatDocument;
import com.swimap.imap12.util.dateChooser.InmTriangleIcon;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.util.ScreenUIToolKit;
import com.swimap.iview.util.adapter.ResourceMngHelper;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentListener;

public class InmDateChooser
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(InmDateChooser.class, "IVIEW");
    protected static final ResourceBundle res = ResourceMngHelper.getResourceBundleFromPropertyFile("mainfrm/imap12/util/dateChooser/Res");
    private boolean b24Enable = false;
    public static final byte HAS_YF = 0;
    public static final byte HAS_YMF = 1;
    public static final byte HAS_YMDF = 2;
    public static final byte HAS_DMYF = 15;
    public static final byte HAS_MDYF = 16;
    public static final byte HAS_YMDTF = 3;
    public static final byte HAS_YMDTFT = 7;
    public static final byte HAS_DMYTF = 8;
    public static final byte HAS_DMYTFT = 9;
    public static final byte HAS_MDYTF = 10;
    public static final byte HAS_MDYTFT = 11;
    public static final byte HAS_TF = 4;
    public static final byte HAS_TFT = 12;
    public static final byte HAS_YMDHMF = 5;
    public static final byte HAS_YMDHMFT = 13;
    public static final byte HAS_DMYHMF = 17;
    public static final byte HAS_DMYHMFT = 18;
    public static final byte HAS_MDYHMF = 19;
    public static final byte HAS_MDYHMFT = 20;
    public static final byte HAS_HMF = 6;
    public static final byte HAS_HMFT = 14;
    private Calendar _calendar = null;
    private byte _hasFields = (byte)-1;
    private Frame parentFrame = null;
    protected JTextField timeTextField = null;
    private InmDateDocument dateDocument = null;
    private JButton activeTimeChooseButton = null;
    private String dateTitle = null;
    private JButton incttButton = null;
    private JButton decttButton = null;
    private SpinnerAction incttAction = new SpinnerAction(true);
    private SpinnerAction decttAction = new SpinnerAction(false);
    private static final int TWENTY_FOUR = 24;
    private static final int YMDLENGTH = 11;
    private static final int DEFAULT_YEAR = 2000;
    private static final Dimension BTN_SIZE = new Dimension(22, 21);
    private static final int MAXIMAL_YEAR_VALUE = 10000;
    private static final int FIFTEEN_MINUTES_TO_MILLISECONDS = 900000;
    private static final int DEFAULT_MAX_YEAR = 2038;
    private static final int DEFAULT_MIN_YEAR = 1970;
    private static final int FIFTEEN_MINUTES = 15;
    private String toolTipText = null;
    private int minYear = 1970;
    private int maxYear = 2038;
    private boolean isAlreadyOpenDailog = false;
    private TimeZone timeZone = null;
    private Icon enableUpIcon = null;
    private Icon enableDownIcon = null;
    private Icon disenableUpIcon = null;
    private Icon disenableDownIcon = null;
    private final byte[] TWELVE_LOCK = new byte[]{18, 9, 14, 20, 11, 12, 13, 7};
    private static final String TOOLTIP_HOUR = "HH";
    private static final String TOOLTIP_S_HOUR = "hh";
    private static final String TOOLTIP_MINUTE = "mm";
    private static final String TOOLTIP_SECOND = "ss";
    private static final String TOOLTIP_TT = "tt";
    private static final String TOOLTIP_YEAR = "yyyy";
    private static final String TOOLTIP_DAY = "dd";
    private static final String TOOLTIP_MONTH = "MM";
    private static final char FIELD_YEAR_CHAR = 'y';
    private static final char FIELD_MONTH_CHAR = 'M';
    private static final char FIELD_DAY_CHAR = 'd';
    private static final char FIELD_HOUR_CHAR = 'H';
    private static final char FIELD_S_HOUR_CHAR = 'h';
    private static final char FIELD_MINUTE_CHAR = 'm';
    private static final char FIELD_SECOND_CHAR = 's';
    private static final char FIELD_TT_CHAR = 't';
    private static final int DEFAULT_DELAY = 200;
    private static final int DEFAULT_PERIOD = 50;
    private static int delayTime = 200;
    private static int periodTime = 50;
    private Timer incctimer = new Timer(periodTime, this.incttAction);
    private Timer decctimer = new Timer(periodTime, this.decttAction);
    private boolean autoAdjust = false;
    private TimeZone preTimeZone = null;
    private int index = 0;
    protected String oldValue = null;
    protected int oldCaretPosition = 0;
    private String dateFormat = "";

    public InmDateChooser(byte by) {
        this(by, new GregorianCalendar());
    }

    public InmDateChooser(byte by, boolean bl) {
        this(by, new GregorianCalendar(), false);
    }

    public InmDateChooser(byte by, Calendar calendar, boolean bl) {
        by = this.covertStyle(by);
        this.b24Enable = false;
        if (!this.isCurrentSupportType(by)) {
            this._hasFields = (byte)3;
        } else {
            this._hasFields = by;
            if (InmDateDocument.isAM_PMEnable) {
                this._hasFields = this.checkTypeforAm_PM(by);
            }
        }
        this.timeZone = TimeZone.getTimeZone(this.changeTimeZoneID(calendar));
        this._calendar = new GregorianCalendar(this.timeZone);
        this._calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
        this.initDateDocumentString();
        this.jbInit();
    }

    public InmDateChooser(byte by, Calendar calendar) {
        by = this.covertStyle(by);
        if (!this.isCurrentSupportType(by)) {
            this._hasFields = (byte)3;
        } else {
            this._hasFields = by;
            if (InmDateDocument.isAM_PMEnable) {
                this._hasFields = this.checkTypeforAm_PM(by);
            }
        }
        this.timeZone = TimeZone.getTimeZone(this.changeTimeZoneID(calendar));
        this._calendar = new GregorianCalendar(this.timeZone);
        this._calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
        this.initDateDocumentString();
        this.jbInit();
    }

    public InmDateChooser() {
        this(InmDateDocument.defaultType, new GregorianCalendar(), InmDateDocument.time_AM_PM_symbols, InmDateDocument.timeSeparator, InmDateDocument.dateSeparator);
    }

    public InmDateChooser(boolean bl) {
        this(InmDateDocument.defaultType, new GregorianCalendar(), InmDateDocument.time_AM_PM_symbols, InmDateDocument.timeSeparator, InmDateDocument.dateSeparator, false);
    }

    private InmDateChooser(byte by, Calendar calendar, String[] stringArray, String string, String string2, boolean bl) {
        this.b24Enable = false;
        if (!this.isCurrentSupportType(by)) {
            this._hasFields = (byte)3;
        } else {
            this._hasFields = by;
            if (InmDateDocument.isAM_PMEnable) {
                this._hasFields = this.checkTypeforAm_PM(by);
            }
        }
        this.timeZone = TimeZone.getTimeZone(this.changeTimeZoneID(calendar));
        this._calendar = new GregorianCalendar(this.timeZone);
        this._calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
        if (!this.isAM_PMEqual(stringArray)) {
            InmDateDocument.time_AM_PM_symbols = stringArray;
        }
        if (InmDateDocument.timeSeparator == null || !InmDateDocument.timeSeparator.equals(string)) {
            InmDateDocument.timeSeparator = string;
        }
        if (InmDateDocument.dateSeparator == null || !InmDateDocument.dateSeparator.equals(string2)) {
            InmDateDocument.dateSeparator = string2;
        }
        this.initDateDocumentString();
        this.jbInit();
    }

    private InmDateChooser(byte by, Calendar calendar, String[] stringArray, String string, String string2) {
        if (!this.isCurrentSupportType(by)) {
            this._hasFields = (byte)3;
        } else {
            this._hasFields = by;
            if (InmDateDocument.isAM_PMEnable) {
                this._hasFields = this.checkTypeforAm_PM(by);
            }
        }
        this.timeZone = TimeZone.getTimeZone(this.changeTimeZoneID(calendar));
        this._calendar = new GregorianCalendar(this.timeZone);
        this._calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
        if (!this.isAM_PMEqual(stringArray)) {
            InmDateDocument.time_AM_PM_symbols = stringArray;
        }
        if (InmDateDocument.timeSeparator == null || !InmDateDocument.timeSeparator.equals(string)) {
            InmDateDocument.timeSeparator = string;
        }
        if (InmDateDocument.dateSeparator == null || !InmDateDocument.dateSeparator.equals(string2)) {
            InmDateDocument.dateSeparator = string2;
        }
        this.initDateDocumentString();
        this.jbInit();
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.dateDocument.addDocumentListener(documentListener);
    }

    public void removeocumentListener(DocumentListener documentListener) {
        this.dateDocument.removeDocumentListener(documentListener);
    }

    private void initDateDocumentString() {
        InmDateDocument.YEARINITSTR = "    ";
        InmDateDocument.YMINITSTR = "    " + InmDateDocument.dateSeparator + "  ";
        InmDateDocument.YMDINITSTR = "    " + InmDateDocument.dateSeparator + "  " + InmDateDocument.dateSeparator + "  ";
        InmDateDocument.DMYINITSTR = "  " + InmDateDocument.dateSeparator + "  " + InmDateDocument.dateSeparator + "    ";
        InmDateDocument.MDYINITSTR = "  " + InmDateDocument.dateSeparator + "  " + InmDateDocument.dateSeparator + "    ";
        InmDateDocument.YMDHMINITSTR = "    " + InmDateDocument.dateSeparator + "  " + InmDateDocument.dateSeparator + "     " + InmDateDocument.timeSeparator + "  ";
        InmDateDocument.YMDHMINITSTRT = "    " + InmDateDocument.dateSeparator + "  " + InmDateDocument.dateSeparator + "     " + InmDateDocument.timeSeparator + "  " + "   ";
        InmDateDocument.DMYHMINITSTR = "  " + InmDateDocument.dateSeparator + "  " + InmDateDocument.dateSeparator + "   " + "    " + InmDateDocument.timeSeparator + "  ";
        InmDateDocument.DMYHMINITSTRT = "  " + InmDateDocument.dateSeparator + "  " + InmDateDocument.dateSeparator + "   " + "    " + InmDateDocument.timeSeparator + "  " + "   ";
        InmDateDocument.MDYHMINITSTR = "  " + InmDateDocument.dateSeparator + "  " + InmDateDocument.dateSeparator + "   " + "    " + InmDateDocument.timeSeparator + "  ";
        InmDateDocument.MDYHMINITSTRT = "  " + InmDateDocument.dateSeparator + "  " + InmDateDocument.dateSeparator + "   " + "    " + InmDateDocument.timeSeparator + "  " + "   ";
        InmDateDocument.HMINITSTR = "  " + InmDateDocument.timeSeparator + "  ";
        InmDateDocument.TIMEINITSTR = "  " + InmDateDocument.timeSeparator + "  " + InmDateDocument.timeSeparator + "  ";
        InmDateDocument.YMDTINITSTR = "    " + InmDateDocument.dateSeparator + "  " + InmDateDocument.dateSeparator + "     " + InmDateDocument.timeSeparator + "  " + InmDateDocument.timeSeparator + "  ";
        InmDateDocument.DMYTINITSTR = "  " + InmDateDocument.dateSeparator + "  " + InmDateDocument.dateSeparator + "   " + "    " + InmDateDocument.timeSeparator + "  " + InmDateDocument.timeSeparator + "  ";
        InmDateDocument.MDYTINITSTR = "  " + InmDateDocument.dateSeparator + "  " + InmDateDocument.dateSeparator + "   " + "    " + InmDateDocument.timeSeparator + "  " + InmDateDocument.timeSeparator + "  ";
        InmDateDocument.TIMEINITSTRT = "  " + InmDateDocument.timeSeparator + "  " + InmDateDocument.timeSeparator + "  " + "   ";
        InmDateDocument.YMDTINITSTRT = "    " + InmDateDocument.dateSeparator + "  " + InmDateDocument.dateSeparator + "     " + InmDateDocument.timeSeparator + "  " + InmDateDocument.timeSeparator + "  " + "   ";
        InmDateDocument.MDYTINITSTRT = InmDateDocument.DMYTINITSTRT = "  " + InmDateDocument.dateSeparator + "  " + InmDateDocument.dateSeparator + "   " + "    " + InmDateDocument.timeSeparator + "  " + InmDateDocument.timeSeparator + "  " + "   ";
        InmDateDocument.HMINITSTRT = "  " + InmDateDocument.timeSeparator + "  " + "   ";
    }

    private byte checkTypeforAm_PM(byte by) {
        switch (by) {
            case 3: {
                by = (byte)7;
                break;
            }
            case 8: {
                by = (byte)9;
                break;
            }
            case 10: {
                by = (byte)11;
                break;
            }
            case 4: {
                by = (byte)12;
                break;
            }
            case 5: {
                by = (byte)13;
                break;
            }
            case 17: {
                by = (byte)18;
                break;
            }
            case 19: {
                by = (byte)20;
                break;
            }
            case 6: {
                by = (byte)14;
                break;
            }
        }
        return by;
    }

    private void jbInit() {
        this.dateTitle = this._hasFields == 15 || this._hasFields == 16 || this._hasFields == 2 || this._hasFields == 1 ? res.getString("Date_Setting") : (this._hasFields == 0 ? res.getString("Year_Setting") : res.getString("Time_Date_Setting"));
        this.timeTextField = new JTextField(){

            @Override
            public JToolTip createToolTip() {
                MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
                multiRowToolTip.setComponent(this);
                return multiRowToolTip;
            }

            @Override
            public void paste() {
                String string = InmDateChooser.this.timeTextField.getText();
                String string2 = "";
                int n = InmDateChooser.this.timeTextField.getCaretPosition();
                try {
                    string2 = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                }
                catch (HeadlessException headlessException) {
                    logger.trace(headlessException.getMessage(), headlessException);
                    super.setText(string);
                    InmDateChooser.this.timeTextField.setCaretPosition(n);
                    return;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    logger.trace(unsupportedFlavorException.getMessage(), unsupportedFlavorException);
                    super.setText(string);
                    InmDateChooser.this.timeTextField.setCaretPosition(n);
                    return;
                }
                catch (IOException iOException) {
                    logger.trace(iOException.getMessage(), iOException);
                    super.setText(string);
                    InmDateChooser.this.timeTextField.setCaretPosition(n);
                    return;
                }
                String string3 = string.substring(0, n);
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(InmDateChooser.this.dateFormat);
                    simpleDateFormat.setLenient(false);
                    simpleDateFormat.parse(string3 + string2);
                }
                catch (ParseException parseException) {
                    logger.trace(parseException.getMessage(), parseException);
                    super.setText(string);
                    InmDateChooser.this.timeTextField.setCaretPosition(n);
                    return;
                }
                super.setText(string3 + string2);
            }
        };
        this.timeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                InmDateChooser.this.oldValue = InmDateChooser.this.timeTextField.getText();
                InmDateChooser.this.oldCaretPosition = InmDateChooser.this.timeTextField.getCaretPosition();
                if (keyEvent.getKeyCode() == 10 && InmDateChooser.this.autoAdjust) {
                    InmDateChooser.this.modifyYear();
                }
            }
        });
        this.timeTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                InmDateChooser.this.doMouseReleased();
                if (InmDateChooser.this.autoAdjust) {
                    InmDateChooser.this.modifyYear();
                }
                String string = InmDateChooser.this.timeTextField.getText();
                String string2 = InmDateChooser.this.modifyTextFieldText(InmDateChooser.this._hasFields, InmDateChooser.this.isB24Enable());
                if (!ResourceUtil.areEquals(string2, string) && !InmFormatDocument.zFlag) {
                    InmDateChooser.this.timeTextField.setText(string2);
                }
                if (InmDateChooser.this.is12_HourLock()) {
                    return;
                }
                if (!ResourceUtil.areEquals(string2, string) && CalendarToolkit.isContainDayAndHour(InmDateChooser.this._hasFields)) {
                    if (InmDateChooser.this.isB24Enable()) {
                        if (string2.endsWith("PM")) {
                            InmDateChooser.this.setCalendarInternal(InmDateChooser.this.getPriCalendar(false));
                        } else if (!string2.endsWith("AM") && string2.substring(11).startsWith("24")) {
                            InmDateChooser.this.setCalendarInternal(InmDateChooser.this.getPriCalendar(false));
                        }
                    } else if (string2.endsWith("AM")) {
                        InmDateChooser.this.setCalendarInternal(InmDateChooser.this.getPriCalendar(false));
                        InmDateChooser.this.setCurrentHour(24);
                    } else if (!string2.endsWith("PM") && string2.substring(11).startsWith("00")) {
                        InmDateChooser.this.setCalendarInternal(InmDateChooser.this.getPriCalendar(false));
                        InmDateChooser.this.setCurrentHour(24);
                    }
                }
            }
        });
        this.index = 0;
        switch (this._hasFields) {
            case 0: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.YEARINITSTR, InmDateDocument.YEARSEP, 0);
                this.toolTipText = TOOLTIP_YEAR;
                break;
            }
            case 1: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.YMINITSTR, InmDateDocument.YMSEP, 1);
                this.toolTipText = TOOLTIP_YEAR + InmDateDocument.dateSeparator + TOOLTIP_MONTH;
                break;
            }
            case 2: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.YMDINITSTR, InmDateDocument.YMDSEP, 2);
                this.toolTipText = TOOLTIP_YEAR + InmDateDocument.dateSeparator + TOOLTIP_MONTH + InmDateDocument.dateSeparator + TOOLTIP_DAY;
                break;
            }
            case 15: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.DMYINITSTR, InmDateDocument.DMYSEP, 15);
                this.toolTipText = TOOLTIP_DAY + InmDateDocument.dateSeparator + TOOLTIP_MONTH + InmDateDocument.dateSeparator + TOOLTIP_YEAR;
                break;
            }
            case 16: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.MDYINITSTR, InmDateDocument.MDYSEP, 16);
                this.toolTipText = TOOLTIP_MONTH + InmDateDocument.dateSeparator + TOOLTIP_DAY + InmDateDocument.dateSeparator + TOOLTIP_YEAR;
                break;
            }
            case 4: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.TIMEINITSTR, InmDateDocument.TIMESEP, 4);
                this.toolTipText = TOOLTIP_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE + InmDateDocument.timeSeparator + TOOLTIP_SECOND;
                break;
            }
            case 6: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.HMINITSTR, InmDateDocument.HMSEP, 6);
                this.toolTipText = TOOLTIP_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE;
                break;
            }
            case 5: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.YMDHMINITSTR, InmDateDocument.YMDHMSEP, 5);
                this.toolTipText = TOOLTIP_YEAR + InmDateDocument.dateSeparator + TOOLTIP_MONTH + InmDateDocument.dateSeparator + TOOLTIP_DAY + ' ' + TOOLTIP_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE;
                break;
            }
            case 13: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.YMDHMINITSTRT, InmDateDocument.YMDHMSEPT, 13);
                this.toolTipText = TOOLTIP_YEAR + InmDateDocument.dateSeparator + TOOLTIP_MONTH + InmDateDocument.dateSeparator + TOOLTIP_DAY + ' ' + TOOLTIP_S_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE + ' ' + TOOLTIP_TT;
                break;
            }
            case 17: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.DMYHMINITSTR, InmDateDocument.DMYHMSEP, 17);
                this.toolTipText = TOOLTIP_DAY + InmDateDocument.dateSeparator + TOOLTIP_MONTH + InmDateDocument.dateSeparator + TOOLTIP_YEAR + ' ' + TOOLTIP_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE;
                break;
            }
            case 18: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.DMYHMINITSTRT, InmDateDocument.DMYHMSEPT, 18);
                this.toolTipText = TOOLTIP_DAY + InmDateDocument.dateSeparator + TOOLTIP_MONTH + InmDateDocument.dateSeparator + TOOLTIP_YEAR + ' ' + TOOLTIP_S_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE + ' ' + TOOLTIP_TT;
                break;
            }
            case 19: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.MDYHMINITSTR, InmDateDocument.MDYHMSEP, 19);
                this.toolTipText = TOOLTIP_MONTH + InmDateDocument.dateSeparator + TOOLTIP_DAY + InmDateDocument.dateSeparator + TOOLTIP_YEAR + ' ' + TOOLTIP_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE;
                break;
            }
            case 20: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.MDYHMINITSTRT, InmDateDocument.MDYHMSEPT, 20);
                this.toolTipText = TOOLTIP_MONTH + InmDateDocument.dateSeparator + TOOLTIP_DAY + InmDateDocument.dateSeparator + TOOLTIP_YEAR + ' ' + TOOLTIP_S_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE + ' ' + TOOLTIP_TT;
                break;
            }
            case 12: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.TIMEINITSTRT, InmDateDocument.TIMESEPT, 12);
                this.toolTipText = TOOLTIP_S_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE + InmDateDocument.timeSeparator + TOOLTIP_SECOND + ' ' + TOOLTIP_TT;
                break;
            }
            case 14: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.HMINITSTRT, InmDateDocument.HMSEPT, 14);
                this.toolTipText = TOOLTIP_S_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE + ' ' + TOOLTIP_TT;
                break;
            }
            case 3: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.YMDTINITSTR, InmDateDocument.YMDTSEP, 3);
                this.toolTipText = TOOLTIP_YEAR + InmDateDocument.dateSeparator + TOOLTIP_MONTH + InmDateDocument.dateSeparator + TOOLTIP_DAY + ' ' + TOOLTIP_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE + InmDateDocument.timeSeparator + TOOLTIP_SECOND;
                break;
            }
            case 8: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.DMYTINITSTR, InmDateDocument.DMYTSEP, 8);
                this.toolTipText = TOOLTIP_DAY + InmDateDocument.dateSeparator + TOOLTIP_MONTH + InmDateDocument.dateSeparator + TOOLTIP_YEAR + ' ' + TOOLTIP_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE + InmDateDocument.timeSeparator + TOOLTIP_SECOND;
                break;
            }
            case 10: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.MDYTINITSTR, InmDateDocument.MDYTSEP, 10);
                this.toolTipText = TOOLTIP_MONTH + InmDateDocument.dateSeparator + TOOLTIP_DAY + InmDateDocument.dateSeparator + TOOLTIP_YEAR + ' ' + TOOLTIP_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE + InmDateDocument.timeSeparator + TOOLTIP_SECOND;
                break;
            }
            case 7: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.YMDTINITSTRT, InmDateDocument.YMDTSEPT, 7);
                this.toolTipText = TOOLTIP_YEAR + InmDateDocument.dateSeparator + TOOLTIP_MONTH + InmDateDocument.dateSeparator + TOOLTIP_DAY + ' ' + TOOLTIP_S_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE + InmDateDocument.timeSeparator + TOOLTIP_SECOND + ' ' + TOOLTIP_TT;
                break;
            }
            case 9: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.DMYTINITSTRT, InmDateDocument.DMYTSEPT, 9);
                this.toolTipText = TOOLTIP_DAY + InmDateDocument.dateSeparator + TOOLTIP_MONTH + InmDateDocument.dateSeparator + TOOLTIP_YEAR + ' ' + TOOLTIP_S_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE + InmDateDocument.timeSeparator + TOOLTIP_SECOND + ' ' + TOOLTIP_TT;
                break;
            }
            case 11: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.MDYTINITSTRT, InmDateDocument.MDYTSEPT, 11);
                this.toolTipText = TOOLTIP_MONTH + InmDateDocument.dateSeparator + TOOLTIP_DAY + InmDateDocument.dateSeparator + TOOLTIP_YEAR + ' ' + TOOLTIP_S_HOUR + InmDateDocument.timeSeparator + TOOLTIP_MINUTE + InmDateDocument.timeSeparator + TOOLTIP_SECOND + ' ' + TOOLTIP_TT;
                break;
            }
            default: {
                this.dateDocument = new InmDateDocument(this.timeTextField, InmDateDocument.YMDTINITSTR, InmDateDocument.YMDTSEP, 0);
                this.toolTipText = "";
            }
        }
        this.dateFormat = this.toolTipText;
        this.timeTextField.setToolTipText(this.toolTipText);
        this.dateDocument.setFormatString(this.toolTipText);
        this.dateDocument.setYearRange(this.minYear, this.maxYear);
        this.dateDocument.setTimeZone(this.timeZone);
        this.dateDocument.setEnableHour24(this.b24Enable);
        this.timeTextField.setDocument(this.dateDocument);
        this.setLayout(new GridBagLayout());
        this.timeTextField.setPreferredSize(new Dimension(30, 21));
        this.add((Component)this.timeTextField, new GridBagConstraints(this.index, 0, 1, 2, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        ++this.index;
        this.timeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (!InmDateChooser.this.timeTextField.isEditable()) {
                    return;
                }
                InmDateChooser.this.oldValue = InmDateChooser.this.timeTextField.getText();
                InmDateChooser.this.oldCaretPosition = InmDateChooser.this.timeTextField.getCaretPosition();
                if (38 == keyEvent.getKeyCode()) {
                    InmDateChooser.this.doDirectionKey(true);
                } else if (40 == keyEvent.getKeyCode()) {
                    InmDateChooser.this.doDirectionKey(false);
                }
            }
        });
        this.timeTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                InmDateChooser.this.timeTextField.setCaretPosition(0);
            }
        });
        this.enableUpIcon = new InmTriangleIcon(Color.black, 0);
        this.enableDownIcon = new InmTriangleIcon(Color.black, 1);
        this.disenableUpIcon = new InmTriangleIcon(Color.GRAY, 0);
        this.disenableDownIcon = new InmTriangleIcon(Color.GRAY, 1);
        this.incttButton = new JButton("", this.enableUpIcon);
        this.decttButton = new JButton("", this.enableDownIcon);
        this.incttButton.setFocusPainted(false);
        this.decttButton.setFocusPainted(false);
        Dimension dimension = new Dimension(20, 10);
        this.incttButton.setPreferredSize(dimension);
        this.decttButton.setPreferredSize(dimension);
        this.incttButton.setMinimumSize(new Dimension(20, 7));
        this.decttButton.setMinimumSize(new Dimension(20, 7));
        this.incttButton.setMaximumSize(dimension);
        this.decttButton.setMaximumSize(dimension);
        this.incttButton.setFocusable(false);
        this.decttButton.setFocusable(false);
        this.add((Component)this.incttButton, new GridBagConstraints(this.index, 0, 1, 1, 0.0, 0.1, 15, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.decttButton, new GridBagConstraints(this.index, 1, 1, 1, 0.0, 0.1, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.decttButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    InmDateChooser.this.doMousePressed(false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    InmDateChooser.this.doMouseReleased();
                }
            }
        });
        this.incttButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    InmDateChooser.this.doMousePressed(true);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    InmDateChooser.this.doMouseReleased();
                }
            }
        });
        this.timeTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("editable".equals(propertyChangeEvent.getPropertyName())) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    boolean bl2 = InmDateChooser.this.timeTextField.isEnabled();
                    if (InmDateChooser.this.incttButton != null && InmDateChooser.this.decttButton != null) {
                        InmDateChooser.this.incttButton.setEnabled(bl && bl2);
                        InmDateChooser.this.decttButton.setEnabled(bl && bl2);
                        if (bl) {
                            InmDateChooser.this.incttButton.setIcon(InmDateChooser.this.enableUpIcon);
                            InmDateChooser.this.decttButton.setIcon(InmDateChooser.this.enableDownIcon);
                        } else {
                            InmDateChooser.this.incttButton.setIcon(InmDateChooser.this.disenableUpIcon);
                            InmDateChooser.this.decttButton.setIcon(InmDateChooser.this.disenableDownIcon);
                        }
                    }
                }
            }
        });
        ++this.index;
        if (this._hasFields == 0 || this._hasFields == 1 || this._hasFields == 2 || this._hasFields == 15 || this._hasFields == 16 || this._hasFields == 3 || this._hasFields == 7 || this._hasFields == 8 || this._hasFields == 9 || this._hasFields == 10 || this._hasFields == 11 || this._hasFields == 5 || this._hasFields == 13 || this._hasFields == 17 || this._hasFields == 18 || this._hasFields == 19 || this._hasFields == 20) {
            this.activeTimeChooseButton = new JButton("...");
            this.activeTimeChooseButton.setPreferredSize(BTN_SIZE);
            this.activeTimeChooseButton.setMaximumSize(BTN_SIZE);
            this.activeTimeChooseButton.setMinimumSize(BTN_SIZE);
            this.add((Component)this.activeTimeChooseButton, new GridBagConstraints(this.index, 0, 1, 2, 0.0, 0.1, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.activeTimeChooseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    InmDateChooser.this.activeTimeChooseButton_actionPerformed(actionEvent);
                }
            });
            this.activeTimeChooseButton.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((AbstractButton)actionEvent.getSource()).doClick();
                }
            }, KeyStroke.getKeyStroke(10, 0, false), 0);
            ++this.index;
        }
        this.incctimer.setInitialDelay(delayTime);
        this.decctimer.setInitialDelay(delayTime);
        this.setName("InmDateChooser");
        this.updateTextFieldString(this._calendar);
    }

    private void doAM_PMChanged() {
        String string = this.timeTextField.getText();
        String string2 = null;
        String string3 = null;
        if (this._hasFields == 12) {
            string2 = this.timeTextField.getText().substring(0, InmDateDocument.TIMESEPT[2]);
            string3 = string.substring(InmDateDocument.TIMESEPT[2] + 1).trim();
        } else if (this._hasFields == 13 || this._hasFields == 18 || this._hasFields == 20) {
            string2 = this.timeTextField.getText().substring(0, InmDateDocument.YMDHMSEPT[4]);
            string3 = string.substring(InmDateDocument.YMDHMSEPT[4] + 1).trim();
        } else if (this._hasFields == 14) {
            string2 = this.timeTextField.getText().substring(0, InmDateDocument.HMSEPT[1]);
            string3 = string.substring(InmDateDocument.HMSEPT[1] + 1).trim();
        } else {
            string2 = this.timeTextField.getText().substring(0, InmDateDocument.YMDTSEPT[5]);
            string3 = string.substring(InmDateDocument.YMDTSEPT[5] + 1).trim();
        }
        string2 = InmDateDocument.time_AM_PM_symbols[0].equals(string3) ? new StringBuffer(string2).append(' ').append(InmDateDocument.time_AM_PM_symbols[1]).toString() : new StringBuffer(string2).append(' ').append(InmDateDocument.time_AM_PM_symbols[0]).toString();
        this.timeTextField.setText(string2);
    }

    private void activeTimeChooseButton_actionPerformed(ActionEvent actionEvent) {
        if (this.isAlreadyOpenDailog) {
            return;
        }
        this.isAlreadyOpenDailog = true;
        this._calendar = this.getPriCalendar(false);
        InmDateChooserDlg inmDateChooserDlg = null;
        Container container = this.getTopLevelAncestor();
        inmDateChooserDlg = container instanceof Dialog ? new InmDateChooserDlg((Dialog)container, this.dateTitle, true, (int)this._hasFields, this._calendar, this.b24Enable) : (container instanceof Frame ? new InmDateChooserDlg(this.parentFrame == null ? (Frame)container : this.parentFrame, this.dateTitle, true, (int)this._hasFields, this._calendar, this.b24Enable) : new InmDateChooserDlg((Frame)null, this.dateTitle, true, (int)this._hasFields, this._calendar, this.b24Enable));
        String string = this.timeTextField.getText();
        int n = this.timeTextField.getCaretPosition();
        inmDateChooserDlg.setLocationRelativeTo(this);
        ScreenUIToolKit.centerLocateToScreen(inmDateChooserDlg);
        inmDateChooserDlg.setResizable(false);
        inmDateChooserDlg.setYearRange(this.minYear, this.maxYear);
        inmDateChooserDlg.setVisible(true);
        if (inmDateChooserDlg.isApplied()) {
            this.oldValue = string;
            this.oldCaretPosition = n;
            this._calendar = inmDateChooserDlg.getCalendar();
            this.updateTextFieldString(this._calendar);
        }
        inmDateChooserDlg = null;
        this.isAlreadyOpenDailog = false;
    }

    public Calendar popupTimeChooseDlg() {
        this._calendar = this.getPriCalendar(false);
        InmDateChooserDlg inmDateChooserDlg = null;
        if (this.parentFrame == null) {
            Container container = this.getRootPane().getParent();
            if (container instanceof JInternalFrame) {
                container = ((JInternalFrame)container).getDesktopPane().getRootPane().getParent();
            }
            inmDateChooserDlg = container instanceof Frame ? new InmDateChooserDlg((Frame)container, this.dateTitle, true, (int)this._hasFields, this._calendar) : (container instanceof Dialog ? new InmDateChooserDlg((Dialog)container, this.dateTitle, true, (int)this._hasFields, this._calendar) : new InmDateChooserDlg(new Frame(), this.dateTitle, true, (int)this._hasFields, this._calendar));
        } else {
            inmDateChooserDlg = new InmDateChooserDlg(this.parentFrame, this.dateTitle, true, (int)this._hasFields, this._calendar);
        }
        InmCommonUtil.centerLocateToScreen(inmDateChooserDlg);
        inmDateChooserDlg.setResizable(false);
        inmDateChooserDlg.setYearRange(this.minYear, this.maxYear);
        inmDateChooserDlg.setVisible(true);
        if (inmDateChooserDlg.isApplied()) {
            this._calendar = inmDateChooserDlg.getCalendar();
            inmDateChooserDlg = null;
            return this._calendar;
        }
        inmDateChooserDlg = null;
        return null;
    }

    private void updateTextFieldString(Calendar calendar) {
        String string = CalendarToolkit.convertCalendarToStr(calendar, this._hasFields, this.isB24Enable());
        if (string != null) {
            this.timeTextField.setText(string);
        }
        this.timeTextField.setSelectionStart(0);
        this.timeTextField.setSelectionEnd(0);
    }

    private void initCalendarToolkit(CalendarToolkit calendarToolkit, boolean bl) {
        calendarToolkit.analyseTimeStr(this.timeTextField.getText(), this._hasFields, this.b24Enable, bl);
        if (!bl && calendarToolkit.hour == 24) {
            --calendarToolkit.date;
        }
    }

    public Calendar getPriCalendar(boolean bl) {
        if (this.timeTextField.getText().startsWith("  ")) {
            return new GregorianCalendar();
        }
        CalendarToolkit calendarToolkit = new CalendarToolkit();
        try {
            this.initCalendarToolkit(calendarToolkit, bl);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return new GregorianCalendar(this.timeZone);
        }
        GregorianCalendar gregorianCalendar = null;
        switch (this._hasFields) {
            case 0: {
                if (calendarToolkit.year == -1) {
                    return null;
                }
                gregorianCalendar = new GregorianCalendar(this.timeZone);
                gregorianCalendar.set(calendarToolkit.year, 1, 1);
                return gregorianCalendar;
            }
            case 1: {
                if (calendarToolkit.year == -1 || calendarToolkit.month == -1) {
                    return null;
                }
                gregorianCalendar = new GregorianCalendar(this.timeZone);
                gregorianCalendar.set(calendarToolkit.year, calendarToolkit.month, 1);
                return gregorianCalendar;
            }
            case 2: 
            case 15: 
            case 16: {
                if (calendarToolkit.year == -1 || calendarToolkit.month == -1 || calendarToolkit.date == -1) {
                    return null;
                }
                gregorianCalendar = new GregorianCalendar(this.timeZone);
                gregorianCalendar.set(calendarToolkit.year, calendarToolkit.month, calendarToolkit.date);
                return gregorianCalendar;
            }
            case 4: {
                if (calendarToolkit.hour == -1 || calendarToolkit.min == -1 || calendarToolkit.sec == -1) {
                    return null;
                }
                gregorianCalendar = new GregorianCalendar(this.timeZone);
                gregorianCalendar.set(2000, 1, 1, calendarToolkit.hour, calendarToolkit.min, calendarToolkit.sec);
                return gregorianCalendar;
            }
            case 5: 
            case 17: 
            case 19: {
                if (calendarToolkit.hour == -1 || calendarToolkit.min == -1 || calendarToolkit.year == -1 || calendarToolkit.month == -1 || calendarToolkit.date == -1) {
                    return null;
                }
                gregorianCalendar = new GregorianCalendar(this.timeZone);
                gregorianCalendar.set(calendarToolkit.year, calendarToolkit.month, calendarToolkit.date, calendarToolkit.hour, calendarToolkit.min);
                return gregorianCalendar;
            }
            case 13: 
            case 18: 
            case 20: {
                if (calendarToolkit.hour == -1 || calendarToolkit.min == -1 || calendarToolkit.year == -1 || calendarToolkit.month == -1 || calendarToolkit.date == -1 || calendarToolkit.am_pmStr == null) {
                    return null;
                }
                gregorianCalendar = new GregorianCalendar(this.timeZone);
                gregorianCalendar.set(calendarToolkit.year, calendarToolkit.month, calendarToolkit.date, calendarToolkit.hour, calendarToolkit.min);
                return gregorianCalendar;
            }
            case 6: {
                if (calendarToolkit.hour == -1 || calendarToolkit.min == -1) {
                    return null;
                }
                gregorianCalendar = new GregorianCalendar(this.timeZone);
                gregorianCalendar.set(2000, 1, 1, calendarToolkit.hour, calendarToolkit.min);
                return gregorianCalendar;
            }
            case 12: {
                if (calendarToolkit.hour == -1 || calendarToolkit.min == -1 || calendarToolkit.sec == -1 || calendarToolkit.am_pmStr == null) {
                    return null;
                }
                gregorianCalendar = new GregorianCalendar(this.timeZone);
                gregorianCalendar.set(2000, 1, 1, calendarToolkit.hour, calendarToolkit.min, calendarToolkit.sec);
                return gregorianCalendar;
            }
            case 14: {
                if (calendarToolkit.hour == -1 || calendarToolkit.min == -1 || calendarToolkit.am_pmStr == null) {
                    return null;
                }
                gregorianCalendar = new GregorianCalendar(this.timeZone);
                gregorianCalendar.set(2000, 1, 1, calendarToolkit.hour, calendarToolkit.min);
                return gregorianCalendar;
            }
            case 3: 
            case 8: 
            case 10: {
                if (calendarToolkit.year == -1 || calendarToolkit.month == -1 || calendarToolkit.date == -1 || calendarToolkit.hour == -1 || calendarToolkit.min == -1 || calendarToolkit.sec == -1) {
                    return null;
                }
                gregorianCalendar = new GregorianCalendar(this.timeZone);
                gregorianCalendar.set(calendarToolkit.year, calendarToolkit.month, calendarToolkit.date, calendarToolkit.hour, calendarToolkit.min, calendarToolkit.sec);
                return gregorianCalendar;
            }
            case 7: 
            case 9: 
            case 11: {
                if (calendarToolkit.year == -1 || calendarToolkit.month == -1 || calendarToolkit.date == -1 || calendarToolkit.hour == -1 || calendarToolkit.min == -1 || calendarToolkit.sec == -1 || calendarToolkit.am_pmStr == null) {
                    return null;
                }
                gregorianCalendar = new GregorianCalendar(this.timeZone);
                gregorianCalendar.set(calendarToolkit.year, calendarToolkit.month, calendarToolkit.date, calendarToolkit.hour, calendarToolkit.min, calendarToolkit.sec);
                return gregorianCalendar;
            }
        }
        return null;
    }

    public Calendar getCalendar() {
        return this.getPriCalendar(true);
    }

    public Calendar getCalendar(boolean bl) {
        Calendar calendar = this.getPriCalendar(true);
        if (bl) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.preTimeZone);
            gregorianCalendar.set(1, calendar.get(1));
            gregorianCalendar.set(2, calendar.get(2));
            gregorianCalendar.set(5, calendar.get(5));
            gregorianCalendar.set(11, calendar.get(11));
            gregorianCalendar.set(12, calendar.get(12));
            gregorianCalendar.set(13, calendar.get(13));
            return gregorianCalendar;
        }
        return calendar;
    }

    public JTextField getTextField() {
        return this.timeTextField;
    }

    public JButton getButton() {
        return this.activeTimeChooseButton;
    }

    public void toggleControlCondition(boolean bl) {
        this.timeTextField.setEditable(bl);
        if (this.activeTimeChooseButton != null) {
            this.activeTimeChooseButton.setEnabled(bl);
        }
        this.setCalendar(null);
    }

    public void toggleControlEnable(boolean bl) {
        this.timeTextField.setEditable(bl);
        if (this.activeTimeChooseButton != null) {
            this.activeTimeChooseButton.setEnabled(bl);
        }
    }

    public void setEnableHour24(boolean bl) {
        this.b24Enable = false;
        this.dateDocument.setEnableHour24(false);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.timeTextField.setEnabled(bl);
        boolean bl2 = this.timeTextField.isEditable();
        if (this.activeTimeChooseButton != null) {
            this.activeTimeChooseButton.setEnabled(bl);
            this.timeTextField.setCaretPosition(0);
        }
        if (this.incttButton != null && this.decttButton != null) {
            this.incttButton.setEnabled(bl && bl2);
            this.decttButton.setEnabled(bl && bl2);
            if (bl && bl2) {
                this.incttButton.setIcon(this.enableUpIcon);
                this.decttButton.setIcon(this.enableDownIcon);
            } else {
                this.incttButton.setIcon(this.disenableUpIcon);
                this.decttButton.setIcon(this.disenableDownIcon);
            }
        }
    }

    public void setCalendar(Calendar calendar) {
        if (calendar != null) {
            this.timeZone = TimeZone.getTimeZone(this.changeTimeZoneID(calendar));
            this._calendar = new GregorianCalendar(this.timeZone);
            this._calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
        } else {
            this._calendar = null;
        }
        this.updateTextFieldString(this._calendar);
        if (calendar == null) {
            this._calendar = new GregorianCalendar();
        }
    }

    private void setCalendarInternal(Calendar calendar) {
        if (calendar != null) {
            this.timeZone = TimeZone.getTimeZone(this.changeTimeZoneIDInternal(calendar));
            this._calendar = new GregorianCalendar(this.timeZone);
            this._calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
        } else {
            this._calendar = null;
        }
        this.updateTextFieldString(this._calendar);
        if (calendar == null) {
            this._calendar = new GregorianCalendar();
        }
    }

    public void setYear(int n) {
        this._calendar = this.getCalendar();
        if (this._calendar != null) {
            this._calendar.set(1, n);
            this.updateTextFieldString(this._calendar);
        }
    }

    public void setYearRange(int n, int n2) {
        if (n > 0 && n < 10000) {
            this.minYear = n;
        }
        if (n2 > 0 && n2 < 10000) {
            this.maxYear = n2;
        }
        this.dateDocument.setYearRange(n, n2);
    }

    public void setMonth(int n) {
        this._calendar = this.getCalendar();
        if (this._calendar != null) {
            this._calendar.set(2, n - 1);
            this.updateTextFieldString(this._calendar);
        }
    }

    public void setDay(int n) {
        this._calendar = this.getCalendar();
        if (this._calendar != null) {
            this._calendar.set(5, n);
            this.updateTextFieldString(this._calendar);
        }
    }

    public void setHour(int n) {
        if (this._calendar == null) {
            this._calendar = new GregorianCalendar();
        }
        if (this.is12_HourLock()) {
            this._calendar.set(10, n);
        } else {
            this._calendar.set(11, n);
        }
        this.updateTextFieldString(this._calendar);
    }

    public void setCurrentHour(int n) {
        this._calendar = this.getCalendar();
        if (this._calendar != null) {
            this._calendar.set(11, n);
            this.updateTextFieldString(this._calendar);
        }
    }

    public int getHour() {
        if (this.is12_HourLock()) {
            return this.getCalendar().get(10);
        }
        return this.getCalendar().get(11);
    }

    public void setMinute(int n) {
        this._calendar = this.getCalendar();
        if (this._calendar != null) {
            this._calendar.set(12, n);
            this.updateTextFieldString(this._calendar);
        }
    }

    public void setSecond(int n) {
        this._calendar = this.getCalendar();
        if (this._calendar != null) {
            this._calendar.set(13, n);
            this.updateTextFieldString(this._calendar);
        }
    }

    public void setParentFrame(Frame frame) {
        this.parentFrame = frame;
    }

    private boolean isCurrentSupportType(byte by) {
        return by == 0 || by == 1 || by == 4 || by == 6 || by == 3 || by == 7 || by == 8 || by == 9 || by == 10 || by == 11 || by == 5 || by == 13 || by == 17 || by == 18 || by == 19 || by == 20 || by == 12 || by == 14 || by == 2 || by == 15 || by == 16;
    }

    private boolean isAM_PMEqual(String[] stringArray) {
        if (InmDateDocument.time_AM_PM_symbols.length == stringArray.length) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!InmDateDocument.time_AM_PM_symbols[i].equals(stringArray[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean isCurCalendarValid() {
        CalendarToolkit calendarToolkit = new CalendarToolkit();
        try {
            calendarToolkit.analyseTimeStr(this.timeTextField.getText(), this._hasFields, this.b24Enable, false);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean isB24Enable() {
        return this.b24Enable;
    }

    private final byte covertStyle(byte by) {
        if (by == 2 || by == 15 || by == 16) {
            if (InmDateDocument.defaultType == 3 || InmDateDocument.defaultType == 7) {
                by = (byte)2;
            } else if (InmDateDocument.defaultType == 8 || InmDateDocument.defaultType == 9) {
                by = (byte)15;
            } else if (InmDateDocument.defaultType == 10 || InmDateDocument.defaultType == 11) {
                by = (byte)16;
            }
        }
        if (by == 5 || by == 17 || by == 19) {
            if (InmDateDocument.defaultType == 3 || InmDateDocument.defaultType == 7) {
                by = (byte)5;
            } else if (InmDateDocument.defaultType == 8 || InmDateDocument.defaultType == 9) {
                by = (byte)17;
            } else if (InmDateDocument.defaultType == 10 || InmDateDocument.defaultType == 11) {
                by = (byte)19;
            }
        }
        if (by == 13 || by == 18 || by == 20) {
            if (InmDateDocument.defaultType == 3 || InmDateDocument.defaultType == 7) {
                by = (byte)13;
            } else if (InmDateDocument.defaultType == 8 || InmDateDocument.defaultType == 9) {
                by = (byte)18;
            } else if (InmDateDocument.defaultType == 10 || InmDateDocument.defaultType == 11) {
                by = (byte)20;
            }
        }
        if (by == 3 || by == 8 || by == 10) {
            if (InmDateDocument.defaultType == 3 || InmDateDocument.defaultType == 7) {
                by = (byte)3;
            } else if (InmDateDocument.defaultType == 8 || InmDateDocument.defaultType == 9) {
                by = (byte)8;
            } else if (InmDateDocument.defaultType == 10 || InmDateDocument.defaultType == 11) {
                by = (byte)10;
            }
        }
        if (by == 7 || by == 9 || by == 11) {
            if (InmDateDocument.defaultType == 3 || InmDateDocument.defaultType == 7) {
                by = (byte)7;
            } else if (InmDateDocument.defaultType == 8 || InmDateDocument.defaultType == 9) {
                by = (byte)9;
            } else if (InmDateDocument.defaultType == 10 || InmDateDocument.defaultType == 11) {
                by = (byte)11;
            }
        }
        return by;
    }

    public boolean is12_HourLock() {
        for (int i = 0; i < this.TWELVE_LOCK.length; ++i) {
            if (this._hasFields != this.TWELVE_LOCK[i]) continue;
            return true;
        }
        return false;
    }

    public void setTimeTextFieldEditable(boolean bl) {
        if (this.timeTextField != null) {
            this.timeTextField.setEditable(bl);
        }
    }

    public void setAutoAdjust(boolean bl) {
        this.autoAdjust = bl;
    }

    public boolean getAutoAdjust() {
        return this.autoAdjust;
    }

    private void modifyYear() {
        int n = this.getCalendar().get(1);
        if (n < this.minYear) {
            this.setYear(this.minYear);
        }
    }

    private String modifyTextFieldText(byte by, boolean bl) {
        String string = this.timeTextField.getText().trim();
        switch (by) {
            case 4: 
            case 6: {
                if (bl) {
                    return this.change00To24(string);
                }
                return this.change24To00(string);
            }
            case 12: 
            case 14: {
                return this.changeAmPm00To12(string);
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 18: 
            case 20: {
                return string.substring(0, 11) + this.changeAmPm00To12(string.substring(11));
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 17: 
            case 19: {
                if (bl) {
                    return string.substring(0, 11) + this.change00To24(string.substring(11));
                }
                return string.substring(0, 11) + this.change24To00(string.substring(11));
            }
        }
        return string;
    }

    private String change00To24(String string) {
        if (string.startsWith("00")) {
            return string.replaceFirst("00", "24");
        }
        return string;
    }

    private String change24To00(String string) {
        if (string.startsWith("24")) {
            return string.replaceFirst("24", "00");
        }
        return string;
    }

    private String changeAmPm00To12(String string) {
        String string2 = string;
        if (string2.startsWith("00")) {
            string2 = string2.replaceFirst("00", "12");
        }
        return string2;
    }

    private String changeTimeZoneID(Calendar calendar) {
        this.preTimeZone = calendar.getTimeZone();
        return this.changeTimeZoneIDInternal(calendar);
    }

    private String changeTimeZoneIDInternal(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer("GMT");
        int n = calendar.getTimeZone().getRawOffset() / 900000;
        int n2 = Math.abs(n);
        char c = '\u0000';
        String string = null;
        String string2 = null;
        if (n == 0) {
            return stringBuffer.toString();
        }
        c = this.signGetter(n);
        string = this.hourGetter(n2);
        string2 = this.minGetter(n2);
        return stringBuffer.append(c).append(string).append(':').append(string2).toString();
    }

    private char signGetter(int n) {
        if (n < 0) {
            return '-';
        }
        return '+';
    }

    private String hourGetter(int n) {
        int n2 = n / 4;
        String string = String.valueOf(n2);
        if (n2 < 10) {
            return '0' + string;
        }
        return string;
    }

    private String minGetter(int n) {
        int n2 = n % 4 * 15;
        String string = String.valueOf(n2);
        if (n2 == 0) {
            return "00";
        }
        return string;
    }

    public String getText() {
        return this.getTextField().getText();
    }

    public String get(int n) {
        CalendarToolkit calendarToolkit = new CalendarToolkit();
        this.initCalendarToolkit(calendarToolkit, false);
        switch (n) {
            case 1: {
                return calendarToolkit.yearStr;
            }
            case 2: {
                return calendarToolkit.monthStr;
            }
            case 5: {
                return calendarToolkit.dateStr;
            }
            case 10: {
                return calendarToolkit.hourStr;
            }
            case 12: {
                return calendarToolkit.minStr;
            }
            case 13: {
                return calendarToolkit.secStr;
            }
            case 9: {
                return calendarToolkit.am_pmStr;
            }
        }
        return null;
    }

    private void doDirectionKey(boolean bl) {
        int n = this.timeTextField.getCaretPosition();
        char c = this.getFieldChar(n);
        switch (c) {
            case 'y': {
                this.increaseYear(bl);
                break;
            }
            case 'M': {
                this.increaseMonth(bl);
                break;
            }
            case 'd': {
                this.increaseDay(bl);
                break;
            }
            case 'H': 
            case 'h': {
                this.increaseHour(bl);
                break;
            }
            case 'm': {
                this.increaseMinute(bl);
                break;
            }
            case 's': {
                this.increaseSecond(bl);
                break;
            }
            case 't': {
                this.doAM_PMChanged();
                break;
            }
        }
        this.setSelection(n);
    }

    private char getFieldChar(int n) {
        int n2;
        int[] nArray = this.dateDocument.separator;
        String string = this.toolTipText;
        if (n == string.length()) {
            --n;
        } else {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (n != nArray[n2]) continue;
                --n;
                break;
            }
        }
        n2 = string.charAt(n);
        return (char)n2;
    }

    private void setSelection(int n) {
        int[] nArray = this.dateDocument.separator;
        int n2 = 0;
        int n3 = this.timeTextField.getText().length();
        if (nArray.length > 0) {
            if (n <= nArray[0]) {
                n2 = 0;
                n3 = nArray[0];
            } else if (n > nArray[nArray.length - 1]) {
                if (nArray.length > 0) {
                    n2 = nArray[nArray.length - 1] + 1;
                }
                n3 = this.timeTextField.getText().length();
            } else {
                for (int i = 0; i < nArray.length; ++i) {
                    if (n > nArray[i]) continue;
                    n2 = nArray[i - 1] + 1;
                    n3 = nArray[i];
                    break;
                }
            }
        }
        this.timeTextField.setCaretPosition(n2);
    }

    private void increaseYear(boolean bl) {
        int n = this.getCalendar().get(1);
        int n2 = n = bl ? n + 1 : n - 1;
        if (n > this.maxYear) {
            n = this.minYear;
        } else if (n < this.minYear) {
            n = bl ? this.minYear : this.maxYear;
        }
        Calendar calendar = this.getCalendar();
        int n3 = calendar.get(2);
        int n4 = calendar.get(5);
        calendar.set(1, n);
        if (calendar.get(2) != n3 || calendar.get(5) != n4) {
            calendar.set(5, 1);
            calendar.set(2, n3);
            calendar.set(1, n);
            calendar.set(5, calendar.getActualMaximum(5));
        } else {
            calendar.set(1, n);
        }
        this.setCalendarInternal(calendar);
    }

    private void increaseMonth(boolean bl) {
        Calendar calendar = this.getCalendar();
        int n = calendar.get(2);
        int n2 = n = bl ? n + 1 : n - 1;
        if (n > calendar.getActualMaximum(2)) {
            n = 0;
        } else if (n < 0) {
            n = calendar.getActualMaximum(2);
        }
        calendar.set(2, n);
        if (n != calendar.get(2)) {
            calendar.set(5, 1);
            calendar.set(2, n);
            calendar.set(5, calendar.getActualMaximum(5));
        } else {
            calendar.set(2, n);
        }
        this.setCalendarInternal(calendar);
    }

    private void increaseDay(boolean bl) {
        Calendar calendar = this.getCalendar();
        int n = calendar.get(5);
        int n2 = n = bl ? n + 1 : n - 1;
        if (n > calendar.getActualMaximum(5)) {
            n = 1;
        } else if (n <= 0) {
            n = calendar.getActualMaximum(5);
        }
        calendar.set(5, n);
        this.setCalendarInternal(calendar);
    }

    private void increaseHour(boolean bl) {
        Calendar calendar = this.getCalendar();
        boolean bl2 = this.is12_HourLock();
        int n = 0;
        if (!bl2) {
            n = calendar.get(11);
            n = bl ? n + 1 : n - 1;
            calendar.set(11, n);
            n = calendar.get(11);
        } else {
            n = calendar.get(10);
            n = bl ? n + 1 : n - 1;
            int n2 = calendar.get(9);
            calendar.set(10, n);
            n = calendar.get(10);
            if (n2 == 1) {
                n += 12;
            }
        }
        this.setCurrentHour(n);
    }

    private void increaseMinute(boolean bl) {
        Calendar calendar = this.getCalendar();
        int n = calendar.get(12);
        n = bl ? n + 1 : n - 1;
        calendar.set(12, n);
        n = calendar.get(12);
        Calendar calendar2 = this.getCalendar();
        calendar2.set(12, n);
        this.setCalendarInternal(calendar2);
    }

    private void increaseSecond(boolean bl) {
        Calendar calendar = this.getCalendar();
        int n = calendar.get(13);
        n = bl ? n + 1 : n - 1;
        calendar.set(13, n);
        n = calendar.get(13);
        Calendar calendar2 = this.getCalendar();
        calendar2.set(13, n);
        this.setCalendarInternal(calendar2);
    }

    private void doMousePressed(boolean bl) {
        if (!this.timeTextField.isEnabled() || !this.timeTextField.isEditable()) {
            return;
        }
        this.oldValue = this.timeTextField.getText();
        this.oldCaretPosition = this.timeTextField.getCaretPosition();
        this.timeTextField.requestFocus();
        if (delayTime > 0) {
            if (bl) {
                this.incctimer.start();
            } else {
                this.decctimer.start();
            }
            this.doDirectionKey(bl);
        }
    }

    private void doMouseReleased() {
        if (this.incctimer != null) {
            this.incctimer.stop();
        }
        if (this.decctimer != null) {
            this.decctimer.stop();
        }
    }

    protected int getCompIndex() {
        return this.index;
    }

    protected void fireChageEvent() {
        this.dateDocument.fireChageEvent();
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.timeTextField.setName(string + "_timeTextField");
        this.incttButton.setName(string + "_incttButton");
        this.decttButton.setName(string + "_incttButton");
        if (this.activeTimeChooseButton != null) {
            this.activeTimeChooseButton.setName(string + "_activeTimeChooseButton");
        }
    }

    protected static String getTimeEditor(GregorianCalendar gregorianCalendar) {
        return CalendarToolkit.convertCalendarToStr(gregorianCalendar, 3);
    }

    private class SpinnerAction
    implements ActionListener {
        private boolean isAsc = true;

        SpinnerAction(boolean bl) {
            this.isAsc = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InmDateChooser.this.doDirectionKey(this.isAsc);
        }
    }
}

