/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap12.util.dateChooser;

import com.swimap.imap12.util.dateChooser.InmDateDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class InmCommonUtil {
    public static final int SYSTEM_START_YEAR = 1990;
    public static final byte HAS_YF = 0;
    public static final byte HAS_YMF = 1;
    public static final byte HAS_YMDF = 2;
    public static final byte HAS_YMDTF = 3;
    public static final byte HAS_TF = 4;
    public static final byte HAS_YMDHMF = 5;
    public static final byte HAS_HMF = 6;
    public static final byte RANDOM_HOUR = 13;
    public static final String ONE_BLANKS = " ";
    public static final String TWO_BLANKS = "  ";
    public static final String THREE_BLANKS = "   ";
    public static final String FOUR_BLANKS = "    ";
    public static final String FIVE_BLANKS = "     ";
    public static final int WEEK_IDX_SUN = 0;
    public static final int WEEK_IDX_MON = 1;
    public static final int WEEK_IDX_TUE = 2;
    public static final int WEEK_IDX_WED = 3;
    public static final int WEEK_IDX_THU = 4;
    public static final int WEEK_IDX_FRI = 5;
    public static final int WEEK_IDX_SAT = 6;
    public static final int MONTH_IDX_JAN = 0;
    public static final int MONTH_IDX_FEB = 1;
    public static final int MONTH_IDX_MAR = 2;
    public static final int MONTH_IDX_APR = 3;
    public static final int MONTH_IDX_MAY = 4;
    public static final int MONTH_IDX_JUN = 5;
    public static final int MONTH_IDX_JUL = 6;
    public static final int MONTH_IDX_AUG = 7;
    public static final int MONTH_IDX_SEP = 8;
    public static final int MONTH_IDX_OCT = 9;
    public static final int MONTH_IDX_NOV = 10;
    public static final int MONTH_IDX_DEC = 11;
    private static final String[] MDHMS_STR = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"};
    private static int bofereYear = -1;
    private static int lastYear = -1;
    private static int curYear = -1;
    private static int comingyear = -1;
    private static String bofereYearStr = null;
    private static String lastYearStr = null;
    private static String curYearStr = null;
    private static String comingyearStr = null;
    private static final int FIFTY_NINE = 59;
    private static final int SIXTY = 60;
    private static final int TWELVE = 12;
    private static final int TWENTY_THREE = 23;
    private static final int THIRTY_ONE = 31;

    private static String formatSingleDateTimePara(String string, int n) {
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.length() == n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = string.trim().length(); i < n; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static final boolean validateTime(int n, int n2, int n3, boolean bl) {
        if (bl) {
            if (n < 0 || n2 < 0 || n3 < 0) {
                return false;
            }
            if (n == 24 && n2 == 0 && n3 == 0) {
                return true;
            }
            return n <= 23 && n2 <= 59 && n3 <= 59;
        }
        return n >= 0 && n2 >= 0 && n3 >= 0 && n <= 23 && n2 <= 59 && n3 <= 59;
    }

    public static final boolean validateTime(int n, int n2, int n3, boolean bl, boolean bl2) {
        if (bl2 && n >= 13) {
            return false;
        }
        if (bl) {
            if (n < 0 || n2 < 0 || n3 < 0) {
                return false;
            }
            if (n == 24 && n2 == 0 && n3 == 0) {
                return true;
            }
            return n <= 23 && n2 <= 59 && n3 <= 59;
        }
        return n >= 0 && n2 >= 0 && n3 >= 0 && n <= 23 && n2 <= 59 && n3 <= 59;
    }

    public static final boolean validateTime(int n, int n2, int n3) {
        return InmCommonUtil.validateTime(n, n2, n3, false);
    }

    public static final boolean validateTime(String string, String string2, String string3, boolean bl) {
        if ("-0".equals(string) || "-0".equals(string2) || "-0".equals(string3)) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.parseInt(string.trim());
            n2 = Integer.parseInt(string2.trim());
            n3 = Integer.parseInt(string3.trim());
        }
        catch (Exception exception) {
            return false;
        }
        return InmCommonUtil.validateTime(n, n2, n3, bl);
    }

    public static final boolean validateTime(String string, String string2, String string3, boolean bl, boolean bl2) {
        if ("-0".equals(string) || "-0".equals(string2) || "-0".equals(string3)) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.parseInt(string.trim());
            n2 = Integer.parseInt(string2.trim());
            n3 = Integer.parseInt(string3.trim());
        }
        catch (Exception exception) {
            return false;
        }
        return InmCommonUtil.validateTime(n, n2, n3, bl, bl2);
    }

    public static final boolean validateTime(String string, String string2, String string3) {
        return InmCommonUtil.validateTime(string, string2, string3, false);
    }

    public static boolean validateDate(String string, String string2, String string3) {
        return InmCommonUtil.validateDate(string, string2, string3, InmDateDocument.maxYear);
    }

    public static boolean validateDate(String string, String string2, String string3, int n) {
        return InmCommonUtil.validateDate(string, string2, string3, n, null);
    }

    public static boolean validateDate(String string, String string2, String string3, int n, TimeZone timeZone) {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        try {
            n2 = Integer.parseInt(string.trim());
            n3 = Integer.parseInt(string2.trim());
            n4 = Integer.parseInt(string3.trim());
        }
        catch (Exception exception) {
            return false;
        }
        return InmCommonUtil.validateDate(n2, n3, n4, n, timeZone);
    }

    public static boolean validateDate(int n, int n2, int n3) {
        return InmCommonUtil.validateDate(n, n2, n3, InmDateDocument.maxYear);
    }

    public static boolean validateDate(int n, int n2, int n3, int n4) {
        return InmCommonUtil.validateDate(n, n2, n3, n4, null);
    }

    public static boolean validateDate(int n, int n2, int n3, int n4, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = null;
        if (n < 1 || n > n4 || n2 < 0 || n3 < 0 || n2 > 12 || n3 > 31) {
            return false;
        }
        if (timeZone != null) {
            gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.set(n, n2 - 1, n3, 13, 0, 0);
        } else {
            gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3, 13, 0, 0);
        }
        return gregorianCalendar.get(1) == n && gregorianCalendar.get(2) == n2 - 1 && gregorianCalendar.get(5) == n3;
    }

    public static final String toHourMinString(Calendar calendar) {
        String string = null;
        String string2 = null;
        int n = -1;
        int n2 = -1;
        n = calendar.get(11);
        string = Integer.valueOf(n).toString();
        n2 = calendar.get(12);
        string2 = Integer.valueOf(n2).toString();
        StringBuffer stringBuffer = new StringBuffer(5);
        if (string.length() == 1) {
            stringBuffer.append('0').append(string);
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append(InmDateDocument.timeSeparator);
        if (string2.length() == 1) {
            stringBuffer.append('0').append(string2);
        } else {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static final String toHourMinString(Calendar calendar, boolean bl) {
        String string = null;
        String string2 = null;
        int n = -1;
        int n2 = -1;
        n = calendar.get(11);
        string = Integer.valueOf(n).toString();
        n2 = calendar.get(12);
        string2 = Integer.valueOf(n2).toString();
        if (bl && n == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) {
            string = "24";
            string2 = "00";
        }
        StringBuffer stringBuffer = new StringBuffer(5);
        if (string.length() == 1) {
            stringBuffer.append('0').append(string);
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append(InmDateDocument.timeSeparator);
        if (string2.length() == 1) {
            stringBuffer.append('0').append(string2);
        } else {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String toHourString(Calendar calendar) {
        int n = calendar.get(10);
        if (calendar.get(9) == 1) {
            n += 12;
        }
        if (n >= 0 && n < 60) {
            return MDHMS_STR[n];
        }
        return InmCommonUtil.formatSingleDateTimePara(String.valueOf(n), 2);
    }

    public static String toMinuteString(Calendar calendar) {
        int n = calendar.get(12);
        if (n >= 0 && n < 60) {
            return MDHMS_STR[n];
        }
        return InmCommonUtil.formatSingleDateTimePara(String.valueOf(n), 2);
    }

    public static String toSecondString(Calendar calendar) {
        int n = calendar.get(13);
        if (n >= 0 && n < 60) {
            return MDHMS_STR[n];
        }
        return InmCommonUtil.formatSingleDateTimePara(String.valueOf(n), 2);
    }

    public static String toMDHMSString(int n) {
        if (n >= 0 && n < 60) {
            return MDHMS_STR[n];
        }
        return InmCommonUtil.formatSingleDateTimePara(String.valueOf(n), 2);
    }

    public static final String toTimeString(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append(InmCommonUtil.toHourString(calendar));
        stringBuffer.append(InmDateDocument.timeSeparator);
        stringBuffer.append(InmCommonUtil.toMinuteString(calendar));
        stringBuffer.append(InmDateDocument.timeSeparator);
        stringBuffer.append(InmCommonUtil.toSecondString(calendar));
        return stringBuffer.toString();
    }

    public static final String toTimeString(Calendar calendar, boolean bl) {
        String string = InmCommonUtil.toHourString(calendar);
        String string2 = InmCommonUtil.toMinuteString(calendar);
        String string3 = InmCommonUtil.toSecondString(calendar);
        if (bl && calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) {
            string = "24";
            string2 = "00";
            string3 = "00";
        }
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append(string);
        stringBuffer.append(InmDateDocument.timeSeparator);
        stringBuffer.append(string2);
        stringBuffer.append(InmDateDocument.timeSeparator);
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    public static final String toTimeString_AM_PM(Calendar calendar) {
        String string = null;
        String string2 = InmDateDocument.time_AM_PM_symbols[0];
        int n = calendar.get(10);
        if (n == 0) {
            n = 12;
        }
        if (calendar.get(9) == 1) {
            string2 = InmDateDocument.time_AM_PM_symbols[1];
        }
        if ((string = Integer.valueOf(n).toString()).length() == 1) {
            string = '0' + string;
        }
        String string3 = InmCommonUtil.toMinuteString(calendar);
        String string4 = InmCommonUtil.toSecondString(calendar);
        return string + InmDateDocument.timeSeparator + string3 + InmDateDocument.timeSeparator + string4 + ' ' + string2;
    }

    public static final String toTimeString_AM_PM(Calendar calendar, boolean bl) {
        String string = null;
        String string2 = InmDateDocument.time_AM_PM_symbols[0];
        int n = calendar.get(10);
        if (n == 0) {
            n = 12;
        }
        if (calendar.get(9) == 1) {
            string2 = InmDateDocument.time_AM_PM_symbols[1];
        }
        string = Integer.valueOf(n).toString();
        String string3 = InmCommonUtil.toMinuteString(calendar);
        String string4 = InmCommonUtil.toSecondString(calendar);
        if (string.length() == 1) {
            string = '0' + string;
        }
        return string + InmDateDocument.timeSeparator + string3 + InmDateDocument.timeSeparator + string4 + ' ' + string2;
    }

    public static final String toYearString(Calendar calendar) {
        int n = calendar.get(1);
        if (n == curYear) {
            return curYearStr;
        }
        if (n == lastYear) {
            return lastYearStr;
        }
        if (n == bofereYear) {
            return bofereYearStr;
        }
        if (n == comingyear) {
            return comingyearStr;
        }
        return InmCommonUtil.formatSingleDateTimePara(String.valueOf(n), 4);
    }

    public static final String toMonthString(Calendar calendar) {
        int n = calendar.get(2) + 1;
        if (n >= 0 && n < 60) {
            return MDHMS_STR[n];
        }
        return InmCommonUtil.formatSingleDateTimePara(String.valueOf(n), 2);
    }

    public static final String toDateString(Calendar calendar) {
        int n = calendar.get(5);
        if (n >= 0 && n < 60) {
            return MDHMS_STR[n];
        }
        return InmCommonUtil.formatSingleDateTimePara(String.valueOf(n), 2);
    }

    public static final String toYearString(int n) {
        if (n == curYear) {
            return curYearStr;
        }
        if (n == lastYear) {
            return lastYearStr;
        }
        if (n == bofereYear) {
            return bofereYearStr;
        }
        if (n == comingyear) {
            return comingyearStr;
        }
        return InmCommonUtil.formatSingleDateTimePara(String.valueOf(n), 4);
    }

    public static synchronized byte[] calendarToBytes(Calendar calendar) {
        byte[] byArray = new byte[6];
        int n = calendar.get(1) - 1990;
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        byArray[0] = Integer.valueOf(n).byteValue();
        byArray[1] = Integer.valueOf(n2).byteValue();
        byArray[2] = Integer.valueOf(n3).byteValue();
        byArray[3] = Integer.valueOf(n4).byteValue();
        byArray[4] = Integer.valueOf(n5).byteValue();
        byArray[5] = Integer.valueOf(n6).byteValue();
        return byArray;
    }

    public static synchronized String convertCalendarToStr(Calendar calendar, byte by) {
        if (calendar == null) {
            return null;
        }
        String string = InmCommonUtil.toYearString(calendar);
        String string2 = InmCommonUtil.toMonthString(calendar);
        String string3 = InmCommonUtil.toDateString(calendar);
        String string4 = InmCommonUtil.toTimeString(calendar);
        String string5 = InmCommonUtil.toHourMinString(calendar);
        switch (by) {
            case 0: {
                return string;
            }
            case 1: {
                return string + InmDateDocument.dateSeparator + string2;
            }
            case 2: {
                return string + InmDateDocument.dateSeparator + string2 + InmDateDocument.dateSeparator + string3;
            }
            case 3: {
                return string + InmDateDocument.dateSeparator + string2 + InmDateDocument.dateSeparator + string3 + ' ' + string4;
            }
            case 4: {
                return string4;
            }
            case 5: {
                return string + InmDateDocument.dateSeparator + string2 + InmDateDocument.dateSeparator + string3 + ' ' + string5;
            }
            case 6: {
                return string5;
            }
        }
        return null;
    }

    public static void centerLocateToScreen(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        Point point = new Point();
        point.x = (int)(dimension.getWidth() / 2.0 - dimension2.getWidth() / 2.0);
        point.y = (int)(dimension.getHeight() / 2.0 - dimension2.getHeight() / 2.0);
        component.setLocation(point);
    }

    public static int getHourWithAM_PM(String string, String string2) {
        return InmCommonUtil.getHourWithAM_PM(string, Integer.valueOf(string2));
    }

    public static int getHourWithAM_PM(String string, int n) {
        if (!InmDateDocument.time_AM_PM_symbols[0].equals(string)) {
            if (n != 12) {
                n += 12;
            }
        } else if (n == 12) {
            n = 0;
        }
        return n;
    }

    public static boolean validateMinYear(String string, String string2, String string3, int n, TimeZone timeZone) {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        try {
            n2 = Integer.parseInt(string.trim());
            n3 = Integer.parseInt(string2.trim());
            n4 = Integer.parseInt(string3.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        GregorianCalendar gregorianCalendar = null;
        if (n2 < n) {
            return false;
        }
        if (timeZone != null) {
            gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.set(n2, n3 - 1, n4, 13, 0, 0);
        } else {
            gregorianCalendar = new GregorianCalendar(n2, n3 - 1, n4, 13, 0, 0);
        }
        return gregorianCalendar.get(1) == n2 && gregorianCalendar.get(2) == n3 - 1 && gregorianCalendar.get(5) == n4;
    }

    static {
        curYear = Calendar.getInstance().get(1);
        lastYear = curYear - 1;
        bofereYear = curYear - 2;
        comingyear = curYear + 1;
        curYearStr = InmCommonUtil.formatSingleDateTimePara(String.valueOf(curYear), 4);
        lastYearStr = InmCommonUtil.formatSingleDateTimePara(String.valueOf(lastYear), 4);
        bofereYearStr = InmCommonUtil.formatSingleDateTimePara(String.valueOf(bofereYear), 4);
        comingyearStr = InmCommonUtil.formatSingleDateTimePara(String.valueOf(comingyear), 4);
    }
}

