/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap12.util.dateChooser;

import com.swimap.imap12.util.InmIntegerTextField;
import com.swimap.imap12.util.dateChooser.InmCommonUtil;
import com.swimap.imap12.util.dateChooser.InmDateChooser;
import com.swimap.imap12.util.dateChooser.InmDateDocument;
import com.swimap.imap12.util.dateChooser.InmTriangleIcon;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.ScreenUIToolKit;
import com.swimap.iview.util.adapter.FrameworkHelper;
import com.swimap.iview.util.adapter.HelpUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class DateTimeChooserDlg
extends JDialog {
    private static IviewLogger logger = IviewLogger.getLogger(DateTimeChooserDlg.class, "IVIEW");
    private static ResourceBundle res = InmDateChooser.res;
    private String[] columnNames = null;
    private String[] monthItems = null;
    private Calendar _calendar = null;
    private int hFields = -1;
    private boolean hy = false;
    private boolean hm = false;
    private boolean hd = false;
    private boolean ht = false;
    private boolean hhour = false;
    private boolean hminute = false;
    private boolean hsecond = false;
    private boolean htt = false;
    private DefaultTableModel dayTableModel = null;
    private boolean isApply = false;
    private JPanel subMainPanel = null;
    private JComboBox monthComboBox = null;
    private InmIntegerTextField yearTextField = null;
    private JButton incYearButton = null;
    private JButton decYearButton = null;
    private JButton incttButton = null;
    private JButton decttButton = null;
    private JTable chooseDayTable = null;
    private JButton confirmButton = null;
    private JTextField timeTextField = null;
    private InmDateDocument document = null;
    private boolean enabled24 = false;
    private int oldRow = 0;
    private int oldCol = 0;
    private transient Icon upIcon = new InmTriangleIcon(Color.black, 0);
    private transient Icon downIcon = new InmTriangleIcon(Color.black, 1);
    private static final int TWELVE = 12;
    private static final int TWENTY_FOUR = 24;
    private static final int DEFAULT_MAX_YEAR = 9999;
    private static final int DEFAULT_MIN_YEAR = 1;
    private int minYear = 1;
    private int maxYear = 9999;
    private static final int DEFAULT_DELAYTIME = 200;
    private static int delayTime = 200;
    private static final int DEFAULT_PERIODTIME = 50;
    private static int periodTime = 50;
    private Timer timer = null;
    private static final int DEFAULT_BTN_HEIGHT = 21;
    private static final int DEFAULT_BTN_WIDTH = 80;
    private transient FocusListener focusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent focusEvent) {
            DateTimeChooserDlg.this.yearTextField.setIsModify(false);
        }
    };
    private transient DocumentListener documentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            DateTimeChooserDlg.this.yearchanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            DateTimeChooserDlg.this.yearchanged();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            DateTimeChooserDlg.this.yearchanged();
        }
    };
    JPanel buttonsPanel = null;
    private MouseEvent mouseEvent = null;

    DateTimeChooserDlg(Frame frame, String string, boolean bl, int n, Calendar calendar) {
        super(frame, string, bl);
        this.jbInit(n, calendar, false);
        this.setDefaultCloseOperation(2);
    }

    DateTimeChooserDlg(Frame frame, String string, boolean bl, int n, Calendar calendar, boolean bl2) {
        super(frame, string, bl);
        this.jbInit(n, calendar, bl2);
        this.setDefaultCloseOperation(2);
    }

    DateTimeChooserDlg(Dialog dialog, String string, boolean bl, int n, Calendar calendar) {
        super(dialog, string, bl);
        this.jbInit(n, calendar, false);
        this.setDefaultCloseOperation(2);
    }

    DateTimeChooserDlg(Dialog dialog, String string, boolean bl, int n, Calendar calendar, boolean bl2) {
        super(dialog, string, bl);
        this.jbInit(n, calendar, bl2);
        this.setDefaultCloseOperation(2);
    }

    private void yearchanged() {
        this.adjustYearMonthDay(this._calendar, this.yearTextField.getValue());
        if (this.hd) {
            this.fillDayTable();
        }
    }

    private void jbInit(int n, Calendar calendar, boolean bl) {
        this.columnNames = new String[7];
        this.monthItems = new String[12];
        String string = res.getString("Cancel");
        String string2 = res.getString("OK");
        this.columnNames[0] = res.getString("Sun");
        this.columnNames[1] = res.getString("Mon");
        this.columnNames[2] = res.getString("Tues");
        this.columnNames[3] = res.getString("Wed");
        this.columnNames[4] = res.getString("Thurs");
        this.columnNames[5] = res.getString("Friday");
        this.columnNames[6] = res.getString("Sat");
        this.monthItems[0] = res.getString("January");
        this.monthItems[1] = res.getString("February");
        this.monthItems[2] = res.getString("March");
        this.monthItems[3] = res.getString("April");
        this.monthItems[4] = res.getString("May");
        this.monthItems[5] = res.getString("June");
        this.monthItems[6] = res.getString("July");
        this.monthItems[7] = res.getString("August");
        this.monthItems[8] = res.getString("September");
        this.monthItems[9] = res.getString("October");
        this.monthItems[10] = res.getString("November");
        this.monthItems[11] = res.getString("December");
        this.hFields = n;
        this._calendar = calendar != null ? calendar : new GregorianCalendar();
        if (!this.analyseHasFileds(this.hFields)) {
            return;
        }
        JPanel jPanel = new JPanel();
        jPanel.setName("InmDateChooserDlg_mainPanel");
        this.subMainPanel = new JPanel();
        this.subMainPanel.setName("InmDateChooserDlg_subMainPanel");
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setName("InmDateChooserDlg_buttonsPanel");
        this.confirmButton = new JButton(string2);
        this.confirmButton.setName("InmDateChooserDlg_confirmButton");
        JButton jButton = new JButton(string);
        jButton.setName("InmDateChooserDlg_cancelButton");
        ScreenUIToolKit.setDefaultButtons(this.confirmButton, jButton);
        JButton[] jButtonArray = new JButton[]{this.confirmButton, jButton};
        ScreenUIToolKit.setPreferredSizeofButtons(jButtonArray, 21);
        jPanel.setLayout(new GridBagLayout());
        this.subMainPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.getContentPane().add(jPanel);
        jPanel.add((Component)this.subMainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeChooserDlg.this.confirmButton_actionPerformed(actionEvent);
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeChooserDlg.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.timeTextField = new JTextField();
        this.timeTextField.setName("InmDateChooserDlg_timeTextField");
        this.timeTextField.addFocusListener(this.focusListener);
        this.timeTextField.setMinimumSize(new Dimension(122, 21));
        this.timeTextField.setPreferredSize(new Dimension(122, 21));
        if (this.hy) {
            this.initYearField();
        }
        if (this.hm) {
            this.initMonthField();
        }
        if (this.hd) {
            this.initDayField();
        }
        if (this.ht) {
            this.initTimeField(bl);
        } else if (this.hhour && this.hminute) {
            this.initHourAndMinuteField(bl);
        }
        if (this.hFields == 4 || this.hFields == 0 || this.hFields == 1 || this.hFields == 6) {
            this.setBounds(200, 200, 300, 180);
        } else {
            this.setBounds(200, 200, 400, 286);
        }
        if (this.hy) {
            this.yearTextField.setText(Integer.valueOf(this._calendar.get(1)).toString());
        }
        if (this.hm) {
            this.monthComboBox.setSelectedIndex(this._calendar.get(2));
        }
        if (this.chooseDayTable != null) {
            String string3 = "ENTER";
            String string4 = "ESCAPE";
            this.chooseDayTable.getInputMap().put(KeyStroke.getKeyStroke(string3), string3);
            this.chooseDayTable.getActionMap().put(string3, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DateTimeChooserDlg.this.confirmButton_actionPerformed(actionEvent);
                }
            });
            this.chooseDayTable.getInputMap().put(KeyStroke.getKeyStroke(string4), string4);
            this.chooseDayTable.getActionMap().put(string4, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DateTimeChooserDlg.this.cancelButton_actionPerformed(actionEvent);
                }
            });
        }
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                DateTimeChooserDlg.this.generateAndPostPseudoEvent();
            }
        });
        this.addSpinnerMouseListener();
        this.enableHelp();
    }

    private void enableHelp() {
        JRootPane jRootPane = this.getRootPane();
        Object object = ReflectionUtilities.callStaticMethod("com.swimap.iview.util.helpmanagement.CSH", "getHelpIDString", new Class[]{Component.class}, new Object[]{jRootPane});
        if (object == null) {
            HelpUtil.enableHelpKey(jRootPane, "iVIEW.DateChooserDlg");
        } else {
            HelpUtil.enableHelp(jRootPane, "iVIEW.DateChooserDlg");
        }
    }

    private void generateAndPostPseudoEvent() {
        if (this.mouseEvent != null) {
            MouseEvent mouseEvent = new MouseEvent((Component)this.mouseEvent.getSource(), 502, this.mouseEvent.getWhen(), this.mouseEvent.getModifiers(), this.mouseEvent.getX(), this.mouseEvent.getY(), 1, false, 1);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(mouseEvent);
        }
    }

    private void addSpinnerMouseListener() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (DateTimeChooserDlg.this.mouseEvent == null || DateTimeChooserDlg.this.mouseEvent.getSource() != mouseEvent.getSource()) {
                    DateTimeChooserDlg.this.mouseEvent = mouseEvent;
                }
            }
        };
        if (this.incttButton != null) {
            this.incttButton.addMouseListener(mouseAdapter);
        }
        if (this.decttButton != null) {
            this.decttButton.addMouseListener(mouseAdapter);
        }
        if (this.incYearButton != null) {
            this.incYearButton.addMouseListener(mouseAdapter);
        }
        if (this.decYearButton != null) {
            this.decYearButton.addMouseListener(mouseAdapter);
        }
    }

    private boolean analyseHasFileds(int n) {
        switch (n) {
            case 0: {
                this.hy = true;
                return true;
            }
            case 1: {
                this.hy = true;
                this.hm = true;
                return true;
            }
            case 2: 
            case 15: 
            case 16: {
                this.hy = true;
                this.hm = true;
                this.hd = true;
                return true;
            }
            case 4: {
                this.ht = true;
                this.hsecond = true;
                return true;
            }
            case 12: {
                this.htt = true;
                this.hsecond = true;
                return true;
            }
            case 6: {
                this.hhour = true;
                this.hminute = true;
                this.hsecond = false;
                return true;
            }
            case 5: 
            case 17: 
            case 19: {
                this.hy = true;
                this.hm = true;
                this.hd = true;
                this.hhour = true;
                this.hminute = true;
                this.hsecond = false;
                return true;
            }
            case 14: {
                this.hhour = true;
                this.hminute = true;
                this.hsecond = false;
                this.htt = true;
                return true;
            }
            case 13: 
            case 18: 
            case 20: {
                this.hy = true;
                this.hm = true;
                this.hd = true;
                this.hhour = true;
                this.hminute = true;
                this.hsecond = false;
                this.htt = true;
                return true;
            }
            case 3: 
            case 8: 
            case 10: {
                this.hy = true;
                this.hm = true;
                this.hd = true;
                this.ht = true;
                this.hsecond = true;
                return true;
            }
            case 7: 
            case 9: 
            case 11: {
                this.hy = true;
                this.hm = true;
                this.hd = true;
                this.ht = true;
                this.htt = true;
                this.hsecond = true;
                return true;
            }
        }
        return false;
    }

    private void initYearField() {
        this.yearTextField = new InmIntegerTextField(this.minYear, this.maxYear);
        this.yearTextField.setName("InmDateChooserDlg_yearTextField");
        this.yearTextField.setRegularValue(true);
        this.yearTextField.setToolTipText("[" + this.minYear + ", " + this.maxYear + ']');
        this.yearTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                DateTimeChooserDlg.this.doTimeReleased();
                DateTimeChooserDlg.this.yearTextField.setCaretPosition(0);
            }
        });
        this.yearTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38) {
                    DateTimeChooserDlg.this.incYearButton_actionPerformed(null);
                } else if (keyEvent.getKeyCode() == 40) {
                    DateTimeChooserDlg.this.decYearButton_actionPerformed(null);
                }
            }
        });
        this.yearTextField.setFocusAfterError(false);
        this.yearTextField.getDocument().addDocumentListener(this.documentListener);
        this.incYearButton = new JButton("", this.upIcon);
        this.incYearButton.setName("InmDateChooserDlg_incYearButton");
        this.decYearButton = new JButton("", this.downIcon);
        this.decYearButton.setName("InmDateChooserDlg_decYearButton");
        this.incYearButton.setFocusable(false);
        this.decYearButton.setFocusable(false);
        this.yearTextField.setMinimumSize(new Dimension(80, 21));
        this.yearTextField.setPreferredSize(new Dimension(80, 21));
        this.incYearButton.setMaximumSize(new Dimension(39, 15));
        this.incYearButton.setMinimumSize(new Dimension(20, 10));
        this.incYearButton.setPreferredSize(new Dimension(20, 10));
        this.decYearButton.setMaximumSize(new Dimension(39, 15));
        this.decYearButton.setMinimumSize(new Dimension(20, 10));
        this.decYearButton.setPreferredSize(new Dimension(20, 10));
        this.subMainPanel.add((Component)this.yearTextField, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.subMainPanel.add((Component)this.incYearButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.subMainPanel.add((Component)this.decYearButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.decYearButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    DateTimeChooserDlg.this.timer = new Timer();
                    if (delayTime > 0) {
                        TimerTask timerTask = new TimerTask(){

                            @Override
                            public void run() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DateTimeChooserDlg.this.decYearButton_actionPerformed(null);
                                    }
                                });
                            }
                        };
                        DateTimeChooserDlg.this.timer.schedule(timerTask, delayTime, (long)periodTime);
                        DateTimeChooserDlg.this.decYearButton_actionPerformed(null);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    DateTimeChooserDlg.this.doTimeReleased();
                }
            }
        });
        this.incYearButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    DateTimeChooserDlg.this.timer = new Timer();
                    if (delayTime > 0) {
                        TimerTask timerTask = new TimerTask(){

                            @Override
                            public void run() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DateTimeChooserDlg.this.incYearButton_actionPerformed(null);
                                    }
                                });
                            }
                        };
                        DateTimeChooserDlg.this.timer.schedule(timerTask, delayTime, (long)periodTime);
                        DateTimeChooserDlg.this.incYearButton_actionPerformed(null);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    DateTimeChooserDlg.this.doTimeReleased();
                }
            }
        });
    }

    private void initMonthField() {
        this.monthComboBox = new JComboBox<String>(this.monthItems);
        this.monthComboBox.setName("InmDateChooserDlg_monthComboBox");
        this.monthComboBox.setMinimumSize(new Dimension(80, 21));
        this.monthComboBox.setPreferredSize(new Dimension(80, 21));
        this.monthComboBox.addFocusListener(this.focusListener);
        this.monthComboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && !DateTimeChooserDlg.this.monthComboBox.isPopupVisible()) {
                    DateTimeChooserDlg.this.confirmButton.doClick();
                }
            }
        });
        this.subMainPanel.add((Component)this.monthComboBox, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.monthComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeChooserDlg.this.monthComboBox_actionPerformed(actionEvent);
            }
        });
    }

    private void initDayField() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setName("InmDateChooserDlg_chooserDayScrollPane");
        this.dayTableModel = new DefaultTableModel(this.columnNames, 0);
        this.chooseDayTable = new DayTable(this.dayTableModel);
        this.chooseDayTable.setName("InmDateChooserDlg_chooseDayTable");
        this.chooseDayTable.addFocusListener(this.focusListener);
        this.chooseDayTable.setFillsViewportHeight(false);
        this.chooseDayTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
                DateTimeChooserDlg.this.modifyDate();
            }
        });
        this.chooseDayTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DateTimeChooserDlg.this.modifyDate();
            }
        });
        this.chooseDayTable.getTableHeader().setReorderingAllowed(false);
        this.chooseDayTable.getTableHeader().setResizingAllowed(false);
        this.chooseDayTable.setCellSelectionEnabled(true);
        this.chooseDayTable.setColumnSelectionAllowed(true);
        this.chooseDayTable.setRowSelectionAllowed(true);
        this.chooseDayTable.setSelectionBackground(Color.lightGray);
        this.chooseDayTable.setSelectionForeground(Color.red);
        this.chooseDayTable.setSelectionMode(0);
        jScrollPane.getViewport().setBackground(Color.white);
        this.chooseDayTable.setBorder(BorderFactory.createEtchedBorder());
        this.subMainPanel.add((Component)jScrollPane, new GridBagConstraints(0, 2, 5, 0, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        jScrollPane.getViewport().add((Component)this.chooseDayTable, null);
        jScrollPane.getViewport().setBackground(this.chooseDayTable.getBackground());
        this.chooseDayTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Object object = DateTimeChooserDlg.this.chooseDayTable.getValueAt(DateTimeChooserDlg.this.chooseDayTable.getSelectedRow(), DateTimeChooserDlg.this.chooseDayTable.getSelectedColumn());
                if (null != object && !"".equals(object)) {
                    DateTimeChooserDlg.this.confirmButton_actionPerformed(new ActionEvent(new Object(), 0, null));
                }
            }
        });
    }

    private void initTimeField(boolean bl) {
        if (this.htt) {
            this.document = new InmDateDocument(this.timeTextField, InmDateDocument.TIMEINITSTRT, InmDateDocument.TIMESEPT, 12);
            this.timeTextField.setDocument(this.document);
            this.document.setEnableHour24(bl);
            this.timeTextField.setText(InmCommonUtil.toTimeString_AM_PM(this._calendar, bl));
        } else {
            this.document = new InmDateDocument(this.timeTextField, InmDateDocument.TIMEINITSTR, InmDateDocument.TIMESEP, 4);
            this.timeTextField.setDocument(this.document);
            this.document.setEnableHour24(bl);
            this.timeTextField.setText(InmCommonUtil.toTimeString(this._calendar, bl));
            this.buttonsPanel.add((Component)this.timeTextField, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 14, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.buttonsPanel.add((Component)this.timeTextField, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 14, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.timeTextField.setCaretPosition(0);
        this.timeTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                DateTimeChooserDlg.this.doTimeReleased();
                DateTimeChooserDlg.this.timeTextField.setCaretPosition(0);
            }
        });
        this.timeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38) {
                    DateTimeChooserDlg.this.doTimeDirectionKey(true);
                    DateTimeChooserDlg.this.timeTextField.requestFocus();
                } else if (keyEvent.getKeyCode() == 40) {
                    DateTimeChooserDlg.this.doTimeDirectionKey(false);
                    DateTimeChooserDlg.this.timeTextField.requestFocus();
                }
            }
        });
        this.incttButton = new JButton("", this.upIcon);
        this.incttButton.setName("InmDateChooserDlg_incttButton");
        this.decttButton = new JButton("", this.downIcon);
        this.decttButton.setName("InmDateChooserDlg_decttButton");
        this.incttButton.setFocusable(false);
        this.decttButton.setFocusable(false);
        this.incttButton.setMaximumSize(new Dimension(39, 15));
        this.incttButton.setMinimumSize(new Dimension(20, 10));
        this.incttButton.setPreferredSize(new Dimension(20, 10));
        this.decttButton.setMaximumSize(new Dimension(39, 15));
        this.decttButton.setMinimumSize(new Dimension(20, 10));
        this.decttButton.setPreferredSize(new Dimension(20, 10));
        this.subMainPanel.add((Component)this.incttButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.subMainPanel.add((Component)this.decttButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.decttButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    DateTimeChooserDlg.this.doTimePressed(false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    DateTimeChooserDlg.this.doTimeReleased();
                }
            }
        });
        this.incttButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    DateTimeChooserDlg.this.doTimePressed(true);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    DateTimeChooserDlg.this.doTimeReleased();
                }
            }
        });
    }

    private void initHourAndMinuteField(boolean bl) {
        this.buttonsPanel.add((Component)this.timeTextField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.htt) {
            if (this.hsecond) {
                this.document = new InmDateDocument(this.timeTextField, InmDateDocument.TIMEINITSTRT, InmDateDocument.TIMESEPT, 12);
                this.timeTextField.setDocument(this.document);
                this.document.setEnableHour24(bl);
                this.timeTextField.setText(InmCommonUtil.toTimeString_AM_PM(this._calendar, bl));
            } else {
                this.document = new InmDateDocument(this.timeTextField, InmDateDocument.HMINITSTRT, InmDateDocument.HMSEPT, 14);
                this.timeTextField.setDocument(this.document);
                this.document.setEnableHour24(bl);
                String string = InmCommonUtil.toTimeString_AM_PM(this._calendar, bl);
                this.timeTextField.setText(string.substring(0, 5) + string.substring(8));
            }
        } else {
            this.document = new InmDateDocument(this.timeTextField, InmDateDocument.HMINITSTR, InmDateDocument.HMSEP, 6);
            this.timeTextField.setDocument(this.document);
            this.document.setEnableHour24(bl);
            this.timeTextField.setText(InmCommonUtil.toHourMinString(this._calendar, bl));
        }
        this.timeTextField.setCaretPosition(0);
        this.timeTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                DateTimeChooserDlg.this.doTimeReleased();
                DateTimeChooserDlg.this.timeTextField.setCaretPosition(0);
            }
        });
        this.timeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38) {
                    DateTimeChooserDlg.this.doTimeDirectionKey(true);
                } else if (keyEvent.getKeyCode() == 40) {
                    DateTimeChooserDlg.this.doTimeDirectionKey(false);
                }
            }
        });
        this.incttButton = new JButton("", this.upIcon);
        this.decttButton = new JButton("", this.downIcon);
        this.incttButton.setName("InmDateChooserDlg_incttButton");
        this.decttButton.setName("InmDateChooserDlg_decttButton");
        this.incttButton.setFocusable(false);
        this.decttButton.setFocusable(false);
        this.incttButton.setMaximumSize(new Dimension(39, 15));
        this.incttButton.setMinimumSize(new Dimension(20, 10));
        this.incttButton.setPreferredSize(new Dimension(20, 10));
        this.decttButton.setMaximumSize(new Dimension(39, 15));
        this.decttButton.setMinimumSize(new Dimension(20, 10));
        this.decttButton.setPreferredSize(new Dimension(20, 10));
        this.buttonsPanel.add((Component)this.incttButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonsPanel.add((Component)this.decttButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.decttButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DateTimeChooserDlg.this.doTimePressed(false);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DateTimeChooserDlg.this.doTimeReleased();
            }
        });
        this.incttButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DateTimeChooserDlg.this.doTimePressed(true);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DateTimeChooserDlg.this.doTimeReleased();
            }
        });
    }

    private void modifyDate() {
        int n = this.chooseDayTable.getSelectedRow();
        int n2 = this.chooseDayTable.getSelectedColumn();
        if (n < 0 || n2 < 0) {
            return;
        }
        if (this.oldRow == n && this.oldCol == n2) {
            return;
        }
        this.oldRow = n;
        this.oldCol = n2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = DateTimeChooserDlg.this.chooseDayTable.getValueAt(DateTimeChooserDlg.this.chooseDayTable.getSelectedRow(), DateTimeChooserDlg.this.chooseDayTable.getSelectedColumn()).toString();
                if (!"".equals(string) && string != null) {
                    try {
                        DateTimeChooserDlg.this._calendar.set(5, new Integer(string));
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.trace(numberFormatException.getMessage(), numberFormatException);
                    }
                }
            }
        });
    }

    private void confirmButton_actionPerformed(ActionEvent actionEvent) {
        if (this.yearTextField.getIsModify()) {
            this.yearTextField.setIsModify(false);
        }
        String string = this.yearTextField.getText();
        try {
            int n = -1;
            if (string != null && string.trim().length() > 0) {
                n = new Integer(string.trim());
            }
            if (n < this.yearTextField.getMin() || n > this.yearTextField.getMax()) {
                this.yearTextField.modifyText();
                this.confirmButton.requestFocus(true);
                this.yearTextField.setIsModify(false);
                return;
            }
            if (!ResourceUtil.areEquals(String.valueOf(n), string.trim())) {
                this.yearTextField.modifyText();
                this.confirmButton.requestFocus(true);
                this.yearTextField.setIsModify(false);
                return;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return;
        }
        if (this.hy || this.hd) {
            try {
                this.getInputValue();
            }
            catch (Exception exception) {
                OptionPane.showErrorDialog(FrameworkHelper.getMainFrame(), res.getString("Time_selection_error"));
                return;
            }
        }
        if (this.timeTextField != null) {
            String string2 = this.timeTextField.getText();
            this.initDialogValue(this.getCalendar(), this.enabled24, string2, this.hFields);
            String string3 = this.timeTextField.getText();
            if (!ResourceUtil.areEquals(string2, string3)) {
                return;
            }
        }
        switch (this.hFields) {
            case 0: {
                this.isApply = true;
                break;
            }
            case 1: {
                this.isApply = true;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                this.isApply = true;
                break;
            }
        }
        this.dispose();
    }

    private void initDialogValue(Calendar calendar, boolean bl, String string, int n) {
        if ((n == 17 || n == 19 || n == 5 || n == 8 || n == 10 || n == 3 || n == 18 || n == 20 || n == 13 || n == 9 || n == 11 || n == 7) && bl && (string.startsWith("00") && string.endsWith("00") && string.substring(3).startsWith("00") || string.startsWith("00") && string.endsWith("AM"))) {
            calendar.set(11, -24);
        }
        if (this.ht) {
            if (this.htt) {
                this.timeTextField.setText(InmCommonUtil.toTimeString_AM_PM(calendar, bl));
            } else {
                this.timeTextField.setText(InmCommonUtil.toTimeString(calendar, bl));
            }
        } else if (this.hhour && this.hminute) {
            if (this.htt) {
                if (this.hsecond) {
                    this.timeTextField.setText(InmCommonUtil.toTimeString_AM_PM(calendar, bl));
                } else {
                    String string2 = InmCommonUtil.toTimeString_AM_PM(calendar, bl);
                    this.timeTextField.setText(string2.substring(0, 5) + string2.substring(8));
                }
            } else {
                this.timeTextField.setText(InmCommonUtil.toHourMinString(calendar, bl));
            }
        }
        if (this.hy) {
            this.yearTextField.getDocument().removeDocumentListener(this.documentListener);
            this.yearTextField.setText(Integer.valueOf(calendar.get(1)).toString());
            this.yearTextField.getDocument().addDocumentListener(this.documentListener);
        }
        if (this.hm) {
            this.monthComboBox.setSelectedIndex(calendar.get(2));
        }
        if (this.hd) {
            this.fillDayTable();
        }
    }

    private void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.isApply = false;
        this.dispose();
    }

    private void monthComboBox_actionPerformed(ActionEvent actionEvent) {
        if (this.monthComboBox.getSelectedIndex() != -1) {
            this._calendar = this.adjustMonthDay(this._calendar, this.monthComboBox.getSelectedIndex());
            if (this.hd) {
                this.fillDayTable();
            }
        }
    }

    private void incYearButton_actionPerformed(ActionEvent actionEvent) {
        int n = this.yearTextField.getValue() + 1;
        if (n > this.yearTextField.getMax()) {
            n = this.yearTextField.getMin();
        }
        this.yearTextField.setText(Integer.valueOf(n).toString());
        this.yearTextField.requestFocus();
        this.yearTextField.selectAll();
        this.adjustYearMonthDay(this._calendar, n);
        if (this.hd) {
            this.fillDayTable();
        }
    }

    private void decYearButton_actionPerformed(ActionEvent actionEvent) {
        int n = this.yearTextField.getValue() - 1;
        if (n < this.yearTextField.getMin()) {
            n = this.yearTextField.getMax();
        }
        this.yearTextField.setText(Integer.valueOf(n).toString());
        this.yearTextField.requestFocus();
        this.yearTextField.selectAll();
        this.adjustYearMonthDay(this._calendar, n);
        if (this.hd) {
            this.fillDayTable();
        }
    }

    private void doAM_PMChanged() {
        String string = this.timeTextField.getText();
        String string2 = null;
        String string3 = null;
        if (this.hsecond) {
            string3 = string.substring(InmDateDocument.TIMESEPT[2] + 1).trim();
            string2 = this.timeTextField.getText().substring(0, InmDateDocument.TIMESEPT[2]);
        } else {
            string3 = string.substring(InmDateDocument.HMSEPT[1] + 1).trim();
            string2 = this.timeTextField.getText().substring(0, InmDateDocument.HMSEPT[1]);
        }
        string2 = InmDateDocument.time_AM_PM_symbols[0].equals(string3) ? new StringBuffer(string2).append(' ').append(InmDateDocument.time_AM_PM_symbols[1]).toString() : new StringBuffer(string2).append(' ').append(InmDateDocument.time_AM_PM_symbols[0]).toString();
        this.timeTextField.setText(string2);
    }

    private void fillDayTable() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n3 = this._calendar.getActualMaximum(5);
        Calendar calendar = (Calendar)this._calendar.clone();
        calendar.set(5, 1);
        n4 = calendar.get(7);
        calendar = null;
        n5 = this._calendar.getActualMaximum(4);
        while (this.dayTableModel.getRowCount() > 0) {
            this.dayTableModel.removeRow(0);
        }
        Vector<Object> vector = null;
        for (n2 = 0; n6 < n3 && n2 < n5; ++n2) {
            vector = new Vector<Object>(7, 1);
            if (n2 == 0) {
                for (n = 1; n < n4; ++n) {
                    vector.addElement("");
                }
            }
            int n7 = n = n2 == 0 ? n4 : 1;
            while (n <= 7 && n6 < n3) {
                vector.addElement(++n6);
                if (n6 == n3) {
                    while (n <= 7) {
                        vector.addElement("");
                        ++n;
                    }
                }
                ++n;
            }
            this.dayTableModel.addRow(vector);
        }
        n2 = this._calendar.get(4) - 1;
        n = this._calendar.get(7) - 1;
        this.chooseDayTable.setRowSelectionInterval(n2, n2);
        this.chooseDayTable.setColumnSelectionInterval(n, n);
    }

    private Calendar adjustMonthDay(Calendar calendar, int n) {
        calendar.set(2, n);
        if (calendar.get(2) != n) {
            calendar.set(5, 1);
            calendar.set(2, n);
            calendar.set(5, calendar.getActualMaximum(5));
        }
        return calendar;
    }

    private Calendar adjustYearMonthDay(Calendar calendar, int n) {
        int n2 = calendar.get(5);
        int n3 = calendar.get(2);
        calendar.set(1, n);
        if (calendar.get(5) != n2) {
            calendar.set(5, 1);
            calendar.set(2, n3);
            calendar.set(5, calendar.getActualMaximum(5));
        }
        return calendar;
    }

    private void getInputValue() throws Exception {
        String string;
        if (this.ht) {
            string = this.timeTextField.getText();
            String string2 = string.substring(0, 2).trim();
            String string3 = string.substring(3, 5).trim();
            String string4 = string.substring(6, 8).trim();
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            if (string2.length() == 0) {
                throw new Exception(res.getString("The_hour_field_is"));
            }
            n = new Integer(string2);
            if (string3.length() == 0) {
                throw new Exception(res.getString("The_minute_field_is"));
            }
            n2 = new Integer(string3);
            if (string4.length() == 0) {
                throw new Exception(res.getString("The_second_field_is"));
            }
            n3 = new Integer(string4);
            if (this.htt) {
                String string5 = string.substring(9, 11).trim();
                if (InmDateDocument.time_AM_PM_symbols[1].equals(string5)) {
                    if (n != 12) {
                        n += 12;
                    }
                } else if (n == 12) {
                    n = 0;
                }
            }
            this._calendar.set(11, n);
            this._calendar.set(12, n2);
            this._calendar.set(13, n3);
        } else if (this.hhour && this.hminute) {
            string = this.timeTextField.getText();
            String string6 = string.substring(0, 2).trim();
            String string7 = string.substring(3, 5).trim();
            int n = -1;
            int n4 = -1;
            if (string6.length() == 0) {
                throw new Exception(res.getString("The_hour_field_is"));
            }
            n = new Integer(string6);
            if (string7.length() == 0) {
                throw new Exception(res.getString("The_minute_field_is"));
            }
            n4 = new Integer(string7);
            if (this.htt) {
                String string8 = string.substring(6).trim();
                if (InmDateDocument.time_AM_PM_symbols[1].equals(string8)) {
                    if (n != 12) {
                        n += 12;
                    }
                } else if (n == 12) {
                    n = 0;
                }
            }
            this._calendar.set(11, n);
            this._calendar.set(12, n4);
        }
        if (this.hd) {
            string = this.chooseDayTable.getValueAt(this.chooseDayTable.getSelectedRow(), this.chooseDayTable.getSelectedColumn()).toString();
            if ("".equals(string)) {
                throw new Exception(res.getString("Time_selection_error"));
            }
            this._calendar.set(5, new Integer(string));
        }
    }

    final Calendar getCalendar() {
        return this._calendar;
    }

    final boolean isApplied() {
        return this.isApply;
    }

    public void setYearRange(int n, int n2) {
        if (this.yearTextField != null) {
            this.yearTextField.setRange(n, n2);
            this.minYear = n;
            this.maxYear = n2;
            this.yearTextField.setToolTipText("[" + n + ", " + n2 + ']');
            this.repaint();
        }
    }

    private void doTimeDirectionKey(boolean bl) {
        int n = this.timeTextField.getCaretPosition();
        int n2 = this.getTimeFieldChar(n);
        this.increase(n2, bl);
        this.setSelection(n);
    }

    private int getTimeFieldChar(int n) {
        int[] nArray = this.document.separator;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (n <= nArray[0]) {
                n2 = 0;
                break;
            }
            if (n > nArray[nArray.length - 1]) {
                n2 = nArray.length;
                break;
            }
            if (n > nArray[i] || n <= nArray[i - 1]) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private void increase(int n, boolean bl) {
        int[] nArray = this.document.separator;
        switch (n) {
            case 0: {
                this.doHourChanged(bl);
                break;
            }
            case 1: {
                this.doMinuteChanged(n, bl);
                break;
            }
            case 2: {
                if (this.htt && n == nArray.length) {
                    this.doAM_PMChanged();
                    break;
                }
                this.doSecondChanged(n, bl);
                break;
            }
            default: {
                this.doAM_PMChanged();
            }
        }
    }

    private void doHourChanged(boolean bl) {
        String string = "";
        String string2 = this.timeTextField.getText();
        int[] nArray = this.document.separator;
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        string = string2.substring(0, nArray[0]);
        n2 = this.htt ? 12 : 23;
        n3 = this.htt ? 1 : 0;
        n = Integer.parseInt(string);
        int n4 = n = bl ? n + 1 : n - 1;
        if (n > n2 && bl) {
            n = n3;
        } else if (!bl && n < n3) {
            n = n2;
        }
        String string3 = n < 10 ? "0" + n : String.valueOf(n);
        String string4 = string3 + string2.substring(nArray[0]);
        this.timeTextField.setText(string4);
    }

    private void doMinuteChanged(int n, boolean bl) {
        String string = "";
        String string2 = this.timeTextField.getText();
        int[] nArray = this.document.separator;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        string = n == nArray.length ? string2.substring(nArray[n - 1] + 1) : string2.substring(nArray[n - 1] + 1, nArray[n]);
        n3 = this._calendar.getActualMaximum(12);
        n2 = Integer.parseInt(string);
        int n5 = n2 = bl ? n2 + 1 : n2 - 1;
        if (n2 > n3 && bl) {
            n2 = n4;
        } else if (!bl && n2 < n4) {
            n2 = n3;
        }
        String string3 = n2 < 10 ? "0" + n2 : String.valueOf(n2);
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(string2.substring(0, nArray[n - 1] + 1));
        stringBuffer.append(string3);
        if (n != nArray.length) {
            stringBuffer.append(string2.substring(nArray[n]));
        }
        this.timeTextField.setText(stringBuffer.toString());
    }

    private void doSecondChanged(int n, boolean bl) {
        String string = null;
        String string2 = this.timeTextField.getText();
        int[] nArray = this.document.separator;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        string = n == nArray.length ? string2.substring(nArray[n - 1] + 1) : string2.substring(nArray[n - 1] + 1, nArray[n]);
        n3 = this._calendar.getActualMaximum(13);
        n2 = Integer.parseInt(string);
        int n5 = n2 = bl ? n2 + 1 : n2 - 1;
        if (n2 > n3 && bl) {
            n2 = n4;
        } else if (!bl && n2 < n4) {
            n2 = n3;
        }
        String string3 = n2 < 10 ? "0" + n2 : String.valueOf(n2);
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(string2.substring(0, nArray[n - 1] + 1));
        stringBuffer.append(string3);
        if (n != nArray.length) {
            stringBuffer.append(string2.substring(nArray[n - 1]));
        }
        this.timeTextField.setText(stringBuffer.toString());
    }

    private void setSelection(int n) {
        int[] nArray = this.document.separator;
        int n2 = 0;
        int n3 = this.timeTextField.getText().length();
        if (nArray.length > 0) {
            if (n <= nArray[0]) {
                n2 = 0;
                n3 = nArray[0];
            } else if (n > nArray[nArray.length - 1]) {
                if (nArray.length > 0) {
                    n2 = nArray[nArray.length - 1] + 1;
                }
                n3 = this.timeTextField.getText().length();
            } else {
                for (int i = 0; i < nArray.length; ++i) {
                    if (n > nArray[i]) continue;
                    n2 = nArray[i - 1] + 1;
                    n3 = nArray[i];
                    break;
                }
            }
        }
        this.timeTextField.setCaretPosition(this.timeTextField.getText().length());
        this.timeTextField.select(n2, n3);
    }

    private void doTimePressed(final boolean bl) {
        if (!this.timeTextField.isEnabled()) {
            return;
        }
        this.timeTextField.requestFocus();
        this.timer = new Timer();
        if (delayTime > 0) {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DateTimeChooserDlg.this.doTimeDirectionKey(bl);
                        }
                    });
                }
            };
            this.timer.schedule(timerTask, delayTime, (long)periodTime);
            this.doTimeDirectionKey(bl);
        }
    }

    private void doTimeReleased() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.mouseEvent != null) {
            this.mouseEvent = null;
        }
    }

    private class DayTable
    extends JTable {
        DayTable(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            if (keyEvent.getKeyCode() == 39 && bl) {
                this.focusNextCell();
                return true;
            }
            if (keyEvent.getKeyCode() == 37 && bl) {
                this.focusPreviousCell();
                return true;
            }
            if (keyEvent.getKeyCode() == 9 && !keyEvent.isShiftDown() && bl) {
                if (this.getSelectedColumn() == this.getColumnCount() - 1 && this.getSelectedRow() == this.getRowCount() - 1) {
                    DateTimeChooserDlg.this.confirmButton.requestFocus(true);
                } else {
                    this.focusNextCell();
                }
                return true;
            }
            if (keyEvent.getKeyCode() == 9 && keyEvent.isShiftDown() && bl) {
                int n2 = this.getSelectedRow();
                int n3 = this.getSelectedColumn();
                if (n3 == 0 && n2 == 0) {
                    DateTimeChooserDlg.this.timeTextField.requestFocusInWindow();
                } else {
                    this.focusPreviousCell();
                }
                return true;
            }
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        private void focusNextCell() {
            int n = this.getSelectedRow();
            int n2 = this.getSelectedColumn();
            if (n2 >= this.getColumnCount() - 1) {
                if (n == this.getRowCount() - 1) {
                    n = 0;
                    n2 = 0;
                } else {
                    ++n;
                }
                this.addRowSelectionInterval(n, n);
                this.addColumnSelectionInterval(0, 0);
            } else {
                this.addRowSelectionInterval(n, n);
                this.addColumnSelectionInterval(n2 + 1, n2 + 1);
            }
        }

        private void focusPreviousCell() {
            int n = this.getSelectedRow();
            int n2 = this.getSelectedColumn();
            if (n2 <= 0) {
                if (n == 0) {
                    n = this.getRowCount() - 1;
                    n2 = this.getColumnCount() - 1;
                } else {
                    --n;
                    n2 = this.getColumnCount() - 1;
                }
                this.addRowSelectionInterval(n, n);
                this.addColumnSelectionInterval(n2, n2);
            } else {
                this.addRowSelectionInterval(n, n);
                this.addColumnSelectionInterval(n2 - 1, n2 - 1);
            }
        }
    }
}

