/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap12.util;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.textfield.InputInvalidListener;
import com.swimap.iview.templates.textfield.TipComponent;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.zip.DataFormatException;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class InmLongTextField
extends JTextField {
    private static IviewLogger logger = IviewLogger.getLogger(InmLongTextField.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/imap12/util/Res");
    private boolean bAlarm = false;
    private static final int LIMIT = 20;
    private int nLimit = 20;
    private long min = 0L;
    private long max = Long.MAX_VALUE;
    private boolean isLocked = false;
    private boolean isDirectInsert = false;
    private boolean requestFocus = true;
    private TipComponent tip;
    private boolean tooltipEnabled = false;
    private boolean defaultEnabled = true;

    public void setFocusAfterError(boolean bl) {
        this.requestFocus = bl;
    }

    public InmLongTextField() {
        this(0L, Long.MAX_VALUE);
    }

    public InmLongTextField(long l) {
        this(l, Long.MAX_VALUE);
    }

    public InmLongTextField(long l, long l2) {
        if (l2 < l) {
            throw new IllegalArgumentException("maximum can not less than minimum");
        }
        LongDocument longDocument = new LongDocument(this);
        this.setDocument(longDocument);
        this.tip = new TipComponent();
        this.tip.setDisplayTime(2000);
        longDocument.addInputValidListener(new InvalidInputString());
        this.setName("InmLongTextField");
        this.min = l;
        this.max = l2;
        this.nLimit = this.min > 0L ? 19 : 20;
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public synchronized void focusLost(FocusEvent focusEvent) {
                block8: {
                    InmLongTextField.this.tip.dispose();
                    if (InmLongTextField.this.isLocked) {
                        return;
                    }
                    String string = InmLongTextField.this.getText();
                    try {
                        if (string.length() == 0) {
                            throw new DataFormatException();
                        }
                        long l = Long.parseLong(string);
                        if (l < InmLongTextField.this.min || l > InmLongTextField.this.max) {
                            throw new DataFormatException();
                        }
                    }
                    catch (Exception exception) {
                        InmLongTextField.this.isLocked = true;
                        if (InmLongTextField.this.bAlarm) {
                            String string2 = MessageFormat.format(res.getString("Can_not_less"), String.valueOf(InmLongTextField.this.min));
                            OptionPane.showErrorDialog(SwingUtilities.getWindowAncestor(InmLongTextField.this), string2);
                        }
                        InmLongTextField.this.isDirectInsert = true;
                        if (InmLongTextField.this.defaultEnabled) {
                            InmLongTextField.this.setText("" + InmLongTextField.this.min);
                        } else {
                            InmLongTextField.this.setText("");
                        }
                        InmLongTextField.this.isDirectInsert = false;
                        if (!InmLongTextField.this.requestFocus) break block8;
                        InmLongTextField.this.requestFocus();
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    long l = InmLongTextField.this.min;
                    try {
                        l = Long.parseLong(InmLongTextField.this.getText());
                    }
                    catch (Exception exception) {
                        logger.trace(exception.getMessage(), exception);
                    }
                    if (InmLongTextField.this.min >= l) {
                        InmLongTextField.this.setText(String.valueOf(InmLongTextField.this.min));
                    }
                    if (InmLongTextField.this.max < l) {
                        InmLongTextField.this.setText(String.valueOf(InmLongTextField.this.max));
                    }
                }
            }
        });
    }

    public void setTooltipEnabled(boolean bl) {
        this.tooltipEnabled = bl;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    private void showTipForNumber() {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getToolTipTextForNumber());
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getTooltipTextForRange() {
        return res.getString("InmLongTextField.tooltip.number");
    }

    public String getToolTipTextForNumber() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTooltipTextForRange());
        if (this.min == this.max) {
            stringBuffer.append("{");
            stringBuffer.append(this.min);
            stringBuffer.append("}");
        } else {
            stringBuffer.append("[");
            stringBuffer.append(this.min);
            stringBuffer.append(", ");
            stringBuffer.append(this.max);
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    private void showTipForChar(String string) {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getTooltipTextForChar(string));
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    private void showTipForString(String string) {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getTooltipTextForString(string));
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getTooltipTextForString(String string) {
        return MessageFormat.format(res.getString("InmLongTextField.tooltip.string"), string);
    }

    public String getTooltipTextForChar(String string) {
        return MessageFormat.format(res.getString("InmLongTextField.tooltip.char"), string);
    }

    private void showTipForMaxLength(Integer n) {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getTooltipTextForMaxLength(n));
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getTooltipTextForMaxLength(Integer n) {
        return MessageFormat.format(res.getString("InmLongTextField.tooltip.maxLength"), n);
    }

    public long getValue() {
        long l = 0L;
        String string = this.getText();
        if (string.length() == 0) {
            return this.min;
        }
        l = "-".equals(string) ? 0L : Long.parseLong(string);
        if (l < this.min || l > this.max) {
            l = this.min;
        }
        return l;
    }

    public void setRange(long l, long l2) {
        if (l2 < l) {
            throw new IllegalArgumentException("maximum can not less than minimum");
        }
        this.min = l;
        this.max = l2;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public void setAlarm(boolean bl) {
        this.bAlarm = bl;
    }

    public void setLocked(boolean bl) {
        this.isLocked = bl;
    }

    public void setDefaultEnabled(boolean bl) {
        this.defaultEnabled = bl;
    }

    public boolean isDefaultEnabled() {
        return this.defaultEnabled;
    }

    public boolean isEmpty() {
        return this.getText().length() == 0;
    }

    private class LongDocument
    extends PlainDocument {
        private JTextComponent textComponent;
        private int ct = 0;

        LongDocument(JTextComponent jTextComponent) {
            this.textComponent = jTextComponent;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            long l;
            if (InmLongTextField.this.isDirectInsert) {
                super.insertString(n, string, attributeSet);
                return;
            }
            String string2 = this.textComponent.getText();
            String string3 = "";
            if ("-".equals(string) && InmLongTextField.this.min >= 0L) {
                this.fireInValidString(3, "-");
                return;
            }
            if (string2.trim().length() + string.trim().length() > InmLongTextField.this.nLimit) {
                this.fireInValidString(0, InmLongTextField.this.nLimit);
                return;
            }
            try {
                if (n > 0 && n < string2.length()) {
                    string3 = string2.substring(0, n) + string + string2.substring(n, string2.length());
                    l = Long.parseLong(string3);
                    if (l >= 0L && l > InmLongTextField.this.max || l < 0L && l < InmLongTextField.this.min) {
                        this.fireInValidString(1, "");
                        return;
                    }
                } else if (n == 0) {
                    if ((!"-".equals(string) || this.textComponent.getText().length() != 0) && ((l = Long.parseLong(string3 = string + string2)) >= 0L && l > InmLongTextField.this.max || l < 0L && l < InmLongTextField.this.min)) {
                        this.fireInValidString(1, "");
                        return;
                    }
                } else {
                    string3 = string2 + string;
                    l = Long.parseLong(string3);
                    if (l >= 0L && l > InmLongTextField.this.max || l < 0L && l < InmLongTextField.this.min) {
                        this.fireInValidString(1, "");
                        return;
                    }
                }
            }
            catch (Exception exception) {
                int n2 = string3.length();
                boolean bl = true;
                while (n2 > 0) {
                    if (Character.isDigit(string3.charAt(--n2))) continue;
                    bl = n2 == 0 && string3.charAt(0) == '-';
                    break;
                }
                if (!bl) {
                    this.fireInValidString(2, string);
                    return;
                }
                this.fireInValidString(1, "");
                return;
            }
            if (string3.startsWith("00")) {
                this.fireInValidString(2, string);
                return;
            }
            super.insertString(n, string, attributeSet);
            l = 0L;
            l = "-".equals(string) && this.textComponent.getText().length() == 1 ? 0L : Long.parseLong(this.textComponent.getText());
            if (l > InmLongTextField.this.max && InmLongTextField.this.max > 0L) {
                super.remove(n, 1);
                this.fireInValidString(1, "");
                if (InmLongTextField.this.bAlarm && this.ct == 0) {
                    ++this.ct;
                    Toolkit.getDefaultToolkit().beep();
                    --this.ct;
                }
            }
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            String string = this.textComponent.getText();
            String string2 = string.substring(0, n) + string.substring(n + n2);
            if ("-".equals(string2) || string2.length() == 0) {
                super.remove(n, n2);
            }
            try {
                long l = Long.parseLong(string2);
                if (l <= InmLongTextField.this.max || l < 0L) {
                    super.remove(n, n2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.trace(numberFormatException.getMessage(), numberFormatException);
            }
        }

        public void addInputValidListener(InputInvalidListener inputInvalidListener) {
            this.listenerList.add(InputInvalidListener.class, inputInvalidListener);
        }

        public void removeInputValidListener(InputInvalidListener inputInvalidListener) {
            this.listenerList.remove(InputInvalidListener.class, inputInvalidListener);
        }

        private void fireInValidString(int n, Object object) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != InputInvalidListener.class) continue;
                ((InputInvalidListener)objectArray[i + 1]).inputInvalid(n, object);
            }
        }
    }

    private class InvalidInputString
    implements InputInvalidListener {
        private InvalidInputString() {
        }

        @Override
        public void inputInvalid(int n, Object object) {
            if (n == 1) {
                InmLongTextField.this.showTipForNumber();
            } else if (n == 0) {
                InmLongTextField.this.showTipForMaxLength((Integer)object);
            } else if (n == 2) {
                InmLongTextField.this.showTipForString((String)object);
            } else if (n == 3) {
                InmLongTextField.this.showTipForChar((String)object);
            }
        }
    }
}

