/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap12.util;

import com.swimap.imap12.util.InmLengthLimitDocument;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.textfield.InputInvalidListener;
import com.swimap.iview.templates.textfield.TipComponent;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class InmLengthLimitTextField
extends JTextField {
    private static IviewLogger logger = IviewLogger.getLogger(InmLengthLimitTextField.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/imap12/util/Res");
    private TipComponent tip = null;
    private boolean tooltipEnabled = false;

    public InmLengthLimitTextField(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("iMaxField CANNOT be equal or less than 0. =" + n);
        }
        InmLengthLimitDocument inmLengthLimitDocument = new InmLengthLimitDocument(n);
        this.setDocument(inmLengthLimitDocument);
        this.setName("InmLengthLimitTextField");
        this.tip = new TipComponent();
        this.tip.setDisplayTime(2000);
        inmLengthLimitDocument.addInputValidListener(new InvalidInputString());
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                InmLengthLimitTextField.this.tip.dispose();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
    }

    public void setJudgeLengthByGBK(boolean bl) {
        Document document = this.getDocument();
        if (document instanceof InmLengthLimitDocument) {
            ((InmLengthLimitDocument)document).setJudgeLengthByGBK(bl);
        }
    }

    public void setTooltipEnabled(boolean bl) {
        this.tooltipEnabled = bl;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    private void showTipForNumber() {
        if (this.isTooltipEnabled()) {
            Document document = this.getDocument();
            String string = "";
            if (document instanceof InmLengthLimitDocument) {
                string = ((InmLengthLimitDocument)document).getMaxLength();
            }
            this.tip.setText(this.getToolTipTextForNumber(string));
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getToolTipTextForNumber(String string) {
        return MessageFormat.format(res.getString("InmLengthLimitTextField.tooltip.number"), string);
    }

    public String getTooltipTextForString(String string) {
        return MessageFormat.format(res.getString("InmLengthLimitTextField.tooltip.string"), string);
    }

    public void setMaxLength(int n) {
        if (this.getDocument() instanceof InmLengthLimitDocument) {
            ((InmLengthLimitDocument)this.getDocument()).setMaxLength(n);
        }
        if (this.getText().length() > n) {
            try {
                this.setText(this.getText(0, n));
            }
            catch (BadLocationException badLocationException) {
                logger.trace(badLocationException.getMessage(), badLocationException);
            }
        }
    }

    public InmLengthLimitDocument getLimitDocument() {
        return (InmLengthLimitDocument)this.getDocument();
    }

    private void showTipForString(String string) {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getTooltipTextForString(string));
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    private class InvalidInputString
    implements InputInvalidListener {
        private InvalidInputString() {
        }

        @Override
        public void inputInvalid(int n, Object object) {
            if (0 == n) {
                InmLengthLimitTextField.this.showTipForNumber();
            } else if (2 == n) {
                InmLengthLimitTextField.this.showTipForString((String)object);
            }
        }
    }
}

