/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap12.util;

import com.swimap.imap12.util.CapsLockTipBubble;
import com.swimap.imap12.util.InmLengthLimitPasswordDocument;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.templates.textfield.InputInvalidListener;
import com.swimap.iview.templates.textfield.TipComponent;
import com.swimap.iview.templates.textfield.ValidCharDocument;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.jni.Windows;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.NavigationFilter;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;

public class InmLengthLimitPasswordField
extends JPasswordField
implements FocusListener {
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/imap12/util/Res");
    private static IviewLogger logger = IviewLogger.getLogger(InmLengthLimitPasswordField.class, "IVIEW");
    private TipComponent tip;
    private CapsLockTipBubble bubble = null;
    private boolean capsLockTipEnabled = false;
    private double relativeCapsTipPosition = 0.5;
    private boolean tooltipEnabled = false;
    private CapsLockListener capsLockListener = null;
    private static InmLengthLimitPasswordField activeField = null;
    private boolean textSelected = false;
    private Color selectionColor = null;
    private Color selectedTextColor = null;
    private LinkedList typeMarker = null;
    private String inValidChar = null;
    private String validChar = null;
    private int cursorPos = 0;
    private char[] cnts = null;
    private static final char CHAR_EQUIVALENT_2_BITS = '\u0080';
    private static KeyEventPostProcessor keyEventPostProcessor = new InmFieldPostProcessor();

    public InmLengthLimitPasswordField(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("iMaxField CANNOT be equal or less than 0. =" + n);
        }
        InmLengthLimitPasswordDocument inmLengthLimitPasswordDocument = new InmLengthLimitPasswordDocument(n);
        this.setDocument(inmLengthLimitPasswordDocument);
        this.resetCnts(n);
        this.selectionColor = this.getSelectionColor();
        this.selectedTextColor = this.getSelectedTextColor();
        this.setTextSelected(false);
        this.setNavigationFilter(new NavigationFilter(){

            @Override
            public void setDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
                Document document = InmLengthLimitPasswordField.this.getDocument();
                int n2 = n;
                if (!InmLengthLimitPasswordField.this.textSelected && null != document) {
                    n2 = document.getLength();
                }
                super.setDot(filterBypass, n2, bias);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                InmLengthLimitPasswordField.this.setCaretPosition(InmLengthLimitPasswordField.this.cursorPos);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                InmLengthLimitPasswordField.this.setTextSelected(false);
                InmLengthLimitPasswordField.this.setCaretPosition(InmLengthLimitPasswordField.this.cursorPos);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                InmLengthLimitPasswordField.this.setCaretPosition(InmLengthLimitPasswordField.this.cursorPos);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() % 2 == 0) {
                    InmLengthLimitPasswordField.this.setTextSelected(true);
                } else if (InmLengthLimitPasswordField.this.textSelected) {
                    InmLengthLimitPasswordField.this.setTextSelected(false);
                }
            }
        });
        this.setName("InmLengthLimitPasswordField");
        this.tip = new TipComponent();
        this.tip.setDisplayTime(2000);
        inmLengthLimitPasswordDocument.addInputValidListener(new InvalidInputString());
        this.addFocusListener(this);
    }

    @Override
    public void setDocument(Document document) {
        super.setDocument(document);
        if (null == document) {
            return;
        }
        if (document instanceof ValidCharDocument) {
            ValidCharDocument validCharDocument = (ValidCharDocument)document;
            this.resetCnts(validCharDocument.getMaxLength());
        } else if (document instanceof InmLengthLimitPasswordDocument) {
            InmLengthLimitPasswordDocument inmLengthLimitPasswordDocument = (InmLengthLimitPasswordDocument)document;
            this.resetCnts(inmLengthLimitPasswordDocument.getMaxLength());
        }
    }

    @Override
    public void setText(String string) {
        if (null == string || !this.isValidText(string.toCharArray())) {
            return;
        }
        this.clearCnts();
        super.setText("");
        if (0 < string.length()) {
            char[] cArray;
            for (char c : cArray = string.toCharArray()) {
                this.addText(c + "");
            }
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = '\u0000';
            }
        }
    }

    public void setText(char[] cArray) {
        if (null == cArray || !this.isValidText(cArray)) {
            return;
        }
        this.clearCnts();
        super.setText("");
        if (0 < cArray.length) {
            for (char c : cArray) {
                this.addText(c + "");
            }
        }
    }

    private void setPasteText(char[] cArray, int n) {
        this.clearCnts();
        super.setText("");
        if (null != cArray && 0 < cArray.length) {
            for (char c : cArray) {
                PlainDocument plainDocument;
                this.addText(c + "");
                Document document = this.getDocument();
                if (document instanceof ValidCharDocument) {
                    plainDocument = (ValidCharDocument)document;
                    if (cArray.length > ((ValidCharDocument)plainDocument).getMaxLength() && this.cursorPos == this.cnts.length) {
                        this.restoreTypedPass(n);
                        break;
                    }
                } else if (document instanceof InmLengthLimitPasswordDocument && cArray.length > ((InmLengthLimitPasswordDocument)(plainDocument = (InmLengthLimitPasswordDocument)document)).getMaxLength() && this.cursorPos == this.cnts.length) {
                    this.restoreTypedPass(n);
                    break;
                }
                if (super.getPassword().length != 0) continue;
                this.restoreTypedPass(n);
                break;
            }
        }
    }

    private void restoreTypedPass(int n) {
        while (this.cursorPos > n) {
            this.performBackspace();
        }
    }

    private boolean isValidText(char[] cArray) {
        int n;
        int n2;
        if (this.inValidChar != null && this.inValidChar.length() > 0) {
            n2 = cArray.length;
            for (n = 0; n < n2; ++n) {
                if (this.inValidChar.indexOf(String.valueOf(cArray[n])) < 0) continue;
                return false;
            }
        }
        if (this.validChar != null && this.validChar.length() > 0) {
            n2 = cArray.length;
            for (n = 0; n < n2; ++n) {
                if (this.validChar.indexOf(String.valueOf(cArray[n])) >= 0) continue;
                return false;
            }
        }
        n2 = cArray.length;
        for (n = 0; n < n2; ++n) {
            if ((cArray[n] & 0x80) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public char[] getPassword() {
        char[] cArray = new char[this.cursorPos];
        for (int i = 0; i < this.cursorPos; ++i) {
            cArray[i] = ~this.cnts[i];
        }
        return cArray;
    }

    private void performBackspace() {
        if (this.cursorPos > 0) {
            --this.cursorPos;
        }
        super.setText(this.getStars(this.cursorPos));
    }

    private String getStars(int n) {
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("x");
        }
        return stringBuilder.toString();
    }

    private void addText(String string) {
        if (!this.isValidText(string.toCharArray())) {
            super.setText(this.getStars(this.cursorPos));
            activeField.setCaretPosition(this.cursorPos);
            return;
        }
        String string2 = string;
        if (this.cursorPos + string2.length() <= this.cnts.length && string2.length() > 0) {
            char[] cArray = string2.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                this.cnts[this.cursorPos++] = ~cArray[i];
                cArray[i] = '\u0000';
            }
            super.setText(this.getStars(this.cursorPos));
        }
    }

    private void clearCnts() {
        if (null == this.cnts) {
            return;
        }
        for (int i = 0; i < this.cnts.length; ++i) {
            this.cnts[i] = '\u0000';
        }
        this.cursorPos = 0;
    }

    private void resetCnts(int n) {
        this.clearCnts();
        this.cnts = new char[n];
        this.cursorPos = 0;
        super.setText("");
    }

    private void setSelectionVisible(boolean bl) {
        if (bl) {
            this.setSelectionColor(this.selectionColor);
            this.setSelectedTextColor(this.selectedTextColor);
        } else {
            this.setSelectionColor(this.getBackground());
            this.setSelectedTextColor(this.getForeground());
        }
    }

    private void setTextSelected(boolean bl) {
        this.textSelected = bl;
        this.setSelectionVisible(bl);
        if (bl) {
            this.selectAll();
        }
    }

    public void setValidChars(String string) {
        this.validChar = string;
    }

    public void setInvalidChars(String string) {
        this.inValidChar = string;
    }

    public void setTooltipEnabled(boolean bl) {
        this.tooltipEnabled = bl;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    private void showTipForNumber(Integer n) {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getTooltipTextForExceededLength(n));
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getTooltipTextForExceededLength(Integer n) {
        return MessageFormat.format(res.getString("InmLengthLimitPasswordField.tooltip.number"), n);
    }

    public void setMaxLength(int n) {
        Document document = this.getDocument();
        if (document instanceof InmLengthLimitPasswordDocument) {
            ((InmLengthLimitPasswordDocument)document).setMaxLength(n);
        }
        if (document.getLength() > n) {
            try {
                document.remove(n, document.getLength() - n);
            }
            catch (BadLocationException badLocationException) {
                logger.trace(badLocationException.getMessage());
            }
        }
        this.resetCnts(n);
    }

    public InmLengthLimitPasswordDocument getLimitDocument() {
        return (InmLengthLimitPasswordDocument)this.getDocument();
    }

    private void showTipForChar() {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getTooltipTextForChar());
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getTooltipTextForChar() {
        return res.getString("InmLengthLimitPasswordField.tooltip.char");
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        activeField = this;
        this.setTextSelected(false);
        this.setCaretPosition(this.cursorPos);
        try {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (keyboardFocusManager instanceof DefaultKeyboardFocusManager) {
                DefaultKeyboardFocusManager defaultKeyboardFocusManager = (DefaultKeyboardFocusManager)keyboardFocusManager;
                this.typeMarker = (LinkedList)ReflectionUtilities.getFieldByObject(defaultKeyboardFocusManager, "typeAheadMarkers");
                if (null != this.typeMarker && this.typeMarker.size() != 0) {
                    LinkedList linkedList = new LinkedList();
                    logger.info("iview cleared the type marker class ");
                    ReflectionUtilities.setFieldByObject(defaultKeyboardFocusManager, "typeAheadMarkers", linkedList);
                }
            }
        }
        catch (Throwable throwable) {
            logger.error("Error in clearing marker list ");
        }
        if (this.capsLockTipEnabled) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!FrameworkCommandProcessor.isHookShutDownFlag()) {
                            Robot robot = new Robot();
                            robot.delay(100);
                            robot.keyPress(144);
                            robot.delay(100);
                            robot.keyRelease(144);
                            robot.keyPress(144);
                            robot.keyRelease(144);
                        }
                    }
                    catch (AWTException aWTException) {
                        logger.error("Toolkit not supporting this operation", aWTException);
                    }
                    boolean bl = InmLengthLimitPasswordField.this.isCapsLockOn();
                    if (bl) {
                        InmLengthLimitPasswordField.this.showBubble();
                    } else {
                        InmLengthLimitPasswordField.this.hideBubble();
                    }
                }
            });
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        activeField = null;
        this.tip.dispose();
        this.hideBubble();
        try {
            if (null != this.typeMarker && this.typeMarker.size() != 0) {
                DefaultKeyboardFocusManager defaultKeyboardFocusManager = (DefaultKeyboardFocusManager)KeyboardFocusManager.getCurrentKeyboardFocusManager();
                ReflectionUtilities.setFieldByObject(defaultKeyboardFocusManager, "typeAheadMarkers", this.typeMarker);
                logger.info("Iview reset the type marker list");
            }
        }
        catch (Throwable throwable) {
            logger.error("Error in reset the type marjer list");
        }
    }

    private void showBubble() {
        if (null != this.bubble) {
            this.bubble.showBubble(this);
        }
    }

    private void hideBubble() {
        if (null != this.bubble) {
            this.bubble.hideBubble();
        }
    }

    public void setCapsLockTipEnabled(boolean bl) {
        if (this.capsLockTipEnabled == bl) {
            return;
        }
        if (bl) {
            this.bubble = new CapsLockTipBubble();
            this.bubble.setBubbleText(res.getString("CapsLockTip"));
            this.bubble.setRelativeBubblePosition(this.relativeCapsTipPosition);
            this.capsLockListener = new CapsLockListener();
            this.getToolkit().addAWTEventListener(this.capsLockListener, 8L);
            this.getDocument().addDocumentListener(this.capsLockListener);
        } else {
            this.hideBubble();
            this.bubble = null;
            this.getToolkit().removeAWTEventListener(this.capsLockListener);
            this.getDocument().removeDocumentListener(this.capsLockListener);
            this.capsLockListener = null;
        }
        this.capsLockTipEnabled = bl;
    }

    public boolean isCapsLockTipEnabled() {
        return this.capsLockTipEnabled;
    }

    private boolean isCapsLockOn() {
        boolean bl = false;
        try {
            bl = this.getToolkit().getLockingKeyState(20);
        }
        catch (Exception exception) {
            logger.error("Toolkit not supporting this operation", exception);
        }
        return bl;
    }

    public void setRelativeCapsTipPosition(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The pos value should lie between 0 and 1");
        }
        this.relativeCapsTipPosition = d;
        if (null != this.bubble) {
            this.bubble.setRelativeBubblePosition(d);
        }
    }

    @Override
    public void removeNotify() {
        this.getToolkit().removeAWTEventListener(this.capsLockListener);
        this.capsLockListener = null;
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.capsLockTipEnabled && this.capsLockListener == null) {
            this.capsLockListener = new CapsLockListener();
            this.getToolkit().addAWTEventListener(this.capsLockListener, 8L);
        }
    }

    @Override
    public void paste() {
        try {
            int n = this.cursorPos;
            String string = System.getProperty("os.name");
            if (string.indexOf("Solaris") != -1) {
                int n2;
                char[] cArray;
                char[] cArray2 = this.getPassword();
                char[] cArray3 = this.getCmpletePasswd(cArray2, cArray = this.getPassWdFromClipBoard());
                if (!this.isValidText(cArray3)) {
                    return;
                }
                this.setPasteText(cArray3, n);
                for (n2 = 0; n2 < cArray2.length; ++n2) {
                    cArray2[n2] = '\u0000';
                }
                for (n2 = 0; n2 < cArray.length; ++n2) {
                    cArray[n2] = '\u0000';
                }
                for (n2 = 0; n2 < cArray3.length; ++n2) {
                    cArray3[n2] = '\u0000';
                }
            }
            if (string.indexOf("Windows") != -1) {
                this.getClipbord(n);
            }
            System.gc();
        }
        catch (Throwable throwable) {
            logger.error("Exception in paste operation", throwable);
        }
    }

    private char[] getCmpletePasswd(char[] cArray, char[] cArray2) {
        int n = cArray.length;
        if (n == 0) {
            return cArray2;
        }
        int n2 = cArray2.length;
        char[] cArray3 = new char[n + n2];
        System.arraycopy(cArray, 0, cArray3, 0, n);
        System.arraycopy(cArray2, 0, cArray3, n, n2);
        return cArray3;
    }

    private void getClipbord(int n) {
        try {
            Windows windows = new Windows();
            char[] cArray = windows.getSystemClipBoardChars();
            if (null != cArray) {
                int n2;
                char[] cArray2 = this.getPassword();
                char[] cArray3 = this.getCmpletePasswd(cArray2, cArray);
                if (!this.isValidText(cArray3)) {
                    return;
                }
                this.setPasteText(cArray3, n);
                for (n2 = 0; n2 < cArray2.length; ++n2) {
                    cArray2[n2] = '\u0000';
                }
                for (n2 = 0; n2 < cArray3.length; ++n2) {
                    cArray3[n2] = '\u0000';
                }
                for (n2 = 0; n2 < cArray.length; ++n2) {
                    cArray[n2] = '\u0000';
                }
            }
        }
        catch (Throwable throwable) {
            logger.error("Exception in paste operation", throwable);
        }
    }

    private char[] getPassWdFromClipBoard() {
        try {
            long[] lArray;
            Class<?> clazz = this.getClass().getClassLoader().loadClass("sun.awt.X11.XClipboard");
            Method method = clazz.getDeclaredMethod("getClipboardFormats", new Class[0]);
            method.setAccessible(true);
            long[] lArray2 = lArray = (long[])method.invoke((Object)Toolkit.getDefaultToolkit().getSystemClipboard(), new Object[0]);
            int n = lArray2.length;
            int n2 = 0;
            if (n2 < n) {
                long l = lArray2[n2];
                Method method2 = clazz.getDeclaredMethod("getClipboardData", Long.TYPE);
                method2.setAccessible(true);
                byte[] byArray = (byte[])method2.invoke((Object)Toolkit.getDefaultToolkit().getSystemClipboard(), l);
                char[] cArray = new String(byArray).toCharArray();
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = 0;
                }
                byArray = null;
                return cArray;
            }
        }
        catch (Exception exception) {
            logger.error("Exception in paste operation", exception);
        }
        catch (Throwable throwable) {
            logger.error("Error in paste operation", throwable);
        }
        return new char[10];
    }

    static {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(keyEventPostProcessor);
    }

    private static class InmFieldPostProcessor
    implements KeyEventPostProcessor {
        private InmFieldPostProcessor() {
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            String string = "";
            boolean bl = false;
            if (null != activeField) {
                try {
                    Document document = activeField.getDocument();
                    if (null != document && (keyEvent.getID() == 400 || keyEvent.getID() == 401)) {
                        String string2 = "";
                        try {
                            string2 = document.getText(0, document.getLength());
                        }
                        catch (BadLocationException badLocationException) {
                            string2 = "";
                        }
                        activeField.setCaretPosition(string2.length());
                        if (string2.length() != activeField.cursorPos) {
                            if (string2.length() > activeField.cursorPos) {
                                string = string2.substring(activeField.cursorPos);
                                activeField.addText(string);
                            } else if (string2.length() < activeField.cursorPos) {
                                bl = true;
                                activeField.performBackspace();
                            }
                        }
                    }
                    if (activeField.textSelected) {
                        if (bl || keyEvent.getKeyCode() == 127 || string.length() > 0) {
                            activeField.resetCnts(activeField.cnts.length);
                        }
                        if (string.length() > 0) {
                            activeField.setText(string);
                        }
                        if (keyEvent.getID() == 400) {
                            activeField.setTextSelected(false);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return false;
        }
    }

    private class CapsLockListener
    implements AWTEventListener,
    DocumentListener {
        private CapsLockListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            InmLengthLimitPasswordField.this.hideBubble();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            InmLengthLimitPasswordField.this.hideBubble();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            InmLengthLimitPasswordField.this.hideBubble();
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (!(aWTEvent instanceof KeyEvent)) {
                return;
            }
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            if (keyEvent.getKeyCode() == 20) {
                if (InmLengthLimitPasswordField.this.isCapsLockOn()) {
                    if (InmLengthLimitPasswordField.this.isFocusOwner() && !InmLengthLimitPasswordField.this.bubble.isBubbleComponentShowing()) {
                        InmLengthLimitPasswordField.this.showBubble();
                    }
                } else {
                    InmLengthLimitPasswordField.this.hideBubble();
                }
            }
        }
    }

    private class InvalidInputString
    implements InputInvalidListener {
        private InvalidInputString() {
        }

        @Override
        public void inputInvalid(int n, Object object) {
            if (n == 0) {
                InmLengthLimitPasswordField.this.showTipForNumber((Integer)object);
            } else if (n == 2) {
                InmLengthLimitPasswordField.this.showTipForChar();
            } else if (n == 3) {
                InmLengthLimitPasswordField.this.showTipForChar();
            }
        }
    }
}

