/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap12.util;

import com.swimap.imap12.util.InmLengthLimitPasswordField;
import com.swimap.iview.templates.textfield.InputInvalidListener;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class InmLengthLimitPasswordDocument
extends PlainDocument {
    private int iMaxLength = 10;
    private Vector vLimitStrings = null;
    private InmLengthLimitPasswordField inmLimitField = null;

    public InmLengthLimitPasswordDocument(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxLength CANNOT be equal or less than 0. =" + n);
        }
        this.iMaxLength = n;
    }

    public void setMaxLength(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxLength CANNOT be equal or less than 0. =" + n);
        }
        this.iMaxLength = n;
    }

    public int getMaxLength() {
        return this.iMaxLength;
    }

    @Override
    public synchronized void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        String string2 = this.getText(0, this.getLength());
        int n2 = string2.getBytes().length + string.getBytes().length;
        if (n2 > this.iMaxLength) {
            this.fireInValidString(0, this.iMaxLength);
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (!this.accept(string)) {
            this.fireInValidString(2, string);
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.insertString(n, string, attributeSet);
    }

    public synchronized boolean accept(String string) {
        if (null != this.vLimitStrings) {
            String string2 = null;
            for (Object e : this.vLimitStrings) {
                string2 = e.toString();
                if (null == string2 || "".equals(string) || 0 > string.indexOf(string2)) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized void addFilterStringList(Vector vector) {
        this.vLimitStrings = vector;
    }

    public synchronized void addFilterString(Object object) {
        if (null == object) {
            return;
        }
        if (object.toString().length() == 0) {
            return;
        }
        if (null == this.vLimitStrings) {
            this.vLimitStrings = new Vector();
        }
        this.vLimitStrings.add(object);
    }

    public synchronized void removeFilterString() {
        this.vLimitStrings = null;
    }

    public synchronized void removeFilterString(Object object) {
        if (null == object) {
            return;
        }
        if (null != this.vLimitStrings) {
            this.vLimitStrings.remove(object);
        }
    }

    public void addInputValidListener(InputInvalidListener inputInvalidListener) {
        this.listenerList.add(InputInvalidListener.class, inputInvalidListener);
    }

    public void removeInputValidListener(InputInvalidListener inputInvalidListener) {
        this.listenerList.remove(InputInvalidListener.class, inputInvalidListener);
    }

    private void fireInValidString(int n, Object object) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != InputInvalidListener.class) continue;
            ((InputInvalidListener)objectArray[i + 1]).inputInvalid(n, object);
        }
    }
}

