/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap12.util;

import com.swimap.iview.templates.textfield.InputInvalidListener;
import com.swimap.iview.util.CommonUtil;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class InmLengthLimitDocument
extends PlainDocument {
    private volatile int iMaxLength = 10;
    private Vector vLimitStrings = null;
    private boolean fileLengthByGBK = false;

    public InmLengthLimitDocument(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxLength CANNOT be equal or less than 0. =" + n);
        }
        this.iMaxLength = n;
    }

    public synchronized void setMaxLength(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxLength CANNOT be equal or less than 0. =" + n);
        }
        this.iMaxLength = n;
    }

    @Override
    public synchronized void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        String string2 = this.getText(0, this.getLength());
        int n2 = string2.getBytes().length + string.getBytes().length;
        if (this.fileLengthByGBK) {
            n2 = CommonUtil.getUTFStringGBKLength(string2) + CommonUtil.getUTFStringGBKLength(string);
        }
        if (n2 > this.iMaxLength) {
            int n3 = n2 - this.iMaxLength;
            string = string.substring(0, string.length() - n3);
            super.insertString(n, string, attributeSet);
            this.fireInValidString(0, this.iMaxLength);
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (!this.accept(string2 + string)) {
            Toolkit.getDefaultToolkit().beep();
            String string3 = this.getInvalidString(string2 + string);
            this.fireInValidString(2, string3);
            return;
        }
        super.insertString(n, string, attributeSet);
    }

    public synchronized boolean accept(String string) {
        if (null != this.vLimitStrings) {
            String string2 = null;
            for (Object e : this.vLimitStrings) {
                string2 = e.toString();
                if (null == string2 || "".equals(string) || 0 > string.indexOf(string2)) continue;
                return false;
            }
        }
        return true;
    }

    private String getInvalidString(String string) {
        if (null != this.vLimitStrings) {
            String string2 = null;
            for (Object e : this.vLimitStrings) {
                string2 = e.toString();
                if (null == string2 || "".equals(string) || 0 > string.indexOf(string2)) continue;
                return string2;
            }
        }
        return "";
    }

    public synchronized void addFilterStringList(Vector vector) {
        this.vLimitStrings = vector;
    }

    public synchronized void addFilterString(Object object) {
        if (null == object) {
            return;
        }
        if (object.toString().length() == 0) {
            return;
        }
        if (null == this.vLimitStrings) {
            this.vLimitStrings = new Vector();
        }
        this.vLimitStrings.add(object);
    }

    public synchronized void removeFilterString() {
        this.vLimitStrings = null;
    }

    public synchronized void removeFilterString(Object object) {
        if (null == object) {
            return;
        }
        if (null != this.vLimitStrings) {
            this.vLimitStrings.remove(object);
        }
    }

    public String getMaxLength() {
        return "" + this.iMaxLength;
    }

    public void addInputValidListener(InputInvalidListener inputInvalidListener) {
        this.listenerList.add(InputInvalidListener.class, inputInvalidListener);
    }

    public void removeInputValidListener(InputInvalidListener inputInvalidListener) {
        this.listenerList.remove(InputInvalidListener.class, inputInvalidListener);
    }

    private void fireInValidString(int n, Object object) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != InputInvalidListener.class) continue;
            ((InputInvalidListener)objectArray[i + 1]).inputInvalid(n, object);
        }
    }

    synchronized void setJudgeLengthByGBK(boolean bl) {
        this.fileLengthByGBK = bl;
    }
}

