/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap12.util;

import com.swimap.iview.templates.textfield.InputInvalidListener;
import com.swimap.iview.templates.textfield.TipComponent;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.adapter.ResourceMngHelper;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.zip.DataFormatException;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class InmIntegerTextField
extends JTextField {
    private static IviewLogger logger = IviewLogger.getLogger(InmIntegerTextField.class, "IVIEW");
    private static ResourceBundle res = ResourceMngHelper.getResourceBundleFromPropertyFile("mainfrm/imap12/util/Res");
    private boolean bAlarm = false;
    private static final int LIMIT = 11;
    private int nLimit = 11;
    private int min = 0;
    private int max = Integer.MAX_VALUE;
    private boolean isLocked = false;
    private boolean isDirectInsert = false;
    private boolean requestFocus = true;
    private boolean isModify = false;
    private boolean acceptNull = false;
    private boolean modifyText = true;
    private boolean regularValue = false;
    private TipComponent tip;
    private boolean tooltipEnabled = false;
    private boolean defaultEnabled = true;

    public InmIntegerTextField() {
        this(0, Integer.MAX_VALUE);
    }

    public InmIntegerTextField(int n) {
        this(n, Integer.MAX_VALUE);
    }

    public InmIntegerTextField(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("maximum can not less than minimum");
        }
        IntegerDocument integerDocument = new IntegerDocument(this);
        this.setDocument(integerDocument);
        this.setName("InmIntegerTextField");
        this.tip = new TipComponent();
        this.tip.setDisplayTime(2000);
        integerDocument.addInputValidListener(new InvalidInputString());
        this.min = n;
        this.max = n2;
        this.nLimit = this.min > 0 ? 10 : 11;
        this.addFocusListener(new FocusListener(){

            @Override
            public synchronized void focusLost(FocusEvent focusEvent) {
                if (InmIntegerTextField.this.modifyText) {
                    InmIntegerTextField.this.modifyText();
                }
                InmIntegerTextField.this.tip.dispose();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                InmIntegerTextField.this.isLocked = false;
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    int n = InmIntegerTextField.this.min;
                    try {
                        n = Integer.parseInt(InmIntegerTextField.this.getText());
                    }
                    catch (Exception exception) {
                        logger.trace(exception.getMessage(), exception);
                    }
                    if (InmIntegerTextField.this.min >= n) {
                        InmIntegerTextField.this.setText(String.valueOf(InmIntegerTextField.this.min));
                    }
                    if (InmIntegerTextField.this.max < n) {
                        InmIntegerTextField.this.setText(String.valueOf(InmIntegerTextField.this.max));
                    }
                }
            }
        });
    }

    public void setTooltipEnabled(boolean bl) {
        this.tooltipEnabled = bl;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    private void showTipForNumber() {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getToolTipTextForNumber());
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getTooltipTextForRange() {
        return res.getString("InmIntegerTextField.tooltip.number");
    }

    public String getToolTipTextForNumber() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTooltipTextForRange());
        if (this.min == this.max) {
            stringBuffer.append("{");
            stringBuffer.append(this.min);
            stringBuffer.append("}");
        } else {
            stringBuffer.append("[");
            stringBuffer.append(this.min);
            stringBuffer.append(", ");
            stringBuffer.append(this.max);
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    private void showTipForChar(String string) {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getTooltipTextForChar(string));
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getTooltipTextForChar(String string) {
        return MessageFormat.format(res.getString("InmIntegerTextField.tooltip.char"), string);
    }

    private void showTipForString(String string) {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getTooltipTextForString(string));
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getTooltipTextForString(String string) {
        return MessageFormat.format(res.getString("InmIntegerTextField.tooltip.string"), string);
    }

    public boolean getIsModify() {
        return this.isModify;
    }

    public void setIsModify(boolean bl) {
        this.isModify = bl;
    }

    public void setFocusAfterError(boolean bl) {
        this.requestFocus = bl;
    }

    public void removeInnerFocusListener() {
        this.modifyText = false;
    }

    public void modifyText() {
        block11: {
            if (this.isLocked) {
                return;
            }
            String string = this.getText();
            if (this.acceptNull && string.length() == 0) {
                return;
            }
            try {
                if (string.length() == 0) {
                    throw new DataFormatException();
                }
                int n = Integer.parseInt(string);
                if (n < this.min || n > this.max) {
                    throw new DataFormatException();
                }
                if (!String.valueOf(n).equals(string) && this.regularValue) {
                    this.setText(String.valueOf(n));
                    this.setIsModify(true);
                    if (this.requestFocus) {
                        this.requestFocusInWindow();
                    }
                }
            }
            catch (Exception exception) {
                this.isLocked = true;
                if (this.bAlarm) {
                    String string2 = MessageFormat.format(res.getString("Can_not_less"), String.valueOf(this.min));
                    OptionPane.showErrorDialog(SwingUtilities.getWindowAncestor(this), string2);
                }
                this.isDirectInsert = true;
                if (this.defaultEnabled) {
                    this.setText("" + this.min);
                } else {
                    this.setText("");
                }
                this.isDirectInsert = false;
                this.setIsModify(true);
                if (!this.requestFocus) break block11;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InmIntegerTextField.this.requestFocusInWindow();
                    }
                });
            }
        }
    }

    public int getValue() {
        int n = 0;
        String string = this.getText();
        if (string.length() == 0) {
            return this.min;
        }
        n = "-".equals(string) ? 0 : Integer.parseInt(string);
        if (n < this.min || n > this.max) {
            n = this.min;
        }
        return n;
    }

    public void setRange(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("maximum can not less than minimum");
        }
        this.min = n;
        this.max = n2;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public void setAlarm(boolean bl) {
        this.bAlarm = bl;
    }

    public void setAcceptNull(boolean bl) {
        this.acceptNull = bl;
    }

    @Override
    public void replaceSelection(String string) {
        if (!"-".equals(string)) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                IntegerDocument integerDocument = (IntegerDocument)this.getDocument();
                if (null != integerDocument) {
                    integerDocument.fireInValidString(2, string);
                }
                return;
            }
        }
        super.replaceSelection(string);
    }

    public void setDefaultEnabled(boolean bl) {
        this.defaultEnabled = bl;
    }

    public boolean isDefaultEnabled() {
        return this.defaultEnabled;
    }

    public boolean isEmpty() {
        return this.getText().length() == 0;
    }

    public void setRegularValue(boolean bl) {
        this.regularValue = bl;
    }

    private final class IntegerDocument
    extends PlainDocument {
        private JTextComponent textComponent;
        private int ct = 0;

        public IntegerDocument(JTextComponent jTextComponent) {
            this.textComponent = jTextComponent;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (InmIntegerTextField.this.isDirectInsert) {
                super.insertString(n, string, attributeSet);
                return;
            }
            String string2 = this.textComponent.getText();
            String string3 = "";
            if ("-".equals(string) && InmIntegerTextField.this.min >= 0) {
                this.fireInValidString(3, "-");
                return;
            }
            if (string2.trim().length() + string.trim().length() > InmIntegerTextField.this.nLimit) {
                this.fireInValidString(1, "");
                return;
            }
            int n2 = 0;
            try {
                if (n > 0 && n < string2.length()) {
                    string3 = string2.substring(0, n) + string + string2.substring(n, string2.length());
                    n2 = Integer.parseInt(string3);
                    if (n2 >= 0 && n2 > InmIntegerTextField.this.max || n2 < 0 && n2 < InmIntegerTextField.this.min) {
                        this.fireInValidString(1, "");
                        return;
                    }
                } else if (n == 0) {
                    if ((!"-".equals(string) || this.textComponent.getText().length() != 0) && ((n2 = Integer.parseInt(string3 = string + string2)) >= 0 && n2 > InmIntegerTextField.this.max || n2 < 0 && n2 < InmIntegerTextField.this.min)) {
                        this.fireInValidString(1, "");
                        return;
                    }
                } else {
                    string3 = string2 + string;
                    n2 = Integer.parseInt(string3);
                    if (n2 >= 0 && n2 > InmIntegerTextField.this.max || n2 < 0 && n2 < InmIntegerTextField.this.min) {
                        this.fireInValidString(1, "");
                        return;
                    }
                }
            }
            catch (Exception exception) {
                int n3 = string3.length();
                boolean bl = true;
                while (n3 > 0) {
                    if (Character.isDigit(string3.charAt(--n3))) continue;
                    bl = n3 == 0 && string3.charAt(0) == '-';
                    break;
                }
                if (!bl) {
                    this.fireInValidString(2, string);
                    return;
                }
                this.fireInValidString(1, "");
                return;
            }
            if (string3.startsWith("00")) {
                this.fireInValidString(2, string);
                return;
            }
            if (InmIntegerTextField.this.max <= 0 || n2 <= InmIntegerTextField.this.max) {
                super.insertString(n, string, attributeSet);
            }
            int n4 = 0;
            if ("-".equals(string) && this.textComponent.getText().length() == 1) {
                n4 = 0;
            } else {
                try {
                    n4 = Integer.parseInt(this.textComponent.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    int n5 = string3.length();
                    boolean bl = true;
                    while (n5 > 0) {
                        if (Character.isDigit(string3.charAt(--n5))) continue;
                        bl = n5 == 0 && string3.charAt(0) == '-';
                        break;
                    }
                    if (!bl) {
                        this.fireInValidString(2, string);
                    } else {
                        this.fireInValidString(1, "");
                    }
                    n4 = InmIntegerTextField.this.max;
                }
            }
            if (n4 > InmIntegerTextField.this.max && InmIntegerTextField.this.max > 0) {
                this.fireInValidString(1, "");
                super.remove(n, 1);
                if (InmIntegerTextField.this.bAlarm && this.ct == 0) {
                    ++this.ct;
                    Toolkit.getDefaultToolkit().beep();
                    --this.ct;
                }
            }
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            String string = this.textComponent.getText();
            String string2 = string.substring(0, n) + string.substring(n + n2);
            if ("-".equals(string2) || "".equals(string2)) {
                super.remove(n, n2);
                return;
            }
            try {
                int n3 = Integer.parseInt(string2);
                if (n3 <= InmIntegerTextField.this.max || n3 < 0) {
                    super.remove(n, n2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.trace(numberFormatException.getMessage(), numberFormatException);
            }
        }

        public void addInputValidListener(InputInvalidListener inputInvalidListener) {
            this.listenerList.add(InputInvalidListener.class, inputInvalidListener);
        }

        public void removeInputValidListener(InputInvalidListener inputInvalidListener) {
            this.listenerList.remove(InputInvalidListener.class, inputInvalidListener);
        }

        private void fireInValidString(int n, Object object) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != InputInvalidListener.class) continue;
                ((InputInvalidListener)objectArray[i + 1]).inputInvalid(n, object);
            }
        }
    }

    private class InvalidInputString
    implements InputInvalidListener {
        private InvalidInputString() {
        }

        @Override
        public void inputInvalid(int n, Object object) {
            if (n == 1) {
                InmIntegerTextField.this.showTipForNumber();
            } else if (n == 0) {
                logger.trace("Input is invalid. inValidType : " + n);
            } else if (n == 2) {
                InmIntegerTextField.this.showTipForString((String)object);
            } else if (n == 3) {
                InmIntegerTextField.this.showTipForChar((String)object);
            }
        }
    }
}

