/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap12.util;

import com.swimap.imap12.util.InmCellEditor;
import com.swimap.imap12.util.InmIntegerTextField;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class InmIntegerCellEditor
extends InmCellEditor
implements TableCellEditor {
    private static IviewLogger logger = IviewLogger.getLogger(InmIntegerCellEditor.class, "IVIEW");
    private InmIntegerTextField integerText;
    protected int clickCountToStart = 2;

    public InmIntegerCellEditor(int n, int n2) {
        this.integerText = new InmIntegerTextField(n, n2);
        this.integerText.setName("InmIntegerCellEditor_integerText");
    }

    public InmIntegerCellEditor(int n) {
        this.integerText = new InmIntegerTextField(n);
        this.integerText.setName("InmIntegerCellEditor_integerText");
    }

    public InmIntegerCellEditor() {
        this.integerText = new InmIntegerTextField();
        this.integerText.setName("InmIntegerCellEditor_integerText");
    }

    public InmIntegerCellEditor(InmIntegerTextField inmIntegerTextField) {
        if (inmIntegerTextField == null) {
            throw new IllegalArgumentException("iTextField can not be null");
        }
        this.integerText = inmIntegerTextField;
        this.integerText.setName("InmIntegerCellEditor_integerText");
    }

    public void setRange(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("min > max");
        }
        this.integerText.setRange(n, n2);
        if (this.integerText.getText().length() > 0) {
            try {
                int n3 = Integer.parseInt(this.integerText.getText());
                if (n3 < n) {
                    this.integerText.setText(Integer.toString(n));
                } else if (n3 > n2) {
                    this.integerText.setText(Integer.toString(n2));
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.trace(numberFormatException.getMessage(), numberFormatException);
            }
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object != null) {
            Integer n3 = null;
            n3 = Integer.valueOf(object.toString());
            this.integerText.setText(n3.toString());
        } else {
            this.integerText.setText("");
        }
        return this.integerText;
    }

    @Override
    public Object getCellEditorValue() {
        return this.integerText.getValue();
    }

    public void setCellEditorValue(Object object) {
        if (object != null) {
            Integer n = Integer.valueOf(object.toString());
            this.integerText.setText(n.toString());
        } else {
            this.integerText.setText("");
        }
    }
}

