/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap12.util;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.textfield.InputInvalidListener;
import com.swimap.iview.templates.textfield.TipComponent;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.zip.DataFormatException;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class InmDoubleTextField
extends JTextField {
    private static IviewLogger logger = IviewLogger.getLogger(InmDoubleTextField.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/imap12/util/Res");
    public static final int SAVE_FRONT = 0;
    protected boolean bAlarm = true;
    protected boolean isLocked = true;
    protected boolean isDirectInsert = false;
    protected double min = Double.MIN_VALUE;
    protected double max = Double.MAX_VALUE;
    protected String prevStr = null;
    protected int m_nFraction = 17;
    private static final int FRACTION = 17;
    private TipComponent tip = null;
    private boolean tooltipEnabled = false;

    protected void setFractionLimit(int n) {
        if (n < 1) {
            n = 1;
        }
        this.m_nFraction = n;
        this.min = Double.valueOf(this.getStringFromDouble(this.min));
        this.max = Double.valueOf(this.getStringFromDouble(this.max));
    }

    public InmDoubleTextField(double d, double d2) {
        this(d, d2, 17);
    }

    public InmDoubleTextField(double d, double d2, int n) {
        if (d2 < d) {
            throw new IllegalArgumentException("maximum can not less than minimum");
        }
        FloatDocument floatDocument = new FloatDocument(this);
        this.setDocument(floatDocument);
        this.setName("InmDoubleTextField");
        this.min = d;
        this.max = d2;
        this.tip = new TipComponent();
        this.tip.setDisplayTime(2000);
        floatDocument.addInputValidListener(new InvalidInputString());
        this.setFractionLimit(n);
        this.addFocusListener(new FocusListener(){

            @Override
            public synchronized void focusLost(FocusEvent focusEvent) {
                InmDoubleTextField.this.tip.dispose();
                if (InmDoubleTextField.this.isLocked) {
                    return;
                }
                String string = InmDoubleTextField.this.getText();
                try {
                    if (string.length() == 0) {
                        throw new DataFormatException();
                    }
                    double d = Double.parseDouble(string);
                    if (d < InmDoubleTextField.this.min || d > InmDoubleTextField.this.max) {
                        throw new DataFormatException();
                    }
                }
                catch (Exception exception) {
                    InmDoubleTextField.this.isLocked = true;
                    Toolkit.getDefaultToolkit().beep();
                    InmDoubleTextField.this.isDirectInsert = true;
                    InmDoubleTextField.this.setText(new Double(InmDoubleTextField.this.getMin()).toString());
                    InmDoubleTextField.this.isDirectInsert = false;
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                InmDoubleTextField.this.isLocked = false;
            }
        });
    }

    public void setTooltipEnabled(boolean bl) {
        this.tooltipEnabled = bl;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    private void showTipForNumber() {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getToolTipTextForNumber());
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getTooltipTextForRange() {
        return res.getString("InmDoubleTextField.tooltip.number");
    }

    public String getToolTipTextForNumber() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTooltipTextForRange());
        if (Double.doubleToLongBits(this.min) == Double.doubleToLongBits(this.max)) {
            stringBuffer.append("{");
            stringBuffer.append(this.min);
            stringBuffer.append("}");
        } else {
            stringBuffer.append("[");
            stringBuffer.append(this.min);
            stringBuffer.append(", ");
            stringBuffer.append(this.max);
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    private void showTipForChar(String string) {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getTooltipTextForChar(string));
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getTooltipTextForChar(String string) {
        return MessageFormat.format(res.getString("InmDoubleTextField.tooltip.char"), string);
    }

    private void showTipForFraction(Integer n) {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getTooltipTextForFraction(n));
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getTooltipTextForString(String string) {
        return MessageFormat.format(res.getString("InmDoubleTextField.tooltip.string"), string);
    }

    private void showTipForString(String string) {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getTooltipTextForString(string));
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getTooltipTextForFraction(Integer n) {
        return MessageFormat.format(res.getString("InmDoubleTextField.tooltip.exceedFraction"), n);
    }

    @Override
    public void setText(String string) {
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = this.getMin();
        }
        super.setText(this.getStringFromDouble(d));
    }

    public InmDoubleTextField() {
        this(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public InmDoubleTextField(double d) {
        this(d, Double.MAX_VALUE);
    }

    public double getValue() {
        double d = 0.0;
        String string = this.getText();
        if (string.length() == 0) {
            return this.min;
        }
        char c = string.charAt(string.length() - 1);
        if ("+".equals(string) || "-".equals(string)) {
            d = 0.0;
        }
        if ((d = c == 'e' || c == 'E' || c == '+' || c == '-' ? Double.parseDouble(this.getText() + '0') : Double.parseDouble(this.getText())) < this.min || d > this.max) {
            d = this.min;
        }
        return d;
    }

    public void setRange(double d, double d2) {
        if (d2 < d) {
            throw new IllegalArgumentException("maximum can not less than minimum");
        }
        this.min = Double.valueOf(this.getStringFromDouble(d));
        this.max = Double.valueOf(this.getStringFromDouble(d2));
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    private String getStringFromDouble(double d) {
        String string = new Double(d).toString();
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        decimalFormat.setMaximumFractionDigits(this.m_nFraction);
        if (this.getStringFraction(string) > this.m_nFraction) {
            String string2 = string;
            int n = string.indexOf(".");
            string2 = string.substring(0, n + this.m_nFraction + 1);
            int n2 = Math.max(string.indexOf("e"), string.indexOf("E"));
            if (n2 >= 0) {
                string2 = new StringBuffer(string2).append(string.substring(n2, string.length())).toString();
            }
            return string2;
        }
        return string;
    }

    private int getStringFraction(String string) {
        int n = 0;
        int n2 = 0;
        n2 = string.indexOf(".");
        if (n2 < 0) {
            return -1;
        }
        n = Math.max(string.indexOf("E"), string.indexOf("e"));
        if (n < 0) {
            n = string.length();
        }
        return n - n2 - 1;
    }

    public void setAlarm(boolean bl) {
        this.bAlarm = bl;
    }

    public int getNumberLength(String string) {
        int n = Math.max(string.indexOf("e"), string.indexOf("E"));
        if (n < 0) {
            n = string.length();
        }
        if (string.indexOf(".") > 0) {
            --n;
        }
        return n;
    }

    private final class FloatDocument
    extends PlainDocument {
        private JTextComponent textComponent;
        private int ct = 0;

        FloatDocument(JTextComponent jTextComponent) {
            this.textComponent = jTextComponent;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (InmDoubleTextField.this.isDirectInsert) {
                super.insertString(n, string, attributeSet);
                return;
            }
            InmDoubleTextField.this.prevStr = this.textComponent.getText();
            String string2 = "";
            double d = 0.0;
            try {
                if (n > 0 && n < InmDoubleTextField.this.prevStr.length()) {
                    string2 = InmDoubleTextField.this.prevStr.substring(0, n);
                    d = Double.parseDouble(string2 + string + InmDoubleTextField.this.prevStr.substring(n, InmDoubleTextField.this.prevStr.length()));
                } else if (n == InmDoubleTextField.this.prevStr.length()) {
                    if ("e".equalsIgnoreCase(string) || "+".equals(string) || "-".equals(string)) {
                        string2 = InmDoubleTextField.this.prevStr + string + '0';
                        d = Double.parseDouble(string2);
                    } else {
                        string2 = InmDoubleTextField.this.prevStr + string;
                        d = Double.parseDouble(string2);
                    }
                } else {
                    string2 = string + InmDoubleTextField.this.prevStr;
                    d = Double.parseDouble(string2);
                }
                if ((d >= 0.0 && d > InmDoubleTextField.this.max || d < 0.0 && d < InmDoubleTextField.this.min) && !"-".equals(string)) {
                    this.fireInValidString(1, "");
                    return;
                }
            }
            catch (Exception exception) {
                this.fireInValidString(3, string);
                return;
            }
            if (InmDoubleTextField.this.getStringFraction(string2) > InmDoubleTextField.this.m_nFraction) {
                this.fireInValidString(4, InmDoubleTextField.this.m_nFraction);
                return;
            }
            if (string2.startsWith("00")) {
                this.fireInValidString(2, string);
                return;
            }
            if (string2.startsWith("-") && InmDoubleTextField.this.getMin() >= 0.0) {
                this.fireInValidString(3, "-");
                return;
            }
            super.insertString(n, string, attributeSet);
            double d2 = 0.0;
            try {
                d2 = ("e".equalsIgnoreCase(string) || "+".equals(string) || "-".equals(string)) && n == InmDoubleTextField.this.prevStr.length() ? Double.parseDouble(this.textComponent.getText() + '0') : Double.parseDouble(this.textComponent.getText());
            }
            catch (Exception exception) {
                this.fireInValidString(2, string);
                logger.trace(exception.getMessage(), exception);
                d2 = InmDoubleTextField.this.min;
                return;
            }
            if (d2 > InmDoubleTextField.this.max && InmDoubleTextField.this.max > 0.0) {
                super.remove(n, 1);
                this.fireInValidString(1, "");
                if (InmDoubleTextField.this.bAlarm && this.ct == 0) {
                    ++this.ct;
                    Toolkit.getDefaultToolkit().beep();
                    --this.ct;
                }
            }
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            String string = this.textComponent.getText();
            String string2 = string.substring(0, n) + string.substring(n + n2);
            if ("-".equals(string2) || "".equals(string2)) {
                super.remove(n, n2);
            }
            try {
                double d = Double.parseDouble(string2);
                if (d <= InmDoubleTextField.this.max || d < 0.0) {
                    super.remove(n, n2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.trace(numberFormatException.getMessage(), numberFormatException);
            }
        }

        public void addInputValidListener(InputInvalidListener inputInvalidListener) {
            this.listenerList.add(InputInvalidListener.class, inputInvalidListener);
        }

        public void removeInputValidListener(InputInvalidListener inputInvalidListener) {
            this.listenerList.remove(InputInvalidListener.class, inputInvalidListener);
        }

        private void fireInValidString(int n, Object object) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != InputInvalidListener.class) continue;
                ((InputInvalidListener)objectArray[i + 1]).inputInvalid(n, object);
            }
        }
    }

    private class InvalidInputString
    implements InputInvalidListener {
        private InvalidInputString() {
        }

        @Override
        public void inputInvalid(int n, Object object) {
            if (n == 1) {
                InmDoubleTextField.this.showTipForNumber();
            } else if (n == 4) {
                InmDoubleTextField.this.showTipForFraction((Integer)object);
            } else if (n == 0) {
                logger.trace("invalid type is " + n);
            } else if (n == 2) {
                InmDoubleTextField.this.showTipForString((String)object);
            } else if (n == 3) {
                InmDoubleTextField.this.showTipForChar((String)object);
            }
        }
    }
}

