/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap12.util;

import com.swimap.imap12.util.InmCellEditor;
import com.swimap.imap12.util.InmDoubleTextField;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class InmDoubleCellEditor
extends InmCellEditor
implements TableCellEditor {
    private static IviewLogger logger = IviewLogger.getLogger(InmDoubleCellEditor.class, "IVIEW");
    private InmDoubleTextField doubleText;

    public InmDoubleCellEditor() {
        this.doubleText = new InmDoubleTextField();
        this.doubleText.setName("InmDoubleCellEditor_doubleText");
    }

    public void setRange(double d, double d2) {
        if (d > d2) {
            throw new IllegalArgumentException("min > max");
        }
        this.doubleText.setRange(d, d2);
        if (this.doubleText.getText().length() > 0) {
            try {
                double d3 = Double.parseDouble(this.doubleText.getText());
                if (d3 < d) {
                    this.doubleText.setText(Double.toString(d));
                } else if (d3 > d2) {
                    this.doubleText.setText(Double.toString(d2));
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.trace(numberFormatException.getMessage(), numberFormatException);
            }
        }
    }

    public InmDoubleCellEditor(double d, double d2, int n) {
        this.doubleText = new InmDoubleTextField(d, d2, n);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object != null) {
            this.doubleText.setText(object.toString());
        } else {
            this.doubleText.setText(null);
        }
        return this.doubleText;
    }

    @Override
    public Object getCellEditorValue() {
        Double d = new Double(this.doubleText.getValue());
        return d;
    }

    public void setCellEditorValue(Object object) {
        if (object != null) {
            this.doubleText.setText(object.toString());
        } else {
            this.doubleText.setText(null);
        }
    }
}

