/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap12.util;

import com.swimap.iview.templates.bubble.BubbleComponent;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class CapsLockTipBubble
extends BubbleComponent {
    protected static final int DEFAULT_HIDE_TIME = 4;
    private static final int MILLI_TO_SEC = 1000;
    protected static final int ARROW_FIRST_X = 20;
    protected static final int ARROW_SECOND_X = 35;
    protected static final double DEFAULT_REL_POS = 0.5;
    protected static final int MIN_GAP = 0;
    private HideAction hideAction = new HideAction();
    private int hideTime = 4000;
    private Timer hideTimer = new Timer(this.hideTime, this.hideAction);
    protected double relativeBubblePosition = 0.5;

    CapsLockTipBubble() {
        this.setName("CapsLock_Tip");
        this.label.setVisible(false);
        this.addMouseListener(this.hideAction);
        this.hideTimer.setRepeats(false);
        this.textArea.addMouseListener(this.hideAction);
    }

    @Override
    protected void reShape() {
        this.width = this.getPreferredSize().width - 1;
        this.height = this.getPreferredSize().height - 1;
        this.initPolygonPoints();
        this.shape = new Polygon(this.xpoints, this.ypoints, 11);
        if (5 == this.position) {
            this.convertShape(5, this.width, this.height);
        }
    }

    protected void initPolygonPoints() {
        this.xpoints[0] = 5;
        this.xpoints[1] = 0;
        this.xpoints[2] = 0;
        this.xpoints[3] = 5;
        this.xpoints[4] = 20;
        this.xpoints[5] = 20;
        this.xpoints[6] = 35;
        this.xpoints[7] = this.width - 1 - 5;
        this.xpoints[8] = this.width - 1;
        this.xpoints[9] = this.width - 1;
        this.xpoints[10] = this.width - 1 - 5;
        this.ypoints[0] = 0;
        this.ypoints[1] = 5;
        this.ypoints[2] = this.height - 19 - 5;
        this.ypoints[3] = this.height - 19;
        this.ypoints[4] = this.height - 19;
        this.ypoints[5] = this.height - 1;
        this.ypoints[6] = this.height - 19;
        this.ypoints[7] = this.height - 19;
        this.ypoints[8] = this.height - 19 - 5;
        this.ypoints[9] = 5;
        this.ypoints[10] = 0;
    }

    @Override
    protected JLayeredPane updateBounds() {
        JRootPane jRootPane = SwingUtilities.getRootPane(this.invoker);
        if (jRootPane == null) {
            return null;
        }
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        Point point = this.invoker.getLocation();
        point = SwingUtilities.convertPoint(this.invoker.getParent(), point, jLayeredPane);
        int n = this.getPreferredSize().width;
        int n2 = this.getPreferredSize().height;
        if (point.y - n2 + 8 < 0) {
            this.position = 5;
            this.convertShape(5, n, n2);
        } else {
            this.position = 1;
        }
        if (this.position == 1) {
            this.textArea.setLocation(this.insets.left, this.insets.top);
            int n3 = point.x + (int)((double)this.invoker.getWidth() * this.relativeBubblePosition) - 20;
            if (n3 + n > jLayeredPane.getWidth()) {
                n3 = jLayeredPane.getWidth() - n - 0;
            }
            if (n3 + 20 < point.x) {
                n3 = point.x - 20;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 + 20 > point.x + this.invoker.getWidth()) {
                n3 = point.x + this.invoker.getWidth() - 20;
            }
            this.setBounds(n3, point.y - n2 + 8, n, n2);
        } else if (this.position == 5) {
            this.textArea.setLocation(this.insets.left, this.insets.top + 19);
            int n4 = point.x - n + (int)((double)this.invoker.getWidth() * this.relativeBubblePosition) + 20;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 + n - 20 > point.x + this.invoker.getWidth()) {
                n4 = point.x + this.invoker.getWidth() - n + 20;
            }
            this.setBounds(n4, point.y + this.invoker.getHeight() - 8, n, n2);
        }
        this.reShape();
        return jLayeredPane;
    }

    public void setHideTime(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The seconds value should be greater than 0");
        }
        this.hideTime = n * 1000;
    }

    public void setRelativeBubblePosition(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The pos value should lie between 0 and 1");
        }
        this.relativeBubblePosition = d;
    }

    public void hideBubble() {
        this.setVisible(false);
        this.hideTimer.stop();
    }

    public void showBubble(JComponent jComponent) {
        super.showBubble(jComponent);
        this.hideTimer.stop();
        this.hideTimer.setInitialDelay(this.hideTime);
        this.hideTimer.start();
    }

    private void convertShape(int n, int n2, int n3) {
        if (n == 5) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate((double)n2 / 2.0, (double)n3 / 2.0);
            affineTransform.rotate(Math.toRadians(180.0));
            affineTransform.translate((double)(-n2) / 2.0, (double)(-n3) / 2.0);
            this.shape = affineTransform.createTransformedShape(this.shape);
        }
    }

    private class HideAction
    extends MouseAdapter
    implements ActionListener {
        private HideAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (CapsLockTipBubble.this.isBubbleComponentShowing()) {
                CapsLockTipBubble.this.hideBubble();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (CapsLockTipBubble.this.isBubbleComponentShowing()) {
                CapsLockTipBubble.this.hideBubble();
            }
        }
    }
}

