/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate15;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextTool {
    private static Log log = LogFactory.getLog(TextTool.class);

    public static void replaceLine(String fileName, String tagStr, String lineValue) {
        String datastr = TextTool.getFileContents(fileName);
        if (null != datastr && null != tagStr) {
            String resultstr = TextTool.parseStr(datastr, tagStr, lineValue);
            boolean result = TextTool.writeFile(fileName, resultstr);
            log.info((Object)("TextTool | replaceLine | writeFile() result:" + result));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContents(String fileName) {
        InputStreamReader in = null;
        try {
            File file = new File(fileName);
            int size = (int)file.length();
            int chars_read = 0;
            in = new FileReader(file);
            char[] data = new char[size];
            while (in.ready()) {
                chars_read += in.read(data, chars_read, size - chars_read);
            }
            String datastr = new String(data);
            datastr = datastr.substring(0, datastr.length() - 1);
            StringBuffer datastruffer = new StringBuffer(datastr);
            if ('\n' != datastr.charAt(datastr.length() - 1)) {
                datastruffer.append('\n');
            }
            String string = datastruffer.toString();
            return string;
        }
        catch (IOException e) {
            log.info((Object)("Error opening " + fileName));
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.info((Object)("Error opening " + fileName));
            }
        }
        return null;
    }

    private static String parseStr(String datastr, String tagstr, String lineValue) {
        int startindex = datastr.indexOf(tagstr);
        if (startindex < 0) {
            return datastr;
        }
        int endindex = 0;
        int datastrLength = datastr.length();
        for (int i = startindex + tagstr.length(); i < datastrLength; ++i) {
            if ('\n' != datastr.charAt(i)) continue;
            endindex = i;
            break;
        }
        if (startindex < 0) {
            log.info((Object)("cannot find this tag:" + tagstr));
            startindex = 0;
            endindex = 0;
        }
        String prefixLines = datastr.substring(0, startindex);
        String postLines = datastr.substring(endindex, datastr.length());
        return prefixLines + lineValue + postLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeFile(String currFileName, String strline) {
        OutputStreamWriter out = null;
        try {
            File file = new File(currFileName);
            out = new FileWriter(file);
            out.write(strline);
            out.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.info((Object)("Error saving " + currFileName));
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.info((Object)("Error saving " + currFileName));
            }
        }
        return false;
    }

    public static String delSpace(String str) {
        int l = str.length();
        StringBuffer tmp = new StringBuffer("");
        int preindex = -1;
        int index = 0;
        while (index < l && (index = str.indexOf(32, index)) != -1) {
            tmp.append(str.substring(preindex + 1, index));
            preindex = index++;
        }
        return tmp + str.substring(preindex + 1, l);
    }
}

