/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.ssl.util;

import com.swimap.imap.ssl.util.MaterialFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.BASE64Encoder;

public class Util {
    private static Log log = LogFactory.getLog(Util.class);
    private static MaterialFactory materialFactory = new MaterialFactory();
    private static BASE64Encoder encoder = new BASE64Encoder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String source, String destination) throws IOException {
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        byte[] content = null;
        try {
            inStream = new FileInputStream(source);
            int aval = inStream.available();
            content = new byte[aval];
            inStream.read(content);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error((Object)e.toString(), (Throwable)e);
                }
            }
        }
        try {
            if (content != null) {
                outStream = new FileOutputStream(destination);
                outStream.write(content);
                outStream.flush();
            }
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    log.error((Object)e.toString(), (Throwable)e);
                }
            }
        }
        return true;
    }

    public static boolean hasContained(Certificate[] exists, Certificate toBeAdded) {
        int len = exists.length;
        for (int i = 0; i < len; ++i) {
            if (!exists[i].equals(toBeAdded)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasContained(CRL[] exists, CRL toBeAdded) {
        int len = exists.length;
        for (int i = 0; i < len; ++i) {
            if (!exists[i].equals(toBeAdded)) continue;
            return true;
        }
        return false;
    }

    public static X509Certificate[] loadCerts(String certFile) throws CertificateException, FileNotFoundException {
        Certificate[] certs = materialFactory.loadCerts(certFile);
        int len = certs.length;
        ArrayList<Certificate> x509_certs = new ArrayList<Certificate>(len);
        for (int i = 0; i < len; ++i) {
            if (!(certs[i] instanceof X509Certificate)) continue;
            x509_certs.add(certs[i]);
        }
        return x509_certs.toArray(new X509Certificate[x509_certs.size()]);
    }

    public static X509CRL[] loadCRLs(String crlFile) throws FileNotFoundException, CertificateException, CRLException {
        CRL[] crls = materialFactory.loadCRLs(crlFile);
        int len = crls.length;
        ArrayList<CRL> x509_crls = new ArrayList<CRL>(len);
        for (int i = 0; i < len; ++i) {
            if (!(crls[i] instanceof X509CRL)) continue;
            x509_crls.add(crls[i]);
        }
        return x509_crls.toArray(new X509CRL[x509_crls.size()]);
    }

    public static boolean storeCerts(Certificate[] certs, String destination) throws CertificateEncodingException, IOException {
        if (0 == certs.length) {
            File certsFile = new File(destination);
            boolean deleteFlag = certsFile.delete();
            log.info((Object)("Deleting certificate " + destination + " value: " + deleteFlag));
            return true;
        }
        boolean ret = materialFactory.storeCerts(certs, destination);
        return ret;
    }

    public static boolean storeCRLs(CRL[] crls, String destination) throws CRLException, IOException {
        if (0 == crls.length) {
            File crlfile = new File(destination);
            boolean deleteFlag = crlfile.delete();
            log.info((Object)("Deleting certificate " + destination + " value: " + deleteFlag));
            return true;
        }
        boolean ret = materialFactory.storeCRLs(crls, destination);
        return ret;
    }

    public static boolean verifyKeyStore(String keystoreFile, char[] storeps, String keystoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        materialFactory.loadKeyStore(keystoreFile, storeps, keystoreType);
        return true;
    }

    public static boolean verifyPrivateKey(String keystoreFile, char[] storeps, char[] keyps, String keystoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore ks = materialFactory.loadKeyStore(keystoreFile, storeps, keystoreType);
        Enumeration<String> e = ks.aliases();
        String alias = null;
        while (e.hasMoreElements()) {
            alias = e.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            ks.getKey(alias, keyps);
            return true;
        }
        return false;
    }

    static String encodeToBase64(byte[] encode) {
        return encoder.encode(encode);
    }
}

