/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.ssl.util;

import com.swimap.external.cbb.baseutil.AESCipher;
import com.swimap.external.cbb.baseutil.CipherException;
import com.swimap.imap.ssl.tools.AreaDescContainer;
import com.swimap.imap.ssl.tools.DescContainer;
import com.swimap.imap.ssl.tools.XMLInfo;
import com.swimap.imap.ssl.tools.XMLTool;
import com.swimap.iview.util.log.IviewLogger;
import java.security.Key;

public class SFTPSetting {
    private static final IviewLogger logger = IviewLogger.getLogger(SFTPSetting.class);
    private static final String CONFIG_FILE = "style/defaultstyle/conf/sftp/SFTPKeyConfig.xml";
    private static SFTPSetting instance;
    private XMLInfo xmlInfo;
    private boolean usePublicKeyAuth = false;
    private String keyPath = "";
    private String ph = "";
    private boolean tryPasswordAuthWhenFail = true;

    private SFTPSetting() {
        try {
            this.init();
        }
        catch (Exception e) {
            logger.warn((Object)"Reading sftp setting failed. Use default value.", (Throwable)e);
        }
    }

    public static synchronized SFTPSetting getInstance() {
        if (instance == null) {
            instance = new SFTPSetting();
        }
        return instance;
    }

    private void init() {
        this.xmlInfo = XMLTool.getInstance().readXMLFile(CONFIG_FILE);
        if (this.xmlInfo == null) {
            logger.warn((Object)"Error reading file SFTPKeyConfig.xml");
            return;
        }
        AreaDescContainer descContainer = this.xmlInfo.getAreaDescContainer("sftpkey");
        if (null == descContainer) {
            logger.error((Object)"get sftpkey container faild");
            return;
        }
        DescContainer desc = descContainer.getDescContainer("sftpkey");
        if (null == desc) {
            logger.error((Object)"get sftpkey element faild");
            return;
        }
        this.usePublicKeyAuth = Boolean.parseBoolean(desc.getParasItemValue("usePublicKeyAuth"));
        this.keyPath = desc.getParasItemValue("keyPath");
        boolean phraseEncrypted = Boolean.parseBoolean(desc.getParasItemValue("phraseEncrypted"));
        this.ph = desc.getParasItemValue("passwordPhrase");
        this.tryPasswordAuthWhenFail = Boolean.parseBoolean(desc.getParasItemValue("tryPasswordAuthWhenFail"));
        if (this.usePublicKeyAuth && !phraseEncrypted) {
            desc.setParasItem("phraseEncrypted", "true");
            this.setPasswordPhrase(this.ph.toCharArray());
            desc.setParasItem("passwordPhrase", this.ph);
            desc.addParasItem("version", "1.0");
            this.save();
        }
    }

    public boolean save() {
        if (this.xmlInfo == null) {
            logger.warn((Object)"Error reading file SFTPKeyConfig.xml");
            return false;
        }
        AreaDescContainer descContainer = this.xmlInfo.getAreaDescContainer("sftpkey");
        if (null == descContainer) {
            logger.error((Object)"get sftpkey container faild");
            return false;
        }
        DescContainer desc = descContainer.getDescContainer("sftpkey");
        if (null == desc) {
            logger.error((Object)"get sftpkey element faild");
            return false;
        }
        desc.setParasItem("usePublicKeyAuth", Boolean.toString(this.usePublicKeyAuth));
        desc.setParasItem("keyPath", this.keyPath);
        desc.setParasItem("phraseEncrypted", "true");
        desc.setParasItem("passwordPhrase", this.ph);
        desc.setParasItem("tryPasswordAuthWhenFail", Boolean.toString(this.tryPasswordAuthWhenFail));
        if (this.ph != null && !this.ph.isEmpty()) {
            desc.addParasItem("version", "1.0");
        }
        return XMLTool.getInstance().writeXMLFile(CONFIG_FILE, this.xmlInfo);
    }

    public boolean isUsePublicKeyAuth() {
        return this.usePublicKeyAuth;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public char[] getPasswordPhrase() {
        try {
            char[] pschars = AESCipher.decrypt((char[])this.ph.toCharArray(), (Key)AESCipher.defaultKey());
            return pschars;
        }
        catch (CipherException e) {
            logger.error((Object)"decrypt failed.");
            return new char[0];
        }
    }

    public boolean isTryPasswordAuthWhenFail() {
        return this.tryPasswordAuthWhenFail;
    }

    public void setUsePublicKeyAuth(boolean usePublicKeyAuth) {
        this.usePublicKeyAuth = usePublicKeyAuth;
    }

    public void setKeyPath(String keyPath) {
        this.keyPath = keyPath;
    }

    public void setPasswordPhrase(char[] pph) {
        char[] r = null;
        try {
            r = AESCipher.encrypt((char[])pph, (Key)AESCipher.defaultKey());
        }
        catch (CipherException e) {
            logger.error((Object)"encrypt ph failed.");
        }
        this.ph = r != null ? new String(r) : "";
    }

    public void setTryPasswordAuthWhenFail(boolean tryPasswordAuthWhenFail) {
        this.tryPasswordAuthWhenFail = tryPasswordAuthWhenFail;
    }
}

