/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.ssl.tools;

import com.swimap.imap.ssl.tools.AreaDescContainer;
import com.swimap.imap.ssl.tools.DescContainer;
import com.swimap.imap.ssl.tools.PARA;
import com.swimap.imap.ssl.tools.PARAS;
import com.swimap.imap.ssl.tools.XMLInfo;
import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTool {
    private final String AREADESC = "AREADESC";
    private final String AREANAME = "areaname";
    private final String DESC = "DESC";
    private final String DESCNAME = "descname";
    private final String PARAS = "PARAS";
    private final String PARA = "PARA";
    private final String NAME = "name";
    private final String VALUE = "value";
    private static XMLTool instance = new XMLTool();

    private XMLTool() {
    }

    public static XMLTool getInstance() {
        return instance;
    }

    public XMLInfo readXMLFile(String file) {
        try {
            return this.read(file);
        }
        catch (Exception e) {
            return null;
        }
    }

    private XMLInfo read(String file) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        File configFile = new File(file);
        Document doc = docBuilder.parse(configFile);
        NodeList areadescs = doc.getElementsByTagName("AREADESC");
        ArrayList<AreaDescContainer> areaDescContainerList = new ArrayList<AreaDescContainer>(areadescs.getLength());
        for (int i = 0; i < areadescs.getLength(); ++i) {
            Node areaElement = areadescs.item(i);
            if (!areaElement.getNodeName().equals("AREADESC")) continue;
            NodeList names = areaElement.getChildNodes();
            ArrayList<DescContainer> descContainerList = new ArrayList<DescContainer>(names.getLength());
            for (int j = 0; j < names.getLength(); ++j) {
                Node descElement = names.item(j);
                if (!descElement.getNodeName().equals("DESC")) continue;
                NodeList parases = descElement.getChildNodes();
                ArrayList<PARAS> parasList = new ArrayList<PARAS>(parases.getLength());
                for (int k = 0; k < parases.getLength(); ++k) {
                    Node parasElement = parases.item(k);
                    if (!parasElement.getNodeName().equals("PARAS")) continue;
                    NodeList paras = parasElement.getChildNodes();
                    ArrayList<PARA> paraList = new ArrayList<PARA>(paras.getLength());
                    for (int l = 0; l < paras.getLength(); ++l) {
                        Node paraElement = paras.item(l);
                        if (!paraElement.getNodeName().equals("PARA")) continue;
                        Node nameElement = paraElement.getAttributes().getNamedItem("name");
                        Node valueElement = paraElement.getAttributes().getNamedItem("value");
                        if (nameElement == null || valueElement == null) continue;
                        paraList.add(new PARA(nameElement.getNodeValue(), valueElement.getNodeValue(), valueElement));
                    }
                    PARAS papas = new PARAS(paraList, parasElement, doc);
                    parasList.add(papas);
                }
                DescContainer desc = new DescContainer(descElement.getAttributes().getNamedItem("descname").getNodeValue(), parasList);
                descContainerList.add(desc);
            }
            AreaDescContainer areaDesc = new AreaDescContainer(areaElement.getAttributes().getNamedItem("areaname").getNodeValue(), descContainerList);
            areaDescContainerList.add(areaDesc);
        }
        return new XMLInfo(areaDescContainerList, configFile.getAbsolutePath(), doc);
    }

    public boolean writeXMLFile(String fileName, XMLInfo xmlInfo) {
        try {
            return this.writeFile(fileName, xmlInfo);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean writeFile(String fileName, XMLInfo xmlInfo) throws ParserConfigurationException {
        try {
            File file = new File(fileName);
            StreamResult sr = new StreamResult(file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource doms = new DOMSource(xmlInfo.getDocument());
            transformer.transform(doms, sr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

