/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.ssl;

import com.swimap.imap.ssl.CRLInvalidException;
import com.swimap.imap.ssl.CertRevokedException;
import com.swimap.imap.ssl.X509TrustManagerWrapper;
import java.io.IOException;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import javax.net.ssl.X509TrustManager;

public class X509TrustManagerCRL
extends X509TrustManagerWrapper {
    private CRL[] peerCRL = null;

    public X509TrustManagerCRL(X509TrustManager trustManager) {
        super(trustManager);
    }

    @Override
    public void setAuthPeer(boolean auth) {
        super.setAuthPeer(auth);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] cerChain, String authType) throws CertificateException {
        if (!this.authPeer()) {
            return;
        }
        super.checkServerTrusted(cerChain, authType);
        this.checkTrusted(cerChain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] cerChain, String authType) throws CertificateException {
        if (!this.authPeer()) {
            return;
        }
        super.checkClientTrusted(cerChain, authType);
        this.checkTrusted(cerChain, authType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkTrusted(X509Certificate[] cerChain, String authType) throws CertificateException {
        if (this.peerCRL == null) return;
        int cert_len = cerChain.length;
        boolean is_revoked = false;
        String cert_issuer_name = null;
        ArrayList<String> col = new ArrayList<String>(cert_len);
        X509CRLSelector crlsel = new X509CRLSelector();
        CRL[] valid_crls = null;
        int crl_len = this.peerCRL.length;
        if (crl_len <= 0) return;
        for (int i = 0; i < cert_len; ++i) {
            cert_issuer_name = cerChain[i].getIssuerX500Principal().getName();
            col.clear();
            col.add(cert_issuer_name);
            try {
                crlsel.setIssuerNames(col);
            }
            catch (IOException e) {
                CRLInvalidException ex = new CRLInvalidException("No CRL is available. Pleaes update the CRL.");
                ex.initCause(e);
                throw ex;
            }
            valid_crls = this.filterCRL(crlsel);
            if (valid_crls == null || valid_crls.length == 0) continue;
            for (int j = 0; j < valid_crls.length; ++j) {
                is_revoked = valid_crls[j].isRevoked(cerChain[i]);
                if (!is_revoked) continue;
                throw new CertRevokedException("Peer's certificate has revoked.");
            }
        }
    }

    public void setCRLs(CRL[] crl) {
        this.peerCRL = crl;
    }

    private CRL[] filterCRL(X509CRLSelector crlsel) throws CertificateException {
        int crl_len = this.peerCRL.length;
        ArrayList<X509CRL> tempcrl = new ArrayList<X509CRL>(crl_len);
        X509CRL xcrl = null;
        Date current_date = new Date(System.currentTimeMillis());
        for (int i = 0; i < crl_len; ++i) {
            if (!crlsel.match(this.peerCRL[i]) || !current_date.before((xcrl = (X509CRL)this.peerCRL[i]).getNextUpdate())) continue;
            tempcrl.add(xcrl);
        }
        return tempcrl.toArray(new CRL[tempcrl.size()]);
    }
}

