/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.ssl;

import com.swimap.external.sf.ssl.SSLIntializtionException;
import com.swimap.imap.ssl.WrongCRLStoreException;
import com.swimap.imap.ssl.WrongTrustStoreException;
import com.swimap.imap.ssl.X509TrustManagerCRL;
import com.swimap.imap.ssl.util.MaterialFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class TrustMaterial {
    private List<CRL> peerCRLs = new ArrayList<CRL>(16);
    private static final int CRL_SIZE = 16;
    private List<Certificate> trustCerts = new ArrayList<Certificate>(16);
    private static final int CERT_SIZE = 16;
    private boolean authPeer = true;
    private MaterialFactory theMaterialBuilder = new MaterialFactory();

    public void setAuthPeer(boolean authPeer) {
        this.authPeer = authPeer;
    }

    public boolean authPeer() {
        return this.authPeer;
    }

    public void addCRL(CRL crl) {
        this.peerCRLs.add(crl);
    }

    public void addCRL(String CRLFile) throws SSLIntializtionException {
        try {
            CRL[] crls = this.theMaterialBuilder.loadCRLs(CRLFile);
            if (crls != null) {
                int size = crls.length;
                for (int i = 0; i < size; ++i) {
                    this.peerCRLs.add(crls[i]);
                }
            }
        }
        catch (Exception e) {
            throw new WrongCRLStoreException("Failed load crl.", e);
        }
    }

    public void addTrustCert(Certificate cert) {
        this.trustCerts.add(cert);
    }

    public void addTrustCert(String certFile) throws SSLIntializtionException {
        try {
            Certificate[] certs = this.theMaterialBuilder.loadCerts(certFile);
            if (certs != null) {
                int size = certs.length;
                for (int i = 0; i < size; ++i) {
                    this.trustCerts.add(certs[i]);
                }
            }
        }
        catch (Exception e) {
            throw new WrongTrustStoreException("Failed load trust.", e);
        }
    }

    private KeyStore getKeyStore() throws KeyStoreException {
        return this.theMaterialBuilder.loadKeyStore(this.trustCerts, "JKS");
    }

    public TrustManager[] getTrustManagers() throws SSLIntializtionException {
        try {
            KeyStore trustStore = this.getKeyStore();
            TrustManagerFactory tmf = null;
            TrustManager[] tms = null;
            TrustManager[] wrappedTMs = null;
            tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(trustStore);
            tms = tmf.getTrustManagers();
            wrappedTMs = this.getWrappedTrustManagers(tms);
            return wrappedTMs;
        }
        catch (Exception e) {
            throw new WrongTrustStoreException("Incorrect certificates while authorizing peer required.", e);
        }
    }

    private TrustManager[] getWrappedTrustManagers(TrustManager[] tms) {
        CRL[] crls = this.peerCRLs.toArray(new CRL[this.peerCRLs.size()]);
        int len = tms.length;
        TrustManager[] crlTMs = new X509TrustManagerCRL[len];
        for (int i = 0; i < len; ++i) {
            crlTMs[i] = new X509TrustManagerCRL((X509TrustManager)tms[i]);
            ((X509TrustManagerCRL)crlTMs[i]).setCRLs(crls);
            ((X509TrustManagerCRL)crlTMs[i]).setAuthPeer(this.authPeer);
        }
        return crlTMs;
    }
}

