/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class SSLServerSocketFactoryCustomized
extends SSLServerSocketFactory {
    private String[] enabledCipherSuites = null;
    private String[] enabledProtocols = null;
    private boolean needClientAuth = false;
    private SSLServerSocketFactory factory;

    public SSLServerSocketFactoryCustomized(SSLServerSocketFactory factory) {
        this.factory = factory;
    }

    public void setEnabledCipherSuite(String[] cipherSuites) {
        this.enabledCipherSuites = cipherSuites;
    }

    public void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = protocols;
    }

    public void setNeedClientAuth(boolean clientAuth) {
        this.needClientAuth = clientAuth;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public ServerSocket createServerSocket(int arg0) throws IOException {
        ServerSocket socket = this.factory.createServerSocket(arg0);
        this.decorate(socket);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int arg0, int arg1) throws IOException {
        ServerSocket socket = this.factory.createServerSocket(arg0, arg1);
        this.decorate(socket);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int arg0, int arg1, InetAddress arg2) throws IOException {
        ServerSocket socket = this.factory.createServerSocket(arg0, arg1, arg2);
        this.decorate(socket);
        return socket;
    }

    private void decorate(ServerSocket s) {
        if (s instanceof SSLServerSocket) {
            SSLServerSocket ssls = (SSLServerSocket)s;
            if (this.enabledCipherSuites != null) {
                ssls.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            if (this.enabledProtocols != null) {
                ssls.setEnabledProtocols(this.enabledProtocols);
            }
            ssls.setNeedClientAuth(this.needClientAuth);
        }
    }
}

