/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.ssl;

import com.swimap.external.sf.ssl.SSLIntializtionException;
import com.swimap.imap.ssl.KeyMaterial;
import com.swimap.imap.ssl.SSLServerSocketFactoryCustomized;
import com.swimap.imap.ssl.SSLSocketFactoryCustomized;
import com.swimap.imap.ssl.TrustMaterial;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SSL {
    private KeyMaterial theKeyMaterial;
    private TrustMaterial theTrustMaterial;
    private String enabledProtocolVersion = "TLSv1";
    private boolean authPeer = true;
    private String[] enabledCipherSuites = null;
    private static List<String> supportedCipherSuites = null;

    public SSL() {
        this.setEnabledProtocolVersion(this.enabledProtocolVersion);
        this.theTrustMaterial = new TrustMaterial();
        SSLSocketFactory sf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        String[] cs = sf.getSupportedCipherSuites();
        supportedCipherSuites = Arrays.asList(cs);
        this.enabledCipherSuites = cs;
    }

    public void setAuthPeer(boolean authPeer) {
        this.authPeer = authPeer;
    }

    public boolean authPeer() {
        return this.authPeer;
    }

    public String[] setEnabledCipherSuites(String[] cipherSuites) {
        if (cipherSuites == null || cipherSuites.length == 0) {
            this.enabledCipherSuites = supportedCipherSuites.toArray(new String[supportedCipherSuites.size()]);
            return this.enabledCipherSuites;
        }
        int len = cipherSuites.length;
        ArrayList<String> enabled = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            if (!supportedCipherSuites.contains(cipherSuites[i])) continue;
            enabled.add(cipherSuites[i]);
        }
        this.enabledCipherSuites = enabled.isEmpty() ? supportedCipherSuites.toArray(new String[supportedCipherSuites.size()]) : enabled.toArray(new String[enabled.size()]);
        return this.enabledCipherSuites;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public String setEnabledProtocolVersion(String protocolVersion) {
        this.enabledProtocolVersion = protocolVersion == null ? null : (protocolVersion.indexOf("SSLv2") != -1 ? "SSLv3" : (protocolVersion.indexOf("TLSv1") != -1 ? "TLSv1" : protocolVersion));
        return this.enabledProtocolVersion;
    }

    public String getEnabledProtocolVersion() {
        return this.enabledProtocolVersion;
    }

    public void addKeyMaterial(KeyMaterial keyMaterial) {
        this.theKeyMaterial = keyMaterial;
    }

    public void addTrustMaterial(TrustMaterial trustMaterial) {
        if (trustMaterial != null) {
            this.theTrustMaterial = trustMaterial;
        }
    }

    public SSLSocketFactory createSocketFactory() throws SSLIntializtionException {
        SSLContext sslContext = this.createSSLContext();
        SSLSocketFactory factory = this.getSocketFactory(sslContext);
        return factory;
    }

    public SSLServerSocketFactory createServerSocketFactory() throws SSLIntializtionException {
        SSLContext sslContext = this.createSSLContext();
        SSLServerSocketFactory factory = this.getServerSocketFactory(sslContext);
        return factory;
    }

    public SSLEngine createSSLEngine(String peerHost, int peerPort, boolean isClient) throws SSLIntializtionException {
        SSLContext sslContext = this.createSSLContext();
        SSLEngine engine = sslContext.createSSLEngine(peerHost, peerPort);
        engine.setEnabledCipherSuites(this.enabledCipherSuites);
        engine.setEnabledProtocols(new String[]{this.enabledProtocolVersion});
        engine.setNeedClientAuth(this.authPeer);
        engine.setUseClientMode(isClient);
        return engine;
    }

    public SSLContext createSSLContext() throws SSLIntializtionException {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance(this.getEnabledProtocolVersion());
        }
        catch (NoSuchAlgorithmException nsaex) {
            throw new SSLIntializtionException(this.getEnabledProtocolVersion(), nsaex);
        }
        KeyManager[] kms = null;
        TrustManager[] tms = null;
        this.theTrustMaterial.setAuthPeer(this.authPeer);
        tms = this.theTrustMaterial.getTrustManagers();
        if (this.theKeyMaterial == null) {
            kms = null;
        } else {
            try {
                kms = this.theKeyMaterial.getKeyManagers();
            }
            catch (Exception nsaex) {
                throw new SSLIntializtionException("KeyManager can not parse the KeyStore: ", nsaex);
            }
        }
        try {
            sslContext.init(kms, tms, null);
        }
        catch (KeyManagementException e) {
            throw new SSLIntializtionException("Cannot init SSLContext: ", e);
        }
        return sslContext;
    }

    private SSLSocketFactory getSocketFactory(SSLContext context) {
        SSLSocketFactory factory = context.getSocketFactory();
        SSLSocketFactoryCustomized factoryCustomized = new SSLSocketFactoryCustomized(factory);
        factoryCustomized.setEnabledCipherSuite(this.getEnabledCipherSuites());
        factoryCustomized.setEnabledProtocols(new String[]{this.getEnabledProtocolVersion()});
        return factoryCustomized;
    }

    private SSLServerSocketFactory getServerSocketFactory(SSLContext context) {
        SSLServerSocketFactory factory = context.getServerSocketFactory();
        SSLServerSocketFactoryCustomized factoryCustomized = new SSLServerSocketFactoryCustomized(factory);
        factoryCustomized.setEnabledCipherSuite(this.getEnabledCipherSuites());
        factoryCustomized.setEnabledProtocols(new String[]{this.getEnabledProtocolVersion()});
        factoryCustomized.setNeedClientAuth(this.authPeer);
        return factoryCustomized;
    }
}

