/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.ssl;

import com.swimap.external.sf.ssl.IOption;
import com.swimap.imap.ssl.tools.AreaDescContainer;
import com.swimap.imap.ssl.tools.DescContainer;
import com.swimap.imap.ssl.tools.XMLInfo;
import com.swimap.imap.ssl.tools.XMLTool;
import java.io.File;

public class Option
implements IOption {
    private static final String VERSION_KEY = "version";
    private static final String ENCRYPT_LEVEL_KEY = "encryptLevel";
    private static final String ENABLE_AUTH_PEER_KEY = "enableAuthPeer";
    private static final String ENABLE_SSL_KEY = "enableSSL";
    private static final String ENABLE_SESSION_REUSE_KEY = "enableSessionReuse";
    private static final String SESSION_TIMEOUT_KEY = "sessionTimeout";
    private static final String ENABLE_SSL_PORT_AUTO_ADAPT_KEY = "enableSSLPortAutoAdapt";
    private String version = "TLSv1";
    private String encryptLevel = "medium";
    private boolean enableAuthPeer = false;
    private boolean loadADHCiphers = false;
    private boolean enableSSL = true;
    private boolean isLoadDH = true;
    private boolean enableSessionReuse = true;
    private int sessionTimeout = 300;
    private boolean enableSSLPortAutoAdapt = false;
    private XMLInfo optionXMLInfo = null;
    private DescContainer options = null;

    public Option() {
    }

    public Option(String optionFile) {
        this.readOption(optionFile);
    }

    private boolean readOption(String optionFile) {
        this.optionXMLInfo = XMLTool.getInstance().readXMLFile(optionFile);
        if (this.optionXMLInfo == null) {
            return false;
        }
        AreaDescContainer ssl = this.optionXMLInfo.getAreaDescContainer("ssl");
        this.options = ssl.getDescContainer("options");
        if (this.options == null) {
            return false;
        }
        try {
            this.enableSSL = Boolean.valueOf(this.options.getParasItemValue(ENABLE_SSL_KEY));
            this.version = this.options.getParasItemValue(VERSION_KEY);
            this.encryptLevel = this.options.getParasItemValue(ENCRYPT_LEVEL_KEY);
            this.enableAuthPeer = Boolean.valueOf(this.options.getParasItemValue(ENABLE_AUTH_PEER_KEY));
            this.enableSessionReuse = Boolean.valueOf(this.options.getParasItemValue(ENABLE_SESSION_REUSE_KEY));
            this.sessionTimeout = Integer.valueOf(this.options.getParasItemValue(SESSION_TIMEOUT_KEY));
            this.enableSSLPortAutoAdapt = Boolean.valueOf(this.options.getParasItemValue(ENABLE_SSL_PORT_AUTO_ADAPT_KEY));
            this.loadADHCiphers = Boolean.valueOf(this.options.getParasItemValue("loadADHCiphers"));
        }
        catch (NumberFormatException e) {
            System.err.println(e.getMessage());
        }
        return true;
    }

    public void setVersion(String version) {
        this.version = version;
        this.setValue(VERSION_KEY, version);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setEncryptLevel(String encryptLevel) {
        this.encryptLevel = encryptLevel;
        this.setValue(ENCRYPT_LEVEL_KEY, encryptLevel);
    }

    @Override
    public String getEncryptLevel() {
        return this.encryptLevel;
    }

    public void setEnableAuthPeer(boolean enableAuthPeer) {
        this.enableAuthPeer = enableAuthPeer;
        this.setValue(ENABLE_AUTH_PEER_KEY, String.valueOf(enableAuthPeer));
    }

    @Override
    public boolean isEnableAuthPeer() {
        return this.enableAuthPeer;
    }

    public boolean isLoadADHCiphers() {
        return this.loadADHCiphers;
    }

    @Override
    public boolean isLoadDH() {
        return this.isLoadDH;
    }

    public void setLoadDH(boolean load) {
        this.isLoadDH = load;
    }

    public void setEnableSSL(boolean enableSSL) {
        this.enableSSL = enableSSL;
        this.setValue(ENABLE_SSL_KEY, String.valueOf(enableSSL));
    }

    public boolean isEnableSSL() {
        return this.enableSSL;
    }

    public void setEnableSessionReuse(boolean enableSessionReuse) {
        this.enableSessionReuse = enableSessionReuse;
        this.setValue(ENABLE_SESSION_REUSE_KEY, String.valueOf(enableSessionReuse));
    }

    public boolean isEnableSessionReuse() {
        return this.enableSessionReuse;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        this.setValue(SESSION_TIMEOUT_KEY, String.valueOf(sessionTimeout));
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setEnableSSLPortAutoAdapt(boolean enableSSLPortAutoAdapt) {
        this.enableSSLPortAutoAdapt = enableSSLPortAutoAdapt;
        this.setValue(ENABLE_SSL_PORT_AUTO_ADAPT_KEY, String.valueOf(enableSSLPortAutoAdapt));
    }

    public boolean isEnableSSLPortAutoAdapt() {
        return this.enableSSLPortAutoAdapt;
    }

    private boolean setValue(String key, String value) {
        if (this.optionXMLInfo == null || this.options == null) {
            return false;
        }
        boolean success = this.options.setParasItem(key, value);
        if (success) {
            success = this.writeBack();
        }
        return success;
    }

    private boolean writeBack() {
        File f = new File(this.optionXMLInfo.getFileName());
        if (f.canWrite()) {
            return XMLTool.getInstance().writeXMLFile(this.optionXMLInfo.getFileName(), this.optionXMLInfo);
        }
        return false;
    }
}

