/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.ssl;

import com.swimap.external.sf.ssl.SSLIntializtionException;
import com.swimap.imap.ssl.Context;
import com.swimap.imap.ssl.WrongKeyStoreException;
import com.swimap.imap.ssl.WrongTrustStoreException;
import com.swimap.imap.ssl.util.MaterialFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import sun.security.x509.X509CertImpl;

public class KeyMaterial {
    private KeyStore keystore = null;
    private KeyManager[] keyManagers = null;
    private MaterialFactory theMaterialBuilder = new MaterialFactory();
    private final String SUNX509 = "SunX509";
    private static final int MAX_CERT_CHAIN_DEPTH = 10;
    private int currentDepth = 0;

    public KeyMaterial(InputStream stream, char[] storeps, char[] pveps, String keystoreType) throws SSLIntializtionException {
        try {
            this.keystore = this.theMaterialBuilder.loadKeyStore(stream, storeps, keystoreType);
            this.setKeyStoreWithAllCertificates(pveps);
            this.keyManagers = this.getKeyManagersAdapter(pveps);
        }
        catch (SSLIntializtionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrongKeyStoreException("Failed load KeyMaterial.", e);
        }
    }

    public KeyMaterial(String keystoreFile, char[] storeps, char[] pveps, String keystoreType) throws SSLIntializtionException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(keystoreFile);
            this.keystore = this.theMaterialBuilder.loadKeyStore(fin, storeps, keystoreType);
            this.setKeyStoreWithAllCertificates(pveps);
            this.keyManagers = this.getKeyManagersAdapter(pveps);
        }
        catch (SSLIntializtionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrongKeyStoreException("Failed load KeyMaterial.", e);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ioex) {
                    System.err.println("Close file failed");
                }
            }
        }
    }

    public KeyMaterial(KeyStore keystore, char[] pveps) throws SSLIntializtionException {
        this.keystore = keystore;
        this.setKeyStoreWithAllCertificates(pveps);
        this.keyManagers = this.getKeyManagersAdapter(pveps);
    }

    private void setKeyStoreWithAllCertificates(char[] ps) throws SSLIntializtionException {
        KeyStore ks = this.getKeyStoreWithAllCertificates(ps);
        if (ks != null) {
            this.keystore = ks;
        }
    }

    private KeyStore getKeyStoreWithAllCertificates(char[] ps) throws SSLIntializtionException {
        String trustFilePath = Context.getTrustCertPath();
        if (null == trustFilePath || trustFilePath.isEmpty() || !new File(trustFilePath).exists()) {
            return null;
        }
        return this.getKeyStoreEntry(ps);
    }

    private KeyStore getKeyStoreEntry(char[] ps) throws SSLIntializtionException {
        KeyStore newKeystore = null;
        String alias = "";
        Key key = null;
        Certificate[] certificates = null;
        try {
            newKeystore = KeyStore.getInstance("JKS");
            newKeystore.load(null, ps);
            key = this.keystore.getKey(alias, ps);
            certificates = this.keystore.getCertificateChain(alias);
            Enumeration<String> enup = this.keystore.aliases();
            while (enup.hasMoreElements()) {
                alias = enup.nextElement();
            }
        }
        catch (Exception e) {
            throw new WrongKeyStoreException("Failed load KeyMaterial.", e);
        }
        int DEFAULT_SIZE = 10;
        FileInputStream tin = null;
        Collection<? extends Certificate> cers = null;
        X509Certificate[] certs = null;
        try {
            tin = new FileInputStream(Context.getTrustCertPath());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cers = cf.generateCertificates(tin);
            certs = cers.toArray(new X509Certificate[cers.size()]);
        }
        catch (Exception e) {
            throw new WrongTrustStoreException("Failed load trust.", e);
        }
        finally {
            if (null != tin) {
                try {
                    tin.close();
                }
                catch (IOException ex) {
                    System.err.println("Close file failed");
                }
            }
        }
        ArrayList<X509Certificate> als = new ArrayList<X509Certificate>(10);
        if (null == certificates || certificates.length > 1 || certificates.length == 0) {
            return null;
        }
        this.addAllCertificates(certificates, als, certs);
        if (this.currentDepth == 10) {
            return null;
        }
        Certificate[] certs2 = als.toArray(new X509Certificate[als.size()]);
        try {
            newKeystore.setKeyEntry(alias, key, ps, certs2);
        }
        catch (KeyStoreException e) {
            return null;
        }
        return newKeystore;
    }

    private void addAllCertificates(Certificate[] certificates, ArrayList<X509Certificate> als, X509Certificate[] certs) {
        Principal issuer = null;
        X509CertImpl cert = null;
        if (certificates.length == 1) {
            cert = (X509CertImpl)certificates[0];
            als.add(cert);
            issuer = cert.getIssuerDN();
            this.addTrustCert(certs, issuer, als);
        }
    }

    private void addTrustCert(X509Certificate[] certs, Principal issuer, ArrayList<X509Certificate> als) {
        ++this.currentDepth;
        if (this.currentDepth == 10) {
            return;
        }
        Principal certPrincipal = null;
        Principal trustIssuer = null;
        for (int j = 0; j < certs.length; ++j) {
            certPrincipal = ((X509CertImpl)certs[j]).getSubjectDN();
            if (!((Object)certPrincipal).equals(issuer)) continue;
            als.add((X509CertImpl)certs[j]);
            trustIssuer = ((X509CertImpl)certs[j]).getIssuerDN();
            if (((Object)trustIssuer).equals(certPrincipal)) {
                return;
            }
            this.addTrustCert(certs, trustIssuer, als);
        }
    }

    private KeyManager[] getKeyManagersAdapter(char[] ps) throws SSLIntializtionException {
        KeyManager[] kms = null;
        try {
            KeyManagerFactory kmf = null;
            kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(this.keystore, ps);
            kms = kmf.getKeyManagers();
        }
        catch (Exception e) {
            throw new WrongKeyStoreException("", e);
        }
        return kms;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }
}

