/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.ssl;

import com.swimap.external.sf.ssl.CipherMapping;
import com.swimap.external.sf.ssl.SSLIntializtionException;
import com.swimap.imap.ssl.Configurator;
import com.swimap.imap.ssl.KeyMaterial;
import com.swimap.imap.ssl.Option;
import com.swimap.imap.ssl.SSL;
import com.swimap.imap.ssl.TrustMaterial;
import com.swimap.imap.ssl.WrongKeyStoreException;
import java.io.File;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class Context {
    private SSL theSSL = new SSL();
    private Configurator configurator = null;
    private static final String TSLV1 = "TLSv1";
    private static String trustCertPath = null;

    public static String getTrustCertPath() {
        return trustCertPath;
    }

    public static SSLContext createSSLContext(String idCert, String storeType, char[] pfxps, char[] keyps, String trustCert, String crl, String protVersion, String[] cipherSuites, boolean authPeer) throws SSLIntializtionException {
        TrustMaterial tm;
        KeyMaterial km;
        String protVersion2;
        block5: {
            protVersion2 = protVersion;
            km = null;
            km = new KeyMaterial(idCert, pfxps, keyps, storeType);
            tm = new TrustMaterial();
            try {
                tm.addTrustCert(trustCert);
            }
            catch (SSLIntializtionException e) {
                if (!authPeer) break block5;
                throw e;
            }
        }
        tm.addCRL(crl);
        Context context = new Context();
        context.addKeyMaterial(km);
        context.addTrustMaterial(tm);
        context.setAuthPeer(authPeer);
        if (protVersion2 == null || "".equals(protVersion2)) {
            protVersion2 = TSLV1;
        }
        context.setEnabledProtocolVersion(protVersion2);
        context.setEnabledCipherSuites(cipherSuites);
        SSLContext sslcontext = null;
        try {
            sslcontext = context.createSSLContext();
        }
        catch (Exception e) {
            throw new SSLIntializtionException("Unable create ssl context. ", e);
        }
        return sslcontext;
    }

    public SSLContext createSSLContext() throws SSLIntializtionException {
        return this.theSSL.createSSLContext();
    }

    public void setConfigurator(Configurator config) {
        this.configurator = config;
    }

    public Configurator getConfigurator() {
        return this.configurator;
    }

    public void setAuthPeer(boolean authPeer) {
        this.theSSL.setAuthPeer(authPeer);
    }

    public boolean authPeer() {
        return this.theSSL.authPeer();
    }

    public String[] setEnabledCipherSuites(String[] cipherSuites) {
        return this.theSSL.setEnabledCipherSuites(cipherSuites);
    }

    public String[] getEnabledCipherSuites() {
        return this.theSSL.getEnabledCipherSuites();
    }

    public String setEnabledProtocolVersion(String ver) {
        return this.theSSL.setEnabledProtocolVersion(ver);
    }

    public String getEnabledProtocolVersion() {
        return this.theSSL.getEnabledProtocolVersion();
    }

    public void addKeyMaterial(KeyMaterial keyMaterial) {
        this.theSSL.addKeyMaterial(keyMaterial);
    }

    public void addTrustMaterial(TrustMaterial trustMaterial) {
        this.theSSL.addTrustMaterial(trustMaterial);
    }

    public void init(Configurator config, int mode) throws SSLIntializtionException {
        String trust_cert_file;
        String keystore_file = config.getKeyStore();
        String keystore_type = config.getKeyStroeType();
        char[] store_ps = config.getStorePassword();
        char[] key_ps = config.getKeyPassword();
        trustCertPath = trust_cert_file = config.getTrustCert();
        String crl_file = config.getCRL();
        KeyMaterial km = this.createKeyMaterial(keystore_file, keystore_type, store_ps, key_ps);
        TrustMaterial tm = this.createTrustMaterial(trust_cert_file, crl_file);
        Option option = config.getOption();
        if (option != null) {
            boolean auth_peer = option.isEnableAuthPeer();
            String version = option.getVersion();
            String encrypt_level = option.getEncryptLevel();
            this.theSSL.setAuthPeer(auth_peer);
            this.theSSL.setEnabledProtocolVersion(version);
            if (mode == 1 && !auth_peer) {
                if (option.isLoadADHCiphers() || km == null) {
                    option.setLoadDH(true);
                } else {
                    option.setLoadDH(false);
                }
            } else {
                option.setLoadDH(true);
            }
            this.theSSL.setEnabledCipherSuites(CipherMapping.getCipherList(encrypt_level, option.isLoadDH()));
        }
        this.addKeyMaterial(km);
        this.addTrustMaterial(tm);
    }

    KeyMaterial createKeyMaterial(String keystoreFile, String keystoreType, char[] storePS, char[] keyPS) throws SSLIntializtionException {
        KeyMaterial km = null;
        if (keystoreFile != null && !keystoreFile.isEmpty() && new File(keystoreFile).exists()) {
            try {
                km = new KeyMaterial(keystoreFile, storePS, keyPS, keystoreType);
            }
            catch (SSLIntializtionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WrongKeyStoreException("Failed load KeyMaterial.", e);
            }
            finally {
                if (null != storePS) {
                    Arrays.fill(storePS, '\u0000');
                }
                if (null != keyPS) {
                    Arrays.fill(keyPS, '\u0000');
                }
            }
        }
        return km;
    }

    TrustMaterial createTrustMaterial(String trustFile, String crlFile) throws SSLIntializtionException {
        TrustMaterial tm = null;
        if (trustFile != null && !trustFile.isEmpty() && new File(trustFile).exists()) {
            tm = new TrustMaterial();
            tm.addTrustCert(trustFile);
            if (crlFile != null && !crlFile.isEmpty() && new File(crlFile).exists()) {
                tm.addCRL(crlFile);
            }
        }
        return tm;
    }

    public SSLSocketFactory createSocketFactory() throws SSLIntializtionException {
        try {
            return this.theSSL.createSocketFactory();
        }
        catch (Exception e) {
            throw new SSLIntializtionException("Failed to create SSLSocketFactory.", e);
        }
    }

    public SSLServerSocketFactory createServerSocketFactory() throws SSLIntializtionException {
        return this.theSSL.createServerSocketFactory();
    }

    public SSLEngine createSSLEngine(String peerHost, int peerPort, boolean isClient) throws SSLIntializtionException {
        return this.theSSL.createSSLEngine(peerHost, peerPort, isClient);
    }
}

