/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.ssl;

import com.swimap.external.cbb.baseutil.AESCipher;
import com.swimap.external.cbb.baseutil.CipherException;
import com.swimap.external.sf.ssl.ICipher;
import com.swimap.external.sf.ssl.IConfiguration;
import com.swimap.imap.ssl.ClientCipher;
import com.swimap.imap.ssl.Option;
import com.swimap.imap.ssl.tools.AreaDescContainer;
import com.swimap.imap.ssl.tools.DescContainer;
import com.swimap.imap.ssl.tools.XMLInfo;
import com.swimap.imap.ssl.tools.XMLTool;
import java.io.File;
import java.security.Key;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Configurator
implements IConfiguration {
    private static Log logger = LogFactory.getLog(Configurator.class);
    private String configPath = "";
    private XMLInfo xmlInfo = null;
    private AreaDescContainer sslConfig = null;
    private final String sslConfigFileName = "certificateConfig.xml";
    private Option option = null;
    private ICipher cipher = null;
    private static final String KEY_STORE_TYPE_PFX = "PFX";
    private static final String KEY_STORE_TYPE_PKCS12 = "pkcs12";

    public Configurator(String path) {
        this(path, null, new ClientCipher());
    }

    public Configurator(String path, String optionFile, ICipher cipher) {
        boolean succeed = this.setConfigPath(path);
        if (!succeed) {
            StringBuffer msg = new StringBuffer();
            msg.append(path);
            msg.append(File.separator);
            msg.append("certificateConfig.xml");
            msg.append(" is not exist or not well formed.");
            throw new IllegalArgumentException(msg.toString());
        }
        String sslRootPath = this.getValue("sslRootPath", "path");
        if (null != sslRootPath) {
            this.configPath = new File(path).getAbsolutePath();
            File file = new File(sslRootPath);
            this.configPath = file.isAbsolute() ? file.getAbsolutePath() : this.configPath + File.separator + sslRootPath;
            if (!this.configPath.endsWith(File.separator)) {
                this.configPath = this.configPath + File.separator;
            }
        }
        String optionpath = this.getConfigPath();
        if (optionFile != null) {
            this.option = new Option(optionpath + File.separator + optionFile);
        }
        this.cipher = cipher;
    }

    public void setOption(Option option) {
        this.option = option;
    }

    public Option getOption() {
        return this.option;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getCertConfigFileName() {
        return this.xmlInfo.getFileName();
    }

    private boolean isOldVersion(String type, String item, String configpath) {
        String path = configpath + File.separator + item + File.separator + type;
        return "".equals(type) || !new File(path).exists();
    }

    @Override
    public String getCRL() {
        String file_name = this.getValue("crl", "file");
        if (file_name == null || "".equals(file_name)) {
            return null;
        }
        String type = this.getValue("crl", "type");
        if (null == type) {
            type = "";
        }
        if (this.isOldVersion(type, "crl", this.configPath)) {
            return this.configPath + file_name;
        }
        String path = "crl" + File.separator + type + File.separator;
        return this.configPath + path + file_name;
    }

    @Override
    public char[] getKeyPassword() {
        String encrypted_ps = this.getValue("keyStore", "keyPassword");
        if (encrypted_ps == null) {
            return null;
        }
        return this.cipher.decrypt(encrypted_ps.toCharArray());
    }

    @Override
    public String getKeyStore() {
        String file_name = this.getValue("keyStore", "file");
        if (file_name == null || "".equals(file_name)) {
            return null;
        }
        String keyStoreType = this.getValue("keyStore", "type");
        if (null == keyStoreType) {
            keyStoreType = "";
        }
        if (this.isOldVersion(keyStoreType, "keyStore", this.configPath)) {
            return this.configPath + file_name;
        }
        String path = "keyStore" + File.separator + keyStoreType + File.separator;
        return this.configPath + path + file_name;
    }

    public String getKeyStroeType() {
        String keyStoreType = this.getValue("keyStore", "type");
        return Configurator.convertKeyStoreType(keyStoreType);
    }

    private static String convertKeyStoreType(String keyStoreType) {
        if (keyStoreType != null) {
            keyStoreType = KEY_STORE_TYPE_PFX.equals(keyStoreType) ? KEY_STORE_TYPE_PKCS12 : keyStoreType;
        }
        return keyStoreType;
    }

    @Override
    public char[] getStorePassword() {
        String encrypted_ps = this.getValue("keyStore", "storePassword");
        if (encrypted_ps == null) {
            return null;
        }
        return this.cipher.decrypt(encrypted_ps.toCharArray());
    }

    @Override
    public String getTrustCert() {
        String file_name = this.getValue("trust", "file");
        if (file_name == null || "".equals(file_name)) {
            return null;
        }
        String type = this.getValue("trust", "type");
        if (null == type) {
            type = "";
        }
        if (this.isOldVersion(type, "trust", this.configPath)) {
            return this.configPath + file_name;
        }
        String path = "trust" + File.separator + type + File.separator;
        return this.configPath + path + file_name;
    }

    public String getValue(String item, String name) {
        DescContainer desc = this.sslConfig.getDescContainer(item);
        if (desc == null) {
            return null;
        }
        return desc.getParasItemValue(name);
    }

    private boolean readFrom(String configFile) {
        this.xmlInfo = XMLTool.getInstance().readXMLFile(configFile);
        if (this.xmlInfo == null) {
            return false;
        }
        this.sslConfig = this.xmlInfo.getAreaDescContainer("ssl");
        return this.sslConfig != null;
    }

    private boolean setConfigPath(String configPath) {
        if (configPath == null) {
            return false;
        }
        this.configPath = configPath;
        File certConfFile = new File(this.configPath);
        this.configPath = certConfFile.getAbsolutePath();
        certConfFile = new File(this.configPath);
        if (!certConfFile.exists()) {
            return false;
        }
        if (!this.configPath.endsWith(File.separator)) {
            this.configPath = this.configPath + File.separator;
        }
        return this.readFrom(this.configPath + "certificateConfig.xml");
    }

    public boolean setKeyPassword(char[] keyPs) {
        char[] en = null;
        try {
            en = AESCipher.encrypt((char[])keyPs, (Key)AESCipher.defaultKey());
        }
        catch (CipherException e) {
            return false;
        }
        String encrypted_ps = String.valueOf(en);
        boolean success = this.setValue("keyStore", "keyPassword", encrypted_ps);
        return success;
    }

    public boolean setStorePassword(char[] storePs) {
        char[] en = null;
        try {
            en = AESCipher.encrypt((char[])storePs, (Key)AESCipher.defaultKey());
        }
        catch (CipherException e) {
            return false;
        }
        String encrypted_ps = String.valueOf(en);
        boolean success = this.setValue("keyStore", "storePassword", encrypted_ps);
        return success;
    }

    public void addVersion() {
        DescContainer desc = this.sslConfig.getDescContainer("keyStore");
        if (desc == null) {
            return;
        }
        desc.addParasItem("version", "1.0");
        this.writeBack();
    }

    public boolean setValue(String item, String name, String value) {
        DescContainer desc = this.sslConfig.getDescContainer(item);
        if (desc == null) {
            return false;
        }
        boolean succeed = desc.setParasItem(name, value);
        if (succeed) {
            succeed = this.writeBack();
        }
        return succeed;
    }

    private boolean writeBack() {
        File f = new File(this.xmlInfo.getFileName());
        if (f.canWrite()) {
            return XMLTool.getInstance().writeXMLFile(this.xmlInfo.getFileName(), this.xmlInfo);
        }
        return false;
    }
}

