/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sf.ssl;

import com.swimap.external.sf.ssl.ICipher;
import com.swimap.external.sf.ssl.IConfiguration;
import com.swimap.external.sf.ssl.IOption;
import com.swimap.external.sf.ssl.SSLIntializtionException;
import com.swimap.imap.ssl.ClientCipher;
import com.swimap.imap.ssl.Configurator;
import com.swimap.imap.ssl.Context;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SSLManager {
    private static final String SSL_CONFIG_PATH = "style/defaultstyle/conf/ssl";
    private static final String SSL_CONFIG_PATH_ENV = "imap.sslCertificatesPath";
    public static final int SERVER_MODE = 1;
    public static final int CLIENT_MODE = 0;
    private int mode;
    private Context context;
    private IConfiguration configuration;
    private IOption option;

    private SSLManager() {
    }

    public static SSLManager defaultClientManager() throws SSLIntializtionException {
        String path = System.getProperty(SSL_CONFIG_PATH_ENV);
        if (path == null || path.isEmpty()) {
            path = SSL_CONFIG_PATH;
        }
        return SSLManager.init(path, 0, new ClientCipher());
    }

    public static SSLManager init(String path, int mode, ICipher cipher) throws SSLIntializtionException {
        Context context = new Context();
        Configurator config = new Configurator(path, "option.xml", cipher);
        context.init(config, mode);
        SSLManager instance = new SSLManager();
        instance.mode = mode;
        instance.context = context;
        instance.configuration = config;
        instance.option = config.getOption();
        return instance;
    }

    public SSLContext getSSLContext() throws SSLIntializtionException {
        return this.context.createSSLContext();
    }

    public SSLSocketFactory getSSLSocketFactory() throws SSLIntializtionException {
        return this.context.createSocketFactory();
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() throws SSLIntializtionException {
        return this.context.createServerSocketFactory();
    }

    public SSLEngine createSSLEngine(String peerHost, int peerPort) throws SSLIntializtionException {
        return this.context.createSSLEngine(peerHost, peerPort, this.mode == 0);
    }

    public IConfiguration getConfiguration() {
        return this.configuration;
    }

    public IOption getOption() {
        return this.option;
    }
}

