/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sf.ssl;

public final class CipherMapping {
    private static final String LOW = "low";
    private static final String MEDIUM = "medium";
    private static final String HIGH = "high";
    private static final String[] LOW_CIPHER = new String[]{"SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA"};
    private static final String[] LOW_CIPHER_DH = new String[]{"SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA"};
    private static final String[] MEDIUM_CIPHER = new String[]{"TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_MD5"};
    private static final String[] MEDIUM_CIPHER_DH = new String[]{"TLS_DH_anon_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_MD5"};
    private static final String[] HIGH_CIPHER = new String[]{"SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"};
    private static final String[] HIGH_CIPHER_DH = new String[]{"SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"};

    private static String[] getLowCipher(boolean loadDH) {
        if (loadDH) {
            return LOW_CIPHER_DH;
        }
        return LOW_CIPHER;
    }

    private static String[] getMediumCipher(boolean loadDH) {
        if (loadDH) {
            return MEDIUM_CIPHER_DH;
        }
        return MEDIUM_CIPHER;
    }

    private static String[] getHighCipher(boolean loadDH) {
        if (loadDH) {
            return HIGH_CIPHER_DH;
        }
        return HIGH_CIPHER;
    }

    private static String[] getAllCipher(boolean loadDH) {
        if (loadDH) {
            String[] all = new String[HIGH_CIPHER_DH.length + MEDIUM_CIPHER_DH.length + LOW_CIPHER_DH.length];
            System.arraycopy(HIGH_CIPHER_DH, 0, all, 0, HIGH_CIPHER_DH.length);
            System.arraycopy(MEDIUM_CIPHER_DH, 0, all, HIGH_CIPHER_DH.length, MEDIUM_CIPHER_DH.length);
            System.arraycopy(LOW_CIPHER_DH, 0, all, HIGH_CIPHER_DH.length + MEDIUM_CIPHER_DH.length, LOW_CIPHER_DH.length);
            return all;
        }
        String[] all = new String[HIGH_CIPHER.length + MEDIUM_CIPHER.length + LOW_CIPHER.length];
        System.arraycopy(HIGH_CIPHER, 0, all, 0, HIGH_CIPHER.length);
        System.arraycopy(MEDIUM_CIPHER, 0, all, HIGH_CIPHER.length, MEDIUM_CIPHER.length);
        System.arraycopy(LOW_CIPHER, 0, all, HIGH_CIPHER.length + MEDIUM_CIPHER.length, LOW_CIPHER.length);
        return all;
    }

    public static String[] getCipherList(String level, boolean loadDH) {
        if (LOW.equals(level)) {
            return CipherMapping.getLowCipher(loadDH);
        }
        if (MEDIUM.equals(level)) {
            return CipherMapping.getMediumCipher(loadDH);
        }
        if (HIGH.equals(level)) {
            return CipherMapping.getHighCipher(loadDH);
        }
        return CipherMapping.getAllCipher(loadDH);
    }
}

