/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc.mrb;

import com.swimap.base.rpc.cdr.CDR;
import imap.iMAPcommon.InParamSeqHolder;
import imap.iMAPcommon.OutParamSeq;
import imap.iMAPcommon.OutParamSeqHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.omg.CORBA.portable.Streamable;

public class MRBContext {
    private boolean bigEndian;
    private InParamSeqHolder inArguments = new InParamSeqHolder();
    private OutParamSeqHolder outArguments = new OutParamSeqHolder(new OutParamSeq());
    private Map<Integer, byte[]> outParaMap = new ConcurrentHashMap<Integer, byte[]>();
    private int outLength = 0;

    public MRBContext(byte[] data) {
        if (data != null && data.length != 0) {
            this.inArguments = new InParamSeqHolder();
            this.bigEndian = CDR.decode(data, (Streamable)this.inArguments);
        }
    }

    public void returnOutParameter(int index, Streamable holder) {
        if (holder != null) {
            this.outParaMap.put(index, CDR.encodeWithoutByteOrder(holder));
        }
    }

    public void returnResultParameter(Streamable resultHolder) {
        this.outArguments.value.result = CDR.encodeWithoutByteOrder(resultHolder);
    }

    public void setOutParameterLength(int length) {
        this.outLength = length;
    }

    public byte[] getOutData() {
        byte[][] paras = new byte[this.outLength][];
        byte[] tmp = null;
        for (int j = 0; j < this.outLength; ++j) {
            tmp = this.outParaMap.get(j);
            paras[j] = tmp != null ? tmp : new byte[0];
        }
        this.outArguments.value.paramSeq = paras;
        if (this.outArguments.value.paramSeq != null) {
            if (this.outArguments.value.result == null) {
                this.outArguments.value.result = new byte[0];
            }
            return CDR.encode((Streamable)this.outArguments);
        }
        return null;
    }

    public int getInCount() {
        if (this.inArguments != null) {
            return this.inArguments.value.length;
        }
        return 0;
    }

    public int getOutCount() {
        if (this.inArguments != null) {
            return this.outArguments.value.paramSeq.length;
        }
        return 0;
    }

    public void get(int index, Streamable holder) {
        if (this.inArguments != null) {
            CDR.decode(this.inArguments.value[index], holder, this.bigEndian);
        }
    }
}

