/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc.mrb;

import com.swimap.base.rpc.mdp.MDP;
import com.swimap.base.rpc.mdp.MDPSocketClient;
import com.swimap.external.dsf.base.rpc.cdr.CdrArguments;
import com.swimap.external.dsf.base.rpc.mdp.IAsyncHandler;
import com.swimap.external.dsf.base.rpc.mdp.MDPError;
import com.swimap.external.dsf.base.rpc.mrb.CdrResponse;
import javax.net.ssl.SSLContext;
import org.omg.CORBA.portable.Streamable;

public class MRB {
    public MDP mdp;
    private static MRB instance;
    private static final byte MRB_COMM_FLG = 16;

    MRB(MDP mdp) {
        this.mdp = mdp;
        MRB mRB = this;
        MDPSocketClient mdpClient = mRB.mdp.getSocketClient();
        mdpClient.setCommFlag((byte)16);
    }

    public static MRB createInstance(String url) throws Exception {
        MDP mdp = MDP.createInstance(url);
        return new MRB(mdp);
    }

    public static MRB createInstance(String url, SSLContext sslContext) throws Exception {
        MDP mdp = MDP.createInstance(url, sslContext);
        return new MRB(mdp);
    }

    public static void setDefault(MRB mrb) {
        instance = mrb;
    }

    public static MRB getDefault() {
        return instance;
    }

    public void tryConnect(int timeout) throws Exception {
        this.mdp.tryConnect(timeout);
    }

    public void setTimeout(int timeout) {
        this.mdp.setTimeout(timeout);
    }

    public int getTimeout() {
        return this.mdp.getTimeout();
    }

    public String getURL() {
        return this.mdp.getURL();
    }

    public CdrResponse invoke(int pid, int mid, int cmdCode, Streamable ... inArgs) throws MDPError {
        byte[] rsp = this.mdp.invoke(pid, mid, cmdCode, new CdrArguments(inArgs).encode());
        return new CdrResponse(rsp);
    }

    public CdrResponse invoke(String service, int cmdCode, Streamable ... inArgs) throws MDPError {
        return this.invoke(service, cmdCode, new CdrArguments(inArgs));
    }

    public CdrResponse invoke(int timeout, String service, int cmdCode, Streamable ... inArgs) throws MDPError {
        return this.invoke(timeout, service, cmdCode, new CdrArguments(inArgs));
    }

    public CdrResponse invoke(String service, int cmdCode, CdrArguments args) throws MDPError {
        byte[] rsp = this.mdp.invoke(service, cmdCode, args.encode());
        return new CdrResponse(rsp);
    }

    public CdrResponse invoke(int timeout, String service, int cmdCode, CdrArguments args) throws MDPError {
        byte[] rsp = this.mdp.invoke(service, cmdCode, args.encode(), timeout);
        return new CdrResponse(rsp);
    }

    public char asyncInvoke(IAsyncHandler handler, String service, int cmdCode, Streamable ... inArgs) {
        return this.asyncInvoke(handler, service, cmdCode, new CdrArguments(inArgs));
    }

    public char asyncInvoke(int timeout, IAsyncHandler handler, String service, int cmdCode, Streamable ... inArgs) {
        return this.asyncInvoke(timeout, handler, service, cmdCode, new CdrArguments(inArgs));
    }

    public char asyncInvoke(IAsyncHandler handler, String service, int cmdCode, CdrArguments args) {
        return this.mdp.asyncInvoke(handler, service, cmdCode, args.encode());
    }

    public char asyncInvoke(int timeout, IAsyncHandler handler, String service, int cmdCode, CdrArguments args) {
        return this.mdp.asyncInvoke(handler, service, cmdCode, args.encode(), timeout);
    }

    public char asyncInvoke(IAsyncHandler handler, int pid, int mid, int cmdCode, Streamable ... inArgs) {
        return this.mdp.asyncInvoke(handler, pid, mid, cmdCode, new CdrArguments(inArgs).encode());
    }

    public char asyncInvoke(int timeout, IAsyncHandler handler, int pid, int mid, int cmdCode, Streamable ... inArgs) {
        return this.mdp.asyncInvoke(handler, pid, mid, cmdCode, new CdrArguments(inArgs).encode(), timeout);
    }

    public void close() {
        this.mdp.close();
        this.mdp = null;
    }
}

