/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc.mrb;

import com.swimap.base.rpc.cdr.CDR;
import imap.iMAPcommon.OutParamSeq;
import imap.iMAPcommon.OutParamSeqHolder;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.portable.Streamable;

public class CdrResponse {
    private boolean bigEndian;
    private OutParamSeqHolder dataHolder;

    public CdrResponse(byte[] data) {
        if (data != null) {
            this.dataHolder = new OutParamSeqHolder();
            this.bigEndian = CDR.decode(data, (Streamable)this.dataHolder);
        }
    }

    public CdrResponse(Streamable result, Streamable ... outArgs) {
        this.dataHolder = new OutParamSeqHolder(new OutParamSeq());
        this.dataHolder.value.result = CDR.encodeWithoutByteOrder(result);
        byte[][] paras = new byte[outArgs.length][];
        int i = 0;
        for (Streamable arg : outArgs) {
            paras[i++] = CDR.encodeWithoutByteOrder(arg);
        }
        this.dataHolder.value.paramSeq = paras;
        this.bigEndian = true;
    }

    public void getResult(Streamable holder) throws Exception {
        if (this.dataHolder != null) {
            CDR.decode(this.dataHolder.value.result, holder, this.bigEndian);
        }
    }

    public void getOutput(int index, Streamable holder) throws Exception {
        if (this.dataHolder != null) {
            CDR.decode(this.dataHolder.value.paramSeq[index], holder, this.bigEndian);
        }
    }

    public int getOutputCount() {
        if (this.dataHolder != null) {
            return this.dataHolder.value.paramSeq.length;
        }
        return 0;
    }

    public byte[] encode() {
        if (this.dataHolder != null) {
            return CDR.encode((Streamable)this.dataHolder);
        }
        return null;
    }

    public int getErrorCode() {
        IntHolder errorCode = new IntHolder();
        CDR.decode(this.dataHolder.value.result, (Streamable)errorCode, this.bigEndian);
        return errorCode.value;
    }

    public OutParamSeqHolder getData() {
        return this.dataHolder;
    }
}

