/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc.mdp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MessageHeader {
    public static final byte COMPRESSFLAG = 8;
    public static final byte ASNREQUEST = 0;
    public static final byte CDREQUEST = 16;
    public static final byte HASAPPENDEX = 4;
    public static final int HEAD_LEN = 43;
    static final int PROTOCOL_COMMON = 10;
    static final int PROTOCOL_EXT = 11;
    static final int RESERVED_LEN = 8;
    static final int MODULE_LEN = 2;
    public byte version = (byte)10;
    public char senderDeskID;
    public char receiverDeskID;
    public char senderProcHandle;
    public char receiverProcHandle;
    public char senderProcID;
    public char receiverProcID;
    public int cmdCode;
    public byte msgType;
    public char errCode;
    public byte commFlag;
    public byte[] reserved = new byte[8];
    public char senderCmdHandle;
    public char cmdHandle;
    public int contentLength;
    public byte senderModule;
    public byte receiverModule;
    public boolean localMrbFlag = false;
    public int appendixLength = 0;
    public byte[] appendix = new byte[0];
    public boolean hasAppendix = false;

    public void writeTo(DataOutputStream out) throws IOException {
        out.writeByte(this.version);
        out.writeInt(0);
        out.writeChar(this.senderDeskID);
        out.writeChar(this.receiverDeskID);
        out.writeChar(this.senderProcHandle);
        out.writeChar(this.receiverProcHandle);
        out.writeChar(this.senderProcID);
        out.writeChar(this.receiverProcID);
        out.writeInt(this.cmdCode);
        out.writeByte(this.msgType);
        out.writeChar(this.errCode);
        out.writeByte(this.commFlag);
        out.write(this.reserved);
        out.writeChar(this.senderCmdHandle);
        out.writeChar(this.cmdHandle);
        out.writeInt(this.contentLength + 2);
        out.writeByte(this.senderModule);
        out.writeByte(this.receiverModule);
    }

    public void readFrom(DataInputStream in) throws IOException {
        this.version = in.readByte();
        in.skip(4L);
        this.senderDeskID = in.readChar();
        this.receiverDeskID = in.readChar();
        this.senderProcHandle = in.readChar();
        this.receiverProcHandle = in.readChar();
        this.senderProcID = in.readChar();
        this.receiverProcID = in.readChar();
        this.cmdCode = in.readInt();
        this.msgType = in.readByte();
        this.errCode = in.readChar();
        this.commFlag = in.readByte();
        in.readFully(this.reserved);
        this.senderCmdHandle = in.readChar();
        this.cmdHandle = in.readChar();
        this.hasAppendix = this.hasAppendex();
        if (this.hasAppendix) {
            this.appendixLength = this.getAppendixLength(this.reserved);
            this.appendix = new byte[this.appendixLength];
        }
        this.contentLength = in.readInt() - 2 - this.appendixLength;
        this.senderModule = in.readByte();
        this.receiverModule = in.readByte();
        if (this.hasAppendix) {
            in.readFully(this.appendix);
        }
    }

    private int getAppendixLength(byte[] reserved) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(reserved));
        char sn = in.readChar();
        char length = in.readChar();
        return length;
    }

    public boolean isCompressData() {
        int result = this.commFlag & 8;
        return result == 8;
    }

    public boolean isAsnRequest() {
        int result = this.commFlag & 0x10;
        return result == 0;
    }

    public boolean isCdrRequest() {
        int result = this.commFlag & 0x10;
        return result == 16;
    }

    public boolean hasAppendex() {
        int result = this.commFlag & 4;
        return result == 4;
    }

    public String toString() {
        return "VER= " + this.version + ", SDID=" + this.senderDeskID + ", RDID=" + this.receiverDeskID + ", SPH=" + this.senderProcHandle + ", RPH=" + this.receiverProcHandle + ", SPID=" + this.senderProcID + ", RPID=" + this.receiverProcID + ", CCODE=" + this.cmdCode + ", MTYPE=" + this.msgType + ", ERROR=" + this.errCode + ", CFLAG=" + this.commFlag + ", RSVD={" + this.getReservedString() + '}' + ", SSN=" + this.senderCmdHandle + ", RSN=" + this.cmdHandle + ", LEN=" + this.contentLength + ", SMID=" + this.senderModule + ", RMID=" + this.receiverModule;
    }

    private String getReservedString() {
        StringBuilder sb = new StringBuilder();
        for (byte b : this.reserved) {
            sb.append(b);
            sb.append(',');
        }
        return sb.toString();
    }
}

