/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc.em;

import org.omg.CosNotification.EventType;

public class EventClassType {
    private String sourceClass = "*";
    private String eventType = "*";
    public static final String PARA_NAME_SOURCECLASS = "__sourceclass";
    public static final String PARA_NAME_EVENTTYPE = "__eventtype";
    public static final String LOCAL_EVENT_PREFIX = "local";

    public EventClassType(String sourceClass, String eventType) {
        this.sourceClass = sourceClass;
        this.eventType = eventType;
    }

    public String getSourceClass() {
        return this.sourceClass;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getStringEventType() {
        return this.sourceClass + "." + this.eventType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = 31 * result + (this.sourceClass == null ? 0 : this.sourceClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventClassType other = (EventClassType)obj;
        if (this.eventType == null ? other.eventType != null : !this.eventType.equals(other.eventType)) {
            return false;
        }
        return !(this.sourceClass == null ? other.sourceClass != null : !this.sourceClass.equals(other.sourceClass));
    }

    public String toString() {
        return String.format("EventClassType sourceClass=%s, eventType=%s ", this.sourceClass, this.eventType);
    }

    public static String[] getEventType(String eventType) {
        String sourceClass = "*";
        String type = "*";
        int dotIndex = eventType.indexOf(46);
        if (dotIndex != -1) {
            sourceClass = eventType.substring(0, dotIndex);
            if ("".equals(sourceClass)) {
                sourceClass = "*";
            }
            if ("".equals(type = eventType.substring(dotIndex + 1))) {
                type = "*";
            }
        } else if ("".equals(eventType)) {
            sourceClass = "*";
            type = "*";
        } else {
            sourceClass = eventType;
        }
        return new String[]{sourceClass, type};
    }

    public static EventClassType createByEventType(String eventType) {
        String[] array = EventClassType.getEventType(eventType);
        return new EventClassType(array[0], array[1]);
    }

    public static EventClassType createBySourceType(String sourceClass, String eventType) {
        return new EventClassType(sourceClass, eventType);
    }

    public static EventType getCdrEventType(String eventType) {
        EventClassType eventClassType = EventClassType.createByEventType(eventType);
        return new EventType(eventClassType.getSourceClass(), eventClassType.getEventType());
    }

    public static EventType getCdrEventType(EventClassType eventType) {
        return new EventType(eventType.getSourceClass(), eventType.getEventType());
    }

    public boolean isLocalEvent() {
        return this.sourceClass != null && this.sourceClass.startsWith(LOCAL_EVENT_PREFIX);
    }
}

