/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc.cdr;

import com.swimap.base.rpc.cdr.CDR;
import com.swimap.external.dsf.base.rpc.em.EventClassType;
import org.omg.CORBA.Any;
import org.omg.CORBA.portable.Streamable;
import org.omg.CosNotification.EventHeader;
import org.omg.CosNotification.FixedEventHeader;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.StructuredEventHolder;

public class CdrEvent {
    private static final String EVENT_PARTITION = "Partition";
    private StructuredEvent event;

    public CdrEvent(String eventType) {
        this(EventClassType.createByEventType(eventType));
    }

    public CdrEvent(EventClassType eventType) {
        this.event = new StructuredEvent();
        this.event.header = new EventHeader();
        this.event.header.fixed_header = new FixedEventHeader();
        this.event.header.fixed_header.event_name = "";
        this.event.header.fixed_header.event_type = EventClassType.getCdrEventType(eventType);
        this.event.header.variable_header = new Property[0];
        this.event.filterable_data = new Property[1];
        this.event.filterable_data[0] = new Property();
        this.event.filterable_data[0].name = EVENT_PARTITION;
        this.event.filterable_data[0].value = CDR.createAny();
        this.event.filterable_data[0].value.insert_long(0);
        this.event.remainder_of_body = CDR.createAny();
    }

    private CdrEvent(StructuredEvent event) {
        this.event = event;
    }

    public CdrEvent CopyCdrEvent(String eventType) {
        FixedEventHeader fixedHeader;
        StructuredEvent obj = new StructuredEvent();
        EventHeader header = new EventHeader();
        header.fixed_header = fixedHeader = new FixedEventHeader();
        header.variable_header = this.event.header.variable_header;
        fixedHeader.event_name = this.event.header.fixed_header.event_name;
        fixedHeader.event_type = EventClassType.getCdrEventType(eventType);
        obj.header = header;
        obj.filterable_data = this.event.filterable_data;
        obj.remainder_of_body = this.event.remainder_of_body;
        return new CdrEvent(obj);
    }

    public static CdrEvent decode(byte[] buf) throws Exception {
        StructuredEventHolder holder = new StructuredEventHolder();
        CDR.decode(buf, (Streamable)holder);
        return new CdrEvent(holder.value);
    }

    public byte[] encode() {
        StructuredEventHolder holder = new StructuredEventHolder(this.event);
        return CDR.encode((Streamable)holder);
    }

    public String getType() {
        return this.getSourceClass() + '.' + this.getTypeName();
    }

    public EventClassType getEventClassType() {
        return new EventClassType(this.getSourceClass(), this.getTypeName());
    }

    public String getSourceClass() {
        return this.event.header.fixed_header.event_type.domain_name;
    }

    public String getTypeName() {
        return this.event.header.fixed_header.event_type.type_name;
    }

    public void setPartition(int value) {
        this.event.filterable_data[0] = new Property();
        this.event.filterable_data[0].name = EVENT_PARTITION;
        this.event.filterable_data[0].value = CDR.createAny();
        this.event.filterable_data[0].value.insert_long(value);
    }

    public int getPartition() {
        if (this.event == null || this.event.filterable_data == null || this.event.filterable_data.length == 0) {
            return 0;
        }
        return this.event.filterable_data[0].value.extract_long();
    }

    public void setAttribute(int index, String name, Any value) {
        this.event.filterable_data[index + 1].name = name;
        this.event.filterable_data[index + 1].value = value;
    }

    public Any getAttribute(String name) {
        if (this.event == null || this.event.filterable_data == null) {
            return null;
        }
        for (Property p : this.event.filterable_data) {
            if (!p.name.equals(name)) continue;
            return p.value;
        }
        return null;
    }

    public Any getAttribute(int index) {
        if (this.event == null || this.event.filterable_data == null || ++index < 0 || index >= this.event.filterable_data.length) {
            return null;
        }
        return this.event.filterable_data[index].value;
    }

    public String getAttributeName(int index) {
        if (this.event == null || this.event.filterable_data == null || ++index < 0 || index >= this.event.filterable_data.length) {
            return null;
        }
        return this.event.filterable_data[index].name;
    }

    public void setAttributeCount(int count) {
        if (this.event == null || this.event.filterable_data == null) {
            return;
        }
        Property partition = this.event.filterable_data[0];
        this.event.filterable_data = new Property[count + 1];
        this.event.filterable_data[0] = partition;
        Property p = null;
        for (int i = 0; i < count; ++i) {
            p = new Property();
            p.name = "attr" + i;
            p.value = CDR.createAny();
            this.event.filterable_data[i + 1] = p;
        }
    }

    public int getAttributeCount() {
        if (this.event == null || this.event.filterable_data == null) {
            return 0;
        }
        return this.event.filterable_data.length - 1;
    }

    public String toString() {
        return this.event.header.fixed_header.event_type.domain_name + '.' + this.event.header.fixed_header.event_type.type_name + " {\n" + this.attrToString() + "}\n";
    }

    private String attrToString() {
        Property[] properties;
        StringBuilder sb = new StringBuilder();
        for (Property property : properties = this.event.filterable_data) {
            sb.append(property.name);
            sb.append(" : ");
            sb.append(CDR.anyToString(property.value, true));
            sb.append("\n");
        }
        return sb.toString();
    }
}

