/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc;

import com.swimap.base.rpc.RpcRegister;
import com.swimap.base.rpc.RpcServerPushDispatcher;
import com.swimap.base.rpc.RpcServerPushHandlerProxy;
import com.swimap.base.rpc.RpcSessionClientIDPairs;
import com.swimap.base.rpc.RpcSocketPDU;
import com.swimap.base.rpc.nio.Client;
import com.swimap.base.rpc.nio.Clients;
import com.swimap.base.rpc.nio.ISocketPDU;
import com.swimap.base.rpc.nio.ServerPush;
import com.swimap.external.dsf.base.rpc.Rpc;
import com.swimap.external.dsf.base.rpc.RpcContext;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcServerPushHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcServerPush {
    public static final String ALL_EVENT = "";
    private static final String SERVICE_NAME = "ServerPush";
    private static final String METHOD_NAME = "push";
    private static final String SERVICE_PATH = "/ServerPush/push";
    private static Log log = LogFactory.getLog(RpcServerPush.class);
    private static Receiver receiver;

    public static void push(long clientID, RpcEvent event) throws ClientNotFound {
        Client client = Clients.getClient(clientID);
        if (client == null) {
            ClientNotFound notFound = new ClientNotFound(clientID);
            log.warn((Object)notFound);
            throw notFound;
        }
        RpcSocketPDU pdu = new RpcSocketPDU(4, SERVICE_PATH, event.getMessage());
        ServerPush.push(client, (ISocketPDU)pdu);
    }

    public static void push(long[] clients, RpcEvent event) throws RpcError {
        StringBuilder failClientIds = new StringBuilder();
        for (long clientID : clients) {
            try {
                RpcServerPush.push(clientID, event);
            }
            catch (ClientNotFound e) {
                failClientIds.append(clientID).append(",");
            }
        }
        if (failClientIds.length() > 0) {
            throw new RpcError("Not all push event success., eventType=" + event.getType() + ", fail push[" + failClientIds.toString() + "]");
        }
    }

    public static void push(Iterable<Long> clients, RpcEvent event) throws RpcError {
        StringBuilder failClientIds = new StringBuilder();
        for (long clientID : clients) {
            try {
                RpcServerPush.push(clientID, event);
            }
            catch (Exception e) {
                failClientIds.append(clientID).append(",");
            }
        }
        if (failClientIds.length() > 0) {
            throw new RpcError("Not all push event success., eventType=" + event.getType() + ", fail push[" + failClientIds.toString() + "]");
        }
    }

    public static void push(int sessionID, RpcEvent event) throws ClientNotFound {
        Long clientID = RpcSessionClientIDPairs.getClientID(sessionID);
        if (clientID == null) {
            throw new ClientNotFound("can't found matching clientID");
        }
        RpcServerPush.push(clientID, event);
    }

    public static void push(Integer[] sessions, RpcEvent event) throws RpcError {
        StringBuilder failSessionIds = new StringBuilder();
        for (Integer session : sessions) {
            try {
                RpcServerPush.push(session, event);
            }
            catch (Exception e) {
                failSessionIds.append(session).append(",");
            }
        }
        if (failSessionIds.length() > 0) {
            throw new RpcError("Not all push event success., eventType=" + event.getType() + ", fail push sessionIds [" + failSessionIds.toString() + "]");
        }
    }

    public static void broadcast(RpcEvent event) {
        RpcSocketPDU pdu = new RpcSocketPDU(4, SERVICE_PATH, event.getMessage());
        ServerPush.broadcast(pdu);
        RpcServerPush.getReceiver().receivePushEvent(new RpcContext(null, null, event.getMessage()));
    }

    public static void addHandler(String event, RpcServerPushHandler handler) {
        if (handler != null) {
            RpcServerPush.getReceiver().addHandler(event, handler);
        }
    }

    public static void addHandler(String[] event, RpcServerPushHandler handler) {
        if (handler != null) {
            RpcServerPush.getReceiver().addHandler(event, handler);
        }
    }

    public static void removeHandler(RpcServerPushHandler handler) {
        if (handler != null) {
            RpcServerPush.getReceiver().removeHandler(handler);
        }
    }

    public static synchronized Receiver getReceiver() {
        if (receiver == null) {
            receiver = new Receiver();
            try {
                RpcRegister.add(receiver);
            }
            catch (Exception e) {
                log.fatal((Object)"Init Server Push Receiver failed!", (Throwable)e);
            }
        }
        return receiver;
    }

    @Rpc(name="ServerPush")
    public static class Receiver {
        private final Map<String, Set<RpcServerPushHandlerProxy>> handlers = new ConcurrentHashMap<String, Set<RpcServerPushHandlerProxy>>();
        private final Set<RpcServerPushHandlerProxy> HandlersForAll = new HashSet<RpcServerPushHandlerProxy>();
        private RpcServerPushDispatcher dispatcher;
        private AtomicInteger count = new AtomicInteger();

        public void start() {
            if (this.dispatcher == null) {
                this.dispatcher = RpcServerPushDispatcher.getInstance();
                this.dispatcher.start();
            }
        }

        public void stop() {
            if (this.dispatcher != null) {
                this.dispatcher.stop();
            }
        }

        @Rpc(name="push")
        public void receivePushEvent(RpcContext ctx) {
            RpcEvent event = new RpcEvent(ctx.getMessage());
            Set<RpcServerPushHandlerProxy> Handlers = this.handlers.get(event.getType());
            if (Handlers != null) {
                this.dispatchEvent(event, Handlers);
            }
            this.dispatchEvent(event, this.HandlersForAll);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchEvent(RpcEvent event, Set<RpcServerPushHandlerProxy> handlers) {
            Set<RpcServerPushHandlerProxy> set = handlers;
            synchronized (set) {
                for (RpcServerPushHandlerProxy proxy : handlers) {
                    proxy.receive(event);
                }
            }
        }

        void addHandler(String eventType, RpcServerPushHandler handler) {
            String[] temp = new String[]{eventType};
            this.addHandler(temp, handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addHandler(String[] eventType, RpcServerPushHandler handler) {
            int n;
            boolean isAll = false;
            for (String tempType : eventType) {
                if (tempType != null && !tempType.equals(RpcServerPush.ALL_EVENT)) continue;
                Set<RpcServerPushHandlerProxy> set = this.HandlersForAll;
                synchronized (set) {
                    this.HandlersForAll.add(new RpcServerPushHandlerProxy(eventType, handler));
                }
                isAll = true;
                break;
            }
            if (!isAll) {
                Map<String, Set<RpcServerPushHandlerProxy>> map = this.handlers;
                synchronized (map) {
                    RpcServerPushHandlerProxy rpcProxy = new RpcServerPushHandlerProxy(eventType, handler);
                    for (String temp : eventType) {
                        Set<RpcServerPushHandlerProxy> val = this.handlers.get(temp);
                        if (val == null) {
                            val = new HashSet<RpcServerPushHandlerProxy>();
                            this.handlers.put(temp, val);
                        }
                        val.add(rpcProxy);
                    }
                }
            }
            if ((n = this.count.incrementAndGet()) > 50) {
                log.warn((Object)("ServerPush handler 50 too much {" + this + "}"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeHandler(RpcServerPushHandler handler) {
            Collection<Set<RpcServerPushHandlerProxy>> sets;
            Set<RpcServerPushHandlerProxy> set = this.HandlersForAll;
            synchronized (set) {
                RpcServerPushHandlerProxy proxy = null;
                Iterator<RpcServerPushHandlerProxy> it = this.HandlersForAll.iterator();
                while (it.hasNext()) {
                    proxy = it.next();
                    if (!proxy.getRpcServerPushHandler().equals(handler)) continue;
                    it.remove();
                    if (proxy == null) continue;
                    proxy.clear();
                }
            }
            Collection<Set<RpcServerPushHandlerProxy>> collection = sets = this.handlers.values();
            synchronized (collection) {
                RpcServerPushHandlerProxy proxy = null;
                Iterator<RpcServerPushHandlerProxy> it = null;
                for (Set<RpcServerPushHandlerProxy> proxys : sets) {
                    it = proxys.iterator();
                    while (it.hasNext()) {
                        proxy = it.next();
                        if (!proxy.getRpcServerPushHandler().equals(handler)) continue;
                        it.remove();
                        if (proxy == null) continue;
                        proxy.clear();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            RpcServerPushHandlerProxy proxy2;
            StringBuilder buf = new StringBuilder();
            Object object = this.handlers;
            synchronized (object) {
                proxy2 = null;
                Iterator<RpcServerPushHandlerProxy> it = null;
                for (Set<RpcServerPushHandlerProxy> proxys : this.handlers.values()) {
                    for (RpcServerPushHandlerProxy proxy2 : proxys) {
                        buf.append(proxy2.getRpcServerPushHandler().getClass()).append('=');
                        buf.append(proxy2.getEventListSize()).append(';');
                    }
                }
            }
            object = this.HandlersForAll;
            synchronized (object) {
                proxy2 = null;
                for (RpcServerPushHandlerProxy proxy2 : this.HandlersForAll) {
                    buf.append(proxy2.getRpcServerPushHandler().getClass()).append('=');
                    buf.append(proxy2.getEventListSize()).append(';');
                }
            }
            return buf.toString();
        }
    }

    public static class ClientNotFound
    extends Exception {
        private long clientID;

        public ClientNotFound(long clientID) {
            super("client id = " + clientID);
            this.clientID = clientID;
        }

        public ClientNotFound(String msg) {
            super(msg);
        }

        public long getClientID() {
            return this.clientID;
        }
    }
}

