/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc;

import com.swimap.base.rpc.BinHelper;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import java.io.InputStream;

public class RpcResponse {
    private RpcMessage message;

    RpcResponse(InputStream stream) throws Exception {
        this.message = BinHelper.parseMessage(stream);
        this.checkError(this.message);
    }

    public RpcResponse(RpcMessage message) throws Exception {
        this.checkError(message);
        this.message = message;
    }

    private void checkError(RpcMessage message) throws Exception {
        if (message.getType().equals("exception")) {
            throw message.toException();
        }
    }

    public RpcMessage getMessage() {
        return this.message;
    }

    public int getInternalErrorCode() {
        if (null != this.getMessage().getString("com.swimap.base.rpc.internal.error.code")) {
            return this.getMessage().getInt("com.swimap.base.rpc.internal.error.code");
        }
        return 0;
    }

    public String getInternalErrorDesc() {
        return this.getMessage().getString("com.swimap.base.rpc.internal.error.DESC");
    }
}

