/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc;

import com.swimap.base.rpc.HttpsSocketFactory;
import com.swimap.base.rpc.RpcErrorVerUnMatch;
import com.swimap.base.rpc.RpcInvoker;
import com.swimap.base.rpc.RpcMessageRequestEntity;
import com.swimap.base.rpc.RpcRegister;
import com.swimap.base.rpc.RpcRegisterItem;
import com.swimap.base.rpc.RpcRetryHandler;
import com.swimap.base.rpc.RpcServer;
import com.swimap.base.rpc.RpcSocketClient;
import com.swimap.external.dsf.base.rpc.Base64;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcContext;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcErrorMethodNotFound;
import com.swimap.external.dsf.base.rpc.RpcErrorTimeout;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequestFactory;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcRequest {
    private static final int MAX_CONNECTION_PER_HOST = 6;
    private static Log log = LogFactory.getLog(RpcRequest.class);
    private static final int DEFAULT_REQUEST_TIMEOUT = 180000;
    private static final String CONTENT_CHARSET = "UTF-8";
    private static final int CONNECTION_TIMEOUT = 10000;
    private static MultiThreadedHttpConnectionManager connectionManager;
    private static HttpClient httpClient;
    private static RpcRequestFactory factory;
    private static RpcSocketClient socketClient;
    private static String currentSession;
    private String url;
    private SSLContext sslContext;
    private int timeout;
    private RpcMessage message = new RpcMessage("request");

    public static void setFactory(RpcRequestFactory factory) {
        RpcRequest.factory = factory;
    }

    public static boolean hasFactory() {
        return factory != null;
    }

    public static RpcRequest create(String url) {
        if (factory != null) {
            return factory.create(url);
        }
        return new RpcRequest(url);
    }

    public static RpcRequest create(String url, SSLContext context) {
        if (factory != null) {
            return factory.create(url, context);
        }
        return new RpcRequest(url, context);
    }

    public static RpcRequest create(String serviceLocation, String methodName) {
        return RpcRequest.create(serviceLocation + '/' + methodName);
    }

    public static RpcRequest create(String serviceLocation, String methodName, SSLContext context) {
        return RpcRequest.create(serviceLocation + '/' + methodName, context);
    }

    public static void setCurrentSession(String session) {
        currentSession = session;
    }

    public static void setCurrentSession(byte[] session) {
        currentSession = Base64.encode(session);
    }

    private RpcRequest(String url) {
        this.url = url;
        this.setTimeout(180000);
        if (currentSession != null) {
            this.setSessionId(currentSession);
        }
    }

    private RpcRequest(String url, SSLContext sslContext) {
        this.url = url;
        this.sslContext = sslContext;
        this.setTimeout(180000);
        if (currentSession != null) {
            this.setSessionId(currentSession);
        }
    }

    public RpcRequest() {
        throw new IllegalAccessError("an internal constructor called.");
    }

    public RpcRequest arg(String name, Object value) {
        this.addArgument(name, value);
        return this;
    }

    public RpcRequest table(DataTable table) {
        this.addTable(table);
        return this;
    }

    public void addTable(DataTable table) {
        this.message.addTable(table);
    }

    public void addArgument(String name, Object value) {
        this.message.addParameter(name, value);
    }

    public void addAttachement(String name, byte[] data) {
        this.message.addAttachment(name, data);
    }

    protected static synchronized HttpClient getHttpClient() {
        if (httpClient == null) {
            Protocol https = new Protocol("https", (ProtocolSocketFactory)new HttpsSocketFactory(), 443);
            Protocol.registerProtocol((String)"https", (Protocol)https);
            connectionManager = new MultiThreadedHttpConnectionManager();
            connectionManager.getParams().setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, 6);
            httpClient = new HttpClient((HttpConnectionManager)connectionManager);
            httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            httpClient.getParams().setParameter("http.connection.timeout", (Object)10000);
            httpClient.getParams().setParameter("http.protocol.content-charset", (Object)CONTENT_CHARSET);
            httpClient.getParams().setParameter("http.connection.stalecheck", (Object)false);
            httpClient.getParams().setParameter("http.method.retry-handler", (Object)new RpcRetryHandler());
            httpClient.getParams().setParameter("http.socket.receivebuffer", (Object)32768);
            httpClient.getParams().setParameter("http.socket.sendbuffer", (Object)32768);
            httpClient.getParams().setParameter("http.tcp.nodelay", (Object)true);
        }
        return httpClient;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public static void setStaleCheck(boolean staleCheck) {
        RpcRequest.getHttpClient().getParams().setParameter("http.connection.stalecheck", (Object)staleCheck);
    }

    public void reset() {
        this.message.clear();
        this.setTimeout(180000);
        if (currentSession != null) {
            this.setSessionId(currentSession);
        }
    }

    public RpcResponse invoke() throws Exception {
        if (this.inSameContainer()) {
            return RpcInvoker.instance.invokeLocally(this);
        }
        return this.remoteInvoke(false);
    }

    boolean inSameContainer() {
        if (this.url.charAt(0) == '/') {
            return true;
        }
        if ("".equals(RpcNaming.instance().getLocalURL())) {
            return false;
        }
        try {
            URI local = new URI(RpcNaming.instance().getLocalURL());
            URI uri = new URI(this.url);
            if (local.getHost().equals(uri.getHost())) {
                int target = uri.getPort();
                List<Integer> ports = RpcServer.getInstance().getOpenPorts();
                for (int port : ports) {
                    if (port != target) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcResponse invokeLocally() throws Exception {
        URI uri = new URI(this.url);
        String path = uri.getPath();
        if (path.startsWith("/api/")) {
            path = path.substring(4);
        }
        RpcMessage msg = this.message.clone();
        RpcRegisterItem call = RpcRegister.instance().getItem(path, msg.getParameterNames());
        if (call == null) {
            if (log.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder(path + '?');
                Set<String> names = msg.getParameterNames();
                for (String name : names) {
                    sb.append(name);
                    sb.append(",");
                }
                log.info((Object)("rcp method not found: " + sb.toString()));
            }
            throw new RpcErrorMethodNotFound(path);
        }
        RpcContext context = new RpcContext(call.getMethod(), path, msg);
        try {
            call.invoke(msg.getParameterMap(), context);
        }
        finally {
            try {
                context.close();
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return new RpcResponse(context.getResponseMessage());
    }

    public void invokeOneway() throws Exception {
        if (this.inSameContainer()) {
            RpcInvoker.instance.invokeLocally(this);
        } else {
            this.remoteInvoke(true);
        }
    }

    public RpcMessage getMessage() {
        return this.message;
    }

    public void setMessage(RpcMessage message) {
        this.message = message;
    }

    public void setSessionId(String sessionId) {
        this.message.setSessionId(sessionId);
    }

    public String getSessionId() {
        return this.message.getSessionId();
    }

    boolean isSupport(String url) throws RpcError {
        if (url.startsWith("tcps") && this.sslContext == null) {
            throw new RpcError("tcps protocol is disable, because SSLContext is null.");
        }
        return url.startsWith("tcp");
    }

    private RpcResponse remoteInvoke(boolean oneway) throws Exception {
        if (this.url.startsWith("http") || this.url.startsWith("https")) {
            return this.httpInvoke(oneway);
        }
        if (this.isSupport(this.url)) {
            return this.socketInvoke(oneway);
        }
        throw new IllegalArgumentException("Unspported protocol: " + this.url);
    }

    private RpcResponse httpInvoke(boolean oneWay) throws Exception {
        PostMethod method = null;
        try {
            method = new PostMethod(this.url);
            method.getParams().setParameter("http.socket.timeout", (Object)this.timeout);
            method.setRequestEntity((RequestEntity)new RpcMessageRequestEntity(this.message));
            RpcRequest.getHttpClient().executeMethod((HttpMethod)method);
            InputStream stream = method.getResponseBodyAsStream();
            if (oneWay) {
                byte[] buf = new byte[1024];
                while (stream.read(buf) >= 0) {
                }
                RpcResponse rpcResponse = null;
                return rpcResponse;
            }
            RpcResponse rpcResponse = new RpcResponse(stream);
            return rpcResponse;
        }
        catch (SocketTimeoutException timeout) {
            throw new RpcErrorTimeout();
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private RpcResponse socketInvoke(boolean oneWay) throws Exception {
        try {
            URI uri = new URI(this.url);
            if (oneWay) {
                RpcRequest.getSocketClient().sendOneway(uri, this.message, this.timeout, this.sslContext);
                return null;
            }
            RpcMessage rsp = RpcRequest.getSocketClient().sendRequest(uri, this.message, this.timeout, this.sslContext);
            return new RpcResponse(rsp);
        }
        catch (SocketTimeoutException timeout) {
            throw new RpcErrorTimeout(timeout);
        }
        catch (RpcErrorVerUnMatch ve) {
            throw ve;
        }
        catch (IOException ioe) {
            RpcError error = new RpcError(ioe);
            error.setErrorCode(101);
            throw error;
        }
    }

    public static synchronized RpcSocketClient getSocketClient() {
        if (socketClient == null) {
            socketClient = new RpcSocketClient();
        }
        return socketClient;
    }

    public static RpcRequest byName(String name) throws Exception {
        return RpcNaming.instance().createRequestByName(name);
    }
}

