/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc;

import com.swimap.base.rpc.InternalErrorUtil;
import com.swimap.base.rpc.RpcNamingCache;
import com.swimap.base.rpc.RpcRegister;
import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.NATUtility;
import com.swimap.external.dsf.base.rpc.Rpc;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcErrorMetMax;
import com.swimap.external.dsf.base.rpc.RpcErrorNameNotFound;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcNaming {
    private static final String METHOD_CLEAR = "clear";
    private static final String VALUE_SEPARATOR = "=";
    private static Log log = LogFactory.getLog(RpcNaming.class);
    public static final String NONE = "";
    public static final String METHOD_REMOVE = "remove";
    public static final String METHOD_REMOVEDEFAULT = "removeDefault";
    public static final String TABLE_NAME = "list";
    public static final String METHOD_FIND = "find";
    public static final String METHOD_GET = "get";
    public static final String METHOD_SET = "set";
    public static final String METHOD_SETDEFAULT = "setDefault";
    public static final String METHOD_iSACTIVE = "isActive";
    public static final String METHOD_CONNECTION_INFO = "getConnectionInfor";
    public static final String PARA_PROTOCOL = "protocol";
    public static final String PARA_CLIENT = "client";
    public static final String PARA_NAME = "name";
    public static final String PARA_VALUE = "value";
    public static final String PARA_IGNORE = "ignore";
    public static final String PROPERTY_NS_LOCATION = "imap.rpc.ns";
    private static final RpcNaming DEFAULT_INSTANCE;
    private static RpcNaming instance;
    private static String namingServiceURL;
    private static String nsContainerURL;
    private static boolean useLocalNaming;
    private static SSLContext sslContext;
    private String localURL = "";

    protected RpcNaming() {
    }

    public static void setInstance(RpcNaming mock) {
        instance = mock == null ? DEFAULT_INSTANCE : mock;
    }

    public static RpcNaming instance() {
        return instance;
    }

    public void setLocalURL(String url) {
        this.localURL = url;
    }

    String getServiceLocation(Object service) {
        if (useLocalNaming) {
            return '/' + RpcRegister.getRpcServicePath(service.getClass());
        }
        return this.localURL + '/' + RpcRegister.getRpcServicePath(service.getClass());
    }

    public String getLocalURL() {
        return this.localURL;
    }

    public void register(String name, Object service) throws Exception {
        RpcRequest req = RpcRequest.create(RpcNaming.getNamingServiceURL(), METHOD_SET, sslContext);
        req.addArgument(PARA_NAME, name);
        req.addArgument(PARA_VALUE, this.getServiceLocation(service));
        req.invoke();
    }

    public void registerDefault(String name, Object service) throws Exception {
        RpcRequest req = RpcRequest.create(RpcNaming.getNamingServiceURL(), METHOD_SETDEFAULT, sslContext);
        req.addArgument(PARA_NAME, name);
        req.addArgument(PARA_VALUE, this.getServiceLocation(service));
        req.invoke();
    }

    public void register(Object service) throws Exception {
        RpcRequest req = RpcRequest.create(RpcNaming.getNamingServiceURL(), METHOD_SET, sslContext);
        req.addArgument(PARA_NAME, RpcNaming.getRpcServiceName(service.getClass()));
        req.addArgument(PARA_VALUE, this.getServiceLocation(service));
        req.invoke();
    }

    public static String getNamingServiceURL() {
        if (namingServiceURL == null) {
            RpcNaming.setNamingServiceURL(System.getProperty(PROPERTY_NS_LOCATION));
        }
        return namingServiceURL;
    }

    public static String getCurrentIp() {
        String ipport;
        String currentIp = null;
        if (namingServiceURL != null && (ipport = namingServiceURL.split("/")[2]) != null) {
            currentIp = ipport.split(":")[0];
        }
        return currentIp;
    }

    public static String getCurrentPort() {
        String ipport;
        String currentPort = null;
        if (namingServiceURL != null && (ipport = namingServiceURL.split("/")[2]) != null) {
            currentPort = ipport.split(":")[1];
        }
        return currentPort;
    }

    public static String getURL() {
        return nsContainerURL;
    }

    public static void setNamingService(String url) throws Exception {
        RpcNaming.setSSLContext(null);
        String freeURL = RpcNaming.tryConnet2DS(url);
        RpcNaming.setNamingServiceURL(freeURL);
    }

    public static void setNamingService(String url, SSLContext sslContext) throws Exception {
        if (url == null || !url.startsWith("tcps") && !url.startsWith("https")) {
            throw new Exception("URL error, prefix must be tcps or https ");
        }
        RpcNaming.setSSLContext(sslContext);
        String freeURL = RpcNaming.tryConnet2DS(url);
        RpcNaming.setNamingServiceURL(freeURL);
    }

    private static void setSSLContext(SSLContext context) {
        sslContext = context;
    }

    private static boolean isURLConnected(URI uri) {
        Socket socket = null;
        boolean isURLConnected = false;
        try {
            socket = new Socket(uri.getHost(), uri.getPort());
            if (socket.isConnected()) {
                isURLConnected = true;
            }
            socket.close();
        }
        catch (Exception e) {
            log.error((Object)e);
            isURLConnected = false;
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        log.warn((Object)("isURLConnected=" + uri + " " + isURLConnected));
        return isURLConnected;
    }

    private static String getFreeURI(String freedsMessage, URI uri) throws URISyntaxException {
        String[] freeURIs;
        for (String uristr : freeURIs = freedsMessage.split(",")) {
            URI freeURI = new URI(uristr);
            log.warn((Object)("getAvailableDS:" + uristr));
            if (freeURI.getHost().equals(uri.getHost()) && freeURI.getPort() == uri.getPort() || !RpcNaming.isURLConnected(freeURI)) continue;
            return uristr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String tryConnet2DS(String url) throws Exception {
        block14: {
            log.info((Object)"getAvailableDS");
            boolean metMax = false;
            URI uri = new URI(url);
            NATUtility.masterIp = uri.getHost();
            try {
                RpcRequest connectionInfoReq = RpcRequest.create(url, METHOD_CONNECTION_INFO, sslContext);
                RpcResponse connectionInfoRsp = connectionInfoReq.invoke();
                if (connectionInfoRsp.getInternalErrorCode() != 0) {
                    InternalErrorUtil.printInternalError("DSF", connectionInfoRsp);
                }
                RpcMessage connectionInfoMSG = connectionInfoRsp.getMessage();
                boolean isMetMax = connectionInfoMSG.getBoolean("isMetMax");
                String[] availableDS = connectionInfoMSG.getStringArray("availableDS");
                if (!isMetMax) break block14;
                metMax = true;
                ArrayList<URI> result = new ArrayList<URI>();
                for (int i = 0; i < availableDS.length; ++i) {
                    if (availableDS[i] == null || availableDS[i].length() == 0) continue;
                    String testUris = null;
                    try {
                        testUris = RpcNaming.appendNATuri(availableDS[i], uri);
                    }
                    catch (Exception e) {
                        log.error((Object)("Get URL met exception for " + availableDS[i]));
                    }
                    if (testUris == null || testUris.length() <= 0) continue;
                    result.add(new URI(testUris));
                }
                throw new RpcErrorMetMax("DS conncetion met the max value", result);
            }
            catch (RpcError e) {
                if (e.getErrorCode() == 101 || e.getErrorCode() == 102 || e.getErrorCode() == 107) {
                    throw e;
                }
                InternalErrorUtil.printInternalError("DSF", e);
            }
            catch (Exception e) {
                log.error((Object)"Get ds connection information", (Throwable)e);
            }
            finally {
                if (metMax && RpcRequest.getSocketClient() != null) {
                    String tempURL = url;
                    if (url.endsWith("/naming")) {
                        tempURL = url.substring(0, url.length() - 7);
                    }
                    RpcRequest.getSocketClient().close(tempURL);
                }
            }
        }
        log.warn((Object)("Available DS obtained finally:-" + url));
        return url;
    }

    private static String appendNATuri(String uriString, URI uri) throws URISyntaxException {
        String tempIp = NONE;
        int port = uri.getPort();
        for (String ip : uriString.split(",")) {
            URI tempURI = new URI(ip);
            tempIp = NATUtility.getValidIpUsageCfg(tempURI.getHost(), uri);
            port = tempURI.getPort();
            if (null != tempIp && tempIp != NONE) {
                log.warn((Object)("dsip obtained using ipusage := " + tempIp));
                break;
            }
            tempIp = NATUtility.getValidIp(tempURI.getHost());
            if (null != tempIp && uriString.contains(tempIp)) {
                tempIp = null;
            }
            if (null == tempIp || tempIp == NONE) continue;
            log.warn((Object)("dsip obtained using xor:" + tempIp));
            break;
        }
        if (null == tempIp) {
            return uriString;
        }
        URI appendUri = new URI(uri.getScheme(), null, tempIp, port, uri.getPath(), null, null);
        uriString = uriString.trim().endsWith(",") ? uriString + appendUri.toString() : uriString + "," + appendUri.toString();
        return uriString;
    }

    private static void setNamingServiceURL(String url) {
        if (namingServiceURL != null) {
            RpcRequest.getSocketClient().close(namingServiceURL);
        }
        namingServiceURL = url;
        useLocalNaming = "/naming".equals(url);
        nsContainerURL = url == null || useLocalNaming ? null : url.substring(0, url.length() - 7);
        RpcNamingCache.instance.clearCache(null);
    }

    public void unregister(String name) throws Exception {
        RpcRequest req = RpcRequest.create(RpcNaming.getNamingServiceURL(), METHOD_REMOVE, sslContext);
        req.addArgument(PARA_NAME, name);
        req.invoke();
    }

    public void unregister(Object service) throws Exception {
        RpcRequest req = RpcRequest.create(RpcNaming.getNamingServiceURL(), METHOD_REMOVE, sslContext);
        req.addArgument(PARA_NAME, RpcNaming.getRpcServiceName(service.getClass()));
        req.invoke();
    }

    public void unregisterDefault(String name, Object service) throws Exception {
        RpcRequest req = RpcRequest.create(RpcNaming.getNamingServiceURL(), METHOD_REMOVEDEFAULT, sslContext);
        req.addArgument(PARA_NAME, name);
        req.invoke();
    }

    public String lookup(String name) throws Exception {
        String value = RpcNamingCache.instance.get(name);
        if (value != null) {
            if (value.equals(NONE)) {
                return null;
            }
            return value;
        }
        RpcRequest req = RpcRequest.create(RpcNaming.getNamingServiceURL(), METHOD_GET, sslContext);
        req.addArgument(PARA_CLIENT, RpcNaming.instance().getLocalURL());
        req.addArgument(PARA_NAME, name);
        RpcResponse rsp = req.invoke();
        value = RpcNaming.getRemoteLocation(rsp.getMessage().getString(PARA_VALUE));
        if (!rsp.getMessage().getBoolean(PARA_IGNORE)) {
            RpcNamingCache.instance.put(name, value);
        }
        return value;
    }

    private static String getRemoteLocation(String location) {
        if (location.charAt(0) == '/' && nsContainerURL != null) {
            return nsContainerURL + location;
        }
        return location;
    }

    public String[] find(String pattern) throws Exception {
        String values = RpcNamingCache.instance.get(pattern);
        if (values != null) {
            return values.split(VALUE_SEPARATOR);
        }
        RpcRequest req = RpcRequest.create(RpcNaming.getNamingServiceURL(), METHOD_FIND, sslContext);
        req.addArgument(PARA_CLIENT, RpcNaming.instance().getLocalURL());
        req.addArgument(PARA_NAME, pattern);
        RpcResponse rsp = req.invoke();
        int n = 0;
        StringBuilder sb = new StringBuilder();
        DataTable table = rsp.getMessage().getTable(TABLE_NAME);
        String[] result = new String[table.size()];
        String location = null;
        for (DataRecord record : table) {
            if (n > 0) {
                sb.append(VALUE_SEPARATOR);
            }
            location = RpcNaming.getRemoteLocation(record.get(PARA_VALUE));
            sb.append(location);
            result[n++] = location;
        }
        RpcNamingCache.instance.put(pattern, sb.toString());
        return result;
    }

    void clear() throws Exception {
        RpcRequest.create(RpcNaming.getNamingServiceURL(), METHOD_CLEAR, sslContext).invoke();
    }

    public static void close() {
        RpcNamingCache.instance.clearCache(null);
        if (RpcRequest.getSocketClient() != null) {
            RpcRequest.getSocketClient().close(nsContainerURL);
        }
        namingServiceURL = null;
        nsContainerURL = null;
    }

    public RpcRequest createRequestByName(String name) throws Exception {
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex != -1) {
            String serviceName = name.substring(0, dotIndex);
            String methodName = name.substring(dotIndex + 1);
            String serviceLocation = this.lookup(serviceName);
            if (serviceLocation != null && serviceLocation.length() > 0) {
                return RpcRequest.create(serviceLocation, methodName, sslContext);
            }
        }
        throw new RpcErrorNameNotFound(name);
    }

    public static RpcRequest createRequest(String name) throws Exception {
        return RpcNaming.instance().createRequestByName(name);
    }

    private static String getRpcServiceName(Class<?> cls) {
        Rpc ann = cls.getAnnotation(Rpc.class);
        if (ann != null && ann.name().length() > 0) {
            return ann.name().replace('/', '.');
        }
        return cls.getSimpleName();
    }

    public static SSLContext getSSLContext() {
        return sslContext;
    }

    static {
        instance = DEFAULT_INSTANCE = new RpcNaming();
        namingServiceURL = null;
        nsContainerURL = null;
        useLocalNaming = false;
        sslContext = null;
        RpcNaming.setNamingServiceURL(System.getProperty(PROPERTY_NS_LOCATION));
    }
}

