/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.dsf.base.rpc;

import com.swimap.base.rpc.BinHelper;
import com.swimap.base.rpc.ValueConvertor;
import com.swimap.base.rpc.XmlHelper;
import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.NameValuePair;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcParameter;
import com.swimap.external.dsf.base.rpc.mdp.MDPError;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcMessage {
    private static Log log = LogFactory.getLog(RpcMessage.class);
    public static final String EVENT = "event";
    public static final String EXCEPTION = "exception";
    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";
    public static final String UNKNOWN_TYPE = "unknown";
    public static final String ATTR_NAME_MID = "_mid";
    public static final String ATTR_NAME_SID = "_sid";
    public static final String ATTR_NAME_XSLT = "_xslt";
    private String messageType;
    Map<String, RpcParameter> parameterMap = new TreeMap<String, RpcParameter>();
    List<RpcParameter> parameters = new ArrayList<RpcParameter>();
    List<DataTable> tables = new ArrayList<DataTable>();
    public Map<String, byte[]> attachments;
    int messageId;
    String sessionId;
    String xslt;
    Object extData;

    public RpcMessage() {
        this.messageType = UNKNOWN_TYPE;
    }

    public RpcMessage(String type) {
        this.messageType = type;
    }

    public static RpcMessage getErrorMessage(Throwable ex) {
        Throwable e = ex;
        if (e == null) {
            e = new NullPointerException();
        }
        RpcMessage msg = new RpcMessage(EXCEPTION);
        if (e instanceof AppError) {
            AppError error = (AppError)e;
            msg.addParameter("class", error.getName());
            if (error.hasDetail()) {
                DataTable detail = new DataTable("detail");
                detail.setColumns("id", "msg");
                for (AppError.Info info : error.getDetail()) {
                    detail.add(info.id, info.message);
                }
                msg.addTable(detail);
            }
        } else {
            msg.addParameter("sys", "1");
            msg.addParameter("class", e.getClass().getName());
            msg.addParameter("message", e.getMessage());
            if (e instanceof RpcError) {
                msg.addParameter("code", ((RpcError)e).getErrorCode());
            } else if (e instanceof MDPError) {
                msg.addParameter("code", ((MDPError)e).getErrorCode() + 110);
            }
        }
        return msg;
    }

    /*
     * Unable to fully structure code
     */
    public Exception toException() {
        if (this.getBoolean("sys")) {
            try {
                cls = Class.forName(this.getString("class"));
                creator = cls.getConstructor(new Class[]{String.class});
                error = (Exception)creator.newInstance(new Object[]{this.getString("message")});
                if (error instanceof MDPError) {
                    e = new RpcError(error);
                    e.setErrorCode(this.getInt("code"));
                    error = e;
                }
                if (!(error instanceof RpcError)) ** GOTO lbl23
                ((RpcError)error).setErrorCode(this.getInt("code"));
            }
            catch (Exception e) {
                return e;
            }
        } else {
            appError = new AppError(this.getString("class"));
            detail = this.getTable("detail");
            if (detail != null) {
                for (DataRecord record : detail) {
                    appError.addDetail(record.get(0), record.get(1));
                }
            }
            error = appError;
        }
lbl23:
        // 4 sources

        stacks = this.getTable("stack");
        if (stacks != null) {
            stackTrace = new StackTraceElement[stacks.size()];
            i = 0;
            for (DataRecord record : stacks) {
                stackTrace[i++] = new StackTraceElement(record.get("class"), record.get("method"), record.get("file"), record.getInt("line"));
            }
            error.setStackTrace(stackTrace);
        }
        return error;
    }

    public void setParameters(Map parameterMap) throws Exception {
        String name = null;
        String[] value = null;
        for (Map.Entry entry : parameterMap.entrySet()) {
            name = (String)entry.getKey();
            if (this.setInternalParameter(name, (value = (String[])entry.getValue())[0])) continue;
            NameValuePair item = new NameValuePair(name, value[0]);
            this.parameterMap.put(item.getName(), item);
            this.parameters.add(item);
        }
    }

    public boolean setInternalParameter(String name, String value) {
        if (name.equals(ATTR_NAME_MID)) {
            this.setMessageId(Integer.valueOf(value));
        } else if (name.equals(ATTR_NAME_SID)) {
            this.setSessionId(value);
        } else if (name.equals(ATTR_NAME_XSLT)) {
            this.setXSLT(value);
        } else {
            return false;
        }
        return true;
    }

    public void addParameter(String name, Object value) {
        NameValuePair item = new NameValuePair(name, value);
        RpcParameter existed = this.parameterMap.put(name, item);
        if (existed != null) {
            this.parameters.set(this.parameters.indexOf(existed), item);
        } else {
            this.parameters.add(item);
        }
    }

    public void addTable(DataTable table) {
        if (table == null) {
            return;
        }
        this.parameterMap.put(table.getName(), table);
        this.tables.add(table);
    }

    public Map<String, RpcParameter> getParameterMap() {
        return this.parameterMap;
    }

    public Collection<RpcParameter> getParameters() {
        return this.parameters;
    }

    public Collection<DataTable> getTables() {
        return this.tables;
    }

    public void setType(String type) {
        this.messageType = type;
    }

    public String getType() {
        return this.messageType;
    }

    public Set<String> getParameterNames() {
        return this.parameterMap.keySet();
    }

    public boolean hasParameter(String paraName) {
        return this.parameterMap.containsKey(paraName);
    }

    public boolean hasTable(String tableName) {
        RpcParameter para = this.parameterMap.get(tableName);
        return para != null && para instanceof DataTable;
    }

    public boolean containsTable() {
        return !this.tables.isEmpty();
    }

    public DataTable getTable(String name) {
        RpcParameter para = this.parameterMap.get(name);
        if (para instanceof DataTable) {
            return (DataTable)para;
        }
        return null;
    }

    public List<DataTable> tables() {
        return this.tables;
    }

    public String getString(String name) {
        RpcParameter para = this.parameterMap.get(name);
        if (para != null) {
            return para.getValue();
        }
        return null;
    }

    public double getDouble(String name) {
        RpcParameter para = this.parameterMap.get(name);
        if (para == null) {
            throw new NullPointerException(name + " not found");
        }
        return Double.valueOf(para.getValue());
    }

    public Date getDate(String name) {
        try {
            RpcParameter para = this.parameterMap.get(name);
            return ValueConvertor.parseDate(para.getValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getInt(String name) {
        RpcParameter para = this.parameterMap.get(name);
        if (para == null) {
            throw new NullPointerException(name + " not found");
        }
        return Integer.valueOf(para.getValue());
    }

    public long getLong(String name) {
        RpcParameter para = this.parameterMap.get(name);
        if (para == null) {
            throw new NullPointerException(name + " not found");
        }
        return Long.valueOf(para.getValue());
    }

    public boolean getBoolean(String name) {
        RpcParameter para = this.parameterMap.get(name);
        if (para != null) {
            return para.getValue().equals("1");
        }
        return false;
    }

    public int[] getIntArray(String name) {
        RpcParameter para = this.parameterMap.get(name);
        if (para != null) {
            return ValueConvertor.getIntArray(para.getValue());
        }
        return null;
    }

    public byte[] getByteArray(String name) {
        RpcParameter para = this.parameterMap.get(name);
        if (para != null) {
            return ValueConvertor.getByteArray(para.getValue());
        }
        return null;
    }

    public char[] getCharArray(String name) {
        RpcParameter para = this.parameterMap.get(name);
        if (para != null) {
            return ValueConvertor.getCharArray(para.getValue());
        }
        return null;
    }

    public String[] getStringArray(String name) {
        RpcParameter para = this.parameterMap.get(name);
        if (para != null) {
            return ValueConvertor.getStringArray(para.getValue());
        }
        return null;
    }

    public void setMessageId(int mid) {
        this.messageId = mid;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public boolean hasMessageId() {
        return this.messageId > 0;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean hasSessionId() {
        return this.sessionId != null;
    }

    public String getXSLT() {
        return this.xslt;
    }

    public void setXSLT(String url) {
        this.xslt = url;
    }

    public void clear() {
        this.parameters.clear();
        this.tables.clear();
        this.parameterMap.clear();
    }

    public String toString() {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        try {
            XmlHelper.writeMessage(ba, this, null);
            return ba.toString("UTF-8");
        }
        catch (Exception e) {
            log.error((Object)"convert message to string failed!", (Throwable)e);
            return e.toString();
        }
    }

    public static RpcMessage parse(String xml) throws Exception {
        return XmlHelper.parseMessage(xml, "UTF-8");
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        try {
            BinHelper.writeMessage(ba, this);
        }
        catch (Exception e) {
            log.error((Object)"convert message to byte array failed!", (Throwable)e);
        }
        return ba.toByteArray();
    }

    public RpcMessage clone() {
        RpcMessage copy = new RpcMessage(this.messageType);
        copy.messageId = this.messageId;
        copy.sessionId = this.sessionId;
        copy.xslt = this.xslt;
        for (Map.Entry<String, RpcParameter> entry : this.parameterMap.entrySet()) {
            copy.parameterMap.put(entry.getKey(), entry.getValue());
        }
        copy.parameters.addAll(this.parameters);
        for (DataTable table : this.tables) {
            copy.tables.add(table);
        }
        if (this.hasAttachments()) {
            copy.getAttachments().putAll(this.attachments);
        }
        copy.extData = this.extData;
        return copy;
    }

    public void addObjectParameter(Object obj) {
        Field[] fields;
        for (Field field : fields = obj.getClass().getFields()) {
            try {
                Object value = field.get(obj);
                this.addParameter(field.getName(), value);
            }
            catch (Exception e) {
                log.error((Object)"get field failed", (Throwable)e);
            }
        }
    }

    public void copyParamterTo(Object obj) {
        Field[] fields;
        for (Field field : fields = obj.getClass().getFields()) {
            try {
                String value = this.getString(field.getName());
                if (value == null) continue;
                field.set(obj, ValueConvertor.convert(value, field.getType()));
            }
            catch (Exception e) {
                log.error((Object)"set field failed", (Throwable)e);
            }
        }
    }

    public Map<String, byte[]> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new HashMap<String, byte[]>();
        }
        return this.attachments;
    }

    public boolean hasAttachments() {
        return this.attachments != null && !this.attachments.isEmpty();
    }

    public boolean hasAttachment(String name) {
        return this.attachments != null && this.attachments.containsKey(name);
    }

    public String[] getAttachmentNames() {
        if (this.hasAttachments()) {
            String[] names = new String[this.attachments.size()];
            this.attachments.keySet().toArray(names);
            return names;
        }
        return new String[0];
    }

    public byte[] getAttachment(String name) {
        if (this.attachments != null) {
            return this.attachments.get(name);
        }
        return null;
    }

    public void addAttachment(String name, byte[] data) {
        if (data == null) {
            return;
        }
        this.getAttachments().put(name, data);
    }

    public void setExtData(Object data) {
        this.extData = data;
    }

    public Object getExtData() {
        return this.extData;
    }
}

